/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.cache;

import java.io.File;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.cache.CacheUtil;
import net.sourceforge.jnlp.cache.ResourceTracker;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.util.WeakList;

public class Resource {
    public static final int UNINITIALIZED = 0;
    public static final int CONNECT = 1;
    public static final int CONNECTING = 2;
    public static final int CONNECTED = 4;
    public static final int DOWNLOAD = 8;
    public static final int DOWNLOADING = 16;
    public static final int DOWNLOADED = 32;
    public static final int ERROR = 64;
    public static final int STARTED = 128;
    private static WeakList<Resource> resources = new WeakList();
    private WeakList<ResourceTracker> trackers = new WeakList();
    URL location;
    File localFile;
    Version requestVersion;
    Version downloadVersion;
    URLConnection connection;
    long transferred = 0L;
    long size = -1L;
    int status = 0;
    UpdatePolicy updatePolicy;

    private Resource(URL location, Version requestVersion, UpdatePolicy updatePolicy) {
        this.location = location;
        this.requestVersion = requestVersion;
        this.updatePolicy = updatePolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Resource getResource(URL location, Version requestVersion, UpdatePolicy updatePolicy) {
        WeakList<Resource> weakList = resources;
        synchronized (weakList) {
            Resource result;
            Resource resource = new Resource(location, requestVersion, updatePolicy);
            int index = resources.indexOf(resource);
            if (index >= 0 && (result = resources.get(index)) != null) {
                return result;
            }
            resources.add(resource);
            resources.trimToSize();
            return resource;
        }
    }

    public URL getLocation() {
        return this.location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResourceTracker getTracker() {
        WeakList<ResourceTracker> weakList = this.trackers;
        synchronized (weakList) {
            List<ResourceTracker> t = this.trackers.hardList();
            if (t.size() > 0) {
                return t.get(0);
            }
            return null;
        }
    }

    public boolean isSet(int flag) {
        if (flag == 0) {
            return this.status == 0;
        }
        return (this.status & flag) != 0;
    }

    public UpdatePolicy getUpdatePolicy() {
        return this.updatePolicy;
    }

    private String getStatusString(int flag) {
        StringBuffer result = new StringBuffer();
        if (flag == 0) {
            result.append("<> ");
        }
        if ((flag & 1) != 0) {
            result.append("CONNECT ");
        }
        if ((flag & 2) != 0) {
            result.append("CONNECTING ");
        }
        if ((flag & 4) != 0) {
            result.append("CONNECTED ");
        }
        if ((flag & 8) != 0) {
            result.append("DOWNLOAD ");
        }
        if ((flag & 0x10) != 0) {
            result.append("DOWNLOADING ");
        }
        if ((flag & 0x20) != 0) {
            result.append("DOWNLOADED ");
        }
        if ((flag & 0x40) != 0) {
            result.append("ERROR ");
        }
        if ((flag & 0x80) != 0) {
            result.append("STARTED ");
        }
        return result.deleteCharAt(result.length() - 1).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeStatus(int clear, int add) {
        int orig = 0;
        Resource resource = this;
        synchronized (resource) {
            orig = this.status;
            this.status &= ~clear;
            this.status |= add;
        }
        if (JNLPRuntime.isDebug() && this.status != orig) {
            System.out.print("Status: " + this.getStatusString(this.status));
            if ((this.status & ~orig) != 0) {
                System.out.print(" +(" + this.getStatusString(this.status & ~orig) + ")");
            }
            if ((~this.status & orig) != 0) {
                System.out.print(" -(" + this.getStatusString(~this.status & orig) + ")");
            }
            System.out.println(" @ " + this.location.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTracker(ResourceTracker tracker) {
        WeakList<ResourceTracker> weakList = this.trackers;
        synchronized (weakList) {
            this.trackers.remove(tracker);
            this.trackers.trimToSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTracker(ResourceTracker tracker) {
        WeakList<ResourceTracker> weakList = this.trackers;
        synchronized (weakList) {
            List<ResourceTracker> t = this.trackers.hardList();
            if (!t.contains(tracker)) {
                this.trackers.add(tracker);
            }
            this.trackers.trimToSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDownloadEvent() {
        List<ResourceTracker> send;
        WeakList<ResourceTracker> weakList = this.trackers;
        synchronized (weakList) {
            send = this.trackers.hardList();
        }
        for (int i = 0; i < send.size(); ++i) {
            ResourceTracker rt = send.get(i);
            rt.fireDownloadEvent(this);
        }
    }

    public boolean equals(Object other) {
        if (other instanceof Resource) {
            return CacheUtil.urlEquals(this.location, ((Resource)other).location);
        }
        return false;
    }

    public String toString() {
        return "location=" + this.location.toString() + " state=" + this.getStatusString(this.status);
    }
}

