/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.controlpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.sourceforge.jnlp.controlpanel.MiddleClickListener;
import net.sourceforge.jnlp.controlpanel.NamedBorderPanel;
import net.sourceforge.jnlp.runtime.DeploymentConfiguration;
import net.sourceforge.jnlp.runtime.Translator;

public class AdvancedProxySettingsPane
extends JPanel {
    private JDialog parent;
    private DeploymentConfiguration config;
    public static String[] properties = new String[]{"deployment.proxy.http.host", "deployment.proxy.http.port", "deployment.proxy.https.host", "deployment.proxy.https.port", "deployment.proxy.ftp.host", "deployment.proxy.ftp.port", "deployment.proxy.socks.host", "deployment.proxy.socks.port", "deployment.proxy.same", "deployment.proxy.override.hosts"};
    private String[] fields = new String[properties.length];
    private JComponent defaultFocusComponent = null;

    public AdvancedProxySettingsPane(JDialog parent, DeploymentConfiguration config) {
        super(new BorderLayout());
        this.parent = parent;
        this.config = config;
        this.getProperties();
        this.addComponents();
    }

    private void getProperties() {
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i] = this.config.getProperty(properties[i]);
        }
    }

    private void addComponents() {
        JPanel topPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        NamedBorderPanel servers = new NamedBorderPanel(Translator.R("APSServersPanel"));
        servers.setLayout(new GridBagLayout());
        JLabel type = new JLabel(Translator.R("APSProxyTypeLabel"));
        JLabel proxyAddress = new JLabel(Translator.R("APSProxyAddressLabel"));
        JLabel port = new JLabel(Translator.R("APSProxyPortLabel"));
        JLabel http = new JLabel(Translator.R("APSLabelHTTP") + ":");
        final JTextField httpAddressField = new JTextField(this.fields[0]);
        final JTextField httpPortField = new JTextField(this.fields[1]);
        httpAddressField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ((AdvancedProxySettingsPane)AdvancedProxySettingsPane.this).fields[0] = httpAddressField.getText();
            }
        });
        httpPortField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ((AdvancedProxySettingsPane)AdvancedProxySettingsPane.this).fields[1] = httpPortField.getText();
            }
        });
        httpAddressField.addMouseListener(new MiddleClickListener(this.config, properties[0]));
        httpPortField.addMouseListener(new MiddleClickListener(this.config, properties[1]));
        JLabel secure = new JLabel(Translator.R("APSLabelSecure") + ":");
        final JTextField secureAddressField = new JTextField(this.fields[2]);
        final JTextField securePortField = new JTextField(this.fields[3]);
        secureAddressField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ((AdvancedProxySettingsPane)AdvancedProxySettingsPane.this).fields[2] = secureAddressField.getText();
            }
        });
        securePortField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ((AdvancedProxySettingsPane)AdvancedProxySettingsPane.this).fields[3] = securePortField.getText();
            }
        });
        secureAddressField.addMouseListener(new MiddleClickListener(this.config, properties[2]));
        securePortField.addMouseListener(new MiddleClickListener(this.config, properties[3]));
        JLabel ftp = new JLabel(Translator.R("APSLabelFTP") + ":");
        final JTextField ftpAddressField = new JTextField(this.fields[4]);
        final JTextField ftpPortField = new JTextField(this.fields[5]);
        ftpAddressField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ((AdvancedProxySettingsPane)AdvancedProxySettingsPane.this).fields[4] = ftpAddressField.getText();
            }
        });
        ftpPortField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ((AdvancedProxySettingsPane)AdvancedProxySettingsPane.this).fields[5] = ftpPortField.getText();
            }
        });
        ftpAddressField.addMouseListener(new MiddleClickListener(this.config, properties[4]));
        ftpPortField.addMouseListener(new MiddleClickListener(this.config, properties[5]));
        JLabel socks = new JLabel(Translator.R("APSLabelSocks") + ":");
        final JTextField socksAddressField = new JTextField(this.fields[6]);
        final JTextField socksPortField = new JTextField(this.fields[7]);
        socksAddressField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ((AdvancedProxySettingsPane)AdvancedProxySettingsPane.this).fields[6] = socksAddressField.getText();
            }
        });
        socksPortField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ((AdvancedProxySettingsPane)AdvancedProxySettingsPane.this).fields[7] = socksPortField.getText();
            }
        });
        socksAddressField.addMouseListener(new MiddleClickListener(this.config, properties[6]));
        socksPortField.addMouseListener(new MiddleClickListener(this.config, properties[7]));
        JCheckBox sameProxyForAll = new JCheckBox(Translator.R("APSSameProxyForAllProtocols"), Boolean.parseBoolean(this.fields[8]));
        sameProxyForAll.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ((AdvancedProxySettingsPane)AdvancedProxySettingsPane.this).fields[8] = String.valueOf(e.getStateChange() == 1);
            }
        });
        JPanel p = new JPanel();
        BoxLayout bl = new BoxLayout(p, 1);
        p.setLayout(bl);
        p.add(sameProxyForAll);
        c.fill = 1;
        c.gridheight = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.gridx = 0;
        servers.add((Component)type, c);
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.gridx = 1;
        servers.add((Component)proxyAddress, c);
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.gridx = 4;
        servers.add((Component)port, c);
        this.plant(1, http, httpAddressField, httpPortField, servers, c);
        this.plant(2, secure, secureAddressField, securePortField, servers, c);
        this.plant(3, ftp, ftpAddressField, ftpPortField, servers, c);
        this.plant(4, socks, socksAddressField, socksPortField, servers, c);
        c.gridwidth = 5;
        c.gridx = 0;
        c.gridy = 5;
        servers.add((Component)p, c);
        NamedBorderPanel exceptions = new NamedBorderPanel(Translator.R("APSExceptionsLabel"));
        exceptions.setLayout(new BorderLayout());
        JLabel exceptionDescription = new JLabel(Translator.R("APSExceptionsDescription"));
        final JTextArea exceptionListArea = new JTextArea();
        exceptionListArea.setLineWrap(true);
        exceptionListArea.setText(this.fields[9]);
        exceptionListArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ((AdvancedProxySettingsPane)AdvancedProxySettingsPane.this).fields[9] = exceptionListArea.getText();
            }
        });
        exceptionListArea.addMouseListener(new MiddleClickListener(this.config, this.fields[9]));
        JLabel exceptionFormat = new JLabel(Translator.R("APSExceptionInstruction"));
        JScrollPane exceptionScroll = new JScrollPane(exceptionListArea, 22, 31);
        exceptions.add((Component)exceptionDescription, "North");
        exceptions.add((Component)exceptionScroll, "Center");
        exceptions.add((Component)exceptionFormat, "South");
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridy = 0;
        topPanel.add((Component)servers, c);
        c.weighty = 1.0;
        c.gridy = 1;
        topPanel.add((Component)exceptions, c);
        this.add(topPanel);
        this.add((Component)this.createButtonPanel(), "South");
    }

    private void plant(int y, JLabel label, JTextField addr, JTextField port, JPanel addTo, GridBagConstraints c) {
        c.gridy = y;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.gridx = 0;
        addTo.add((Component)label, c);
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.gridx = 1;
        addTo.add((Component)addr, c);
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.gridx = 3;
        addTo.add((Component)new JLabel(":"), c);
        c.gridwidth = 1;
        c.weightx = 0.3;
        c.gridx = 4;
        addTo.add((Component)port, c);
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(4));
        ArrayList<JButton> buttons = new ArrayList<JButton>();
        JButton okButton = new JButton(Translator.R("ButOk"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < AdvancedProxySettingsPane.this.fields.length; ++i) {
                    AdvancedProxySettingsPane.this.config.setProperty(properties[i], AdvancedProxySettingsPane.this.fields[i]);
                }
                AdvancedProxySettingsPane.this.parent.dispose();
            }
        });
        buttons.add(okButton);
        JButton cancelButton = new JButton(Translator.R("ButCancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdvancedProxySettingsPane.this.parent.dispose();
            }
        });
        buttons.add(cancelButton);
        int maxWidth = 0;
        int maxHeight = 0;
        for (JButton button : buttons) {
            maxWidth = Math.max(button.getMinimumSize().width, maxWidth);
            maxHeight = Math.max(button.getMinimumSize().height, maxHeight);
        }
        int wantedWidth = maxWidth + 10;
        int wantedHeight = maxHeight;
        for (JButton button : buttons) {
            button.setPreferredSize(new Dimension(wantedWidth, wantedHeight));
            buttonPanel.add(button);
        }
        return buttonPanel;
    }

    public void focusOnDefaultButton() {
        if (this.defaultFocusComponent != null) {
            this.defaultFocusComponent.requestFocusInWindow();
        }
    }
}

