/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.controlpanel;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.sourceforge.jnlp.controlpanel.AdvancedProxySettingsDialog;
import net.sourceforge.jnlp.controlpanel.MiddleClickListener;
import net.sourceforge.jnlp.controlpanel.NamedBorderPanel;
import net.sourceforge.jnlp.runtime.DeploymentConfiguration;
import net.sourceforge.jnlp.runtime.Translator;

public class NetworkSettingsPanel
extends JPanel
implements ActionListener {
    private DeploymentConfiguration config;
    private JPanel description;
    private ArrayList<JPanel> proxyPanels = new ArrayList();
    public static String[] properties = new String[]{"deployment.proxy.type", "deployment.proxy.http.host", "deployment.proxy.http.port", "deployment.proxy.bypass.local", "deployment.proxy.auto.config.url"};

    public NetworkSettingsPanel(DeploymentConfiguration config) {
        this.config = config;
        this.setLayout(new BorderLayout());
        this.addComponents();
    }

    protected void addComponents() {
        NamedBorderPanel settingPanel = new NamedBorderPanel(Translator.R("CPHeadNetworkSettings"));
        settingPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        JLabel networkDesc = new JLabel("<html>" + Translator.R("CPNetworkSettingsDescription") + "<hr /></html>");
        JLabel[] description = new JLabel[]{new JLabel("<html>" + Translator.R("NSDescription-1") + "</html>"), new JLabel("<html>" + Translator.R("NSDescription0") + "</html>"), new JLabel("<html>" + Translator.R("NSDescription1") + "</html>"), new JLabel("<html>" + Translator.R("NSDescription2") + "</html>"), new JLabel("<html>" + Translator.R("NSDescription3") + "</html>")};
        this.description = new JPanel(new CardLayout());
        for (int i = 0; i < description.length; ++i) {
            this.description.add((Component)description[i], String.valueOf(i - 1));
        }
        JPanel proxyServerPanel = new JPanel(new BorderLayout());
        JPanel proxyLocationPanel = new JPanel(new FlowLayout(3));
        JPanel proxyBypassPanel = new JPanel(new FlowLayout(3));
        JLabel addressLabel = new JLabel(Translator.R("NSAddress") + ":");
        JLabel portLabel = new JLabel(Translator.R("NSPort") + ":");
        final JTextField addressField = new JTextField(this.config.getProperty(properties[1]), 10);
        addressField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                NetworkSettingsPanel.this.config.setProperty(properties[1], addressField.getText());
            }
        });
        addressField.addMouseListener(new MiddleClickListener(this.config, properties[1]));
        final JTextField portField = new JTextField(this.config.getProperty(properties[2]), 3);
        portField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                NetworkSettingsPanel.this.config.setProperty(properties[2], portField.getText());
            }
        });
        JButton advancedProxyButton = new JButton(Translator.R("NSAdvanced") + "...");
        advancedProxyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AdvancedProxySettingsDialog.showAdvancedProxySettingsDialog(NetworkSettingsPanel.this.config);
                    addressField.setText(NetworkSettingsPanel.this.config.getProperty(properties[1]));
                    portField.setText(NetworkSettingsPanel.this.config.getProperty(properties[2]));
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        JCheckBox bypassCheckBox = new JCheckBox(Translator.R("NSBypassLocal"), Boolean.parseBoolean(this.config.getProperty(properties[3])));
        bypassCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                NetworkSettingsPanel.this.config.setProperty(properties[3], String.valueOf(e.getStateChange() == 1));
            }
        });
        proxyLocationPanel.add(Box.createRigidArea(new Dimension(13, 0)));
        proxyLocationPanel.add(addressLabel);
        proxyLocationPanel.add(addressField);
        proxyLocationPanel.add(portLabel);
        proxyLocationPanel.add(portField);
        proxyLocationPanel.add(advancedProxyButton);
        proxyBypassPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        proxyBypassPanel.add(bypassCheckBox);
        proxyServerPanel.add((Component)proxyLocationPanel, "Center");
        proxyServerPanel.add((Component)proxyBypassPanel, "South");
        JRadioButton directConnection = new JRadioButton(Translator.R("NSDirectConnection"), this.config.getProperty(properties[0]).equals("0"));
        directConnection.setActionCommand("0");
        directConnection.addActionListener(this);
        JRadioButton useProxyServer = new JRadioButton(Translator.R("NSManualProxy"), this.config.getProperty(properties[0]).equals("1"));
        useProxyServer.setActionCommand("1");
        useProxyServer.addActionListener(this);
        JRadioButton useAutoProxyConfigScript = new JRadioButton(Translator.R("NSAutoProxy"), this.config.getProperty(properties[0]).equals("2"));
        useAutoProxyConfigScript.setActionCommand("2");
        useAutoProxyConfigScript.addActionListener(this);
        JRadioButton useBrowserSettings = new JRadioButton(Translator.R("NSBrowserProxy"), this.config.getProperty(properties[0]).equals("3"));
        useBrowserSettings.setActionCommand("3");
        useBrowserSettings.addActionListener(this);
        ButtonGroup modeSelect = new ButtonGroup();
        modeSelect.add(useBrowserSettings);
        modeSelect.add(useProxyServer);
        modeSelect.add(useAutoProxyConfigScript);
        modeSelect.add(directConnection);
        JPanel proxyAutoPanel = new JPanel(new FlowLayout(3));
        JLabel locationLabel = new JLabel(Translator.R("NSScriptLocation") + ":");
        final JTextField locationField = new JTextField(this.config.getProperty(properties[4]), 20);
        locationField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String value = locationField.getText();
                if (value.trim().equals("")) {
                    value = null;
                }
                NetworkSettingsPanel.this.config.setProperty(properties[4], value);
            }
        });
        proxyAutoPanel.add(Box.createRigidArea(new Dimension(13, 0)));
        proxyAutoPanel.add(locationLabel);
        proxyAutoPanel.add(locationField);
        c.gridy = 0;
        settingPanel.add((Component)networkDesc, c);
        c.gridy = 1;
        settingPanel.add((Component)this.description, c);
        c.gridy = 2;
        settingPanel.add((Component)directConnection, c);
        c.gridy = 3;
        settingPanel.add((Component)useBrowserSettings, c);
        c.gridy = 4;
        settingPanel.add((Component)useProxyServer, c);
        c.gridy = 5;
        settingPanel.add((Component)proxyServerPanel, c);
        this.proxyPanels.add(proxyServerPanel);
        c.gridy = 6;
        settingPanel.add((Component)useAutoProxyConfigScript, c);
        c.gridy = 7;
        settingPanel.add((Component)proxyAutoPanel, c);
        this.proxyPanels.add(proxyAutoPanel);
        Component filler = Box.createRigidArea(new Dimension(1, 1));
        ++c.gridy;
        c.weighty = 1.0;
        settingPanel.add(filler, c);
        this.setState();
        this.add((Component)settingPanel, "Center");
    }

    private void enablePanel(JPanel panel, boolean enable) {
        for (Component c : panel.getComponents()) {
            if (c instanceof JPanel) {
                this.enablePanel((JPanel)c, enable);
            }
            c.setEnabled(enable);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.config.setProperty(properties[0], e.getActionCommand());
        this.setState();
    }

    private void setState() {
        block3: {
            block5: {
                block4: {
                    block2: {
                        ((CardLayout)this.description.getLayout()).show(this.description, this.config.getProperty(properties[0]));
                        if (!this.config.getProperty(properties[0]).equals("0")) break block2;
                        for (JPanel panel : this.proxyPanels) {
                            this.enablePanel(panel, false);
                        }
                        break block3;
                    }
                    if (!this.config.getProperty(properties[0]).equals("1")) break block4;
                    this.enablePanel(this.proxyPanels.get(1), false);
                    this.enablePanel(this.proxyPanels.get(0), true);
                    break block3;
                }
                if (!this.config.getProperty(properties[0]).equals("2")) break block5;
                this.enablePanel(this.proxyPanels.get(0), false);
                this.enablePanel(this.proxyPanels.get(1), true);
                break block3;
            }
            if (!this.config.getProperty(properties[0]).equals("3")) break block3;
            for (JPanel panel : this.proxyPanels) {
                this.enablePanel(panel, false);
            }
        }
    }
}

