/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.controlpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sourceforge.jnlp.controlpanel.NamedBorderPanel;
import net.sourceforge.jnlp.runtime.DeploymentConfiguration;
import net.sourceforge.jnlp.runtime.Translator;

public class SecuritySettingsPanel
extends NamedBorderPanel
implements ActionListener {
    private DeploymentConfiguration config;
    public static String[] properties = new String[]{"deployment.security.askgrantdialog.show", "deployment.security.askgrantdialog.notinca", "deployment.security.browser.keystore.use", "deployment.security.clientauth.keystore.auto", "deployment.security.jsse.hostmismatch.warning", "deployment.security.https.warning.show", "deployment.security.sandbox.awtwarningwindow", "deployment.security.sandbox.jnlp.enhanced", "deployment.security.validation.crl", "deployment.security.validation.ocsp", "deployment.security.pretrust.list", "deployment.security.blacklist.check", "deployment.security.password.cache", "deployment.security.SSLv2Hello", "deployment.security.SSLv3", "deployment.security.TLSv1"};

    public SecuritySettingsPanel(DeploymentConfiguration config) {
        super(Translator.R("CPHeadSecurity"), new BorderLayout());
        this.config = config;
        this.addComponents();
    }

    private void addComponents() {
        JPanel topPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        JLabel description = new JLabel("<html>" + Translator.R("CPSecurityDescription") + "<hr /></html>");
        JCheckBox[] securityGeneralOptions = new JCheckBox[]{new JCheckBox(Translator.R("SGPAllowUserGrantSigned")), new JCheckBox(Translator.R("SGPAllowUserGrantUntrust")), new JCheckBox(Translator.R("SGpUseBrowserKeystore")), new JCheckBox(Translator.R("SGPUsePersonalCertOneMatch")), new JCheckBox(Translator.R("SGPWarnCertHostMismatch")), new JCheckBox(Translator.R("SGPShowValid")), new JCheckBox(Translator.R("SGPShowSandboxWarning")), new JCheckBox(Translator.R("SGPAllowUserAcceptJNLPSecurityRequests")), new JCheckBox(Translator.R("SGPCheckCertRevocationList")), new JCheckBox(Translator.R("SGPEnableOnlineCertValidate")), new JCheckBox(Translator.R("SGPEnableTrustedPublisherList")), new JCheckBox(Translator.R("SGPEnableBlacklistRevocation")), new JCheckBox(Translator.R("SGPEnableCachingPassword")), new JCheckBox(Translator.R("SGPUseSSL2")), new JCheckBox(Translator.R("SGPUseSSL3")), new JCheckBox(Translator.R("SGPUseTLS1"))};
        c.fill = 1;
        c.gridx = 0;
        c.weightx = 1.0;
        topPanel.add((Component)description, c);
        for (int i = 0; i < properties.length; ++i) {
            try {
                String s = this.config.getProperty(properties[i]);
                securityGeneralOptions[i].setSelected(Boolean.parseBoolean(s));
                securityGeneralOptions[i].setActionCommand(properties[i]);
                securityGeneralOptions[i].addActionListener(this);
                c.gridy = i + 1;
                topPanel.add((Component)securityGeneralOptions[i], c);
                continue;
            }
            catch (Exception e) {
                securityGeneralOptions[i] = null;
            }
        }
        Component filler = Box.createRigidArea(new Dimension(1, 1));
        c.weighty = 1.0;
        ++c.gridy;
        topPanel.add(filler, c);
        this.add((Component)topPanel, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.config.setProperty(e.getActionCommand(), String.valueOf(((JCheckBox)e.getSource()).isSelected()));
    }
}

