/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.ConfigurationException;
import net.sourceforge.jnlp.runtime.JNLPRuntime;

public final class DeploymentConfiguration {
    public static final String DEPLOYMENT_DIR = ".icedtea";
    public static final String DEPLOYMENT_CONFIG = "deployment.config";
    public static final String DEPLOYMENT_PROPERTIES = "deployment.properties";
    public static final String DEPLOYMENT_COMMENT = "Netx deployment configuration";
    public static final int JNLP_ASSOCIATION_NEVER = 0;
    public static final int JNLP_ASSOCIATION_NEW_ONLY = 1;
    public static final int JNLP_ASSOCIATION_ASK_USER = 2;
    public static final int JNLP_ASSOCIATION_REPLACE_ASK = 3;
    public static final String CONSOLE_HIDE = "HIDE";
    public static final String CONSOLE_SHOW = "SHOW";
    public static final String CONSOLE_DISABLE = "DISABLE";
    public static final String KEY_USER_CACHE_DIR = "deployment.user.cachedir";
    public static final String KEY_USER_PERSISTENCE_CACHE_DIR = "deployment.user.pcachedir";
    public static final String KEY_SYSTEM_CACHE_DIR = "deployment.system.cachedir";
    public static final String KEY_USER_LOG_DIR = "deployment.user.logdir";
    public static final String KEY_USER_TMP_DIR = "deployment.user.tmp";
    public static final String KEY_USER_LOCKS_DIR = "deployment.user.locksdir";
    public static final String KEY_USER_NETX_RUNNING_FILE = "deployment.user.runningfile";
    public static final String KEY_USER_TRUSTED_CA_CERTS = "deployment.user.security.trusted.cacerts";
    public static final String KEY_USER_TRUSTED_JSSE_CA_CERTS = "deployment.user.security.trusted.jssecacerts";
    public static final String KEY_USER_TRUSTED_CERTS = "deployment.user.security.trusted.certs";
    public static final String KEY_USER_TRUSTED_JSSE_CERTS = "deployment.user.security.trusted.jssecerts";
    public static final String KEY_USER_TRUSTED_CLIENT_CERTS = "deployment.user.security.trusted.clientauthcerts";
    public static final String KEY_SYSTEM_TRUSTED_CA_CERTS = "deployment.system.security.cacerts";
    public static final String KEY_SYSTEM_TRUSTED_JSSE_CA_CERTS = "deployment.system.security.jssecacerts";
    public static final String KEY_SYSTEM_TRUSTED_CERTS = "deployment.system.security.trusted.certs";
    public static final String KEY_SYSTEM_TRUSTED_JSSE_CERTS = "deployment.system.security.trusted.jssecerts";
    public static final String KEY_SYSTEM_TRUSTED_CLIENT_CERTS = "deployment.system.security.trusted.clientautcerts";
    public static final String KEY_SECURITY_PROMPT_USER = "deployment.security.askgrantdialog.show";
    public static final String KEY_SECURITY_ALLOW_HIDE_WINDOW_WARNING = "deployment.security.sandbox.awtwarningwindow";
    public static final String KEY_SECURITY_PROMPT_USER_FOR_JNLP = "deployment.security.sandbox.jnlp.enhanced";
    public static final String KEY_SECURITY_INSTALL_AUTHENTICATOR = "deployment.security.authenticator";
    public static final String KEY_PROXY_TYPE = "deployment.proxy.type";
    public static final String KEY_PROXY_SAME = "deployment.proxy.same";
    public static final String KEY_PROXY_AUTO_CONFIG_URL = "deployment.proxy.auto.config.url";
    public static final String KEY_PROXY_BYPASS_LIST = "deployment.proxy.bypass.list";
    public static final String KEY_PROXY_BYPASS_LOCAL = "deployment.proxy.bypass.local";
    public static final String KEY_PROXY_HTTP_HOST = "deployment.proxy.http.host";
    public static final String KEY_PROXY_HTTP_PORT = "deployment.proxy.http.port";
    public static final String KEY_PROXY_HTTPS_HOST = "deployment.proxy.https.host";
    public static final String KEY_PROXY_HTTPS_PORT = "deployment.proxy.https.port";
    public static final String KEY_PROXY_FTP_HOST = "deployment.proxy.ftp.host";
    public static final String KEY_PROXY_FTP_PORT = "deployment.proxy.ftp.port";
    public static final String KEY_PROXY_SOCKS4_HOST = "deployment.proxy.socks.host";
    public static final String KEY_PROXY_SOCKS4_PORT = "deployment.proxy.socks.port";
    public static final String KEY_PROXY_OVERRIDE_HOSTS = "deployment.proxy.override.hosts";
    public static final String KEY_ENABLE_LOGGING = "deployment.log";
    public static final String KEY_CREATE_DESKTOP_SHORTCUT = "deployment.javaws.shortcut";
    public static final String KEY_BROWSER_PATH = "deployment.browser.path";
    private boolean systemPropertiesMandatory = false;
    private File systemPropertiesFile = null;
    private File userPropertiesFile = null;
    private Map<String, ConfigValue> currentConfiguration = new HashMap<String, ConfigValue>();
    private Map<String, ConfigValue> unchangeableConfiguration = new HashMap<String, ConfigValue>();

    public void load() throws ConfigurationException {
        File userFile = new File(System.getProperty("user.home") + File.separator + DEPLOYMENT_DIR + File.separator + DEPLOYMENT_PROPERTIES);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkRead(userFile.toString());
        }
        Map<String, ConfigValue> initialProperties = this.loadDefaultProperties();
        Map<String, ConfigValue> systemProperties = null;
        File systemConfigFile = this.findSystemConfigFile();
        if (systemConfigFile != null) {
            if (this.loadSystemConfiguration(systemConfigFile)) {
                if (JNLPRuntime.isDebug()) {
                    System.out.println("System level deployment.config is mandatory: " + this.systemPropertiesMandatory);
                }
                systemProperties = this.loadProperties(ConfigType.System, this.systemPropertiesFile, this.systemPropertiesMandatory);
            }
            if (systemProperties != null) {
                this.mergeMaps(initialProperties, systemProperties);
            }
        }
        this.unchangeableConfiguration = new HashMap<String, ConfigValue>();
        Set<String> keys = initialProperties.keySet();
        for (String key : keys) {
            this.unchangeableConfiguration.put(key, new ConfigValue(initialProperties.get(key)));
        }
        this.userPropertiesFile = userFile;
        Map<String, ConfigValue> userProperties = this.loadProperties(ConfigType.User, this.userPropertiesFile, false);
        if (userProperties != null) {
            this.mergeMaps(initialProperties, userProperties);
        }
        this.currentConfiguration = initialProperties;
    }

    public String getProperty(String key) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && this.userPropertiesFile != null) {
            sm.checkRead(this.userPropertiesFile.toString());
        }
        return this.currentConfiguration.get(key).get();
    }

    public Set<String> getAllPropertyNames() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && this.userPropertiesFile != null) {
            sm.checkRead(this.userPropertiesFile.toString());
        }
        return this.currentConfiguration.keySet();
    }

    public void setProperty(String key, String value) {
        ConfigValue currentValue;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && this.userPropertiesFile != null) {
            sm.checkWrite(this.userPropertiesFile.toString());
        }
        if ((currentValue = this.currentConfiguration.get(key)) != null) {
            if (!currentValue.isLocked()) {
                currentValue.set(value);
            }
        } else {
            currentValue = new ConfigValue(value);
            this.currentConfiguration.put(key, currentValue);
        }
    }

    private Map<String, ConfigValue> loadDefaultProperties() {
        String SYSTEM_HOME = System.getProperty("java.home");
        String SYSTEM_SECURITY = SYSTEM_HOME + File.separator + "lib" + File.separator + "security";
        String USER_HOME = System.getProperty("user.home") + File.separator + DEPLOYMENT_DIR;
        String USER_SECURITY = USER_HOME + File.separator + "security";
        String LOCKS_DIR = System.getProperty("java.io.tmpdir") + File.separator + System.getProperty("user.name") + File.separator + "netx" + File.separator + "locks";
        String[][] defaults = new String[][]{{KEY_USER_CACHE_DIR, USER_HOME + File.separator + "cache"}, {KEY_USER_PERSISTENCE_CACHE_DIR, USER_HOME + File.separator + "pcache"}, {KEY_SYSTEM_CACHE_DIR, null}, {KEY_USER_LOG_DIR, USER_HOME + File.separator + "log"}, {KEY_USER_TMP_DIR, USER_HOME + File.separator + "tmp"}, {KEY_USER_LOCKS_DIR, LOCKS_DIR}, {KEY_USER_NETX_RUNNING_FILE, LOCKS_DIR + File.separator + "netx_running"}, {"deployment.user.security.policy", "file://" + USER_SECURITY + File.separator + "java.policy"}, {KEY_USER_TRUSTED_CA_CERTS, USER_SECURITY + File.separator + "trusted.cacerts"}, {KEY_USER_TRUSTED_JSSE_CA_CERTS, USER_SECURITY + File.separator + "trusted.jssecacerts"}, {KEY_USER_TRUSTED_CERTS, USER_SECURITY + File.separator + "trusted.certs"}, {KEY_USER_TRUSTED_JSSE_CERTS, USER_SECURITY + File.separator + "trusted.jssecerts"}, {KEY_USER_TRUSTED_CLIENT_CERTS, USER_SECURITY + File.separator + "trusted.clientcerts"}, {"deployment.system.security.policy", null}, {KEY_SYSTEM_TRUSTED_CA_CERTS, SYSTEM_SECURITY + File.separator + "cacerts"}, {KEY_SYSTEM_TRUSTED_JSSE_CA_CERTS, SYSTEM_SECURITY + File.separator + "jssecacerts"}, {KEY_SYSTEM_TRUSTED_CERTS, SYSTEM_SECURITY + File.separator + "trusted.certs"}, {KEY_SYSTEM_TRUSTED_JSSE_CERTS, SYSTEM_SECURITY + File.separator + "trusted.jssecerts"}, {KEY_SYSTEM_TRUSTED_CLIENT_CERTS, SYSTEM_SECURITY + File.separator + "trusted.clientcerts"}, {KEY_SECURITY_PROMPT_USER, String.valueOf(true)}, {"deployment.security.askgrantdialog.notinca", String.valueOf(true)}, {"deployment.security.notinca.warning", String.valueOf(true)}, {"deployment.security.expired.warning", String.valueOf(true)}, {"deployment.security.jsse.hostmismatch.warning", String.valueOf(true)}, {"deployment.security.trusted.policy", null}, {KEY_SECURITY_ALLOW_HIDE_WINDOW_WARNING, String.valueOf(true)}, {KEY_SECURITY_PROMPT_USER_FOR_JNLP, String.valueOf(true)}, {KEY_SECURITY_INSTALL_AUTHENTICATOR, String.valueOf(true)}, {KEY_PROXY_TYPE, String.valueOf(3)}, {KEY_PROXY_SAME, String.valueOf(false)}, {KEY_PROXY_AUTO_CONFIG_URL, null}, {KEY_PROXY_BYPASS_LIST, null}, {KEY_PROXY_BYPASS_LOCAL, null}, {KEY_PROXY_HTTP_HOST, null}, {KEY_PROXY_HTTP_PORT, null}, {KEY_PROXY_HTTPS_HOST, null}, {KEY_PROXY_HTTPS_PORT, null}, {KEY_PROXY_FTP_HOST, null}, {KEY_PROXY_FTP_PORT, null}, {KEY_PROXY_SOCKS4_HOST, null}, {KEY_PROXY_SOCKS4_PORT, null}, {KEY_PROXY_OVERRIDE_HOSTS, null}, {"deployment.cache.max.size", String.valueOf("-1")}, {"deployment.cache.jarcompression", String.valueOf(0)}, {"deployment.javapi.cache.enabled", String.valueOf(false)}, {"deployment.console.startup.mode", CONSOLE_HIDE}, {"deployment.trace", String.valueOf(false)}, {KEY_ENABLE_LOGGING, String.valueOf(false)}, {"deployment.javaws.associations", String.valueOf(2)}, {KEY_CREATE_DESKTOP_SHORTCUT, "ASK_IF_HINTED"}, {"deployment.javaws.installURL", null}, {"deployment.javaws.autodownload", null}, {KEY_BROWSER_PATH, null}, {"deployment.javaws.update.timeout", String.valueOf(500)}};
        HashMap<String, ConfigValue> result = new HashMap<String, ConfigValue>();
        for (int i = 0; i < defaults.length; ++i) {
            String key = defaults[i][0];
            String actualValue = defaults[i][1];
            boolean locked = false;
            ConfigValue value = new ConfigValue(actualValue, locked);
            result.put(key, value);
        }
        return result;
    }

    private File findSystemConfigFile() {
        File etcFile = new File(File.separator + "etc" + File.separator + ".java" + File.separator + "deployment" + File.separator + DEPLOYMENT_CONFIG);
        if (etcFile.isFile()) {
            return etcFile;
        }
        File jreFile = new File(System.getProperty("java.home") + File.separator + "lib" + File.separator + DEPLOYMENT_CONFIG);
        if (jreFile.isFile()) {
            return jreFile;
        }
        return null;
    }

    private boolean loadSystemConfiguration(File configFile) {
        if (JNLPRuntime.isDebug()) {
            System.out.println("Loading system configuation from: " + configFile);
        }
        Map<Object, Object> systemConfiguration = new HashMap();
        try {
            systemConfiguration = this.parsePropertiesFile(configFile);
        }
        catch (IOException e) {
            if (JNLPRuntime.isDebug()) {
                System.out.println("No System level deployment.properties found.");
            }
            return false;
        }
        try {
            String urlString = ((ConfigValue)systemConfiguration.get("deployment.system.config")).get();
            if (urlString == null) {
                if (JNLPRuntime.isDebug()) {
                    System.out.println("No System level deployment.properties found.");
                }
                return false;
            }
            URL url = new URL(urlString);
            if (url.getProtocol().equals("file")) {
                ConfigValue mandatory;
                this.systemPropertiesFile = new File(url.getFile());
                if (JNLPRuntime.isDebug()) {
                    System.out.println("Using System leveldeployment.properties: " + this.systemPropertiesFile);
                }
                this.systemPropertiesMandatory = Boolean.valueOf((mandatory = (ConfigValue)systemConfiguration.get("deployment.system.config.mandatory")) == null ? null : mandatory.get());
                return true;
            }
            if (JNLPRuntime.isDebug()) {
                System.out.println("Remote + deployment.properties not supported");
            }
            return false;
        }
        catch (MalformedURLException e) {
            if (JNLPRuntime.isDebug()) {
                System.out.println("Invalid url for deployment.properties");
            }
            return false;
        }
    }

    private Map<String, ConfigValue> loadProperties(ConfigType type, File file, boolean mandatory) throws ConfigurationException {
        if (file == null || !file.isFile()) {
            if (JNLPRuntime.isDebug()) {
                System.out.println("No " + type.toString() + " level " + DEPLOYMENT_PROPERTIES + " found.");
            }
            if (!mandatory) {
                return null;
            }
            throw new ConfigurationException();
        }
        if (JNLPRuntime.isDebug()) {
            System.out.println("Loading " + type.toString() + " level properties from: " + file);
        }
        try {
            return this.parsePropertiesFile(file);
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        if (this.userPropertiesFile == null) {
            throw new IllegalStateException("must load() before save()");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkWrite(this.userPropertiesFile.toString());
        }
        if (JNLPRuntime.isDebug()) {
            System.out.println("Saving properties into " + this.userPropertiesFile.toString());
        }
        Properties toSave = new Properties();
        for (String key : this.currentConfiguration.keySet()) {
            String newValue;
            String oldValue = this.unchangeableConfiguration.get(key) == null ? null : this.unchangeableConfiguration.get(key).get();
            String string = newValue = this.currentConfiguration.get(key) == null ? null : this.currentConfiguration.get(key).get();
            if (oldValue == null && newValue == null) continue;
            if (oldValue == null && newValue != null) {
                toSave.setProperty(key, newValue);
                continue;
            }
            if (oldValue != null && newValue == null) {
                toSave.setProperty(key, newValue);
                continue;
            }
            if (oldValue.equals(newValue)) continue;
            toSave.setProperty(key, newValue);
        }
        File backupPropertiesFile = new File(this.userPropertiesFile.toString() + ".old");
        if (this.userPropertiesFile.isFile() && !this.userPropertiesFile.renameTo(backupPropertiesFile)) {
            throw new IOException("Error saving backup copy of " + this.userPropertiesFile);
        }
        this.userPropertiesFile.getParentFile().mkdirs();
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.userPropertiesFile));
        try {
            toSave.store(out, DEPLOYMENT_COMMENT);
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ConfigValue> parsePropertiesFile(File propertiesFile) throws IOException {
        HashMap<String, ConfigValue> result = new HashMap<String, ConfigValue>();
        Properties properties = new Properties();
        BufferedReader reader = new BufferedReader(new FileReader(propertiesFile));
        try {
            properties.load(reader);
        }
        finally {
            ((Reader)reader).close();
        }
        Set<String> keys = properties.stringPropertyNames();
        for (String key : keys) {
            ConfigValue configValue;
            if (key.endsWith(".locked")) {
                String realKey = key.substring(0, key.length() - ".locked".length());
                configValue = (ConfigValue)result.get(realKey);
                if (configValue == null) {
                    configValue = new ConfigValue(null, true);
                    result.put(realKey, configValue);
                    continue;
                }
                configValue.setLocked(true);
                continue;
            }
            String newValue = properties.getProperty(key);
            configValue = (ConfigValue)result.get(key);
            if (configValue == null) {
                configValue = new ConfigValue(newValue);
                result.put(key, configValue);
                continue;
            }
            configValue.set(newValue);
        }
        return result;
    }

    private void mergeMaps(Map<String, ConfigValue> finalMap, Map<String, ConfigValue> srcMap) {
        for (String key : srcMap.keySet()) {
            ConfigValue configValue = finalMap.get(key);
            if (configValue == null) {
                configValue = srcMap.get(key);
                finalMap.put(key, configValue);
                continue;
            }
            if (configValue.isLocked()) continue;
            configValue.set(srcMap.get(key).get());
        }
    }

    private static void dumpConfiguration(Map<String, ConfigValue> config, PrintStream out) {
        System.out.println("KEY: VALUE [Locked]");
        for (String key : config.keySet()) {
            ConfigValue value = config.get(key);
            out.println("'" + key + "': '" + value.get() + "'" + (value.isLocked() ? " [LOCKED]" : ""));
        }
    }

    public static enum ConfigType {
        System,
        User;

    }

    private final class ConfigValue {
        private String value;
        private boolean locked;

        ConfigValue(String value) {
            this(value, false);
        }

        ConfigValue(String value, boolean locked) {
            this.value = value;
            this.locked = locked;
        }

        ConfigValue(ConfigValue other) {
            this(other.value, other.locked);
        }

        String get() {
            return this.value;
        }

        void set(String value) {
            this.value = value;
        }

        boolean isLocked() {
            return this.locked;
        }

        void setLocked(boolean locked) {
            this.locked = locked;
        }
    }
}

