/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.awt.Image;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.Authenticator;
import java.net.ProxySelector;
import java.security.AllPermission;
import java.security.Policy;
import java.security.Security;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import javax.jnlp.ServiceManager;
import javax.naming.ConfigurationException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.text.html.parser.ParserDelegator;
import net.sourceforge.jnlp.DefaultLaunchHandler;
import net.sourceforge.jnlp.LaunchHandler;
import net.sourceforge.jnlp.cache.DefaultDownloadIndicator;
import net.sourceforge.jnlp.cache.DownloadIndicator;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.runtime.DeploymentConfiguration;
import net.sourceforge.jnlp.runtime.JNLPPolicy;
import net.sourceforge.jnlp.runtime.JNLPProxySelector;
import net.sourceforge.jnlp.runtime.JNLPSecurityManager;
import net.sourceforge.jnlp.security.JNLPAuthenticator;
import net.sourceforge.jnlp.security.SecurityDialogMessageHandler;
import net.sourceforge.jnlp.security.VariableX509TrustManager;
import net.sourceforge.jnlp.services.XServiceManagerStub;
import net.sourceforge.jnlp.util.FileUtils;
import net.sourceforge.jnlp.util.TeeOutputStream;
import sun.misc.Launcher;

public class JNLPRuntime {
    private static ResourceBundle resources;
    private static final DeploymentConfiguration config;
    private static JNLPSecurityManager security;
    private static JNLPPolicy policy;
    private static SecurityDialogMessageHandler securityDialogMessageHandler;
    private static LaunchHandler handler;
    private static DownloadIndicator indicator;
    private static UpdatePolicy updatePolicy;
    private static Image windowIcon;
    private static boolean initialized;
    private static boolean headless;
    private static boolean verify;
    private static boolean securityEnabled;
    private static boolean debug;
    private static boolean redirectStreams;
    public static Object initMutex;
    private static boolean isWebstartApplication;
    private static boolean forksAllowed;
    private static List<String> initialArguments;
    public static final String STDERR_FILE = "java.stderr";
    public static final String STDOUT_FILE = "java.stdout";

    public static boolean isInitialized() {
        return initialized;
    }

    public static void initialize(boolean isApplication) throws IllegalStateException {
        block11: {
            JNLPRuntime.checkInitialized();
            try {
                config.load();
            }
            catch (ConfigurationException e) {
                if (!isApplication) break block11;
                System.out.println(JNLPRuntime.getMessage("RConfigurationError"));
                System.exit(1);
            }
        }
        JNLPRuntime.initializeStreams();
        isWebstartApplication = isApplication;
        System.setProperty("javawebstart.version", "javaws-" + System.getProperty("java.version"));
        if (!headless) {
            JNLPRuntime.checkHeadless();
        }
        if (!headless && windowIcon == null) {
            JNLPRuntime.loadWindowIcon();
        }
        if (!headless && indicator == null) {
            indicator = new DefaultDownloadIndicator();
        }
        if (handler == null) {
            handler = new DefaultLaunchHandler();
        }
        ServiceManager.setServiceManagerStub(new XServiceManagerStub());
        policy = new JNLPPolicy();
        security = new JNLPSecurityManager();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        JNLPRuntime.doMainAppContextHacks();
        if (securityEnabled) {
            Policy.setPolicy(policy);
            System.setSecurityManager((SecurityManager)((Object)security));
        }
        securityDialogMessageHandler = JNLPRuntime.startSecurityThreads();
        try {
            SSLContext context = SSLContext.getInstance("SSL");
            TrustManager[] trust = new TrustManager[]{VariableX509TrustManager.getInstance()};
            context.init(null, trust, null);
            SSLSocketFactory sslSocketFactory = context.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(sslSocketFactory);
        }
        catch (Exception e) {
            System.err.println("Unable to set SSLSocketfactory (may _prevent_ access to sites that should be trusted)! Continuing anyway...");
            e.printStackTrace();
        }
        Authenticator.setDefault(new JNLPAuthenticator());
        ProxySelector.setDefault(new JNLPProxySelector());
        Security.setProperty("package.access", Security.getProperty("package.access") + ",net.sourceforge.jnlp");
        initialized = true;
    }

    private static SecurityDialogMessageHandler startSecurityThreads() {
        ThreadGroup securityThreadGroup = new ThreadGroup("NetxSecurityThreadGroup");
        SecurityDialogMessageHandler runner = new SecurityDialogMessageHandler();
        Thread securityThread = new Thread(securityThreadGroup, runner, "NetxSecurityThread");
        securityThread.setDaemon(true);
        securityThread.start();
        return runner;
    }

    private static void doMainAppContextHacks() {
        new ParserDelegator();
    }

    private static void initializeStreams() {
        Boolean enableLogging = Boolean.valueOf(config.getProperty("deployment.log"));
        if (redirectStreams || enableLogging.booleanValue()) {
            String logDir = config.getProperty("deployment.user.logdir");
            try {
                File errFile = new File(logDir, STDERR_FILE);
                errFile.getParentFile().mkdirs();
                FileUtils.createRestrictedFile(errFile, true);
                File outFile = new File(logDir, STDOUT_FILE);
                outFile.getParentFile().mkdirs();
                FileUtils.createRestrictedFile(outFile, true);
                if (redirectStreams) {
                    System.setErr(new PrintStream(new FileOutputStream(errFile)));
                    System.setOut(new PrintStream(new FileOutputStream(outFile)));
                } else {
                    System.setErr(new TeeOutputStream(new FileOutputStream(errFile), System.err));
                    System.setOut(new TeeOutputStream(new FileOutputStream(outFile), System.out));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static DeploymentConfiguration getConfiguration() {
        return config;
    }

    public static boolean isWebstartApplication() {
        return isWebstartApplication;
    }

    public static Image getWindowIcon() {
        return windowIcon;
    }

    public static void setWindowIcon(Image image) {
        JNLPRuntime.checkExitClass();
        windowIcon = image;
    }

    public static boolean isHeadless() {
        return headless;
    }

    public static boolean isVerifying() {
        return verify;
    }

    public static void setHeadless(boolean enabled) {
        JNLPRuntime.checkInitialized();
        headless = enabled;
    }

    public static void setVerify(boolean enabled) {
        JNLPRuntime.checkInitialized();
        verify = enabled;
    }

    public static boolean isSecurityEnabled() {
        return securityEnabled;
    }

    public static void setSecurityEnabled(boolean enabled) {
        JNLPRuntime.checkInitialized();
        securityEnabled = enabled;
    }

    public static SecurityDialogMessageHandler getSecurityDialogHandler() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AllPermission());
        }
        return securityDialogMessageHandler;
    }

    public static void setExitClass(Class exitClass) {
        JNLPRuntime.checkExitClass();
        security.setExitClass(exitClass);
    }

    public static void disableExit() {
        security.disableExit();
    }

    public static ApplicationInstance getApplication() {
        return security.getApplication();
    }

    public static boolean isDebug() {
        return debug;
    }

    public static void setDebug(boolean enabled) {
        JNLPRuntime.checkExitClass();
        debug = enabled;
    }

    public static void setRedirectStreams(boolean redirect) {
        JNLPRuntime.checkInitialized();
        redirectStreams = redirect;
    }

    public static void setDefaultUpdatePolicy(UpdatePolicy policy) {
        JNLPRuntime.checkExitClass();
        updatePolicy = policy;
    }

    public static UpdatePolicy getDefaultUpdatePolicy() {
        return updatePolicy;
    }

    public static void setDefaultLaunchHandler(LaunchHandler handler) {
        JNLPRuntime.checkExitClass();
        JNLPRuntime.handler = handler;
    }

    public static LaunchHandler getDefaultLaunchHandler() {
        return handler;
    }

    public static void setDefaultDownloadIndicator(DownloadIndicator indicator) {
        JNLPRuntime.checkExitClass();
        JNLPRuntime.indicator = indicator;
    }

    public static DownloadIndicator getDefaultDownloadIndicator() {
        return indicator;
    }

    public static String getMessage(String key) {
        try {
            String result = resources.getString(key);
            if (result.length() == 0) {
                return null;
            }
            return result;
        }
        catch (Exception ex) {
            if (!key.equals("RNoResource")) {
                return JNLPRuntime.getMessage("RNoResource", key);
            }
            return "Missing resource: " + key;
        }
    }

    public static String getMessage(String key, Object ... args) {
        return MessageFormat.format(JNLPRuntime.getMessage(key), args);
    }

    public static boolean getForksAllowed() {
        return forksAllowed;
    }

    public static void setForksAllowed(boolean value) {
        JNLPRuntime.checkInitialized();
        forksAllowed = value;
    }

    private static void checkInitialized() {
        if (initialized) {
            throw new IllegalStateException("JNLPRuntime already initialized.");
        }
    }

    private static void checkExitClass() {
        if (securityEnabled && initialized && !security.isExitClass()) {
            throw new IllegalStateException("Caller is not the exit class");
        }
    }

    private static void checkHeadless() {
        try {
            if ("true".equalsIgnoreCase(System.getProperty("java.awt.headless"))) {
                headless = true;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static void loadResources() {
        try {
            resources = ResourceBundle.getBundle("net.sourceforge.jnlp.resources.Messages");
        }
        catch (Exception ex) {
            throw new IllegalStateException("Missing resource bundle in netx.jar:net/sourceforge/jnlp/resource/Messages.properties");
        }
    }

    private static void loadWindowIcon() {
        block3: {
            if (windowIcon != null) {
                return;
            }
            try {
                windowIcon = new ImageIcon(new Launcher().getClassLoader().getResource("net/sourceforge/jnlp/resources/netx-icon.png")).getImage();
            }
            catch (Exception ex) {
                if (!JNLPRuntime.isDebug()) break block3;
                ex.printStackTrace();
            }
        }
    }

    public static void setInitialArgments(List<String> args) {
        JNLPRuntime.checkInitialized();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AllPermission());
        }
        initialArguments = args;
    }

    public static List<String> getInitialArguments() {
        return initialArguments;
    }

    static {
        JNLPRuntime.loadResources();
        config = new DeploymentConfiguration();
        handler = null;
        indicator = null;
        updatePolicy = UpdatePolicy.ALWAYS;
        windowIcon = null;
        initialized = false;
        headless = false;
        verify = true;
        securityEnabled = true;
        debug = false;
        redirectStreams = false;
        initMutex = new Object();
        forksAllowed = true;
    }
}

