/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.CertVerifier;
import net.sourceforge.jnlp.security.SecurityDialogPanel;
import net.sourceforge.jnlp.security.SecurityWarning;
import net.sourceforge.jnlp.security.SecurityWarningDialog;
import net.sourceforge.jnlp.util.FileUtils;
import sun.misc.Launcher;

public class AccessWarningPane
extends SecurityDialogPanel {
    JCheckBox alwaysAllow;
    Object[] extras;

    public AccessWarningPane(SecurityWarningDialog x, CertVerifier certVerifier) {
        super(x, certVerifier);
        this.addComponents();
    }

    public AccessWarningPane(SecurityWarningDialog x, Object[] extras, CertVerifier certVerifier) {
        super(x, certVerifier);
        this.extras = extras;
        this.addComponents();
    }

    private void addComponents() {
        SecurityWarning.AccessType type = this.parent.getAccessType();
        JNLPFile file = this.parent.getFile();
        String name = "";
        String publisher = "";
        String from = "";
        try {
            name = file.getInformation().getTitle() != null ? file.getInformation().getTitle() : Translator.R("SNoAssociatedCertificate");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            publisher = file.getInformation().getVendor() != null ? file.getInformation().getVendor() : Translator.R("SNoAssociatedCertificate");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            from = !file.getInformation().getHomepage().toString().equals("") ? file.getInformation().getHomepage().toString() : file.getSourceLocation().getAuthority();
        }
        catch (Exception e) {
            from = file.getSourceLocation().getAuthority();
        }
        String topLabelText = "";
        switch (type) {
            case READ_FILE: {
                if (this.extras != null && this.extras.length > 0 && this.extras[0] instanceof String) {
                    topLabelText = Translator.R("SFileReadAccess", FileUtils.displayablePath((String)this.extras[0]));
                    break;
                }
                topLabelText = Translator.R("SFileReadAccess", Translator.R("AFileOnTheMachine"));
                break;
            }
            case WRITE_FILE: {
                if (this.extras != null && this.extras.length > 0 && this.extras[0] instanceof String) {
                    topLabelText = Translator.R("SFileWriteAccess", FileUtils.displayablePath((String)this.extras[0]));
                    break;
                }
                topLabelText = Translator.R("SFileWriteAccess", Translator.R("AFileOnTheMachine"));
                break;
            }
            case CREATE_DESTKOP_SHORTCUT: {
                topLabelText = Translator.R("SDesktopShortcut");
                break;
            }
            case CLIPBOARD_READ: {
                topLabelText = Translator.R("SClipboardReadAccess");
                break;
            }
            case CLIPBOARD_WRITE: {
                topLabelText = Translator.R("SClipboardWriteAccess");
                break;
            }
            case PRINTER: {
                topLabelText = Translator.R("SPrinterAccess");
                break;
            }
            case NETWORK: {
                topLabelText = this.extras != null && this.extras.length >= 0 ? Translator.R("SNetworkAccess", this.extras[0]) : Translator.R("SNetworkAccess", "(address here)");
            }
        }
        ImageIcon icon = new ImageIcon(new Launcher().getClassLoader().getResource("net/sourceforge/jnlp/resources/warning.png"));
        JLabel topLabel = new JLabel(this.htmlWrap(topLabelText), icon, 2);
        topLabel.setFont(new Font(topLabel.getFont().toString(), 1, 12));
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setBackground(Color.WHITE);
        topPanel.add((Component)topLabel, "Center");
        topPanel.setPreferredSize(new Dimension(450, 100));
        topPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JLabel nameLabel = new JLabel(Translator.R("Name") + ":   " + name);
        nameLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel publisherLabel = new JLabel(Translator.R("Publisher") + ": " + publisher);
        publisherLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel fromLabel = new JLabel(Translator.R("From") + ":   " + from);
        fromLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.alwaysAllow = new JCheckBox(Translator.R("AlwaysAllowAction"));
        this.alwaysAllow.setEnabled(false);
        JPanel infoPanel = new JPanel(new GridLayout(4, 1));
        infoPanel.add(nameLabel);
        infoPanel.add(publisherLabel);
        infoPanel.add(fromLabel);
        infoPanel.add(this.alwaysAllow);
        infoPanel.setBorder(BorderFactory.createEmptyBorder(25, 25, 25, 25));
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton run = new JButton(Translator.R("ButAllow"));
        JButton cancel = new JButton(Translator.R("ButCancel"));
        run.addActionListener(this.createSetValueListener(this.parent, 0));
        run.addActionListener(new CheckBoxListener());
        cancel.addActionListener(this.createSetValueListener(this.parent, 1));
        this.initialFocusComponent = cancel;
        buttonPanel.add(run);
        buttonPanel.add(cancel);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BoxLayout(this, 1));
        this.add(topPanel);
        this.add(infoPanel);
        this.add(buttonPanel);
    }

    private class CheckBoxListener
    implements ActionListener {
        private CheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AccessWarningPane.this.alwaysAllow == null || AccessWarningPane.this.alwaysAllow.isSelected()) {
                // empty if block
            }
        }
    }
}

