/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.PluginBridge;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.CertVerifier;
import net.sourceforge.jnlp.security.CertificateUtils;
import net.sourceforge.jnlp.security.HttpsCertVerifier;
import net.sourceforge.jnlp.security.KeyStores;
import net.sourceforge.jnlp.security.SecurityDialogPanel;
import net.sourceforge.jnlp.security.SecurityUtil;
import net.sourceforge.jnlp.security.SecurityWarning;
import net.sourceforge.jnlp.security.SecurityWarningDialog;
import net.sourceforge.jnlp.util.FileUtils;
import sun.misc.Launcher;

public class CertWarningPane
extends SecurityDialogPanel {
    JCheckBox alwaysTrust;
    CertVerifier certVerifier;

    public CertWarningPane(SecurityWarningDialog x, CertVerifier certVerifier) {
        super(x, certVerifier);
        this.certVerifier = certVerifier;
        this.addComponents();
    }

    private void addComponents() {
        SecurityWarning.AccessType type = this.parent.getAccessType();
        JNLPFile file = this.parent.getFile();
        Certificate c = this.parent.getJarSigner().getPublisher();
        String name = "";
        String publisher = "";
        String from = "";
        try {
            name = this.certVerifier instanceof HttpsCertVerifier && c instanceof X509Certificate ? SecurityUtil.getCN(((X509Certificate)c).getSubjectX500Principal().getName()) : (file instanceof PluginBridge ? file.getTitle() : file.getInformation().getTitle());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (c instanceof X509Certificate) {
                publisher = SecurityUtil.getCN(((X509Certificate)c).getSubjectX500Principal().getName());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            from = file instanceof PluginBridge ? file.getCodeBase().getHost() : file.getInformation().getHomepage().toString();
        }
        catch (Exception e) {
            // empty catch block
        }
        String topLabelText = "";
        String propertyName = "";
        if (this.certVerifier instanceof HttpsCertVerifier) {
            topLabelText = Translator.R("SHttpsUnverified") + " " + Translator.R("Continue");
            propertyName = "OptionPane.warningIcon";
        } else {
            switch (type) {
                case VERIFIED: {
                    topLabelText = Translator.R("SSigVerified");
                    propertyName = "OptionPane.informationIcon";
                    break;
                }
                case UNVERIFIED: {
                    topLabelText = Translator.R("SSigUnverified");
                    propertyName = "OptionPane.warningIcon";
                    break;
                }
                case SIGNING_ERROR: {
                    topLabelText = Translator.R("SSignatureError");
                    propertyName = "OptionPane.warningIcon";
                }
            }
        }
        ImageIcon icon = new ImageIcon(new Launcher().getClassLoader().getResource("net/sourceforge/jnlp/resources/warning.png"));
        JLabel topLabel = new JLabel(this.htmlWrap(topLabelText), icon, 2);
        topLabel.setFont(new Font(topLabel.getFont().toString(), 1, 12));
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setBackground(Color.WHITE);
        topPanel.add((Component)topLabel, "Center");
        topPanel.setPreferredSize(new Dimension(400, 60));
        topPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JLabel nameLabel = new JLabel(Translator.R("Name") + ":   " + name);
        nameLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel publisherLabel = new JLabel(Translator.R("Publisher") + ": " + publisher);
        publisherLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel fromLabel = new JLabel(Translator.R("From") + ":   " + from);
        fromLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.alwaysTrust = new JCheckBox(Translator.R("SAlwaysTrustPublisher"));
        this.alwaysTrust.setEnabled(true);
        JPanel infoPanel = new JPanel(new GridLayout(4, 1));
        infoPanel.add(nameLabel);
        infoPanel.add(publisherLabel);
        if (!(this.certVerifier instanceof HttpsCertVerifier)) {
            infoPanel.add(fromLabel);
        }
        infoPanel.add(this.alwaysTrust);
        infoPanel.setBorder(BorderFactory.createEmptyBorder(25, 25, 25, 25));
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton run = new JButton(Translator.R("ButRun"));
        JButton cancel = new JButton(Translator.R("ButCancel"));
        int buttonWidth = Math.max(run.getMinimumSize().width, cancel.getMinimumSize().width);
        int buttonHeight = run.getMinimumSize().height;
        Dimension d = new Dimension(buttonWidth, buttonHeight);
        run.setPreferredSize(d);
        cancel.setPreferredSize(d);
        run.addActionListener(this.createSetValueListener(this.parent, 0));
        run.addActionListener(new CheckBoxListener());
        cancel.addActionListener(this.createSetValueListener(this.parent, 1));
        this.initialFocusComponent = cancel;
        buttonPanel.add(run);
        buttonPanel.add(cancel);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BoxLayout(this, 1));
        this.add(topPanel);
        this.add(infoPanel);
        this.add(buttonPanel);
        JButton moreInfo = new JButton(Translator.R("ButMoreInformation"));
        moreInfo.addActionListener(new MoreInfoButtonListener());
        JLabel bottomLabel = this.parent.getJarSigner().getRootInCacerts() ? new JLabel(this.htmlWrap(Translator.R("STrustedSource"))) : new JLabel(this.htmlWrap(Translator.R("SUntrustedSource")));
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 0));
        bottomPanel.add(bottomLabel);
        bottomPanel.add(moreInfo);
        bottomPanel.setPreferredSize(new Dimension(500, 100));
        bottomPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add(bottomPanel);
    }

    private class CheckBoxListener
    implements ActionListener {
        private CheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (CertWarningPane.this.alwaysTrust != null && CertWarningPane.this.alwaysTrust.isSelected()) {
                try {
                    KeyStore ks = KeyStores.getKeyStore(KeyStores.Level.USER, KeyStores.Type.CERTS);
                    X509Certificate c = (X509Certificate)CertWarningPane.this.parent.getJarSigner().getPublisher();
                    CertificateUtils.addToKeyStore(c, ks);
                    File keyStoreFile = new File(KeyStores.getKeyStoreLocation(KeyStores.Level.USER, KeyStores.Type.CERTS));
                    if (!keyStoreFile.isFile()) {
                        FileUtils.createRestrictedFile(keyStoreFile, true);
                    }
                    FileOutputStream os = new FileOutputStream(keyStoreFile);
                    ks.store(os, KeyStores.getPassword());
                    if (JNLPRuntime.isDebug()) {
                        System.out.println("certificate is now permanently trusted");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private class MoreInfoButtonListener
    implements ActionListener {
        private MoreInfoButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SecurityWarningDialog.showMoreInfoDialog(CertWarningPane.this.parent.getJarSigner(), CertWarningPane.this.parent);
        }
    }
}

