/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.MessageDigest;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.CertVerifier;
import net.sourceforge.jnlp.security.SecurityDialogPanel;
import net.sourceforge.jnlp.security.SecurityUtil;
import net.sourceforge.jnlp.security.SecurityWarningDialog;
import net.sourceforge.jnlp.tools.HexDumpEncoder;
import sun.security.x509.CertificateValidity;

public class CertsInfoPane
extends SecurityDialogPanel {
    private CertPath certPath;
    private JList list;
    protected JTree tree;
    private JTable table;
    private JTextArea output;
    private ListSelectionModel listSelectionModel;
    private ListSelectionModel tableSelectionModel;
    protected String[] certNames;
    private String[] columnNames = new String[]{Translator.R("Field"), Translator.R("Value")};
    protected ArrayList<String[][]> certsData;

    public CertsInfoPane(SecurityWarningDialog x, CertVerifier certVerifier) {
        super(x, certVerifier);
        this.addComponents();
    }

    void buildTree() {
        this.certPath = this.parent.getJarSigner().getCertPath();
        X509Certificate firstCert = (X509Certificate)this.certPath.getCertificates().get(0);
        String subjectString = SecurityUtil.getCN(firstCert.getSubjectX500Principal().getName());
        String issuerString = SecurityUtil.getCN(firstCert.getIssuerX500Principal().getName());
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(subjectString + " (" + issuerString + ")");
        if (!((Object)firstCert.getSubjectDN()).equals(firstCert.getIssuerDN()) && this.certPath.getCertificates().size() > 1) {
            X509Certificate secondCert = (X509Certificate)this.certPath.getCertificates().get(1);
            subjectString = SecurityUtil.getCN(secondCert.getSubjectX500Principal().getName());
            issuerString = SecurityUtil.getCN(secondCert.getIssuerX500Principal().getName());
            top.add(new DefaultMutableTreeNode(subjectString + " (" + issuerString + ")"));
        }
        this.tree = new JTree(top);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(new TreeSelectionHandler());
    }

    protected void populateTable() {
        this.certNames = new String[this.certPath.getCertificates().size()];
        this.certsData = new ArrayList();
        for (int i = 0; i < this.certPath.getCertificates().size(); ++i) {
            X509Certificate c = (X509Certificate)this.certPath.getCertificates().get(i);
            this.certsData.add(this.parseCert(c));
            this.certNames[i] = SecurityUtil.getCN(c.getSubjectX500Principal().getName()) + " (" + SecurityUtil.getCN(c.getIssuerX500Principal().getName()) + ")";
        }
    }

    protected String[][] parseCert(X509Certificate c) {
        String version = "" + c.getVersion();
        String serialNumber = c.getSerialNumber().toString();
        String signatureAlg = c.getSigAlgName();
        String issuer = c.getIssuerX500Principal().toString();
        String validity = new CertificateValidity(c.getNotBefore(), c.getNotAfter()).toString();
        String subject = c.getSubjectX500Principal().toString();
        HexDumpEncoder encoder = new HexDumpEncoder();
        String signature = encoder.encodeBuffer(c.getSignature());
        String md5Hash = "";
        String sha1Hash = "";
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(c.getEncoded());
            md5Hash = this.makeFingerprint(digest.digest());
            digest = MessageDigest.getInstance("SHA-1");
            digest.update(c.getEncoded());
            sha1Hash = this.makeFingerprint(digest.digest());
        }
        catch (Exception e) {
            // empty catch block
        }
        String[][] cert = new String[][]{{Translator.R("Version"), version}, {Translator.R("SSerial"), serialNumber}, {Translator.R("SSignatureAlgorithm"), signatureAlg}, {Translator.R("SIssuer"), issuer}, {Translator.R("SValidity"), validity}, {Translator.R("SSubject"), subject}, {Translator.R("SSignature"), signature}, {Translator.R("SMD5Fingerprint"), md5Hash}, {Translator.R("SSHA1Fingerprint"), sha1Hash}};
        return cert;
    }

    protected void addComponents() {
        this.buildTree();
        this.populateTable();
        JScrollPane listPane = new JScrollPane(this.tree);
        DefaultTableModel tableModel = new DefaultTableModel(this.certsData.get(0), this.columnNames);
        this.table = new JTable(tableModel);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.tableSelectionModel = this.table.getSelectionModel();
        this.tableSelectionModel.addListSelectionListener(new TableSelectionHandler());
        this.table.setFillsViewportHeight(true);
        JScrollPane tablePane = new JScrollPane(this.table);
        tablePane.setPreferredSize(new Dimension(500, 200));
        this.output = new JTextArea();
        this.output.setEditable(false);
        JScrollPane outputPane = new JScrollPane(this.output, 20, 30);
        outputPane.setPreferredSize(new Dimension(500, 200));
        JSplitPane rightSplitPane = new JSplitPane(0, tablePane, outputPane);
        rightSplitPane.setDividerLocation(0.5);
        rightSplitPane.setResizeWeight(0.5);
        JSplitPane mainPane = new JSplitPane(1, listPane, rightSplitPane);
        mainPane.setDividerLocation(0.3);
        mainPane.setResizeWeight(0.3);
        JPanel buttonPane = new JPanel(new BorderLayout());
        JButton close = new JButton(Translator.R("ButClose"));
        JButton copyToClipboard = new JButton(Translator.R("ButCopy"));
        close.addActionListener(this.createSetValueListener(this.parent, 0));
        copyToClipboard.addActionListener(new CopyToClipboardHandler());
        buttonPane.add((Component)close, "East");
        buttonPane.add((Component)copyToClipboard, "West");
        buttonPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)mainPane, "Center");
        this.add((Component)buttonPane, "South");
    }

    private String makeFingerprint(byte[] hash) {
        String fingerprint = "";
        for (int i = 0; i < hash.length; ++i) {
            if (!fingerprint.equals("")) {
                fingerprint = fingerprint + ":";
            }
            fingerprint = fingerprint + Integer.toHexString(hash[i] & 0xFF | 0x100).substring(1, 3);
        }
        return fingerprint.toUpperCase();
    }

    private class TableSelectionHandler
    implements ListSelectionListener {
        private TableSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            int minIndex = lsm.getMinSelectionIndex();
            int maxIndex = lsm.getMaxSelectionIndex();
            for (int i = minIndex; i <= maxIndex; ++i) {
                if (!lsm.isSelectedIndex(i)) continue;
                CertsInfoPane.this.output.setText((String)CertsInfoPane.this.table.getValueAt(i, 1));
            }
        }
    }

    private class ListSelectionHandler
    implements ListSelectionListener {
        private ListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            int minIndex = lsm.getMinSelectionIndex();
            int maxIndex = lsm.getMaxSelectionIndex();
            for (int i = minIndex; i <= maxIndex; ++i) {
                if (!lsm.isSelectedIndex(i)) continue;
                CertsInfoPane.this.table.setModel(new DefaultTableModel(CertsInfoPane.this.certsData.get(i), CertsInfoPane.this.columnNames));
            }
        }
    }

    protected class TreeSelectionHandler
    implements TreeSelectionListener {
        protected TreeSelectionHandler() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)CertsInfoPane.this.tree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            if (node.isRoot()) {
                CertsInfoPane.this.table.setModel(new DefaultTableModel(CertsInfoPane.this.certsData.get(0), CertsInfoPane.this.columnNames));
            } else if (node.isLeaf()) {
                CertsInfoPane.this.table.setModel(new DefaultTableModel(CertsInfoPane.this.certsData.get(1), CertsInfoPane.this.columnNames));
            }
        }
    }

    private class CopyToClipboardHandler
    implements ActionListener {
        private CopyToClipboardHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            int certIndex = 0;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)CertsInfoPane.this.tree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            if (node.isRoot()) {
                certIndex = 0;
            } else if (node.isLeaf()) {
                certIndex = 1;
            }
            String[][] cert = CertsInfoPane.this.certsData.get(certIndex);
            int rows = cert.length;
            int cols = cert[0].length;
            String certString = "";
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    certString = certString + cert[i][j];
                    certString = certString + " ";
                }
                certString = certString + "\n";
            }
            clipboard.setContents(new StringSelection(certString), null);
        }
    }
}

