/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.PasswordAuthentication;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.sourceforge.jnlp.runtime.JNLPRuntime;

public class PasswordAuthenticationDialog
extends JDialog {
    private JLabel jlInfo = new JLabel("");
    private JTextField jtfUserName = new JTextField();
    private JPasswordField jpfPassword = new JPasswordField();
    private boolean userCancelled;

    public PasswordAuthenticationDialog() {
        this.initialize();
    }

    public void initialize() {
        this.setTitle("IcedTea Java Plugin - Authorization needed to proceed");
        this.setLayout(new GridBagLayout());
        JLabel jlUserName = new JLabel("Username: ");
        JLabel jlPassword = new JLabel("Password: ");
        JButton jbOK = new JButton("OK");
        JButton jbCancel = new JButton("Cancel");
        this.jtfUserName.setSize(20, 10);
        this.jpfPassword.setSize(20, 10);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.insets = new Insets(10, 5, 3, 3);
        this.add((Component)this.jlInfo, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(10, 5, 3, 3);
        this.add((Component)jlUserName, c);
        c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 1;
        c.insets = new Insets(10, 5, 3, 3);
        c.weightx = 1.0;
        this.add((Component)this.jtfUserName, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.insets = new Insets(5, 5, 3, 3);
        this.add((Component)jlPassword, c);
        c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 2;
        c.insets = new Insets(5, 5, 3, 3);
        c.weightx = 1.0;
        this.add((Component)this.jpfPassword, c);
        c = new GridBagConstraints();
        c.anchor = 14;
        c.gridx = 1;
        c.gridy = 3;
        c.insets = new Insets(5, 5, 3, 70);
        c.weightx = 0.0;
        this.add((Component)jbCancel, c);
        c = new GridBagConstraints();
        c.anchor = 14;
        c.gridx = 1;
        c.gridy = 3;
        c.insets = new Insets(5, 5, 3, 3);
        c.weightx = 0.0;
        this.add((Component)jbOK, c);
        this.setMinimumSize(new Dimension(400, 150));
        this.setMaximumSize(new Dimension(1024, 150));
        this.setAlwaysOnTop(true);
        this.setSize(400, 150);
        this.setLocationRelativeTo(null);
        jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PasswordAuthenticationDialog.this.userCancelled = false;
                PasswordAuthenticationDialog.this.dispose();
            }
        });
        jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PasswordAuthenticationDialog.this.userCancelled = true;
                PasswordAuthenticationDialog.this.dispose();
            }
        });
        this.jtfUserName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PasswordAuthenticationDialog.this.userCancelled = false;
                PasswordAuthenticationDialog.this.dispose();
            }
        });
        this.jpfPassword.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PasswordAuthenticationDialog.this.userCancelled = false;
                PasswordAuthenticationDialog.this.dispose();
            }
        });
    }

    protected PasswordAuthentication askUser(String host, int port, String prompt, String type) {
        PasswordAuthentication auth = null;
        host = host + (port != -1 ? ":" + port : "");
        this.userCancelled = true;
        this.jlInfo.setText("<html>The " + type + " server at " + host + " is requesting authentication. It says \"" + prompt + "\"</html>");
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    PasswordAuthenticationDialog.this.setVisible(true);
                }
            });
            if (JNLPRuntime.isDebug()) {
                System.out.println("password dialog shown");
            }
            while (this.isShowing()) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException ie) {}
            }
            if (JNLPRuntime.isDebug()) {
                System.out.println("password dialog closed");
            }
            if (!this.userCancelled) {
                auth = new PasswordAuthentication(this.jtfUserName.getText(), this.jpfPassword.getPassword());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return auth;
    }

    public static void main(String[] args) {
        PasswordAuthenticationDialog frame = new PasswordAuthenticationDialog();
        PasswordAuthentication auth = frame.askUser("127.0.0.1", 3128, "Password for local proxy", "proxy");
        System.err.println("Auth info: " + auth.getUserName() + ":" + new String(auth.getPassword()));
        System.exit(0);
    }
}

