/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.awt.Dialog;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.Semaphore;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.security.CertVerifier;
import net.sourceforge.jnlp.security.SecurityDialogMessage;

public class SecurityWarning {
    public static boolean showAccessWarningDialog(AccessType accessType, JNLPFile file) {
        return SecurityWarning.showAccessWarningDialog(accessType, file, null);
    }

    public static boolean showAccessWarningDialog(AccessType accessType, JNLPFile file, Object[] extras) {
        if (!SecurityWarning.shouldPromptUser()) {
            return false;
        }
        SecurityDialogMessage message = new SecurityDialogMessage();
        message.dialogType = DialogType.ACCESS_WARNING;
        message.accessType = accessType;
        message.file = file;
        message.extras = extras;
        Object selectedValue = SecurityWarning.getUserResponse(message);
        if (selectedValue == null) {
            return false;
        }
        if (selectedValue instanceof Integer) {
            return (Integer)selectedValue == 0;
        }
        return false;
    }

    public static boolean showNotAllSignedWarningDialog(JNLPFile file) {
        if (!SecurityWarning.shouldPromptUser()) {
            return false;
        }
        SecurityDialogMessage message = new SecurityDialogMessage();
        message.dialogType = DialogType.NOTALLSIGNED_WARNING;
        message.accessType = AccessType.NOTALLSIGNED;
        message.file = file;
        message.extras = new Object[0];
        Object selectedValue = SecurityWarning.getUserResponse(message);
        if (selectedValue == null) {
            return false;
        }
        if (selectedValue instanceof Integer) {
            return (Integer)selectedValue == 0;
        }
        return false;
    }

    public static boolean showCertWarningDialog(AccessType accessType, JNLPFile file, CertVerifier jarSigner) {
        if (!SecurityWarning.shouldPromptUser()) {
            return false;
        }
        SecurityDialogMessage message = new SecurityDialogMessage();
        message.dialogType = DialogType.CERT_WARNING;
        message.accessType = accessType;
        message.file = file;
        message.certVerifier = jarSigner;
        Object selectedValue = SecurityWarning.getUserResponse(message);
        if (selectedValue == null) {
            return false;
        }
        if (selectedValue instanceof Integer) {
            return (Integer)selectedValue == 0;
        }
        return false;
    }

    public static int showAppletWarning() {
        if (!SecurityWarning.shouldPromptUser()) {
            return 2;
        }
        SecurityDialogMessage message = new SecurityDialogMessage();
        message.dialogType = DialogType.APPLET_WARNING;
        Object selectedValue = SecurityWarning.getUserResponse(message);
        if (selectedValue == null) {
            return 2;
        }
        if (selectedValue instanceof Integer) {
            return (Integer)selectedValue;
        }
        return 2;
    }

    private static Object getUserResponse(final SecurityDialogMessage message) {
        if (SwingUtilities.isEventDispatchThread()) {
            final JDialog fakeDialog = new JDialog();
            fakeDialog.setSize(0, 0);
            fakeDialog.setResizable(false);
            fakeDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            fakeDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    message.toDispose = fakeDialog;
                    message.lock = null;
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            JNLPRuntime.getSecurityDialogHandler().postMessage(message);
                            return null;
                        }
                    });
                }
            });
            fakeDialog.setVisible(true);
        } else {
            message.toDispose = null;
            message.lock = new Semaphore(0);
            JNLPRuntime.getSecurityDialogHandler().postMessage(message);
            boolean done = false;
            while (!done) {
                try {
                    message.lock.acquire();
                    done = true;
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return message.userResponse;
    }

    private static boolean shouldPromptUser() {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.valueOf(JNLPRuntime.getConfiguration().getProperty("deployment.security.askgrantdialog.show"));
            }
        });
    }

    public static enum AccessType {
        READ_FILE,
        WRITE_FILE,
        CREATE_DESTKOP_SHORTCUT,
        CLIPBOARD_READ,
        CLIPBOARD_WRITE,
        PRINTER,
        NETWORK,
        VERIFIED,
        UNVERIFIED,
        NOTALLSIGNED,
        SIGNING_ERROR;

    }

    public static enum DialogType {
        CERT_WARNING,
        MORE_INFO,
        CERT_INFO,
        SINGLE_CERT_INFO,
        ACCESS_WARNING,
        NOTALLSIGNED_WARNING,
        APPLET_WARNING;

    }
}

