/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JDialog;
import javax.swing.UIManager;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.security.AccessWarningPane;
import net.sourceforge.jnlp.security.AppletWarningPane;
import net.sourceforge.jnlp.security.CertVerifier;
import net.sourceforge.jnlp.security.CertWarningPane;
import net.sourceforge.jnlp.security.CertsInfoPane;
import net.sourceforge.jnlp.security.MoreInfoPane;
import net.sourceforge.jnlp.security.NotAllSignedWarningPane;
import net.sourceforge.jnlp.security.SecurityDialogPanel;
import net.sourceforge.jnlp.security.SecurityWarning;
import net.sourceforge.jnlp.security.SingleCertInfoPane;

public class SecurityWarningDialog
extends JDialog {
    private SecurityWarning.DialogType dialogType;
    private SecurityWarning.AccessType accessType;
    private SecurityDialogPanel panel;
    private JNLPFile file;
    private CertVerifier certVerifier;
    private X509Certificate cert;
    private Object[] extras;
    private boolean initialized = false;
    private Object value;
    private List<ActionListener> listeners = new CopyOnWriteArrayList<ActionListener>();

    SecurityWarningDialog(SecurityWarning.DialogType dialogType, SecurityWarning.AccessType accessType, JNLPFile file, CertVerifier jarSigner, X509Certificate cert, Object[] extras) {
        this.dialogType = dialogType;
        this.accessType = accessType;
        this.file = file;
        this.certVerifier = jarSigner;
        this.cert = cert;
        this.extras = extras;
        this.initialized = true;
        this.initDialog();
    }

    SecurityWarningDialog(SecurityWarning.DialogType dialogType, SecurityWarning.AccessType accessType, JNLPFile file) {
        this(dialogType, accessType, file, null, null, null);
    }

    SecurityWarningDialog(SecurityWarning.DialogType dialogType, SecurityWarning.AccessType accessType, JNLPFile file, CertVerifier jarSigner) {
        this(dialogType, accessType, file, jarSigner, null, null);
    }

    SecurityWarningDialog(SecurityWarning.DialogType dialogType, SecurityWarning.AccessType accessType, CertVerifier certVerifier) {
        this(dialogType, accessType, null, certVerifier, null, null);
    }

    SecurityWarningDialog(SecurityWarning.DialogType dialogType, SecurityWarning.AccessType accessType, JNLPFile file, Object[] extras) {
        this(dialogType, accessType, file, null, null, extras);
    }

    SecurityWarningDialog(SecurityWarning.DialogType dialogType, X509Certificate c) {
        this(dialogType, null, null, null, c, null);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public static void showMoreInfoDialog(CertVerifier jarSigner, SecurityWarningDialog parent) {
        SecurityWarningDialog dialog = new SecurityWarningDialog(SecurityWarning.DialogType.MORE_INFO, null, null, jarSigner);
        dialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        dialog.setVisible(true);
        dialog.dispose();
    }

    public static void showCertInfoDialog(CertVerifier jarSigner, SecurityWarningDialog parent) {
        SecurityWarningDialog dialog = new SecurityWarningDialog(SecurityWarning.DialogType.CERT_INFO, null, null, jarSigner);
        dialog.setLocationRelativeTo(parent);
        dialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        dialog.setVisible(true);
        dialog.dispose();
    }

    public static void showSingleCertInfoDialog(X509Certificate c, JDialog parent) {
        SecurityWarningDialog dialog = new SecurityWarningDialog(SecurityWarning.DialogType.SINGLE_CERT_INFO, c);
        dialog.setLocationRelativeTo(parent);
        dialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        dialog.setVisible(true);
        dialog.dispose();
    }

    private void initDialog() {
        this.setSystemLookAndFeel();
        String dialogTitle = "";
        if (this.dialogType == SecurityWarning.DialogType.CERT_WARNING) {
            dialogTitle = "Warning - Security";
        } else if (this.dialogType == SecurityWarning.DialogType.MORE_INFO) {
            dialogTitle = "More Information";
        } else if (this.dialogType == SecurityWarning.DialogType.CERT_INFO) {
            dialogTitle = "Details - Certificate";
        } else if (this.dialogType == SecurityWarning.DialogType.ACCESS_WARNING) {
            dialogTitle = "Security Warning";
        } else if (this.dialogType == SecurityWarning.DialogType.APPLET_WARNING) {
            dialogTitle = "Applet Warning";
        } else if (this.dialogType == SecurityWarning.DialogType.NOTALLSIGNED_WARNING) {
            dialogTitle = "Security Warning";
        }
        this.setTitle(dialogTitle);
        this.setModalityType(Dialog.ModalityType.MODELESS);
        this.setDefaultCloseOperation(2);
        this.installPanel();
        this.pack();
        WindowAdapter adapter = new WindowAdapter(){
            private boolean gotFocus = false;

            @Override
            public void windowGainedFocus(WindowEvent we) {
                if (!this.gotFocus) {
                    SecurityWarningDialog.this.selectDefaultButton();
                    this.gotFocus = true;
                }
            }

            @Override
            public void windowOpened(WindowEvent e) {
                if (e.getSource() instanceof SecurityWarningDialog) {
                    SecurityWarningDialog dialog = (SecurityWarningDialog)e.getSource();
                    dialog.setResizable(true);
                    SecurityWarningDialog.centerDialog(dialog);
                    dialog.setValue(null);
                }
            }
        };
        this.addWindowListener(adapter);
        this.addWindowFocusListener(adapter);
    }

    public SecurityWarning.AccessType getAccessType() {
        return this.accessType;
    }

    public JNLPFile getFile() {
        return this.file;
    }

    public CertVerifier getJarSigner() {
        return this.certVerifier;
    }

    public X509Certificate getCert() {
        return this.cert;
    }

    private void installPanel() {
        if (this.dialogType == SecurityWarning.DialogType.CERT_WARNING) {
            this.panel = new CertWarningPane(this, this.certVerifier);
        } else if (this.dialogType == SecurityWarning.DialogType.MORE_INFO) {
            this.panel = new MoreInfoPane(this, this.certVerifier);
        } else if (this.dialogType == SecurityWarning.DialogType.CERT_INFO) {
            this.panel = new CertsInfoPane(this, this.certVerifier);
        } else if (this.dialogType == SecurityWarning.DialogType.SINGLE_CERT_INFO) {
            this.panel = new SingleCertInfoPane(this, this.certVerifier);
        } else if (this.dialogType == SecurityWarning.DialogType.ACCESS_WARNING) {
            this.panel = new AccessWarningPane(this, this.extras, this.certVerifier);
        } else if (this.dialogType == SecurityWarning.DialogType.APPLET_WARNING) {
            this.panel = new AppletWarningPane(this, this.certVerifier);
        } else if (this.dialogType == SecurityWarning.DialogType.NOTALLSIGNED_WARNING) {
            this.panel = new NotAllSignedWarningPane(this);
        }
        this.add((Component)this.panel, "Center");
    }

    private static void centerDialog(JDialog dialog) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = dialog.getSize();
        dialog.setLocation((screen.width - dialogSize.width) / 2, (screen.height - dialogSize.height) / 2);
    }

    private void selectDefaultButton() {
        if (this.panel == null) {
            System.out.println("initial value panel is null");
        }
        this.panel.requestFocusOnDefaultButton();
    }

    protected void setValue(Object value) {
        if (JNLPRuntime.isDebug()) {
            System.out.println("Setting value:" + value);
        }
        this.value = value;
    }

    public Object getValue() {
        if (JNLPRuntime.isDebug()) {
            System.out.println("Returning value:" + this.value);
        }
        return this.value;
    }

    @Override
    public void dispose() {
        this.notifySelectionMade();
        super.dispose();
    }

    protected void setSystemLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void notifySelectionMade() {
        for (ActionListener listener : this.listeners) {
            listener.actionPerformed(null);
        }
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }
}

