/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.services;

import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import javax.jnlp.ClipboardService;
import net.sourceforge.jnlp.security.SecurityWarning;
import net.sourceforge.jnlp.services.ServiceUtil;

class XClipboardService
implements ClipboardService {
    protected XClipboardService() {
    }

    @Override
    public Transferable getContents() {
        if (ServiceUtil.checkAccess(SecurityWarning.AccessType.CLIPBOARD_READ, new Object[0])) {
            Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            return (Transferable)ServiceUtil.createPrivilegedProxy(Transferable.class, t);
        }
        return null;
    }

    @Override
    public void setContents(Transferable contents) {
        if (ServiceUtil.checkAccess(SecurityWarning.AccessType.CLIPBOARD_WRITE, new Object[0])) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(contents, null);
        }
    }
}

