/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.jpeg;

import com.sun.imageio.plugins.jpeg.JPEG;
import com.sun.imageio.plugins.jpeg.JPEGMetadataFormat;
import java.awt.color.ICC_Profile;
import java.util.ArrayList;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadataFormat;

public class JPEGImageMetadataFormat
extends JPEGMetadataFormat {
    private static JPEGImageMetadataFormat theInstance = null;

    private JPEGImageMetadataFormat() {
        super("javax_imageio_jpeg_image_1.0", 1);
        this.addElement("JPEGvariety", "javax_imageio_jpeg_image_1.0", 3);
        this.addElement("markerSequence", "javax_imageio_jpeg_image_1.0", 4);
        this.addElement("app0JFIF", "JPEGvariety", 2);
        this.addStreamElements("markerSequence");
        this.addElement("app14Adobe", "markerSequence", 0);
        this.addElement("sof", "markerSequence", 1, 4);
        this.addElement("sos", "markerSequence", 1, 4);
        this.addElement("JFXX", "app0JFIF", 1, Integer.MAX_VALUE);
        this.addElement("app0JFXX", "JFXX", 3);
        this.addElement("app2ICC", "app0JFIF", 0);
        this.addAttribute("app0JFIF", "majorVersion", 2, false, "1", "0", "255", true, true);
        this.addAttribute("app0JFIF", "minorVersion", 2, false, "2", "0", "255", true, true);
        ArrayList<String> resUnits = new ArrayList<String>();
        resUnits.add("0");
        resUnits.add("1");
        resUnits.add("2");
        this.addAttribute("app0JFIF", "resUnits", 2, false, "0", resUnits);
        this.addAttribute("app0JFIF", "Xdensity", 2, false, "1", "1", "65535", true, true);
        this.addAttribute("app0JFIF", "Ydensity", 2, false, "1", "1", "65535", true, true);
        this.addAttribute("app0JFIF", "thumbWidth", 2, false, "0", "0", "255", true, true);
        this.addAttribute("app0JFIF", "thumbHeight", 2, false, "0", "0", "255", true, true);
        this.addElement("JFIFthumbJPEG", "app0JFXX", 2);
        this.addElement("JFIFthumbPalette", "app0JFXX", 0);
        this.addElement("JFIFthumbRGB", "app0JFXX", 0);
        ArrayList<String> codes = new ArrayList<String>();
        codes.add("16");
        codes.add("17");
        codes.add("19");
        this.addAttribute("app0JFXX", "extensionCode", 2, false, null, codes);
        this.addChildElement("markerSequence", "JFIFthumbJPEG");
        this.addAttribute("JFIFthumbPalette", "thumbWidth", 2, false, null, "0", "255", true, true);
        this.addAttribute("JFIFthumbPalette", "thumbHeight", 2, false, null, "0", "255", true, true);
        this.addAttribute("JFIFthumbRGB", "thumbWidth", 2, false, null, "0", "255", true, true);
        this.addAttribute("JFIFthumbRGB", "thumbHeight", 2, false, null, "0", "255", true, true);
        this.addObjectValue("app2ICC", ICC_Profile.class, false, null);
        this.addAttribute("app14Adobe", "version", 2, false, "100", "100", "255", true, true);
        this.addAttribute("app14Adobe", "flags0", 2, false, "0", "0", "65535", true, true);
        this.addAttribute("app14Adobe", "flags1", 2, false, "0", "0", "65535", true, true);
        ArrayList<String> transforms = new ArrayList<String>();
        transforms.add("0");
        transforms.add("1");
        transforms.add("2");
        this.addAttribute("app14Adobe", "transform", 2, true, null, transforms);
        this.addElement("componentSpec", "sof", 0);
        ArrayList<String> procs = new ArrayList<String>();
        procs.add("0");
        procs.add("1");
        procs.add("2");
        this.addAttribute("sof", "process", 2, false, null, procs);
        this.addAttribute("sof", "samplePrecision", 2, false, "8");
        this.addAttribute("sof", "numLines", 2, false, null, "0", "65535", true, true);
        this.addAttribute("sof", "samplesPerLine", 2, false, null, "0", "65535", true, true);
        ArrayList<String> comps = new ArrayList<String>();
        comps.add("1");
        comps.add("2");
        comps.add("3");
        comps.add("4");
        this.addAttribute("sof", "numFrameComponents", 2, false, null, comps);
        this.addAttribute("componentSpec", "componentId", 2, true, null, "0", "255", true, true);
        this.addAttribute("componentSpec", "HsamplingFactor", 2, true, null, "1", "255", true, true);
        this.addAttribute("componentSpec", "VsamplingFactor", 2, true, null, "1", "255", true, true);
        ArrayList<String> tabids = new ArrayList<String>();
        tabids.add("0");
        tabids.add("1");
        tabids.add("2");
        tabids.add("3");
        this.addAttribute("componentSpec", "QtableSelector", 2, true, null, tabids);
        this.addElement("scanComponentSpec", "sos", 0);
        this.addAttribute("sos", "numScanComponents", 2, true, null, comps);
        this.addAttribute("sos", "startSpectralSelection", 2, false, "0", "0", "63", true, true);
        this.addAttribute("sos", "endSpectralSelection", 2, false, "63", "0", "63", true, true);
        this.addAttribute("sos", "approxHigh", 2, false, "0", "0", "15", true, true);
        this.addAttribute("sos", "approxLow", 2, false, "0", "0", "15", true, true);
        this.addAttribute("scanComponentSpec", "componentSelector", 2, true, null, "0", "255", true, true);
        this.addAttribute("scanComponentSpec", "dcHuffTable", 2, true, null, tabids);
        this.addAttribute("scanComponentSpec", "acHuffTable", 2, true, null, tabids);
    }

    public boolean canNodeAppear(String elementName, ImageTypeSpecifier imageType) {
        if (elementName.equals(this.getRootName()) || elementName.equals("JPEGvariety") || this.isInSubtree(elementName, "markerSequence")) {
            return true;
        }
        return this.isInSubtree(elementName, "app0JFIF") && JPEG.isJFIFcompliant(imageType, true);
    }

    public static synchronized IIOMetadataFormat getInstance() {
        if (theInstance == null) {
            theInstance = new JPEGImageMetadataFormat();
        }
        return theInstance;
    }
}

