/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pisces;

import java.util.Arrays;
import sun.java2d.pisces.Helpers;

public final class PiscesCache {
    final int bboxX0;
    final int bboxY0;
    final int bboxX1;
    final int bboxY1;
    final int[][] rowAARLE;
    private int x0 = Integer.MIN_VALUE;
    private int y0 = Integer.MIN_VALUE;
    private final int[][] touchedTile;
    static final int TILE_SIZE_LG = 5;
    static final int TILE_SIZE = 32;
    private static final int INIT_ROW_SIZE = 8;

    PiscesCache(int minx, int miny, int maxx, int maxy) {
        assert (maxy >= miny && maxx >= minx);
        this.bboxX0 = minx;
        this.bboxY0 = miny;
        this.bboxX1 = maxx + 1;
        this.bboxY1 = maxy + 1;
        this.rowAARLE = new int[this.bboxY1 - this.bboxY0 + 1][8];
        this.x0 = 0;
        this.y0 = -1;
        int nyTiles = maxy - miny + 32 >> 5;
        int nxTiles = maxx - minx + 32 >> 5;
        this.touchedTile = new int[nyTiles][nxTiles];
    }

    void addRLERun(int val, int runLen) {
        if (runLen > 0) {
            this.addTupleToRow(this.y0, val, runLen);
            if (val != 0) {
                int tx = this.x0 >> 5;
                int tx1 = this.x0 + runLen - 1 >> 5;
                int ty = this.y0 >> 5;
                if (tx1 >= this.touchedTile[ty].length) {
                    tx1 = this.touchedTile[ty].length - 1;
                }
                if (tx <= tx1) {
                    int nextTileXCoord = tx + 1 << 5;
                    if (nextTileXCoord > this.x0 + runLen) {
                        int[] nArray = this.touchedTile[ty];
                        int n = tx;
                        nArray[n] = nArray[n] + val * runLen;
                    } else {
                        int[] nArray = this.touchedTile[ty];
                        int n = tx;
                        nArray[n] = nArray[n] + val * (nextTileXCoord - this.x0);
                    }
                    ++tx;
                }
                while (tx < tx1) {
                    int[] nArray = this.touchedTile[ty];
                    int n = tx++;
                    nArray[n] = nArray[n] + (val << 5);
                }
                if (tx == tx1) {
                    int lastXCoord = Math.min(this.x0 + runLen, tx + 1 << 5);
                    int txXCoord = tx << 5;
                    int[] nArray = this.touchedTile[ty];
                    int n = tx;
                    nArray[n] = nArray[n] + val * (lastXCoord - txXCoord);
                }
            }
            this.x0 += runLen;
        }
    }

    void startRow(int y, int x) {
        assert (y - this.bboxY0 > this.y0);
        assert (y <= this.bboxY1);
        this.y0 = y - this.bboxY0;
        assert (this.rowAARLE[this.y0][1] == 0);
        this.x0 = x - this.bboxX0;
        assert (this.x0 >= 0) : "Input must not be to the left of bbox bounds";
        this.rowAARLE[this.y0][0] = x;
        this.rowAARLE[this.y0][1] = 2;
    }

    int alphaSumInTile(int x, int y) {
        return this.touchedTile[(y -= this.bboxY0) >> 5][(x -= this.bboxX0) >> 5];
    }

    int minTouched(int rowidx) {
        return this.rowAARLE[rowidx][0];
    }

    int rowLength(int rowidx) {
        return this.rowAARLE[rowidx][1];
    }

    private void addTupleToRow(int row, int a, int b) {
        int end = this.rowAARLE[row][1];
        this.rowAARLE[row] = Helpers.widenArray(this.rowAARLE[row], end, 2);
        this.rowAARLE[row][end++] = a;
        this.rowAARLE[row][end++] = b;
        this.rowAARLE[row][1] = end;
    }

    public String toString() {
        String ret = "bbox = [" + this.bboxX0 + ", " + this.bboxY0 + " => " + this.bboxX1 + ", " + this.bboxY1 + "]\n";
        for (int[] row : this.rowAARLE) {
            ret = row != null ? ret + "minTouchedX=" + row[0] + "\tRLE Entries: " + Arrays.toString(Arrays.copyOfRange(row, 2, row[1])) + "\n" : ret + "[]\n";
        }
        return ret;
    }
}

