/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pisces;

import java.awt.geom.AffineTransform;
import sun.awt.geom.PathConsumer2D;

public class TransformingPathConsumer2D {
    public static PathConsumer2D transformConsumer(PathConsumer2D out, AffineTransform at) {
        if (at == null) {
            return out;
        }
        float Mxx = (float)at.getScaleX();
        float Mxy = (float)at.getShearX();
        float Mxt = (float)at.getTranslateX();
        float Myx = (float)at.getShearY();
        float Myy = (float)at.getScaleY();
        float Myt = (float)at.getTranslateY();
        if (Mxy == 0.0f && Myx == 0.0f) {
            if (Mxx == 1.0f && Myy == 1.0f) {
                if (Mxt == 0.0f && Myt == 0.0f) {
                    return out;
                }
                return new TranslateFilter(out, Mxt, Myt);
            }
            return new ScaleFilter(out, Mxx, Myy, Mxt, Myt);
        }
        return new TransformFilter(out, Mxx, Mxy, Mxt, Myx, Myy, Myt);
    }

    static class TransformFilter
    implements PathConsumer2D {
        PathConsumer2D out;
        float Mxx;
        float Mxy;
        float Mxt;
        float Myx;
        float Myy;
        float Myt;

        TransformFilter(PathConsumer2D out, float Mxx, float Mxy, float Mxt, float Myx, float Myy, float Myt) {
            this.out = out;
            this.Mxx = Mxx;
            this.Mxy = Mxy;
            this.Mxt = Mxt;
            this.Myx = Myx;
            this.Myy = Myy;
            this.Myt = Myt;
        }

        public void moveTo(float x0, float y0) {
            this.out.moveTo(x0 * this.Mxx + y0 * this.Mxy + this.Mxt, x0 * this.Myx + y0 * this.Myy + this.Myt);
        }

        public void lineTo(float x1, float y1) {
            this.out.lineTo(x1 * this.Mxx + y1 * this.Mxy + this.Mxt, x1 * this.Myx + y1 * this.Myy + this.Myt);
        }

        public void quadTo(float x1, float y1, float x2, float y2) {
            this.out.quadTo(x1 * this.Mxx + y1 * this.Mxy + this.Mxt, x1 * this.Myx + y1 * this.Myy + this.Myt, x2 * this.Mxx + y2 * this.Mxy + this.Mxt, x2 * this.Myx + y2 * this.Myy + this.Myt);
        }

        public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
            this.out.curveTo(x1 * this.Mxx + y1 * this.Mxy + this.Mxt, x1 * this.Myx + y1 * this.Myy + this.Myt, x2 * this.Mxx + y2 * this.Mxy + this.Mxt, x2 * this.Myx + y2 * this.Myy + this.Myt, x3 * this.Mxx + y3 * this.Mxy + this.Mxt, x3 * this.Myx + y3 * this.Myy + this.Myt);
        }

        public void closePath() {
            this.out.closePath();
        }

        public void pathDone() {
            this.out.pathDone();
        }

        public long getNativeConsumer() {
            return 0L;
        }
    }

    static class ScaleFilter
    implements PathConsumer2D {
        PathConsumer2D out;
        float sx;
        float sy;
        float tx;
        float ty;

        ScaleFilter(PathConsumer2D out, float sx, float sy, float tx, float ty) {
            this.out = out;
            this.sx = sx;
            this.sy = sy;
            this.tx = tx;
            this.ty = ty;
        }

        public void moveTo(float x0, float y0) {
            this.out.moveTo(x0 * this.sx + this.tx, y0 * this.sy + this.ty);
        }

        public void lineTo(float x1, float y1) {
            this.out.lineTo(x1 * this.sx + this.tx, y1 * this.sy + this.ty);
        }

        public void quadTo(float x1, float y1, float x2, float y2) {
            this.out.quadTo(x1 * this.sx + this.tx, y1 * this.sy + this.ty, x2 * this.sx + this.tx, y2 * this.sy + this.ty);
        }

        public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
            this.out.curveTo(x1 * this.sx + this.tx, y1 * this.sy + this.ty, x2 * this.sx + this.tx, y2 * this.sy + this.ty, x3 * this.sx + this.tx, y3 * this.sy + this.ty);
        }

        public void closePath() {
            this.out.closePath();
        }

        public void pathDone() {
            this.out.pathDone();
        }

        public long getNativeConsumer() {
            return 0L;
        }
    }

    static class TranslateFilter
    implements PathConsumer2D {
        PathConsumer2D out;
        float tx;
        float ty;

        TranslateFilter(PathConsumer2D out, float tx, float ty) {
            this.out = out;
            this.tx = tx;
            this.ty = ty;
        }

        public void moveTo(float x0, float y0) {
            this.out.moveTo(x0 + this.tx, y0 + this.ty);
        }

        public void lineTo(float x1, float y1) {
            this.out.lineTo(x1 + this.tx, y1 + this.ty);
        }

        public void quadTo(float x1, float y1, float x2, float y2) {
            this.out.quadTo(x1 + this.tx, y1 + this.ty, x2 + this.tx, y2 + this.ty);
        }

        public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
            this.out.curveTo(x1 + this.tx, y1 + this.ty, x2 + this.tx, y2 + this.ty, x3 + this.tx, y3 + this.ty);
        }

        public void closePath() {
            this.out.closePath();
        }

        public void pathDone() {
            this.out.pathDone();
        }

        public long getNativeConsumer() {
            return 0L;
        }
    }
}

