/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.xr;

import java.awt.MultipleGradientPaint;
import sun.java2d.loops.SurfaceType;

public class XRUtils {
    public static final int None = 0;
    public static final byte PictOpClear = 0;
    public static final byte PictOpSrc = 1;
    public static final byte PictOpDst = 2;
    public static final byte PictOpOver = 3;
    public static final byte PictOpOverReverse = 4;
    public static final byte PictOpIn = 5;
    public static final byte PictOpInReverse = 6;
    public static final byte PictOpOut = 7;
    public static final byte PictOpOutReverse = 8;
    public static final byte PictOpAtop = 9;
    public static final byte PictOpAtopReverse = 10;
    public static final byte PictOpXor = 11;
    public static final byte PictOpAdd = 12;
    public static final byte PictOpSaturate = 13;
    public static final int RepeatNone = 0;
    public static final int RepeatNormal = 1;
    public static final int RepeatPad = 2;
    public static final int RepeatReflect = 3;
    public static final int FAST = 0;
    public static final int GOOD = 1;
    public static final int BEST = 2;
    public static final byte[] FAST_NAME = "fast".getBytes();
    public static final byte[] GOOD_NAME = "good".getBytes();
    public static final byte[] BEST_NAME = "best".getBytes();
    public static final int PictStandardARGB32 = 0;
    public static final int PictStandardRGB24 = 1;
    public static final int PictStandardA8 = 2;
    public static final int PictStandardA4 = 3;
    public static final int PictStandardA1 = 4;

    public static int ATransOpToXRQuality(int affineTranformOp) {
        switch (affineTranformOp) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        return -1;
    }

    public static byte[] ATransOpToXRQualityName(int affineTranformOp) {
        switch (affineTranformOp) {
            case 1: {
                return FAST_NAME;
            }
            case 2: {
                return GOOD_NAME;
            }
            case 3: {
                return BEST_NAME;
            }
        }
        return null;
    }

    public static byte[] getFilterName(int filterType) {
        switch (filterType) {
            case 0: {
                return FAST_NAME;
            }
            case 1: {
                return GOOD_NAME;
            }
            case 2: {
                return BEST_NAME;
            }
        }
        return null;
    }

    public static int getPictureFormatForTransparency(int transparency) {
        switch (transparency) {
            case 1: {
                return 1;
            }
            case 2: 
            case 3: {
                return 0;
            }
        }
        return -1;
    }

    public static SurfaceType getXRSurfaceTypeForTransparency(int transparency) {
        if (transparency == 1) {
            return SurfaceType.IntRgb;
        }
        return SurfaceType.IntArgbPre;
    }

    public static int getRepeatForCycleMethod(MultipleGradientPaint.CycleMethod cycleMethod) {
        if (cycleMethod.equals((Object)MultipleGradientPaint.CycleMethod.NO_CYCLE)) {
            return 2;
        }
        if (cycleMethod.equals((Object)MultipleGradientPaint.CycleMethod.REFLECT)) {
            return 3;
        }
        if (cycleMethod.equals((Object)MultipleGradientPaint.CycleMethod.REPEAT)) {
            return 1;
        }
        return 0;
    }

    public static int XDoubleToFixed(double dbl) {
        return (int)(dbl * 65536.0);
    }

    public static double XFixedToDouble(int fixed) {
        return (double)fixed / 65536.0;
    }

    public static int[] convertFloatsToFixed(float[] values) {
        int[] fixed = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            fixed[i] = XRUtils.XDoubleToFixed(values[i]);
        }
        return fixed;
    }

    public static long intToULong(int signed) {
        if (signed < 0) {
            return (long)signed + 0x100000000L;
        }
        return signed;
    }

    public static byte j2dAlphaCompToXR(int j2dRule) {
        switch (j2dRule) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 9: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 10: {
                return 9;
            }
            case 11: {
                return 10;
            }
            case 12: {
                return 11;
            }
        }
        throw new InternalError("No XRender equivalent available for requested java2d composition rule: " + j2dRule);
    }

    public static short clampToShort(int x) {
        return (short)(x > Short.MAX_VALUE ? Short.MAX_VALUE : (x < Short.MIN_VALUE ? Short.MIN_VALUE : x));
    }

    public static short clampToUShort(int x) {
        return (short)(x > 65535 ? 65535 : (x < 0 ? 0 : x));
    }
}

