/*
 * Decompiled with CFR 0.152.
 */
package sun.management.counter;

import sun.management.counter.Counter;
import sun.management.counter.Units;
import sun.management.counter.Variability;

public abstract class AbstractCounter
implements Counter {
    String name;
    Units units;
    Variability variability;
    int flags;
    int vectorLength;
    private static final long serialVersionUID = 6992337162326171013L;

    protected AbstractCounter(String name, Units units, Variability variability, int flags, int vectorLength) {
        this.name = name;
        this.units = units;
        this.variability = variability;
        this.flags = flags;
        this.vectorLength = vectorLength;
    }

    protected AbstractCounter(String name, Units units, Variability variability, int flags) {
        this(name, units, variability, flags, 0);
    }

    public String getName() {
        return this.name;
    }

    public Units getUnits() {
        return this.units;
    }

    public Variability getVariability() {
        return this.variability;
    }

    public boolean isVector() {
        return this.vectorLength > 0;
    }

    public int getVectorLength() {
        return this.vectorLength;
    }

    public boolean isInternal() {
        return (this.flags & 1) == 0;
    }

    public int getFlags() {
        return this.flags;
    }

    public abstract Object getValue();

    public String toString() {
        String result = this.getName() + ": " + this.getValue() + " " + this.getUnits();
        if (this.isInternal()) {
            return result + " [INTERNAL]";
        }
        return result;
    }

    class Flags {
        static final int SUPPORTED = 1;

        Flags() {
        }
    }
}

