/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import sun.applet.BarClass3;
import sun.applet.FooClass;
import sun.applet.JSObject;

public class MethodOverloadResolver {
    private static boolean debugging = false;

    public static void main(String[] args) {
        MethodOverloadResolver.testMethodResolver();
    }

    public static void testMethodResolver() {
        debugging = true;
        ArrayList<Object[]> list = new ArrayList<Object[]>(20);
        FooClass fc = new FooClass();
        String s1 = "foo_string_int(S,I)";
        String s1a = "foo_string_int(S,S)";
        Object[] o1 = new Object[]{fc.getClass(), "foo_string_int", "blah", 42};
        list.add(o1);
        Object[] o1a = new Object[]{fc.getClass(), "foo_string_int", "blah", "42.42"};
        list.add(o1a);
        String s2 = "foo_string_int(N)";
        Object[] o2 = new Object[]{fc.getClass(), "foo_string_int", "blah", null};
        list.add(o2);
        String s3 = "foo_jsobj(LLowCostSignatureComputer/JSObject;)";
        Object[] o3 = new Object[]{fc.getClass(), "foo_jsobj", new JSObject()};
        list.add(o3);
        String s4 = "foo_classtype(Ljava/lang/Integer;)";
        Object[] o4 = new Object[]{fc.getClass(), "foo_classtype", 42};
        list.add(o4);
        String s5 = "foo_multiprim(I)";
        String s6 = "foo_multiprim(F)";
        String s6a = "foo_multiprim(D)";
        Object[] o5 = new Object[]{fc.getClass(), "foo_multiprim", new Integer(42)};
        Object[] o6 = new Object[]{fc.getClass(), "foo_multiprim", new Float(42.42)};
        Object[] o6a = new Object[]{fc.getClass(), "foo_multiprim", new Double(42.42)};
        list.add(o5);
        list.add(o6);
        list.add(o6a);
        String s7 = "foo_float(I)";
        Object[] o7 = new Object[]{fc.getClass(), "foo_float", new Integer(42)};
        list.add(o7);
        String s8 = "foo_float(S)";
        Object[] o8 = new Object[]{fc.getClass(), "foo_float", "42"};
        list.add(o8);
        String s9 = "foo_class(LLowCostSignatureComputer/BarClass3;)";
        Object[] o9 = new Object[]{fc.getClass(), "foo_class", new BarClass3()};
        list.add(o9);
        String s10 = "foo_strandbyteonly(I)";
        Object[] o10 = new Object[]{fc.getClass(), "foo_strandbyteonly", 42};
        list.add(o10);
        String s11 = "foo_strandbyteonly(LLowCostSignatureComputer/JSObject;)";
        Object[] o11 = new Object[]{fc.getClass(), "foo_strandbyteonly", new JSObject()};
        list.add(o11);
        String s12 = "foo_str_and_float(S,I)";
        Object[] o12 = new Object[]{fc.getClass(), "foo_str_and_float", new JSObject(), new Integer(42)};
        list.add(o12);
        String s13 = "foo_int_only(JSObject)";
        Object[] o13 = new Object[]{fc.getClass(), "foo_int_only", new JSObject()};
        list.add(o13);
        String s14 = "foo_noargs()";
        Object[] o14 = new Object[]{fc.getClass(), "foo_noargs"};
        list.add(o14);
        String s15 = "foo_boolonly()";
        Object[] o15 = new Object[]{fc.getClass(), "foo_boolonly", new Boolean(true)};
        list.add(o15);
        for (Object[] o : list) {
            Object[] methodAndArgs = MethodOverloadResolver.getMatchingMethod(o);
            if (!debugging) continue;
            if (methodAndArgs != null) {
                System.out.println("Best match: " + methodAndArgs[0] + "\n");
                continue;
            }
            System.out.println("No match found.\n");
        }
    }

    public static Object[] getMatchingMethod(Object[] callList) {
        Object[] ret = null;
        Class c = (Class)callList[0];
        String methodName = (String)callList[1];
        Method[] matchingMethods = MethodOverloadResolver.getMatchingMethods(c, methodName, callList.length - 2);
        if (debugging) {
            System.out.println("getMatchingMethod called with: " + MethodOverloadResolver.printList(callList));
        }
        int lowestCost = Integer.MAX_VALUE;
        ArrayList paramList = new ArrayList();
        for (Method matchingMethod : matchingMethods) {
            int methodCost = 0;
            Class<?>[] paramTypes = matchingMethod.getParameterTypes();
            Object[] methodAndArgs = new Object[paramTypes.length + 1];
            methodAndArgs[0] = matchingMethod;
            for (int i = 0; i < paramTypes.length; ++i) {
                Boolean castedObjIsPrim;
                Object castedObj;
                Class<?> paramTypeClass = paramTypes[i];
                Object suppliedParam = callList[i + 2];
                Class<?> suppliedParamClass = suppliedParam != null ? suppliedParam.getClass() : null;
                Object[] costAndCastedObj = MethodOverloadResolver.getCostAndCastedObject(suppliedParam, paramTypeClass);
                methodCost += ((Integer)costAndCastedObj[0]).intValue();
                if ((Integer)costAndCastedObj[0] < 0) break;
                methodAndArgs[i + 1] = castedObj = paramTypeClass.isPrimitive() ? costAndCastedObj[1] : paramTypeClass.cast(costAndCastedObj[1]);
                Class<?> castedObjClass = castedObj == null ? null : castedObj.getClass();
                Boolean bl = castedObjIsPrim = castedObj == null ? null : Boolean.valueOf(castedObj.getClass().isPrimitive());
                if (!debugging) continue;
                System.out.println("Param " + i + " of method " + matchingMethod + " has cost " + (Integer)costAndCastedObj[0] + " original param type " + suppliedParamClass + " casted to " + castedObjClass + " isPrimitive=" + castedObjIsPrim + " value " + castedObj);
            }
            if ((methodCost <= 0 || methodCost >= lowestCost) && paramTypes.length != 0) continue;
            ret = methodAndArgs;
            lowestCost = methodCost;
        }
        return ret;
    }

    public static Object[] getMatchingConstructor(Object[] callList) {
        Object[] ret = null;
        Class c = (Class)callList[0];
        Constructor[] matchingConstructors = MethodOverloadResolver.getMatchingConstructors(c, callList.length - 1);
        if (debugging) {
            System.out.println("getMatchingConstructor called with: " + MethodOverloadResolver.printList(callList));
        }
        int lowestCost = Integer.MAX_VALUE;
        ArrayList paramList = new ArrayList();
        for (Constructor matchingConstructor : matchingConstructors) {
            int constructorCost = 0;
            Class<?>[] paramTypes = matchingConstructor.getParameterTypes();
            Object[] constructorAndArgs = new Object[paramTypes.length + 1];
            constructorAndArgs[0] = matchingConstructor;
            for (int i = 0; i < paramTypes.length; ++i) {
                Boolean castedObjIsPrim;
                Object castedObj;
                Class<?> paramTypeClass = paramTypes[i];
                Object suppliedParam = callList[i + 1];
                Class<?> suppliedParamClass = suppliedParam != null ? suppliedParam.getClass() : null;
                Object[] costAndCastedObj = MethodOverloadResolver.getCostAndCastedObject(suppliedParam, paramTypeClass);
                constructorCost += ((Integer)costAndCastedObj[0]).intValue();
                if ((Integer)costAndCastedObj[0] < 0) break;
                constructorAndArgs[i + 1] = castedObj = paramTypeClass.isPrimitive() ? costAndCastedObj[1] : paramTypeClass.cast(costAndCastedObj[1]);
                Class<?> castedObjClass = castedObj == null ? null : castedObj.getClass();
                Boolean bl = castedObjIsPrim = castedObj == null ? null : Boolean.valueOf(castedObj.getClass().isPrimitive());
                if (!debugging) continue;
                System.out.println("Param " + i + " of constructor " + matchingConstructor + " has cost " + (Integer)costAndCastedObj[0] + " original param type " + suppliedParamClass + " casted to " + castedObjClass + " isPrimitive=" + castedObjIsPrim + " value " + castedObj);
            }
            if ((constructorCost <= 0 || constructorCost >= lowestCost) && paramTypes.length != 0) continue;
            ret = constructorAndArgs;
            lowestCost = constructorCost;
        }
        return ret;
    }

    public static Object[] getCostAndCastedObject(Object suppliedParam, Class<?> paramTypeClass) {
        Object castedObj;
        boolean suppliedParamIsArray;
        Object[] ret = new Object[2];
        Integer cost = new Integer(0);
        Class<?> suppliedParamClass = suppliedParam != null ? suppliedParam.getClass() : null;
        boolean bl = suppliedParamIsArray = suppliedParamClass != null && suppliedParamClass.isArray();
        if (paramTypeClass.isArray() != suppliedParamIsArray && !paramTypeClass.equals(Object.class) && !paramTypeClass.equals(String.class)) {
            ret[0] = Integer.MIN_VALUE;
            ret[1] = suppliedParam;
            return ret;
        }
        if (paramTypeClass.isArray()) {
            Object newArray = Array.newInstance(paramTypeClass.getComponentType(), Array.getLength(suppliedParam));
            for (int i = 0; i < Array.getLength(suppliedParam); ++i) {
                Object[] costAndCastedObject;
                Object original = Array.get(suppliedParam, i);
                if (original == null && paramTypeClass.getComponentType().isPrimitive()) {
                    original = 0;
                }
                if ((Integer)(costAndCastedObject = MethodOverloadResolver.getCostAndCastedObject(original, paramTypeClass.getComponentType()))[0] < 0) {
                    ret[0] = Integer.MIN_VALUE;
                    ret[1] = suppliedParam;
                    return ret;
                }
                Array.set(newArray, i, costAndCastedObject[1]);
            }
            ret[0] = 9;
            ret[1] = newArray;
            return ret;
        }
        if (suppliedParamIsArray && paramTypeClass.equals(String.class)) {
            ret[0] = 9;
            ret[1] = MethodOverloadResolver.getArrayAsString(suppliedParam);
            return ret;
        }
        if (suppliedParamClass == null) {
            castedObj = null;
            cost = !paramTypeClass.isPrimitive() ? Integer.valueOf(cost + 2) : Integer.valueOf(Integer.MIN_VALUE);
        } else if (paramTypeClass.isPrimitive() && paramTypeClass.equals(MethodOverloadResolver.getPrimitive(suppliedParam))) {
            cost = cost + 1;
            castedObj = suppliedParam;
        } else if (suppliedParamClass.equals(paramTypeClass)) {
            cost = cost + 3;
            castedObj = suppliedParam;
        } else if (MethodOverloadResolver.isNum(suppliedParam) && (paramTypeClass.isPrimitive() || Number.class.isAssignableFrom(paramTypeClass) || Character.class.isAssignableFrom(paramTypeClass) || Byte.class.isAssignableFrom(paramTypeClass))) {
            cost = cost + 4;
            if (suppliedParam.toString().equals("true")) {
                suppliedParam = "1";
            } else if (suppliedParam.toString().equals("false")) {
                suppliedParam = "0";
            }
            castedObj = paramTypeClass.equals(Boolean.TYPE) ? Boolean.valueOf(MethodOverloadResolver.getNum(suppliedParam.toString(), paramTypeClass).doubleValue() != 0.0) : (paramTypeClass.equals(Character.TYPE) ? (Serializable)Character.valueOf((char)Short.decode(suppliedParam.toString()).shortValue()) : (Serializable)MethodOverloadResolver.getNum(suppliedParam.toString(), paramTypeClass));
        } else if (suppliedParam instanceof String && MethodOverloadResolver.isNum(suppliedParam) && (paramTypeClass.isInstance(Number.class) || paramTypeClass.isInstance(Character.class) || paramTypeClass.isInstance(Byte.class) || paramTypeClass.isPrimitive())) {
            cost = cost + 5;
            if (suppliedParam.toString().equals("true")) {
                suppliedParam = "1";
            } else if (suppliedParam.toString().equals("false")) {
                suppliedParam = "0";
            }
            castedObj = paramTypeClass.equals(Character.TYPE) ? (Serializable)Character.valueOf((char)Short.decode(suppliedParam.toString()).shortValue()) : (Serializable)MethodOverloadResolver.getNum(suppliedParam.toString(), paramTypeClass);
        } else if (suppliedParam instanceof String && (paramTypeClass.equals(Boolean.class) || paramTypeClass.equals(Boolean.TYPE))) {
            cost = cost + 5;
            castedObj = new Boolean(suppliedParam.toString().length() > 0);
        } else if (paramTypeClass.isAssignableFrom(suppliedParamClass)) {
            cost = cost + 6;
            castedObj = paramTypeClass.cast(suppliedParam);
        } else if (paramTypeClass.equals(String.class)) {
            cost = cost + 7;
            castedObj = suppliedParam.toString();
        } else if (suppliedParam instanceof JSObject && paramTypeClass.isArray()) {
            cost = cost + 8;
            castedObj = (JSObject)suppliedParam;
        } else {
            cost = Integer.MIN_VALUE;
            castedObj = suppliedParam;
        }
        ret[0] = cost;
        ret[1] = castedObj;
        return ret;
    }

    private static Method[] getMatchingMethods(Class<?> c, String name, int paramCount) {
        Method[] allMethods = c.getMethods();
        ArrayList<Method> matchingMethods = new ArrayList<Method>(5);
        for (Method m : allMethods) {
            if (!m.getName().equals(name) || m.getParameterTypes().length != paramCount) continue;
            matchingMethods.add(m);
        }
        return matchingMethods.toArray(new Method[0]);
    }

    private static Constructor[] getMatchingConstructors(Class<?> c, int paramCount) {
        Constructor<?>[] allConstructors = c.getConstructors();
        ArrayList matchingConstructors = new ArrayList(5);
        for (Constructor<?> cs : allConstructors) {
            if (cs.getParameterTypes().length != paramCount) continue;
            matchingConstructors.add(cs);
        }
        return matchingConstructors.toArray(new Constructor[0]);
    }

    private static Class getPrimitive(Object o) {
        if (o instanceof Byte) {
            return Byte.TYPE;
        }
        if (o instanceof Character) {
            return Character.TYPE;
        }
        if (o instanceof Short) {
            return Short.TYPE;
        }
        if (o instanceof Integer) {
            return Integer.TYPE;
        }
        if (o instanceof Long) {
            return Long.TYPE;
        }
        if (o instanceof Float) {
            return Float.TYPE;
        }
        if (o instanceof Double) {
            return Double.TYPE;
        }
        if (o instanceof Boolean) {
            return Boolean.TYPE;
        }
        return o.getClass();
    }

    private static boolean isNum(Object o) {
        if (o instanceof Number) {
            return true;
        }
        if (o instanceof Boolean) {
            return true;
        }
        if (!(o instanceof String)) {
            return false;
        }
        try {
            Long.parseLong((String)o);
            return true;
        }
        catch (NumberFormatException nfe) {
            try {
                Float.parseFloat((String)o);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
    }

    private static Number getNum(String s, Class<?> c) throws NumberFormatException {
        Number n = s.contains(".") ? (Number)new Double(s) : (Number)new Long(s);
        if (c.equals(Integer.class) || c.equals(Integer.TYPE)) {
            return n.intValue();
        }
        if (c.equals(Long.class) || c.equals(Long.TYPE)) {
            return n.longValue();
        }
        if (c.equals(Short.class) || c.equals(Short.TYPE)) {
            return n.shortValue();
        }
        if (c.equals(Float.class) || c.equals(Float.TYPE)) {
            return Float.valueOf(n.floatValue());
        }
        if (c.equals(Double.class) || c.equals(Double.TYPE)) {
            return n.doubleValue();
        }
        if (c.equals(Byte.class) || c.equals(Byte.TYPE)) {
            return n.byteValue();
        }
        return n;
    }

    private static String printList(Object[] oList) {
        String ret = "";
        ret = ret + "{ ";
        for (Object o : oList) {
            String oStr = o != null ? o.toString() + " [" + o.getClass() + "]" : "null";
            ret = ret + oStr;
            ret = ret + ", ";
        }
        ret = ret.substring(0, ret.length() - 2);
        ret = ret + " }";
        return ret;
    }

    private static String getArrayAsString(Object array) {
        String ret = new String();
        for (int i = 0; i < Array.getLength(array); ++i) {
            Object element = Array.get(array, i);
            if (element != null) {
                ret = element.getClass().isArray() ? ret + MethodOverloadResolver.getArrayAsString(element) : ret + element;
            }
            ret = ret + ",";
        }
        if (ret.length() > 0) {
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret;
    }
}

