/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.applet.Applet;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Hashtable;
import net.sourceforge.jnlp.NetxPanel;
import sun.applet.AppletPanel;
import sun.applet.AppletSecurityContextManager;
import sun.applet.AppletViewerPanel;
import sun.applet.PluginAppletViewer;
import sun.applet.PluginDebug;
import sun.applet.PluginStreamHandler;

class PluginAppletPanelFactory {
    PluginAppletPanelFactory() {
    }

    public AppletPanel createPanel(PluginStreamHandler streamhandler, int identifier, long handle, int x, int y, final URL doc, final Hashtable<String, String> atts) {
        AppletViewerPanel panel = AccessController.doPrivileged(new PrivilegedAction<AppletViewerPanel>(){

            @Override
            public AppletViewerPanel run() {
                try {
                    NetxPanel panel = new NetxPanel(doc, atts, false);
                    AppletViewerPanel.debug((String)"Using NetX panel");
                    PluginDebug.debug(atts.toString());
                    return panel;
                }
                catch (Exception ex) {
                    AppletViewerPanel.debug((String)"Unable to start NetX applet - defaulting to Sun applet", (Throwable)ex);
                    return new AppletViewerPanel(doc, atts);
                }
            }
        });
        PluginAppletViewer.framePanel(identifier, System.out, handle, panel);
        panel.init();
        this.initEventQueue((AppletPanel)panel);
        String portComponent = doc.getPort() != -1 ? ":" + doc.getPort() : "";
        String codeBase = doc.getProtocol() + "://" + doc.getHost() + portComponent;
        if (atts.get("codebase") != null) {
            try {
                URL appletSrcURL = new URL(codeBase + atts.get("codebase"));
                codeBase = appletSrcURL.getProtocol() + "://" + appletSrcURL.getHost();
            }
            catch (MalformedURLException mfue) {
                // empty catch block
            }
        }
        int maxWait = 180000;
        int wait = 0;
        while (panel == null || !((NetxPanel)panel).isAlive() && wait < maxWait) {
            try {
                Thread.sleep(50L);
                wait += 50;
            }
            catch (InterruptedException ie) {}
        }
        PluginAppletViewer.waitForAppletInit((NetxPanel)panel);
        Applet a = panel.getApplet();
        if (panel.getApplet() == null) {
            streamhandler.write("instance " + identifier + " reference " + -1 + " fatalError " + "Initialization failed");
            return null;
        }
        PluginDebug.debug("Applet " + a.getClass() + " initialized");
        streamhandler.write("instance " + identifier + " reference 0 initialized");
        AppletSecurityContextManager.getSecurityContext(0).associateSrc(((NetxPanel)panel).getAppletClassLoader(), doc);
        AppletSecurityContextManager.getSecurityContext(0).associateInstance(identifier, ((NetxPanel)panel).getAppletClassLoader());
        return panel;
    }

    public boolean isStandalone() {
        return false;
    }

    private void initEventQueue(AppletPanel panel) {
        PrivilegedAction<String> pa = new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("appletviewer.send.event");
            }
        };
        String eventList = AccessController.doPrivileged(pa);
        if (eventList == null) {
            panel.sendEvent(1);
            panel.sendEvent(2);
            panel.sendEvent(3);
        } else {
            String[] events = this.splitSeparator(",", eventList);
            for (int i = 0; i < events.length; ++i) {
                PluginDebug.debug("Adding event to queue: " + events[i]);
                if (events[i].equals("dispose")) {
                    panel.sendEvent(0);
                    continue;
                }
                if (events[i].equals("load")) {
                    panel.sendEvent(1);
                    continue;
                }
                if (events[i].equals("init")) {
                    panel.sendEvent(2);
                    continue;
                }
                if (events[i].equals("start")) {
                    panel.sendEvent(3);
                    continue;
                }
                if (events[i].equals("stop")) {
                    panel.sendEvent(4);
                    continue;
                }
                if (events[i].equals("destroy")) {
                    panel.sendEvent(5);
                    continue;
                }
                if (events[i].equals("quit")) {
                    panel.sendEvent(6);
                    continue;
                }
                if (events[i].equals("error")) {
                    panel.sendEvent(7);
                    continue;
                }
                PluginDebug.debug("Unrecognized event name: " + events[i]);
            }
            while (!panel.emptyEventQueue()) {
            }
        }
    }

    private String[] splitSeparator(String sep, String s) {
        ArrayList<String> l = new ArrayList<String>();
        int tokenStart = 0;
        int tokenEnd = 0;
        while ((tokenEnd = s.indexOf(sep, tokenStart)) != -1) {
            l.add(s.substring(tokenStart, tokenEnd));
            tokenStart = tokenEnd + 1;
        }
        l.add(s.substring(tokenStart));
        return l.toArray(new String[l.size()]);
    }
}

