/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import com.sun.jndi.toolkit.url.UrlUtil;
import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AudioClip;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketPermission;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.SwingUtilities;
import net.sourceforge.jnlp.NetxPanel;
import net.sourceforge.jnlp.runtime.JNLPClassLoader;
import sun.applet.AppletAudioClip;
import sun.applet.AppletEvent;
import sun.applet.AppletImageRef;
import sun.applet.AppletListener;
import sun.applet.AppletMessageHandler;
import sun.applet.AppletPanel;
import sun.applet.AppletSecurityContextManager;
import sun.applet.AppletViewerPanel;
import sun.applet.PluginAppletPanelFactory;
import sun.applet.PluginCallRequest;
import sun.applet.PluginCallRequestFactory;
import sun.applet.PluginDebug;
import sun.applet.PluginMessageConsumer;
import sun.applet.PluginParseRequest;
import sun.applet.PluginStreamHandler;
import sun.awt.AppContext;
import sun.awt.SunToolkit;
import sun.awt.X11.XEmbeddedFrame;
import sun.misc.Ref;

public class PluginAppletViewer
extends XEmbeddedFrame
implements AppletContext,
Printable {
    private static String defaultSaveFile = "Applet.ser";
    AppletViewerPanel panel;
    Label label;
    PrintStream statusMsgStream;
    int identifier;
    private static HashMap<Integer, PluginParseRequest> requests = new HashMap();
    private static HashMap<Integer, PluginAppletViewer> applets = new HashMap();
    private static PluginStreamHandler streamhandler;
    private static PluginCallRequestFactory requestFactory;
    private static HashMap<Integer, PAV_INIT_STATUS> status;
    private long handle = 0L;
    private WindowListener windowEventListener = null;
    private AppletEventListener appletEventListener = null;
    public static final int APPLET_TIMEOUT = 180000;
    private static Long requestIdentityCounter;
    private Image bufFrameImg;
    private Graphics bufFrameImgGraphics;
    private static Map<URL, AudioClip> audioClips;
    private static Map<URL, AppletImageRef> imageRefs;
    static Vector<AppletPanel> appletPanels;
    static Hashtable<String, String> systemParam;
    private static int x;
    private static int y;
    private static final int XDELTA = 30;
    private static final int YDELTA = 30;
    static String encoding;
    private static AppletMessageHandler amh;

    public PluginAppletViewer() {
    }

    public static void framePanel(int identifier, PrintStream statusMsgStream, long handle, AppletViewerPanel panel) {
        PluginDebug.debug("Framing " + panel);
        System.getSecurityManager().checkPermission(new AllPermission());
        PluginAppletViewer appletFrame = new PluginAppletViewer(handle, identifier, statusMsgStream, panel);
        appletFrame.add("Center", (Component)panel);
        appletFrame.pack();
        appletFrame.appletEventListener = new AppletEventListener(appletFrame, appletFrame);
        panel.addAppletListener((AppletListener)appletFrame.appletEventListener);
        applets.put(identifier, appletFrame);
        PluginDebug.debug(panel + " framed");
    }

    private PluginAppletViewer(long handle, int identifier, PrintStream statusMsgStream, AppletViewerPanel appletPanel) {
        super(handle, true);
        this.statusMsgStream = statusMsgStream;
        this.identifier = identifier;
        this.panel = appletPanel;
        if (!appletPanels.contains(this.panel)) {
            appletPanels.addElement((AppletPanel)this.panel);
        }
        this.windowEventListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PluginAppletViewer.this.appletClose();
            }

            @Override
            public void windowIconified(WindowEvent evt) {
                PluginAppletViewer.this.appletStop();
            }

            @Override
            public void windowDeiconified(WindowEvent evt) {
                PluginAppletViewer.this.appletStart();
            }
        };
        this.addWindowListener(this.windowEventListener);
    }

    public static void setStreamhandler(PluginStreamHandler sh) {
        streamhandler = sh;
    }

    public static void setPluginCallRequestFactory(PluginCallRequestFactory rf) {
        requestFactory = rf;
    }

    public static void handleMessage(int identifier, int reference, String message) {
        PluginDebug.debug("PAV handling: " + message);
        try {
            if (message.startsWith("handle")) {
                if (PluginAppletViewer.updateStatus(identifier, PAV_INIT_STATUS.PRE_INIT) != null) {
                    return;
                }
                String[] msgParts = new String[4];
                for (int i = 0; i < 3; ++i) {
                    int spaceLocation = message.indexOf(32);
                    int nextSpaceLocation = message.indexOf(32, spaceLocation + 1);
                    msgParts[i] = message.substring(spaceLocation + 1, nextSpaceLocation);
                    message = message.substring(nextSpaceLocation + 1);
                }
                long handle = Long.parseLong(msgParts[0]);
                String width = msgParts[1];
                String height = msgParts[2];
                int spaceLocation = message.indexOf(32, "tag".length() + 1);
                String documentBase = UrlUtil.decode(message.substring("tag".length() + 1, spaceLocation));
                String tag = message.substring(spaceLocation + 1);
                PluginDebug.debug("Handle = " + handle + "\n" + "Width = " + width + "\n" + "Height = " + height + "\n" + "DocumentBase = " + documentBase + "\n" + "Tag = " + tag);
                PluginAppletViewer.parse(identifier, handle, width, height, new StringReader(tag), new URL(documentBase));
                int maxWait = 180000;
                int wait = 0;
                while (!applets.containsKey(identifier) && wait < maxWait) {
                    try {
                        Thread.sleep(50L);
                        wait += 50;
                    }
                    catch (InterruptedException ie) {}
                }
                if (wait >= maxWait) {
                    throw new Exception("Applet initialization timeout");
                }
                PluginAppletViewer oldFrame = applets.get(identifier);
                PluginAppletViewer.waitForAppletInit((NetxPanel)PluginAppletViewer.applets.get((Object)Integer.valueOf((int)identifier)).panel);
                if (PluginAppletViewer.updateStatus(identifier, PAV_INIT_STATUS.REFRAME_COMPLETE).equals((Object)PAV_INIT_STATUS.INACTIVE)) {
                    PluginAppletViewer.destroyApplet(identifier);
                    return;
                }
            } else if (message.startsWith("destroy")) {
                PAV_INIT_STATUS previousStatus = PluginAppletViewer.updateStatus(identifier, PAV_INIT_STATUS.INACTIVE);
                PluginDebug.debug("Destroy status set for " + identifier);
                if (previousStatus != null && previousStatus.equals((Object)PAV_INIT_STATUS.REFRAME_COMPLETE)) {
                    PluginAppletViewer.destroyApplet(identifier);
                }
            } else {
                PluginDebug.debug("Handling message: " + message + " instance " + identifier + " " + Thread.currentThread());
                while (!(applets.containsKey(identifier) || status.containsKey(identifier) && !status.get(identifier).equals((Object)PAV_INIT_STATUS.PRE_INIT))) {
                }
                if (status.get(identifier).equals((Object)PAV_INIT_STATUS.INACTIVE)) {
                    return;
                }
                applets.get(identifier).handleMessage(reference, message);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            PluginAppletViewer.updateStatus(identifier, PAV_INIT_STATUS.INACTIVE);
            throw new RuntimeException("Failed to handle message: " + message + " for instance " + identifier, e);
        }
    }

    private static synchronized PAV_INIT_STATUS updateStatus(int identifier, PAV_INIT_STATUS newStatus) {
        PAV_INIT_STATUS prev = status.get(identifier);
        if (status.containsKey(identifier)) {
            if (status.get(identifier).equals((Object)PAV_INIT_STATUS.DESTROYED)) {
                return prev;
            }
            if (status.get(identifier).equals((Object)PAV_INIT_STATUS.INACTIVE) && !newStatus.equals((Object)PAV_INIT_STATUS.DESTROYED)) {
                return prev;
            }
        }
        status.put(identifier, newStatus);
        return prev;
    }

    private static synchronized void destroyApplet(int identifier) {
        PluginDebug.debug("DestroyApplet called for " + identifier);
        PAV_INIT_STATUS prev = PluginAppletViewer.updateStatus(identifier, PAV_INIT_STATUS.DESTROYED);
        if (prev.equals((Object)PAV_INIT_STATUS.DESTROYED)) {
            PluginDebug.debug(identifier + " already destroyed. Returning.");
            return;
        }
        PluginDebug.debug("Attempting to destroy frame " + identifier);
        if (applets.containsKey(identifier)) {
            applets.get(identifier).dispose();
        }
        if (PluginAppletViewer.applets.get((Object)Integer.valueOf((int)identifier)).panel.applet == null) {
            PluginDebug.debug(identifier + " panel inactive. Returning.");
            return;
        }
        PluginDebug.debug("Attempting to destroy panel " + identifier);
        final int fIdentifier = identifier;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((PluginAppletViewer)applets.get(fIdentifier)).appletClose();
            }
        });
        PluginDebug.debug(identifier + " destroyed");
    }

    public static void waitForAppletInit(NetxPanel panel) {
        int waitTime = 0;
        while (panel.getApplet() == null && panel.isAlive() && waitTime < 180000) {
            try {
                if (waitTime % 500 == 0) {
                    PluginDebug.debug("Waiting for applet panel " + panel + " to initialize...");
                }
                Thread.sleep(waitTime += 50);
            }
            catch (InterruptedException interruptedException) {}
        }
        PluginDebug.debug("Applet panel " + panel + " initialized");
    }

    public void handleMessage(int reference, String message) {
        if (message.startsWith("width")) {
            int maxWait = 180000;
            int wait = 0;
            while (!status.get(this.identifier).equals((Object)PAV_INIT_STATUS.INIT_COMPLETE) && wait < maxWait) {
                try {
                    Thread.sleep(50L);
                    wait += 50;
                }
                catch (InterruptedException ie) {}
            }
            String[] dimMsg = message.split(" ");
            final int height = Integer.parseInt(dimMsg[3]);
            final int width = Integer.parseInt(dimMsg[1]);
            if (this.panel instanceof NetxPanel) {
                ((NetxPanel)this.panel).updateSizeInAtts(height, width);
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        PluginAppletViewer.this.setSize(width, height);
                        PluginAppletViewer.this.panel.setSize(1, 1);
                        PluginAppletViewer.this.panel.validate();
                        PluginAppletViewer.this.panel.setSize(width, height);
                        PluginAppletViewer.this.panel.validate();
                        PluginAppletViewer.this.panel.applet.resize(width, height);
                        PluginAppletViewer.this.panel.applet.validate();
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        } else if (message.startsWith("GetJavaObject")) {
            int maxWait = 180000;
            int wait = 0;
            while (this.panel == null || !((NetxPanel)this.panel).isAlive() && wait < maxWait) {
                try {
                    Thread.sleep(50L);
                    wait += 50;
                }
                catch (InterruptedException ie) {}
            }
            PluginAppletViewer.waitForAppletInit((NetxPanel)this.panel);
            PluginDebug.debug(this.panel + " -- " + this.panel.getApplet() + " -- " + ((NetxPanel)this.panel).isAlive());
            if (this.panel.getApplet() == null) {
                streamhandler.write("instance " + this.identifier + " reference " + -1 + " fatalError " + "Initialization failed");
                return;
            }
            Applet o = this.panel.getApplet();
            PluginDebug.debug("Looking for object " + o + " panel is " + this.panel);
            AppletSecurityContextManager.getSecurityContext(0).store(o);
            PluginDebug.debug("WRITING 1: context 0 reference " + reference + " GetJavaObject " + AppletSecurityContextManager.getSecurityContext(0).getIdentifier(o));
            streamhandler.write("context 0 reference " + reference + " GetJavaObject " + AppletSecurityContextManager.getSecurityContext(0).getIdentifier(o));
            PluginDebug.debug("WRITING 1 DONE");
        }
    }

    private synchronized void forceredraw() {
        this.doLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioClip getAudioClip(URL url) {
        PluginAppletViewer.checkConnect(url);
        Map<URL, AudioClip> map = audioClips;
        synchronized (map) {
            AudioClip clip = audioClips.get(url);
            if (clip == null) {
                clip = new AppletAudioClip(url);
                audioClips.put(url, clip);
            }
            return clip;
        }
    }

    @Override
    public Image getImage(URL url) {
        return this.getCachedImage(url);
    }

    private Image getCachedImage(URL url) {
        return (Image)this.getCachedImageRef(url).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Ref getCachedImageRef(URL url) {
        PluginDebug.debug("getCachedImageRef() searching for " + url);
        try {
            String originalURL = url.toString();
            String codeBase = this.panel.getCodeBase().toString();
            if (originalURL.startsWith(codeBase)) {
                PluginDebug.debug("getCachedImageRef() got URL = " + url);
                PluginDebug.debug("getCachedImageRef() plugin codebase = " + codeBase);
                if (this.panel instanceof NetxPanel) {
                    URL localURL = null;
                    String resourceName = originalURL.substring(codeBase.length());
                    JNLPClassLoader loader = (JNLPClassLoader)((NetxPanel)this.panel).getAppletClassLoader();
                    if (loader.resourceAvailableLocally(resourceName)) {
                        localURL = loader.getResource(resourceName);
                    }
                    url = localURL != null ? localURL : url;
                }
            }
            PluginDebug.debug("getCachedImageRef() getting img from URL = " + url);
            Map<URL, AppletImageRef> map = imageRefs;
            synchronized (map) {
                AppletImageRef ref = imageRefs.get(url);
                if (ref == null) {
                    ref = new AppletImageRef(url);
                    imageRefs.put(url, ref);
                }
                return ref;
            }
        }
        catch (Exception e) {
            System.err.println("Error occurred when trying to fetch image:");
            e.printStackTrace();
            return null;
        }
    }

    static void flushImageCache() {
        imageRefs.clear();
    }

    @Override
    public Applet getApplet(String name) {
        name = name.toLowerCase();
        SocketPermission panelSp = new SocketPermission(this.panel.getCodeBase().getHost(), "connect");
        Enumeration<AppletPanel> e = appletPanels.elements();
        while (e.hasMoreElements()) {
            SocketPermission sp;
            AppletPanel p = e.nextElement();
            String param = p.getParameter("name");
            if (param != null) {
                param = param.toLowerCase();
            }
            if (!name.equals(param) || !p.getDocumentBase().equals(this.panel.getDocumentBase()) || !panelSp.implies(sp = new SocketPermission(p.getCodeBase().getHost(), "connect"))) continue;
            return p.applet;
        }
        return null;
    }

    @Override
    public Enumeration<Applet> getApplets() {
        Vector<Applet> v = new Vector<Applet>();
        SocketPermission panelSp = new SocketPermission(this.panel.getCodeBase().getHost(), "connect");
        Enumeration<AppletPanel> e = appletPanels.elements();
        while (e.hasMoreElements()) {
            SocketPermission sp;
            AppletPanel p = e.nextElement();
            if (!p.getDocumentBase().equals(this.panel.getDocumentBase()) || !panelSp.implies(sp = new SocketPermission(p.getCodeBase().getHost(), "connect"))) continue;
            v.addElement(p.applet);
        }
        return v.elements();
    }

    @Override
    public void showDocument(URL url) {
        PluginDebug.debug("Showing document...");
        this.showDocument(url, "_self");
    }

    @Override
    public void showDocument(URL url, String target) {
        try {
            this.write("url " + UrlUtil.encode(url.toString(), "UTF-8") + " " + target);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void showStatus(String status) {
        try {
            status = status.replace("\n", " ");
            this.write("status " + status);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Long getRequestIdentifier() {
        Long l = requestIdentityCounter;
        synchronized (l) {
            if (requestIdentityCounter == Long.MAX_VALUE) {
                requestIdentityCounter = 0L;
            }
            Long l2 = requestIdentityCounter;
            Long l3 = requestIdentityCounter = Long.valueOf(requestIdentityCounter + 1L);
            return l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getWindow() {
        PluginDebug.debug("STARTING getWindow");
        Long reference = PluginAppletViewer.getRequestIdentifier();
        PluginCallRequest request = requestFactory.getPluginCallRequest("window", "instance " + this.identifier + " reference " + reference + " " + "GetWindow", reference);
        PluginDebug.debug("STARTING postCallRequest");
        streamhandler.postCallRequest(request);
        PluginDebug.debug("STARTING postCallRequest done");
        streamhandler.write(request.getMessage());
        try {
            PluginDebug.debug("wait request 1");
            PluginCallRequest pluginCallRequest = request;
            synchronized (pluginCallRequest) {
                PluginDebug.debug("wait request 2");
                while ((Long)request.getObject() == 0L) {
                    request.wait();
                }
                PluginDebug.debug("wait request 3");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for call request.", e);
        }
        PluginDebug.debug("STARTING getWindow DONE");
        return (Long)request.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getMember(long internal, String name) {
        AppletSecurityContextManager.getSecurityContext(0).store(name);
        int nameID = AppletSecurityContextManager.getSecurityContext(0).getIdentifier(name);
        Long reference = PluginAppletViewer.getRequestIdentifier();
        PluginCallRequest request = requestFactory.getPluginCallRequest("member", "instance 0 reference " + reference + " GetMember " + internal + " " + nameID, reference);
        streamhandler.postCallRequest(request);
        streamhandler.write(request.getMessage());
        try {
            PluginDebug.debug("wait getMEM request 1");
            PluginCallRequest pluginCallRequest = request;
            synchronized (pluginCallRequest) {
                PluginDebug.debug("wait getMEM request 2");
                while (!request.isDone()) {
                    request.wait();
                }
                PluginDebug.debug("wait getMEM request 3 GOT: " + request.getObject().getClass());
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for call request.", e);
        }
        PluginDebug.debug(" getMember DONE");
        return request.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMember(long internal, String name, Object value) {
        String valueToSetTo;
        System.err.println("Setting to class " + value.getClass() + ":" + value.getClass().isPrimitive());
        AppletSecurityContextManager.getSecurityContext(0).store(name);
        int nameID = AppletSecurityContextManager.getSecurityContext(0).getIdentifier(name);
        Long reference = PluginAppletViewer.getRequestIdentifier();
        if (value instanceof Byte || value instanceof Character || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof Boolean) {
            valueToSetTo = "literalreturn " + value.toString();
            if (value instanceof Character) {
                valueToSetTo = "literalreturn " + ((Character)value).charValue();
            } else if (value instanceof Float || value instanceof Double) {
                valueToSetTo = "literalreturn " + String.format("%308.308e", value);
            }
        } else {
            AppletSecurityContextManager.getSecurityContext(0).store(value);
            valueToSetTo = Integer.toString(AppletSecurityContextManager.getSecurityContext(0).getIdentifier(value));
        }
        PluginCallRequest request = requestFactory.getPluginCallRequest("void", "instance 0 reference " + reference + " SetMember " + internal + " " + nameID + " " + valueToSetTo, reference);
        streamhandler.postCallRequest(request);
        streamhandler.write(request.getMessage());
        try {
            PluginDebug.debug("wait setMem request: " + request.getMessage());
            PluginDebug.debug("wait setMem request 1");
            PluginCallRequest pluginCallRequest = request;
            synchronized (pluginCallRequest) {
                PluginDebug.debug("wait setMem request 2");
                while (!request.isDone()) {
                    request.wait();
                }
                PluginDebug.debug("wait setMem request 3");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for call request.", e);
        }
        PluginDebug.debug(" setMember DONE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSlot(long internal, int index, Object value) {
        String valueToSetTo;
        AppletSecurityContextManager.getSecurityContext(0).store(value);
        Long reference = PluginAppletViewer.getRequestIdentifier();
        if (value instanceof Byte || value instanceof Character || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof Boolean) {
            valueToSetTo = "literalreturn " + value.toString();
            if (value instanceof Character) {
                valueToSetTo = "literalreturn " + ((Character)value).charValue();
            } else if (value instanceof Float || value instanceof Double) {
                valueToSetTo = "literalreturn " + String.format("%308.308e", value);
            }
        } else {
            AppletSecurityContextManager.getSecurityContext(0).store(value);
            valueToSetTo = Integer.toString(AppletSecurityContextManager.getSecurityContext(0).getIdentifier(value));
        }
        PluginCallRequest request = requestFactory.getPluginCallRequest("void", "instance 0 reference " + reference + " SetSlot " + internal + " " + index + " " + valueToSetTo, reference);
        streamhandler.postCallRequest(request);
        streamhandler.write(request.getMessage());
        try {
            PluginDebug.debug("wait setSlot request 1");
            PluginCallRequest pluginCallRequest = request;
            synchronized (pluginCallRequest) {
                PluginDebug.debug("wait setSlot request 2");
                while (!request.isDone()) {
                    request.wait();
                }
                PluginDebug.debug("wait setSlot request 3");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for call request.", e);
        }
        PluginDebug.debug(" setSlot DONE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getSlot(long internal, int index) {
        Long reference = PluginAppletViewer.getRequestIdentifier();
        PluginCallRequest request = requestFactory.getPluginCallRequest("member", "instance 0 reference " + reference + " GetSlot " + internal + " " + index, reference);
        streamhandler.postCallRequest(request);
        streamhandler.write(request.getMessage());
        try {
            PluginDebug.debug("wait getSlot request 1");
            PluginCallRequest pluginCallRequest = request;
            synchronized (pluginCallRequest) {
                PluginDebug.debug("wait getSlot request 2");
                while (!request.isDone()) {
                    request.wait();
                }
                PluginDebug.debug("wait getSlot request 3");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for call request.", e);
        }
        PluginDebug.debug(" getSlot DONE");
        return request.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object eval(long internal, String s) {
        AppletSecurityContextManager.getSecurityContext(0).store(s);
        int stringID = AppletSecurityContextManager.getSecurityContext(0).getIdentifier(s);
        Long reference = PluginAppletViewer.getRequestIdentifier();
        PluginCallRequest request = requestFactory.getPluginCallRequest("member", "instance 0 reference " + reference + " Eval " + internal + " " + stringID, reference);
        streamhandler.postCallRequest(request);
        streamhandler.write(request.getMessage());
        try {
            PluginDebug.debug("wait eval request 1");
            PluginCallRequest pluginCallRequest = request;
            synchronized (pluginCallRequest) {
                PluginDebug.debug("wait eval request 2");
                while (!request.isDone()) {
                    request.wait();
                }
                PluginDebug.debug("wait eval request 3");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for call request.", e);
        }
        PluginDebug.debug(" getSlot DONE");
        return request.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeMember(long internal, String name) {
        AppletSecurityContextManager.getSecurityContext(0).store(name);
        int nameID = AppletSecurityContextManager.getSecurityContext(0).getIdentifier(name);
        Long reference = PluginAppletViewer.getRequestIdentifier();
        PluginCallRequest request = requestFactory.getPluginCallRequest("void", "instance 0 reference " + reference + " RemoveMember " + internal + " " + nameID, reference);
        streamhandler.postCallRequest(request);
        streamhandler.write(request.getMessage());
        try {
            PluginDebug.debug("wait removeMember request 1");
            PluginCallRequest pluginCallRequest = request;
            synchronized (pluginCallRequest) {
                PluginDebug.debug("wait removeMember request 2");
                while (!request.isDone()) {
                    request.wait();
                }
                PluginDebug.debug("wait removeMember request 3");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for call request.", e);
        }
        PluginDebug.debug(" RemoveMember DONE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object call(long internal, String name, Object[] args) {
        AppletSecurityContextManager.getSecurityContext(0).store(name);
        int nameID = AppletSecurityContextManager.getSecurityContext(0).getIdentifier(name);
        Long reference = PluginAppletViewer.getRequestIdentifier();
        String argIDs = "";
        for (Object arg : args) {
            AppletSecurityContextManager.getSecurityContext(0).store(arg);
            argIDs = argIDs + AppletSecurityContextManager.getSecurityContext(0).getIdentifier(arg) + " ";
        }
        argIDs = argIDs.trim();
        PluginCallRequest request = requestFactory.getPluginCallRequest("member", "instance 0 reference " + reference + " Call " + internal + " " + nameID + " " + argIDs, reference);
        streamhandler.postCallRequest(request);
        streamhandler.write(request.getMessage());
        try {
            PluginDebug.debug("wait call request 1");
            PluginCallRequest len$ = request;
            synchronized (len$) {
                PluginDebug.debug("wait call request 2");
                while (!request.isDone()) {
                    request.wait();
                }
                PluginDebug.debug("wait call request 3");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for call request.", e);
        }
        PluginDebug.debug(" Call DONE");
        return request.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object requestPluginCookieInfo(URI uri) {
        PluginCallRequest request;
        Long reference = PluginAppletViewer.getRequestIdentifier();
        try {
            String encodedURI = UrlUtil.encode(uri.toString(), "UTF-8");
            request = requestFactory.getPluginCallRequest("cookieinfo", "plugin PluginCookieInfo reference " + reference + " " + encodedURI, reference);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        PluginMessageConsumer.registerPriorityWait(reference);
        streamhandler.postCallRequest(request);
        streamhandler.write(request.getMessage());
        try {
            PluginDebug.debug("wait cookieinfo request 1");
            PluginCallRequest e = request;
            synchronized (e) {
                PluginDebug.debug("wait cookieinfo request 2");
                while (!request.isDone()) {
                    request.wait();
                }
                PluginDebug.debug("wait cookieinfo request 3");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for cookieinfo request.", e);
        }
        PluginDebug.debug(" Cookieinfo DONE");
        return request.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object requestPluginProxyInfo(URI uri) {
        Object port;
        String requestURI = null;
        Long reference = PluginAppletViewer.getRequestIdentifier();
        try {
            String scheme = uri.getScheme();
            Object object = port = uri.getPort() != -1 ? ":" + uri.getPort() : "";
            if (!uri.getScheme().startsWith("http") && !uri.getScheme().equals("ftp")) {
                scheme = "http";
            }
            requestURI = UrlUtil.encode(scheme + "://" + uri.getHost() + (String)port + "/" + uri.getPath(), "UTF-8");
        }
        catch (Exception e) {
            PluginDebug.debug("Cannot construct URL from " + uri.toString() + " ... falling back to DIRECT proxy");
            e.printStackTrace();
            return null;
        }
        PluginCallRequest request = requestFactory.getPluginCallRequest("proxyinfo", "plugin PluginProxyInfo reference " + reference + " " + requestURI, reference);
        PluginMessageConsumer.registerPriorityWait(reference);
        streamhandler.postCallRequest(request);
        streamhandler.write(request.getMessage());
        try {
            PluginDebug.debug("wait call request 1");
            port = request;
            synchronized (port) {
                PluginDebug.debug("wait call request 2");
                while (!request.isDone()) {
                    request.wait();
                }
                PluginDebug.debug("wait call request 3");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for call request.", e);
        }
        PluginDebug.debug(" Call DONE");
        return request.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void JavaScriptFinalize(long internal) {
        Long reference = PluginAppletViewer.getRequestIdentifier();
        PluginCallRequest request = requestFactory.getPluginCallRequest("void", "instance 0 reference " + reference + " Finalize " + internal, reference);
        streamhandler.postCallRequest(request);
        streamhandler.write(request.getMessage());
        try {
            PluginDebug.debug("wait finalize request 1");
            PluginCallRequest pluginCallRequest = request;
            synchronized (pluginCallRequest) {
                PluginDebug.debug("wait finalize request 2");
                while (!request.isDone()) {
                    request.wait();
                }
                PluginDebug.debug("wait finalize request 3");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for call request.", e);
        }
        PluginDebug.debug(" finalize DONE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String javascriptToString(long internal) {
        Long reference = PluginAppletViewer.getRequestIdentifier();
        PluginCallRequest request = requestFactory.getPluginCallRequest("member", "instance 0 reference " + reference + " ToString " + internal, reference);
        streamhandler.postCallRequest(request);
        streamhandler.write(request.getMessage());
        try {
            PluginDebug.debug("wait ToString request 1");
            PluginCallRequest pluginCallRequest = request;
            synchronized (pluginCallRequest) {
                PluginDebug.debug("wait ToString request 2");
                while (!request.isDone()) {
                    request.wait();
                }
                PluginDebug.debug("wait ToString request 3");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for call request.", e);
        }
        PluginDebug.debug(" ToString DONE");
        return (String)request.getObject();
    }

    private void write(String message) throws IOException {
        PluginDebug.debug("WRITING 2: instance " + this.identifier + " " + message);
        streamhandler.write("instance " + this.identifier + " " + message);
        PluginDebug.debug("WRITING 2 DONE");
    }

    @Override
    public void setStream(String key, InputStream stream) throws IOException {
    }

    @Override
    public InputStream getStream(String key) {
        return null;
    }

    @Override
    public Iterator<String> getStreamKeys() {
        return null;
    }

    public static String decodeString(String toDecode) {
        toDecode = toDecode.replace("&gt;", ">");
        toDecode = toDecode.replace("&lt;", "<");
        toDecode = toDecode.replace("&amp;", "&");
        toDecode = toDecode.replace("&#10;", "\n");
        toDecode = toDecode.replace("&#13;", "\r");
        toDecode = toDecode.replace("&quot;", "\"");
        return toDecode;
    }

    public static void printTag(PrintStream out, Hashtable<String, String> atts) {
        String param;
        out.print("<applet");
        String v = atts.get("codebase");
        if (v != null) {
            out.print(" codebase=\"" + v + "\"");
        }
        if ((v = atts.get("code")) == null) {
            v = "applet.class";
        }
        out.print(" code=\"" + v + "\"");
        v = atts.get("width");
        if (v == null) {
            v = "150";
        }
        out.print(" width=" + v);
        v = atts.get("height");
        if (v == null) {
            v = "100";
        }
        out.print(" height=" + v);
        v = atts.get("name");
        if (v != null) {
            out.print(" name=\"" + v + "\"");
        }
        out.println(">");
        int len = atts.size();
        String[] params = new String[len];
        len = 0;
        Enumeration<String> e = atts.keys();
        while (e.hasMoreElements()) {
            int i;
            param = e.nextElement();
            for (i = 0; i < len && params[i].compareTo(param) < 0; ++i) {
            }
            System.arraycopy(params, i, params, i + 1, len - i);
            params[i] = param;
            ++len;
        }
        for (int i = 0; i < len; ++i) {
            param = params[i];
            if (systemParam.get(param) != null) continue;
            out.println("<param name=" + param + " value=\"" + atts.get(param) + "\">");
        }
        out.println("</applet>");
    }

    public void updateAtts() {
        Dimension d = this.panel.getSize();
        Insets in = this.panel.getInsets();
        this.panel.atts.put("width", Integer.valueOf(d.width - (in.left + in.right)).toString());
        this.panel.atts.put("height", Integer.valueOf(d.height - (in.top + in.bottom)).toString());
    }

    void appletRestart() {
        this.panel.sendEvent(4);
        this.panel.sendEvent(5);
        this.panel.sendEvent(2);
        this.panel.sendEvent(3);
    }

    void appletReload() {
        this.panel.sendEvent(4);
        this.panel.sendEvent(5);
        this.panel.sendEvent(0);
        AppletPanel.flushClassLoader((String)this.panel.getClassLoaderCacheKey());
        try {
            this.panel.joinAppletThread();
            this.panel.release();
        }
        catch (InterruptedException e) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                PluginAppletViewer.this.panel.createAppletThread();
                return null;
            }
        });
        this.panel.sendEvent(1);
        this.panel.sendEvent(2);
        this.panel.sendEvent(3);
    }

    @Override
    public int print(Graphics graphics, PageFormat pf, int pageIndex) {
        return 1;
    }

    void appletStart() {
        this.panel.sendEvent(3);
    }

    void appletStop() {
        this.panel.sendEvent(4);
    }

    private void appletShutdown(AppletPanel p) {
        p.sendEvent(4);
        p.sendEvent(5);
        p.sendEvent(0);
        p.sendEvent(6);
    }

    void appletClose() {
        AppletViewerPanel p = this.panel;
        new Thread(new Runnable((AppletPanel)p){
            final /* synthetic */ AppletPanel val$p;
            {
                this.val$p = appletPanel;
            }

            @Override
            public void run() {
                ThreadGroup tg = ((JNLPClassLoader)this.val$p.applet.getClass().getClassLoader()).getApplication().getThreadGroup();
                PluginAppletViewer.this.appletShutdown(this.val$p);
                appletPanels.removeElement(this.val$p);
                PluginAppletViewer.this.dispose();
                if (tg.activeCount() > 0) {
                    tg.stop();
                }
                if (PluginAppletViewer.countApplets() == 0) {
                    PluginAppletViewer.this.appletSystemExit();
                }
                PluginAppletViewer.updateStatus(PluginAppletViewer.this.identifier, PAV_INIT_STATUS.DESTROYED);
            }
        }).start();
    }

    private void appletSystemExit() {
    }

    public static int countApplets() {
        return appletPanels.size();
    }

    public static void skipSpace(int[] c, Reader in) throws IOException {
        while (c[0] >= 0 && (c[0] == 32 || c[0] == 9 || c[0] == 10 || c[0] == 13)) {
            c[0] = in.read();
        }
    }

    public static String scanIdentifier(int[] c, Reader in) throws IOException {
        StringBuilder buf = new StringBuilder();
        if (c[0] == 33) {
            PluginAppletViewer.skipComment(c, in);
            return "";
        }
        while (c[0] >= 97 && c[0] <= 122 || c[0] >= 65 && c[0] <= 90 || c[0] >= 48 && c[0] <= 57 || c[0] == 95) {
            buf.append((char)c[0]);
            c[0] = in.read();
        }
        return buf.toString();
    }

    public static void skipComment(int[] c, Reader in) throws IOException {
        StringBuilder buf = new StringBuilder();
        boolean commentHeaderPassed = false;
        c[0] = in.read();
        buf.append((char)c[0]);
        while (true) {
            if (c[0] == 45 && (c[0] = in.read()) == 45) {
                buf.append((char)c[0]);
                if (commentHeaderPassed) {
                    c[0] = in.read();
                    if (c[0] == 62) {
                        buf.append((char)c[0]);
                        PluginDebug.debug("Comment skipped: " + buf.toString());
                        return;
                    }
                } else {
                    commentHeaderPassed = true;
                }
            } else if (!commentHeaderPassed) {
                buf.append((char)c[0]);
                PluginDebug.debug("Warning: Attempted to skip comment, but this tag does not appear to be a comment: " + buf.toString());
                return;
            }
            c[0] = in.read();
            buf.append((char)c[0]);
        }
    }

    public static Hashtable<String, String> scanTag(int[] c, Reader in) throws IOException {
        Hashtable<String, String> atts = new Hashtable<String, String>();
        PluginAppletViewer.skipSpace(c, in);
        while (c[0] >= 0 && c[0] != 62) {
            String att = PluginAppletViewer.decodeString(PluginAppletViewer.scanIdentifier(c, in));
            String val = "";
            PluginAppletViewer.skipSpace(c, in);
            if (c[0] == 61) {
                int quote = -1;
                c[0] = in.read();
                PluginAppletViewer.skipSpace(c, in);
                if (c[0] == 39 || c[0] == 34) {
                    quote = c[0];
                    c[0] = in.read();
                }
                StringBuilder buf = new StringBuilder();
                while (c[0] > 0 && (quote < 0 && c[0] != 32 && c[0] != 9 && c[0] != 10 && c[0] != 13 && c[0] != 62 || quote >= 0 && c[0] != quote)) {
                    buf.append((char)c[0]);
                    c[0] = in.read();
                }
                if (c[0] == quote) {
                    c[0] = in.read();
                }
                PluginAppletViewer.skipSpace(c, in);
                val = PluginAppletViewer.decodeString(buf.toString());
            }
            PluginDebug.debug("PUT " + att + " = '" + val + "'");
            atts.put(att.toLowerCase(Locale.ENGLISH), val);
            while (!(c[0] == 62 || c[0] < 0 || c[0] >= 97 && c[0] <= 122 || c[0] >= 65 && c[0] <= 90 || c[0] >= 48 && c[0] <= 57 || c[0] == 95)) {
                c[0] = in.read();
            }
        }
        return atts;
    }

    private static final boolean isInt(Object o) {
        boolean isInt = false;
        try {
            Integer.parseInt((String)o);
            isInt = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isInt;
    }

    private static Reader makeReader(InputStream is) {
        if (encoding != null) {
            try {
                return new BufferedReader(new InputStreamReader(is, encoding));
            }
            catch (IOException x) {
                // empty catch block
            }
        }
        InputStreamReader r = new InputStreamReader(is);
        encoding = r.getEncoding();
        return new BufferedReader(r);
    }

    public static void parse(int identifier, long handle, String width, String height, Reader in, URL url, String enc) throws IOException {
        encoding = enc;
        PluginAppletViewer.parse(identifier, handle, width, height, in, url, System.out, new PluginAppletPanelFactory());
    }

    public static void parse(int identifier, long handle, String width, String height, Reader in, URL url) throws PrivilegedActionException {
        final int fIdentifier = identifier;
        final long fHandle = handle;
        final String fWidth = width;
        final String fHeight = height;
        final Reader fIn = in;
        final URL fUrl = url;
        AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws IOException {
                PluginAppletViewer.parse(fIdentifier, fHandle, fWidth, fHeight, fIn, fUrl, System.out, new PluginAppletPanelFactory());
                return null;
            }
        });
    }

    public static void parse(int identifier, long handle, String width, String height, Reader in, URL url, PrintStream statusMsgStream, PluginAppletPanelFactory factory) throws IOException {
        boolean isAppletTag = false;
        boolean isObjectTag = false;
        boolean isEmbedTag = false;
        boolean objectTagAlreadyParsed = false;
        int[] c = new int[1];
        String requiresNameWarning = amh.getMessage("parse.warning.requiresname");
        String paramOutsideWarning = amh.getMessage("parse.warning.paramoutside");
        String appletRequiresCodeWarning = amh.getMessage("parse.warning.applet.requirescode");
        String appletRequiresHeightWarning = amh.getMessage("parse.warning.applet.requiresheight");
        String appletRequiresWidthWarning = amh.getMessage("parse.warning.applet.requireswidth");
        String objectRequiresCodeWarning = amh.getMessage("parse.warning.object.requirescode");
        String objectRequiresHeightWarning = amh.getMessage("parse.warning.object.requiresheight");
        String objectRequiresWidthWarning = amh.getMessage("parse.warning.object.requireswidth");
        String embedRequiresCodeWarning = amh.getMessage("parse.warning.embed.requirescode");
        String embedRequiresHeightWarning = amh.getMessage("parse.warning.embed.requiresheight");
        String embedRequiresWidthWarning = amh.getMessage("parse.warning.embed.requireswidth");
        String appNotLongerSupportedWarning = amh.getMessage("parse.warning.appnotLongersupported");
        URLConnection conn = url.openConnection();
        url = conn.getURL();
        int ydisp = 1;
        Hashtable<String, String> atts = null;
        while (true) {
            String nm;
            c[0] = in.read();
            if (c[0] == -1) break;
            if (c[0] != 60) continue;
            c[0] = in.read();
            if (c[0] == 47) {
                c[0] = in.read();
                nm = PluginAppletViewer.scanIdentifier(c, in);
                if (!nm.equalsIgnoreCase("applet") && !nm.equalsIgnoreCase("object") && !nm.equalsIgnoreCase("embed")) continue;
                if (isObjectTag && atts.get("code") == null && atts.get("object") == null) {
                    statusMsgStream.println(objectRequiresCodeWarning);
                    atts = null;
                }
                if (atts != null) {
                    streamhandler.write("instance " + identifier + " status " + amh.getMessage("status.start"));
                    factory.createPanel(streamhandler, identifier, handle, x, y, url, atts);
                    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
                    if ((x += 30) > d.width - 300 || (y += 30) > d.height - 300) {
                        x = 0;
                        y = 2 * ydisp * 30;
                        ++ydisp;
                    }
                }
                atts = null;
                isAppletTag = false;
                isObjectTag = false;
                isEmbedTag = false;
                continue;
            }
            nm = PluginAppletViewer.scanIdentifier(c, in);
            if (nm.equalsIgnoreCase("param")) {
                Hashtable<String, String> t = PluginAppletViewer.scanTag(c, in);
                String att = t.get("name");
                if (atts.containsKey(att)) continue;
                if (att == null) {
                    statusMsgStream.println(requiresNameWarning);
                    continue;
                }
                String val = t.get("value");
                if (val == null) {
                    statusMsgStream.println(requiresNameWarning);
                    continue;
                }
                if (atts != null) {
                    PluginDebug.debug("PUT " + att + " = " + val);
                    atts.put(att.toLowerCase(), val);
                    continue;
                }
                statusMsgStream.println(paramOutsideWarning);
                continue;
            }
            if (nm.equalsIgnoreCase("applet")) {
                isAppletTag = true;
                atts = PluginAppletViewer.scanTag(c, in);
                if (atts.get("code") == null && atts.get("classid") != null && !atts.get("classid").startsWith("clsid:")) {
                    atts.put("code", atts.get("classid"));
                }
                if (atts.get("code") != null && atts.get("code").startsWith("java:")) {
                    atts.put("code", atts.get("code").substring(5));
                }
                if (atts.get("code") == null && atts.get("object") == null) {
                    statusMsgStream.println(appletRequiresCodeWarning);
                    atts = null;
                }
                if (atts.get("width") == null || !PluginAppletViewer.isInt(atts.get("width"))) {
                    atts.put("width", width);
                }
                if (atts.get("height") != null && PluginAppletViewer.isInt(atts.get("height"))) continue;
                atts.put("height", height);
                continue;
            }
            if (nm.equalsIgnoreCase("object")) {
                isObjectTag = true;
                if (!objectTagAlreadyParsed) {
                    objectTagAlreadyParsed = true;
                    atts = PluginAppletViewer.scanTag(c, in);
                }
                if (atts.get("code") == null && atts.get("classid") != null && !atts.get("classid").startsWith("clsid:")) {
                    atts.put("code", atts.get("classid"));
                }
                if (atts.get("code") != null && atts.get("code").startsWith("java:")) {
                    atts.put("code", atts.get("code").substring(5));
                }
                if (atts.get("java_code") != null) {
                    atts.put("code", atts.get("java_code"));
                }
                if (atts.containsKey("code")) {
                    objectTagAlreadyParsed = true;
                }
                if (atts.get("java_codebase") != null) {
                    atts.put("codebase", atts.get("java_codebase"));
                }
                if (atts.get("java_archive") != null) {
                    atts.put("archive", atts.get("java_archive"));
                }
                if (atts.get("java_object") != null) {
                    atts.put("object", atts.get("java_object"));
                }
                if (atts.get("java_type") != null) {
                    atts.put("type", atts.get("java_type"));
                }
                if (atts.get("width") == null || !PluginAppletViewer.isInt(atts.get("width"))) {
                    atts.put("width", width);
                }
                if (atts.get("height") != null && PluginAppletViewer.isInt(atts.get("height"))) continue;
                atts.put("height", height);
                continue;
            }
            if (!nm.equalsIgnoreCase("embed")) continue;
            isEmbedTag = true;
            atts = PluginAppletViewer.scanTag(c, in);
            if (atts.get("code") == null && atts.get("classid") != null && !atts.get("classid").startsWith("clsid:")) {
                atts.put("code", atts.get("classid"));
            }
            if (atts.get("code") != null && atts.get("code").startsWith("java:")) {
                atts.put("code", atts.get("code").substring(5));
            }
            if (atts.get("java_code") != null) {
                atts.put("code", atts.get("java_code"));
            }
            if (atts.get("java_codebase") != null) {
                atts.put("codebase", atts.get("java_codebase"));
            }
            if (atts.get("java_archive") != null) {
                atts.put("archive", atts.get("java_archive"));
            }
            if (atts.get("java_object") != null) {
                atts.put("object", atts.get("java_object"));
            }
            if (atts.get("java_type") != null) {
                atts.put("type", atts.get("java_type"));
            }
            if (atts.get("code") == null && atts.get("object") == null) {
                statusMsgStream.println(embedRequiresCodeWarning);
                atts = null;
            }
            if (atts.get("width") == null || !PluginAppletViewer.isInt(atts.get("width"))) {
                atts.put("width", width);
            }
            if (atts.get("height") != null && PluginAppletViewer.isInt(atts.get("height"))) continue;
            atts.put("height", height);
        }
        in.close();
    }

    private static void checkConnect(URL url) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            try {
                Permission perm = url.openConnection().getPermission();
                if (perm != null) {
                    security.checkPermission(perm);
                } else {
                    security.checkConnect(url.getHost(), url.getPort());
                }
            }
            catch (IOException ioe) {
                security.checkConnect(url.getHost(), url.getPort());
            }
        }
    }

    @Override
    public void update(Graphics g) {
        if (this.bufFrameImg == null || this.bufFrameImgGraphics == null) {
            this.bufFrameImg = this.createImage(this.getWidth(), this.getHeight());
            this.bufFrameImgGraphics = this.bufFrameImg.getGraphics();
        }
        this.paint(this.bufFrameImgGraphics);
        g.drawImage(this.bufFrameImg, 0, 0, this);
    }

    static {
        status = new HashMap();
        requestIdentityCounter = 0L;
        audioClips = new HashMap<URL, AudioClip>();
        imageRefs = new HashMap<URL, AppletImageRef>();
        appletPanels = new Vector();
        systemParam = new Hashtable();
        systemParam.put("codebase", "codebase");
        systemParam.put("code", "code");
        systemParam.put("alt", "alt");
        systemParam.put("width", "width");
        systemParam.put("height", "height");
        systemParam.put("align", "align");
        systemParam.put("vspace", "vspace");
        systemParam.put("hspace", "hspace");
        x = 0;
        y = 0;
        encoding = null;
        amh = new AppletMessageHandler("appletviewer");
    }

    private static class AppletEventListener
    implements AppletListener {
        final Frame frame;
        final PluginAppletViewer appletViewer;

        public AppletEventListener(Frame frame, PluginAppletViewer appletViewer) {
            this.frame = frame;
            this.appletViewer = appletViewer;
        }

        public void appletStateChanged(AppletEvent evt) {
            AppletPanel src = (AppletPanel)evt.getSource();
            switch (evt.getID()) {
                case 51234: {
                    if (src == null) break;
                    this.appletViewer.setSize(this.appletViewer.getPreferredSize());
                    this.appletViewer.validate();
                    break;
                }
                case 51236: {
                    Applet a = src.getApplet();
                    if (a != null) {
                        AppletPanel.changeFrameAppContext((Frame)this.frame, (AppContext)SunToolkit.targetToAppContext(a));
                    } else {
                        AppletPanel.changeFrameAppContext((Frame)this.frame, (AppContext)AppContext.getAppContext());
                    }
                    PluginAppletViewer.updateStatus(this.appletViewer.identifier, PAV_INIT_STATUS.INIT_COMPLETE);
                    break;
                }
            }
        }
    }

    private static enum PAV_INIT_STATUS {
        PRE_INIT,
        INIT_COMPLETE,
        REFRAME_COMPLETE,
        INACTIVE,
        DESTROYED;

    }
}

