/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.jnlp.runtime.JNLPProxySelector;
import sun.applet.PluginAppletViewer;
import sun.applet.PluginDebug;

public class PluginProxySelector
extends JNLPProxySelector {
    private TimedHashMap<String, Proxy> proxyCache = new TimedHashMap();

    protected List<Proxy> getFromBrowser(URI uri) {
        ArrayList<Proxy> proxyList = new ArrayList<Proxy>();
        Proxy cachedProxy = this.checkCache(uri);
        if (cachedProxy != null) {
            proxyList.add(cachedProxy);
            return proxyList;
        }
        Proxy proxy = Proxy.NO_PROXY;
        Object o = PluginAppletViewer.requestPluginProxyInfo(uri);
        try {
            if (o != null) {
                PluginDebug.debug("Proxy URI = " + o);
                URI proxyURI = (URI)o;
                if (uri.getScheme().startsWith("http") || uri.getScheme().equals("ftp") || proxyURI.getScheme().startsWith("socks")) {
                    Proxy.Type type = proxyURI.getScheme().equals("http") ? Proxy.Type.HTTP : Proxy.Type.SOCKS;
                    InetSocketAddress socketAddr = new InetSocketAddress(proxyURI.getHost(), proxyURI.getPort());
                    proxy = new Proxy(type, socketAddr);
                    String uriKey = uri.getScheme() + "://" + uri.getHost();
                    this.proxyCache.put(uriKey, proxy);
                } else {
                    PluginDebug.debug("Proxy " + proxyURI + " cannot be used for " + uri + ". Falling back to DIRECT");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        proxyList.add(proxy);
        PluginDebug.debug("Proxy for " + uri.toString() + " is " + proxy);
        return proxyList;
    }

    private Proxy checkCache(URI uri) {
        String uriKey = uri.getScheme() + "://" + uri.getHost();
        if (this.proxyCache.get(uriKey) != null) {
            return this.proxyCache.get(uriKey);
        }
        return null;
    }

    private class TimedHashMap<K, V>
    extends HashMap<K, V> {
        HashMap<K, Long> timeStamps = new HashMap();
        Long expiry = 10000L;

        private TimedHashMap() {
        }

        @Override
        public V put(K key, V value) {
            this.timeStamps.put(key, new Date().getTime());
            return super.put(key, value);
        }

        @Override
        public V get(Object key) {
            Long now = new Date().getTime();
            if (super.containsKey(key)) {
                Long age = now - this.timeStamps.get(key);
                if (age <= this.expiry) {
                    PluginDebug.debug("Returning proxy " + super.get(key) + " from cache for " + key);
                    this.timeStamps.put(key, new Date().getTime());
                    return super.get(key);
                }
                PluginDebug.debug("Proxy cache for " + key + " has expired (age=" + (double)age.longValue() / 1000.0 + " seconds)");
            }
            return null;
        }
    }
}

