# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Source file list definitions for jre_emul library. Public sources are those
# classes that are part of the public API, and do not include non-public classes
# or classes from non-public packages (like libcore.*).

NATIVE_JRE_SOURCES_CORE = \
  AnnotationUtils.m \
  DebugUtils.m \
  FastPointerLookup.m \
  FileDescriptor_md.m \
  IOSArray.m \
  IOSArrayClass.m \
  IOSClass.m \
  IOSConcreteClass.m \
  IOSObjectArray.m \
  IOSPrimitiveArray.m \
  IOSPrimitiveClass.m \
  IOSProtocolClass.m \
  IOSProxyClass.m \
  IOSReference.m \
  IOSReflection.m \
  J2ObjC_common.m \
  J2ObjC_icu.m \
  JavaThrowable.m \
  JreRetainedLocalValue.m \
  JreRetainedWith.m \
  MappedByteBuffer.m \
  NSCopying+JavaCloneable.m \
  NSDataInputStream.m \
  NSDataOutputStream.m \
  NSDictionaryMap.m \
  NSNumber+JavaNumber.m \
  NSObject+JavaObject.m \
  NSString+JavaString.m \
  ObjectInputStream.m \
  ObjectOutputStream.m \
  UnixFileSystem_md.m \
  canonicalize_md.m \
  io_util.m \
  java/lang/AbstractStringBuilder.m \
  java/lang/reflect/AccessibleObject.m \
  java/lang/reflect/Constructor.m \
  java/lang/reflect/Executable.m \
  java/lang/reflect/Field.m \
  java/lang/reflect/Method.m \
  java_lang_Character.m \
  java_lang_Integer.m \
  java_lang_Long.m \
  java_lang_Math.m \
  java_lang_StrictMath.m \
  java_lang_SystemClassLoader.m \
  java_lang_Thread.m \
  java_util_regex_Matcher.m \
  java_util_regex_Pattern.m \
  jni.m \
  jni_util.m \
  jvm.m \
  libcore_icu_ICU.m \
  libcore_io_Memory.m \
  objc-sync.m \
  sun_misc_Unsafe.m

# Java sources to be translated normally and included in the core library.
# TypeKind is needed by the Checker Framework (https://checkerframework.org/).
JAVA_PUBLIC_SOURCES_CORE = \
  android/system/ErrnoException.java \
  android/system/Int32Ref.java \
  android/system/Int64Ref.java \
  com/google/j2objc/util/AutoreleasePool.java \
  com/google/j2objc/util/CurrencyNumericCodes.java \
  com/google/j2objc/util/logging/IOSLogHandler.java \
  java/io/BufferedInputStream.java \
  java/io/BufferedOutputStream.java \
  java/io/BufferedReader.java \
  java/io/BufferedWriter.java \
  java/io/ByteArrayInputStream.java \
  java/io/ByteArrayOutputStream.java \
  java/io/Closeable.java \
  java/io/Console.java \
  java/io/DataInput.java \
  java/io/DataInputStream.java \
  java/io/DataOutput.java \
  java/io/DataOutputStream.java \
  java/io/EOFException.java \
  java/io/Externalizable.java \
  java/io/File.java \
  java/io/FileDescriptor.java \
  java/io/FileFilter.java \
  java/io/FileInputStream.java \
  java/io/FileNotFoundException.java \
  java/io/FileOutputStream.java \
  java/io/FilePermission.java \
  java/io/FilenameFilter.java \
  java/io/FilterInputStream.java \
  java/io/FilterOutputStream.java \
  java/io/Flushable.java \
  java/io/IOError.java \
  java/io/IOException.java \
  java/io/InputStream.java \
  java/io/InputStreamReader.java \
  java/io/InterruptedIOException.java \
  java/io/InvalidClassException.java \
  java/io/InvalidObjectException.java \
  java/io/NotActiveException.java \
  java/io/NotSerializableException.java \
  java/io/ObjectInput.java \
  java/io/ObjectInputStream.java \
  java/io/ObjectInputValidation.java \
  java/io/ObjectOutput.java \
  java/io/ObjectOutputStream.java \
  java/io/ObjectStreamClass.java \
  java/io/ObjectStreamConstants.java \
  java/io/ObjectStreamException.java \
  java/io/ObjectStreamField.java \
  java/io/OptionalDataException.java \
  java/io/OutputStream.java \
  java/io/OutputStreamWriter.java \
  java/io/PrintStream.java \
  java/io/PrintWriter.java \
  java/io/PushbackInputStream.java \
  java/io/Reader.java \
  java/io/Serializable.java \
  java/io/SerializablePermission.java \
  java/io/SerializationHandleMap.java \
  java/io/StreamCorruptedException.java \
  java/io/StringReader.java \
  java/io/StringWriter.java \
  java/io/SyncFailedException.java \
  java/io/UTFDataFormatException.java \
  java/io/UncheckedIOException.java \
  java/io/UnsupportedEncodingException.java \
  java/io/WriteAbortedException.java \
  java/io/Writer.java \
  java/lang/AbstractMethodError.java \
  java/lang/Appendable.java \
  java/lang/ArithmeticException.java \
  java/lang/ArrayIndexOutOfBoundsException.java \
  java/lang/ArrayStoreException.java \
  java/lang/AssertionError.java \
  java/lang/AutoCloseable.java \
  java/lang/Boolean.java \
  java/lang/Byte.java \
  java/lang/CharSequence.java \
  java/lang/Character.java \
  java/lang/ClassCastException.java \
  java/lang/ClassFormatError.java \
  java/lang/ClassLoader.java \
  java/lang/ClassNotFoundException.java \
  java/lang/CloneNotSupportedException.java \
  java/lang/Comparable.java \
  java/lang/Deprecated.java \
  java/lang/Double.java \
  java/lang/Enum.java \
  java/lang/EnumConstantNotPresentException.java \
  java/lang/Error.java \
  java/lang/Exception.java \
  java/lang/ExceptionInInitializerError.java \
  java/lang/Float.java \
  java/lang/FunctionalInterface.java \
  java/lang/IllegalAccessError.java \
  java/lang/IllegalAccessException.java \
  java/lang/IllegalArgumentException.java \
  java/lang/IllegalMonitorStateException.java \
  java/lang/IllegalStateException.java \
  java/lang/IllegalThreadStateException.java \
  java/lang/IncompatibleClassChangeError.java \
  java/lang/IndexOutOfBoundsException.java \
  java/lang/InheritableThreadLocal.java \
  java/lang/InstantiationError.java \
  java/lang/InstantiationException.java \
  java/lang/Integer.java \
  java/lang/InternalError.java \
  java/lang/InterruptedException.java \
  java/lang/Iterable.java \
  java/lang/LinkageError.java \
  java/lang/Long.java \
  java/lang/Math.java \
  java/lang/NegativeArraySizeException.java \
  java/lang/NoClassDefFoundError.java \
  java/lang/NoSuchFieldError.java \
  java/lang/NoSuchFieldException.java \
  java/lang/NoSuchMethodError.java \
  java/lang/NoSuchMethodException.java \
  java/lang/NullPointerException.java \
  java/lang/NumberFormatException.java \
  java/lang/OutOfMemoryError.java \
  java/lang/Package.java \
  java/lang/Readable.java \
  java/lang/ReflectiveOperationException.java \
  java/lang/Runnable.java \
  java/lang/Runtime.java \
  java/lang/RuntimeException.java \
  java/lang/RuntimePermission.java \
  java/lang/SafeVarargs.java \
  java/lang/SecurityException.java \
  java/lang/SecurityManager.java \
  java/lang/Short.java \
  java/lang/StackOverflowError.java \
  java/lang/StackTraceElement.java \
  java/lang/StrictMath.java \
  java/lang/StringBuffer.java \
  java/lang/StringBuilder.java \
  java/lang/StringIndexOutOfBoundsException.java \
  java/lang/System.java \
  java/lang/Thread.java \
  java/lang/ThreadDeath.java \
  java/lang/ThreadGroup.java \
  java/lang/ThreadLocal.java \
  java/lang/Throwable.java \
  java/lang/TypeNotPresentException.java \
  java/lang/UnsatisfiedLinkError.java \
  java/lang/UnknownError.java \
  java/lang/UnsupportedOperationException.java \
  java/lang/VirtualMachineError.java \
  java/lang/Void.java \
  java/lang/annotation/Annotation.java \
  java/lang/annotation/AnnotationFormatError.java \
  java/lang/annotation/AnnotationTypeMismatchException.java \
  java/lang/annotation/Documented.java \
  java/lang/annotation/ElementType.java \
  java/lang/annotation/IncompleteAnnotationException.java \
  java/lang/annotation/Inherited.java \
  java/lang/annotation/Repeatable.java \
  java/lang/annotation/Retention.java \
  java/lang/annotation/RetentionPolicy.java \
  java/lang/annotation/Target.java \
  java/lang/invoke/CallSite.java \
  java/lang/invoke/LambdaConversionException.java \
  java/lang/invoke/LambdaMetafactory.java \
  java/lang/invoke/MethodHandle.java \
  java/lang/invoke/MethodHandleInfo.java \
  java/lang/invoke/MethodHandles.java \
  java/lang/invoke/MethodType.java \
  java/lang/invoke/SerializedLambda.java \
  java/lang/ref/PhantomReference.java \
  java/lang/ref/Reference.java \
  java/lang/ref/ReferenceQueue.java \
  java/lang/ref/SoftReference.java \
  java/lang/ref/WeakReference.java \
  java/lang/reflect/AnnotatedArrayType.java \
  java/lang/reflect/AnnotatedElement.java \
  java/lang/reflect/AnnotatedParameterizedType.java \
  java/lang/reflect/AnnotatedType.java \
  java/lang/reflect/AnnotatedTypeVariable.java \
  java/lang/reflect/AnnotatedWildcardType.java \
  java/lang/reflect/Array.java \
  java/lang/reflect/GenericArrayType.java \
  java/lang/reflect/GenericDeclaration.java \
  java/lang/reflect/GenericSignatureFormatError.java \
  java/lang/reflect/InvocationHandler.java \
  java/lang/reflect/InvocationTargetException.java \
  java/lang/reflect/MalformedParameterizedTypeException.java \
  java/lang/reflect/Member.java \
  java/lang/reflect/Modifier.java \
  java/lang/reflect/Parameter.java \
  java/lang/reflect/ParameterizedType.java \
  java/lang/reflect/Proxy.java \
  java/lang/reflect/ReflectPermission.java \
  java/lang/reflect/Type.java \
  java/lang/reflect/TypeVariable.java \
  java/lang/reflect/UndeclaredThrowableException.java \
  java/lang/reflect/WildcardType.java \
  java/math/BigDecimal.java \
  java/math/BigInteger.java \
  java/math/MathContext.java \
  java/math/RoundingMode.java \
  java/net/MalformedURLException.java \
  java/net/SocketException.java \
  java/net/URI.java \
  java/net/URISyntaxException.java \
  java/net/URL.java \
  java/net/URLDelegate.java \
  java/nio/Buffer.java \
  java/nio/BufferOverflowException.java \
  java/nio/BufferUnderflowException.java \
  java/nio/ByteBuffer.java \
  java/nio/ByteOrder.java \
  java/nio/CharBuffer.java \
  java/nio/DoubleBuffer.java \
  java/nio/FloatBuffer.java \
  java/nio/IntBuffer.java \
  java/nio/InvalidMarkException.java \
  java/nio/LongBuffer.java \
  java/nio/MappedByteBuffer.java \
  java/nio/NIOAccess.java \
  java/nio/NioUtils.java \
  java/nio/ReadOnlyBufferException.java \
  java/nio/ShortBuffer.java \
  java/nio/channels/AsynchronousCloseException.java \
  java/nio/channels/ByteChannel.java \
  java/nio/channels/Channel.java \
  java/nio/channels/ClosedByInterruptException.java \
  java/nio/channels/ClosedChannelException.java \
  java/nio/channels/FileChannel.java \
  java/nio/channels/GatheringByteChannel.java \
  java/nio/channels/ReadableByteChannel.java \
  java/nio/channels/ScatteringByteChannel.java \
  java/nio/channels/SeekableByteChannel.java \
  java/nio/channels/WritableByteChannel.java \
  java/nio/channels/spi/AbstractInterruptibleChannel.java \
  java/nio/charset/CharacterCodingException.java \
  java/nio/charset/Charset.java \
  java/nio/charset/CharsetDecoder.java \
  java/nio/charset/CharsetEncoder.java \
  java/nio/charset/CoderMalfunctionError.java \
  java/nio/charset/CoderResult.java \
  java/nio/charset/CodingErrorAction.java \
  java/nio/charset/IllegalCharsetNameException.java \
  java/nio/charset/MalformedInputException.java \
  java/nio/charset/StandardCharsets.java \
  java/nio/charset/UnmappableCharacterException.java \
  java/nio/charset/UnsupportedCharsetException.java \
  java/nio/charset/spi/CharsetProvider.java \
  java/nio/file/Path.java \
  java/nio/file/attribute/FileAttribute.java \
  java/nio/file/attribute/FileTime.java \
  java/security/AccessControlContext.java \
  java/security/AccessController.java \
  java/security/AllPermission.java \
  java/security/BasicPermission.java \
  java/security/DomainCombiner.java \
  java/security/Guard.java \
  java/security/Permission.java \
  java/security/PermissionCollection.java \
  java/security/Permissions.java \
  java/security/PrivilegedActionException.java \
  java/text/Annotation.java \
  java/text/AttributedCharacterIterator.java \
  java/text/AttributedString.java \
  java/text/CharacterIterator.java \
  java/text/ChoiceFormat.java \
  java/text/CollationKey.java \
  java/text/Collator.java \
  java/text/DateFormat.java \
  java/text/DateFormatSymbols.java \
  java/text/DecimalFormat.java \
  java/text/DecimalFormatSymbols.java \
  java/text/FieldPosition.java \
  java/text/Format.java \
  java/text/IOSCollator.java \
  java/text/MessageFormat.java \
  java/text/Normalizer.java \
  java/text/NumberFormat.java \
  java/text/ParseException.java \
  java/text/ParsePosition.java \
  java/text/SimpleDateFormat.java \
  java/text/StringCharacterIterator.java \
  java/util/AbstractCollection.java \
  java/util/AbstractList.java \
  java/util/AbstractMap.java \
  java/util/AbstractQueue.java \
  java/util/AbstractSequentialList.java \
  java/util/AbstractSet.java \
  java/util/ArrayDeque.java \
  java/util/ArrayList.java \
  java/util/Arrays.java \
  java/util/Base64.java \
  java/util/BitSet.java \
  java/util/Calendar.java \
  java/util/Collection.java \
  java/util/Collections.java \
  java/util/ComparableTimSort.java \
  java/util/Comparator.java \
  java/util/ConcurrentModificationException.java \
  java/util/Currency.java \
  java/util/Date.java \
  java/util/Deque.java \
  java/util/Dictionary.java \
  java/util/DoubleSummaryStatistics.java \
  java/util/DuplicateFormatFlagsException.java \
  java/util/EmptyStackException.java \
  java/util/Enumeration.java \
  java/util/EnumMap.java \
  java/util/EnumSet.java \
  java/util/EventObject.java \
  java/util/FormatFlagsConversionMismatchException.java \
  java/util/Formattable.java \
  java/util/FormattableFlags.java \
  java/util/Formatter.java \
  java/util/FormatterClosedException.java \
  java/util/GregorianCalendar.java \
  java/util/HashMap.java \
  java/util/HashSet.java \
  java/util/Hashtable.java \
  java/util/IdentityHashMap.java \
  java/util/IllegalFormatCodePointException.java \
  java/util/IllegalFormatConversionException.java \
  java/util/IllegalFormatException.java \
  java/util/IllegalFormatFlagsException.java \
  java/util/IllegalFormatPrecisionException.java \
  java/util/IllegalFormatWidthException.java \
  java/util/IllformedLocaleException.java \
  java/util/IntSummaryStatistics.java \
  java/util/InvalidPropertiesFormatException.java \
  java/util/Iterator.java \
  java/util/LinkedHashMap.java \
  java/util/LinkedHashSet.java \
  java/util/LinkedList.java \
  java/util/List.java \
  java/util/ListIterator.java \
  java/util/ListResourceBundle.java \
  java/util/Locale.java \
  java/util/LongSummaryStatistics.java \
  java/util/Map.java \
  java/util/MissingFormatArgumentException.java \
  java/util/MissingFormatWidthException.java \
  java/util/MissingResourceException.java \
  java/util/NavigableMap.java \
  java/util/NavigableSet.java \
  java/util/NoSuchElementException.java \
  java/util/Objects.java \
  java/util/Optional.java \
  java/util/OptionalDouble.java \
  java/util/OptionalInt.java \
  java/util/OptionalLong.java \
  java/util/PrimitiveIterator.java \
  java/util/Properties.java \
  java/util/PropertyResourceBundle.java \
  java/util/Queue.java \
  java/util/Random.java \
  java/util/RandomAccess.java \
  java/util/ResourceBundle.java \
  java/util/Set.java \
  java/util/SimpleTimeZone.java \
  java/util/SortedMap.java \
  java/util/SortedSet.java \
  java/util/Spliterator.java \
  java/util/Spliterators.java \
  java/util/StringJoiner.java \
  java/util/StringTokenizer.java \
  java/util/TimSort.java \
  java/util/TimeZone.java \
  java/util/TreeMap.java \
  java/util/TreeSet.java \
  java/util/UnknownFormatConversionException.java \
  java/util/UnknownFormatFlagsException.java \
  java/util/UnsafeArrayList.java \
  java/util/Vector.java \
  java/util/WeakHashMap.java \
  java/util/concurrent/AbstractExecutorService.java \
  java/util/concurrent/BlockingQueue.java \
  java/util/concurrent/Callable.java \
  java/util/concurrent/CancellationException.java \
  java/util/concurrent/CompletableFuture.java \
  java/util/concurrent/CompletionException.java \
  java/util/concurrent/CompletionService.java \
  java/util/concurrent/CompletionStage.java \
  java/util/concurrent/ConcurrentHashMap.java \
  java/util/concurrent/ConcurrentMap.java \
  java/util/concurrent/CopyOnWriteArrayList.java \
  java/util/concurrent/CopyOnWriteArraySet.java \
  java/util/concurrent/CountDownLatch.java \
  java/util/concurrent/CountedCompleter.java \
  java/util/concurrent/Delayed.java \
  java/util/concurrent/ExecutionException.java \
  java/util/concurrent/Executor.java \
  java/util/concurrent/ExecutorCompletionService.java \
  java/util/concurrent/Executors.java \
  java/util/concurrent/ExecutorService.java \
  java/util/concurrent/ForkJoinPool.java \
  java/util/concurrent/ForkJoinTask.java \
  java/util/concurrent/ForkJoinWorkerThread.java \
  java/util/concurrent/Future.java \
  java/util/concurrent/FutureTask.java \
  java/util/concurrent/LinkedBlockingQueue.java \
  java/util/concurrent/RejectedExecutionException.java \
  java/util/concurrent/RejectedExecutionHandler.java \
  java/util/concurrent/RunnableFuture.java \
  java/util/concurrent/RunnableScheduledFuture.java \
  java/util/concurrent/ScheduledExecutorService.java \
  java/util/concurrent/ScheduledFuture.java \
  java/util/concurrent/ScheduledThreadPoolExecutor.java \
  java/util/concurrent/SynchronousQueue.java \
  java/util/concurrent/ThreadFactory.java \
  java/util/concurrent/ThreadLocalRandom.java \
  java/util/concurrent/ThreadPoolExecutor.java \
  java/util/concurrent/TimeoutException.java \
  java/util/concurrent/TimeUnit.java \
  java/util/concurrent/atomic/AtomicBoolean.java \
  java/util/concurrent/atomic/AtomicInteger.java \
  java/util/concurrent/atomic/AtomicLong.java \
  java/util/concurrent/atomic/AtomicReference.java \
  java/util/concurrent/atomic/AtomicReferenceFieldUpdater.java \
  java/util/concurrent/locks/AbstractOwnableSynchronizer.java \
  java/util/concurrent/locks/AbstractQueuedSynchronizer.java \
  java/util/concurrent/locks/Condition.java \
  java/util/concurrent/locks/Lock.java \
  java/util/concurrent/locks/LockSupport.java \
  java/util/concurrent/locks/ReadWriteLock.java \
  java/util/concurrent/locks/ReentrantLock.java \
  java/util/function/BiConsumer.java \
  java/util/function/BiFunction.java \
  java/util/function/BiPredicate.java \
  java/util/function/BinaryOperator.java \
  java/util/function/BooleanSupplier.java \
  java/util/function/Consumer.java \
  java/util/function/DoubleBinaryOperator.java \
  java/util/function/DoubleConsumer.java \
  java/util/function/DoubleFunction.java \
  java/util/function/DoublePredicate.java \
  java/util/function/DoubleSupplier.java \
  java/util/function/DoubleToIntFunction.java \
  java/util/function/DoubleToLongFunction.java \
  java/util/function/DoubleUnaryOperator.java \
  java/util/function/Function.java \
  java/util/function/IntBinaryOperator.java \
  java/util/function/IntConsumer.java \
  java/util/function/IntFunction.java \
  java/util/function/IntPredicate.java \
  java/util/function/IntSupplier.java \
  java/util/function/IntToDoubleFunction.java \
  java/util/function/IntToLongFunction.java \
  java/util/function/IntUnaryOperator.java \
  java/util/function/LongBinaryOperator.java \
  java/util/function/LongConsumer.java \
  java/util/function/LongFunction.java \
  java/util/function/LongPredicate.java \
  java/util/function/LongSupplier.java \
  java/util/function/LongToDoubleFunction.java \
  java/util/function/LongToIntFunction.java \
  java/util/function/LongUnaryOperator.java \
  java/util/function/ObjDoubleConsumer.java \
  java/util/function/ObjIntConsumer.java \
  java/util/function/ObjLongConsumer.java \
  java/util/function/Predicate.java \
  java/util/function/Supplier.java \
  java/util/function/ToDoubleBiFunction.java \
  java/util/function/ToDoubleFunction.java \
  java/util/function/ToIntBiFunction.java \
  java/util/function/ToIntFunction.java \
  java/util/function/ToLongBiFunction.java \
  java/util/function/ToLongFunction.java \
  java/util/function/UnaryOperator.java \
  java/util/logging/ConsoleHandler.java \
  java/util/logging/ErrorManager.java \
  java/util/logging/Filter.java \
  java/util/logging/Formatter.java \
  java/util/logging/Handler.java \
  java/util/logging/Level.java \
  java/util/logging/LogManager.java \
  java/util/logging/LogRecord.java \
  java/util/logging/Logger.java \
  java/util/logging/LoggingMXBean.java \
  java/util/logging/LoggingPermission.java \
  java/util/logging/SimpleFormatter.java \
  java/util/logging/StreamHandler.java \
  java/util/regex/MatchResult.java \
  java/util/regex/Matcher.java \
  java/util/regex/Pattern.java \
  java/util/regex/PatternSyntaxException.java \
  java/util/stream/BaseStream.java \
  java/util/stream/Collector.java \
  java/util/stream/Collectors.java \
  java/util/stream/DoubleStream.java \
  java/util/stream/IntStream.java \
  java/util/stream/LongStream.java \
  java/util/stream/Stream.java \
  java/util/stream/Streams.java \
  java/util/stream/StreamSupport.java \
  javax/lang/model/type/TypeKind.java \
  sun/misc/Unsafe.java

JAVA_PRIVATE_SOURCES_CORE = \
  android/compat/annotation/UnsupportedAppUsage.java \
  com/google/j2objc/LibraryNotLinkedError.java \
  com/google/j2objc/ReflectionStrippedError.java \
  com/google/j2objc/WeakProxy.java \
  com/google/j2objc/nio/charset/IOSCharset.java \
  com/google/j2objc/nio/charset/IconvCharsetDecoder.java \
  com/google/j2objc/nio/charset/IconvCharsetEncoder.java \
  com/google/j2objc/util/NativeTimeZone.java \
  com/google/j2objc/util/ReflectionUtil.java \
  dalvik/annotation/compat/UnsupportedAppUsage.java \
  dalvik/annotation/optimization/FastNative.java \
  dalvik/system/BlockGuard.java \
  dalvik/system/CloseGuard.java \
  dalvik/system/VersionCodes.java \
  dalvik/system/VMStack.java \
  java/io/Bits.java \
  java/io/DefaultFileSystem.java \
  java/io/DeleteOnExitHook.java \
  java/io/ExpiringCache.java \
  java/io/FileChannelOpener.java \
  java/io/FileSystem.java \
  java/io/SerialCallbackContext.java \
  java/io/UnixFileSystem.java \
  java/lang/JavaLangAccess.java \
  java/math/BitSieve.java \
  java/math/MutableBigInteger.java \
  java/math/SignedMutableBigInteger.java \
  java/nio/Bits.java \
  java/nio/ByteBufferAsCharBuffer.java \
  java/nio/ByteBufferAsDoubleBuffer.java \
  java/nio/ByteBufferAsFloatBuffer.java \
  java/nio/ByteBufferAsIntBuffer.java \
  java/nio/ByteBufferAsLongBuffer.java \
  java/nio/ByteBufferAsShortBuffer.java \
  java/nio/CharBufferSpliterator.java \
  java/nio/DirectByteBuffer.java \
  java/nio/HeapByteBuffer.java \
  java/nio/HeapCharBuffer.java \
  java/nio/HeapDoubleBuffer.java \
  java/nio/HeapFloatBuffer.java \
  java/nio/HeapIntBuffer.java \
  java/nio/HeapLongBuffer.java \
  java/nio/HeapShortBuffer.java \
  java/nio/StringCharBuffer.java \
  java/nio/charset/ModifiedUtf8.java \
  java/text/CalendarBuilder.java \
  java/text/CharacterIteratorFieldDelegate.java \
  java/text/DigitList.java \
  java/text/DontCareFieldPosition.java \
  java/util/ArrayPrefixHelpers.java \
  java/util/ArraysParallelSortHelpers.java \
  java/util/Comparators.java \
  java/util/DualPivotQuicksort.java \
  java/util/Grego.java \
  java/util/JumboEnumSet.java \
  java/util/RegularEnumSet.java \
  java/util/logging/Logging.java \
  java/util/logging/LoggingProxyImpl.java \
  java/util/stream/AbstractPipeline.java \
  java/util/stream/AbstractShortCircuitTask.java \
  java/util/stream/AbstractSpinedBuffer.java \
  java/util/stream/AbstractTask.java \
  java/util/stream/DistinctOps.java \
  java/util/stream/DoublePipeline.java \
  java/util/stream/FindOps.java \
  java/util/stream/ForEachOps.java \
  java/util/stream/IntPipeline.java \
  java/util/stream/LongPipeline.java \
  java/util/stream/MatchOps.java \
  java/util/stream/Node.java \
  java/util/stream/Nodes.java \
  java/util/stream/PipelineHelper.java \
  java/util/stream/ReduceOps.java \
  java/util/stream/ReferencePipeline.java \
  java/util/stream/Sink.java \
  java/util/stream/SliceOps.java \
  java/util/stream/SortedOps.java \
  java/util/stream/SpinedBuffer.java \
  java/util/stream/StreamOpFlag.java \
  java/util/stream/StreamShape.java \
  java/util/stream/StreamSpliterators.java \
  java/util/stream/TerminalOp.java \
  jdk/internal/module/SystemModulesMap.java \
  libcore/api/CorePlatformApi.java \
  libcore/api/Hide.java \
  libcore/api/IntraCoreApi.java \
  libcore/icu/ICU.java \
  libcore/icu/LocaleData.java \
  libcore/icu/TimeZoneNames.java \
  libcore/io/AsynchronousCloseMonitor.java \
  libcore/io/IoBridge.java \
  libcore/io/IoUtils.java \
  libcore/io/Libcore.java \
  libcore/io/Memory.java \
  libcore/io/Os.java \
  libcore/io/OsConstants.java \
  libcore/io/Posix.java \
  libcore/io/SizeOf.java \
  libcore/io/Streams.java \
  libcore/io/StructFlock.java \
  libcore/io/StructGroupReq.java \
  libcore/io/StructGroupSourceReq.java \
  libcore/io/StructLinger.java \
  libcore/io/StructPollfd.java \
  libcore/io/StructStat.java \
  libcore/io/StructStatVfs.java \
  libcore/io/StructTimeval.java \
  libcore/io/StructUtsname.java \
  libcore/content/type/MimeMap.java \
  libcore/net/MimeUtils.java \
  libcore/net/url/UrlUtils.java \
  libcore/reflect/AnnotatedElements.java \
  libcore/reflect/GenericArrayTypeImpl.java \
  libcore/reflect/GenericSignatureParser.java \
  libcore/reflect/ListOfTypes.java \
  libcore/reflect/ListOfVariables.java \
  libcore/reflect/ParameterizedTypeImpl.java \
  libcore/reflect/TypeVariableImpl.java \
  libcore/reflect/Types.java \
  libcore/reflect/WildcardTypeImpl.java \
  libcore/util/ArrayUtils.java \
  libcore/util/BasicLruCache.java \
  libcore/util/EmptyArray.java \
  libcore/util/HexEncoding.java \
  libcore/util/NonNull.java \
  libcore/util/NullFromTypeParam.java \
  libcore/util/Nullable.java \
  libcore/util/Objects.java \
  libcore/util/SneakyThrow.java \
  sun/misc/Cleaner.java \
  sun/misc/CompoundEnumeration.java \
  sun/misc/DoubleConsts.java \
  sun/misc/FDBigInt.java \
  sun/misc/FDBigInteger.java \
  sun/misc/FloatConsts.java \
  sun/misc/FloatingDecimal.java \
  sun/misc/FormattedFloatingDecimal.java \
  sun/misc/FpUtils.java \
  sun/misc/Hashing.java \
  sun/nio/ch/DirectBuffer.java \
  sun/nio/cs/HistoricallyNamedCharset.java \
  sun/nio/ch/Interruptible.java \
  sun/nio/cs/StreamDecoder.java \
  sun/nio/cs/StreamEncoder.java \
  sun/nio/cs/ThreadLocalCoders.java \
  sun/reflect/CallerSensitive.java \
  sun/reflect/Reflection.java \
  sun/reflect/misc/ReflectUtil.java \
  sun/security/action/GetBooleanAction.java \
  sun/security/action/GetIntegerAction.java \
  sun/security/action/GetPropertyAction.java \
  sun/util/ResourceBundleEnumeration.java \
  sun/util/calendar/AbstractCalendar.java \
  sun/util/calendar/BaseCalendar.java \
  sun/util/calendar/CalendarDate.java \
  sun/util/calendar/CalendarSystem.java \
  sun/util/calendar/CalendarUtils.java \
  sun/util/calendar/Era.java \
  sun/util/calendar/Gregorian.java \
  sun/util/calendar/ImmutableGregorianDate.java \
  sun/util/calendar/JulianCalendar.java \
  sun/util/locale/BaseLocale.java \
  sun/util/locale/Extension.java \
  sun/util/locale/InternalLocaleBuilder.java \
  sun/util/locale/LanguageTag.java \
  sun/util/locale/LocaleEquivalentMaps.java \
  sun/util/locale/LocaleExtensions.java \
  sun/util/locale/LocaleMatcher.java \
  sun/util/locale/LocaleObjectCache.java \
  sun/util/locale/LocaleSyntaxException.java \
  sun/util/locale/LocaleUtils.java \
  sun/util/locale/ParseStatus.java \
  sun/util/locale/StringTokenIterator.java \
  sun/util/locale/UnicodeLocaleExtension.java \
  sun/util/logging/LoggingProxy.java \
  sun/util/logging/LoggingSupport.java \
  sun/util/logging/PlatformLogger.java \
  java/util/concurrent/Helpers.java

JAVA_PUBLIC_SOURCES_IO = \
  java/io/CharArrayReader.java \
  java/io/CharConversionException.java \
  java/io/FileReader.java \
  java/io/FileWriter.java \
  java/io/FilterReader.java \
  java/io/FilterWriter.java \
  java/io/LineNumberInputStream.java \
  java/io/LineNumberReader.java \
  java/io/PipedInputStream.java \
  java/io/PipedOutputStream.java \
  java/io/PipedReader.java \
  java/io/PipedWriter.java \
  java/io/PushbackReader.java \
  java/io/RandomAccessFile.java \
  java/io/SequenceInputStream.java \
  java/io/StreamTokenizer.java \
  java/io/StringBufferInputStream.java

JAVA_PRIVATE_SOURCES_IO =

JAVA_PUBLIC_SOURCES_NET = \
  com/google/j2objc/io/AsyncPipedNSInputStreamAdapter.java \
  com/google/j2objc/net/NSErrorException.java \
  java/io/CharArrayWriter.java \
  java/net/Authenticator.java \
  java/net/BindException.java \
  java/net/CacheRequest.java \
  java/net/CacheResponse.java \
  java/net/ConnectException.java \
  java/net/ContentHandler.java \
  java/net/ContentHandlerFactory.java \
  java/net/CookieHandler.java \
  java/net/CookieManager.java \
  java/net/CookiePolicy.java \
  java/net/CookieStore.java \
  java/net/DatagramPacket.java \
  java/net/DatagramSocket.java \
  java/net/DatagramSocketImpl.java \
  java/net/DatagramSocketImplFactory.java \
  java/net/FileNameMap.java \
  java/net/HttpCookie.java \
  java/net/HttpRetryException.java \
  java/net/HttpURLConnection.java \
  java/net/IDN.java \
  java/net/Inet4Address.java \
  java/net/Inet6Address.java \
  java/net/InetAddress.java \
  java/net/InetSocketAddress.java \
  java/net/InterfaceAddress.java \
  java/net/MulticastSocket.java \
  java/net/NetPermission.java \
  java/net/NetworkInterface.java \
  java/net/NoRouteToHostException.java \
  java/net/PasswordAuthentication.java \
  java/net/PortUnreachableException.java \
  java/net/ProtocolException.java \
  java/net/Proxy.java \
  java/net/ProxySelector.java \
  java/net/ResponseCache.java \
  java/net/SecureCacheResponse.java \
  java/net/ServerSocket.java \
  java/net/Socket.java \
  java/net/SocketAddress.java \
  java/net/SocketImpl.java \
  java/net/SocketImplFactory.java \
  java/net/SocketOption.java \
  java/net/SocketOptions.java \
  java/net/SocketPermission.java \
  java/net/SocketTimeoutException.java \
  java/net/UnknownHostException.java \
  java/net/URLConnection.java \
  java/net/URLDecoder.java \
  java/net/URLEncoder.java \
  java/net/URLStreamHandler.java \
  java/net/URLStreamHandlerFactory.java \
  java/net/UnknownServiceException.java

JAVA_PRIVATE_SOURCES_NET = \
  android/system/GaiException.java \
  android/system/StructAddrinfo.java \
  com/google/j2objc/net/DataEnqueuedInputStream.java \
  com/google/j2objc/net/DataEnqueuedOutputStream.java \
  com/google/j2objc/net/IosHttpHandler.java \
  com/google/j2objc/net/IosHttpURLConnection.java \
  com/google/j2objc/net/ResourceDataStreamHandler.java \
  com/google/j2objc/net/SecurityDataHandler.java \
  java/net/AbstractPlainDatagramSocketImpl.java \
  java/net/AbstractPlainSocketImpl.java \
  java/net/AddressCache.java \
  java/net/DefaultDatagramSocketImplFactory.java \
  java/net/DefaultFileNameMap.java \
  java/net/DefaultInterface.java \
  java/net/Inet6AddressImpl.java \
  java/net/InetAddressImpl.java \
  java/net/InMemoryCookieStore.java \
  java/net/NetUtil.java \
  java/net/PlainDatagramSocketImpl.java \
  java/net/PlainServerSocketImpl.java \
  java/net/PlainSocketImpl.java \
  java/net/ProxySelectorImpl.java \
  java/net/SocketInputStream.java \
  java/net/SocketOutputStream.java \
  java/net/SocksConsts.java \
  java/net/SocksSocketImpl.java \
  java/net/StandardSocketOptions.java \
  java/net/URLImpl.java \
  libcore/icu/NativeIDN.java \
  libcore/io/NetworkBridge.java \
  libcore/io/NetworkOs.java \
  libcore/net/InetAddressUtils.java \
  libcore/net/UriCodec.java \
  libcore/net/http/HttpDate.java \
  sun/misc/IoTrace.java \
  sun/net/ApplicationProxy.java \
  sun/net/ConnectionResetException.java \
  sun/net/NetHooks.java \
  sun/net/ProgressEvent.java \
  sun/net/ProgressMeteringPolicy.java \
  sun/net/ProgressMonitor.java \
  sun/net/ProgressListener.java \
  sun/net/ProgressSource.java \
  sun/net/ResourceManager.java \
  sun/net/SocksProxy.java \
  sun/net/util/IPAddressUtil.java \
  sun/net/www/MessageHeader.java \
  sun/net/www/MeteredStream.java \
  sun/net/www/ParseUtil.java \
  sun/net/www/URLConnection.java \
  sun/net/www/protocol/file/FileURLConnection.java \
  sun/net/www/protocol/file/Handler.java

NATIVE_JRE_SOURCES_NET = \
  DatagramPacket.m \
  Inet4AddressImpl.m \
  Inet6AddressImpl.m \
  NetworkInterface.m \
  PlainDatagramSocketImpl.m \
  PlainSocketImpl.m \
  SocketInputStream.m \
  SocketOutputStream.m \
  net_util.m \
  net_util_md.m

JAVA_PUBLIC_SOURCES_UTIL = \
  java/util/EventListener.java \
  java/util/EventListenerProxy.java \
  java/util/Observable.java \
  java/util/Observer.java \
  java/util/PriorityQueue.java \
  java/util/PropertyPermission.java \
  java/util/ServiceConfigurationError.java \
  java/util/ServiceLoader.java \
  java/util/Stack.java \
  java/util/Timer.java \
  java/util/TimerTask.java \
  java/util/logging/FileHandler.java \
  java/util/logging/MemoryHandler.java \
  java/util/logging/XMLFormatter.java

JAVA_PRIVATE_SOURCES_UTIL = \
  com/google/j2objc/util/CurrencyNumericCodesImpl.java \
  java/util/stream/TerminalSink.java

JAVA_PUBLIC_SOURCES_CONCURRENT = \
  java/util/concurrent/ArrayBlockingQueue.java \
  java/util/concurrent/BlockingDeque.java \
  java/util/concurrent/BrokenBarrierException.java \
  java/util/concurrent/ConcurrentLinkedDeque.java \
  java/util/concurrent/ConcurrentLinkedQueue.java \
  java/util/concurrent/ConcurrentNavigableMap.java \
  java/util/concurrent/ConcurrentSkipListMap.java \
  java/util/concurrent/ConcurrentSkipListSet.java \
  java/util/concurrent/CyclicBarrier.java \
  java/util/concurrent/DelayQueue.java \
  java/util/concurrent/Exchanger.java \
  java/util/concurrent/Flow.java \
  java/util/concurrent/LinkedBlockingDeque.java \
  java/util/concurrent/LinkedTransferQueue.java \
  java/util/concurrent/Phaser.java \
  java/util/concurrent/PriorityBlockingQueue.java \
  java/util/concurrent/RecursiveAction.java \
  java/util/concurrent/RecursiveTask.java \
  java/util/concurrent/Semaphore.java \
  java/util/concurrent/TransferQueue.java \
  java/util/concurrent/atomic/AtomicIntegerArray.java \
  java/util/concurrent/atomic/AtomicIntegerFieldUpdater.java \
  java/util/concurrent/atomic/AtomicLongArray.java \
  java/util/concurrent/atomic/AtomicLongFieldUpdater.java \
  java/util/concurrent/atomic/AtomicMarkableReference.java \
  java/util/concurrent/atomic/AtomicReferenceArray.java \
  java/util/concurrent/atomic/AtomicStampedReference.java \
  java/util/concurrent/atomic/DoubleAccumulator.java \
  java/util/concurrent/atomic/DoubleAdder.java \
  java/util/concurrent/atomic/LongAccumulator.java \
  java/util/concurrent/atomic/LongAdder.java \
  java/util/concurrent/atomic/Striped64.java \
  java/util/concurrent/locks/AbstractQueuedLongSynchronizer.java \
  java/util/concurrent/locks/ReentrantReadWriteLock.java

JAVA_PRIVATE_SOURCES_CONCURRENT =

JAVA_PUBLIC_SOURCES_CHANNELS = \
  java/nio/ChannelFactoryImpl.java \
  java/nio/channels/AcceptPendingException.java \
  java/nio/channels/AlreadyBoundException.java \
  java/nio/channels/AlreadyConnectedException.java \
  java/nio/channels/AsynchronousByteChannel.java \
  java/nio/channels/AsynchronousChannel.java \
  java/nio/channels/AsynchronousChannelGroup.java \
  java/nio/channels/AsynchronousFileChannel.java \
  java/nio/channels/AsynchronousServerSocketChannel.java \
  java/nio/channels/AsynchronousSocketChannel.java \
  java/nio/channels/CancelledKeyException.java \
  java/nio/channels/Channels.java \
  java/nio/channels/ClosedSelectorException.java \
  java/nio/channels/CompletionHandler.java \
  java/nio/channels/ConnectionPendingException.java \
  java/nio/channels/DatagramChannel.java \
  java/nio/channels/FileLock.java \
  java/nio/channels/FileLockInterruptionException.java \
  java/nio/channels/IllegalBlockingModeException.java \
  java/nio/channels/IllegalChannelGroupException.java \
  java/nio/channels/IllegalSelectorException.java \
  java/nio/channels/InterruptedByTimeoutException.java \
  java/nio/channels/InterruptibleChannel.java \
  java/nio/channels/MembershipKey.java \
  java/nio/channels/MulticastChannel.java \
  java/nio/channels/NetworkChannel.java \
  java/nio/channels/NoConnectionPendingException.java \
  java/nio/channels/NonReadableChannelException.java \
  java/nio/channels/NonWritableChannelException.java \
  java/nio/channels/NotYetBoundException.java \
  java/nio/channels/NotYetConnectedException.java \
  java/nio/channels/OverlappingFileLockException.java \
  java/nio/channels/Pipe.java \
  java/nio/channels/ReadPendingException.java \
  java/nio/channels/SelectableChannel.java \
  java/nio/channels/SelectionKey.java \
  java/nio/channels/Selector.java \
  java/nio/channels/ServerSocketChannel.java \
  java/nio/channels/ShutdownChannelGroupException.java \
  java/nio/channels/SocketChannel.java \
  java/nio/channels/UnresolvedAddressException.java \
  java/nio/channels/UnsupportedAddressTypeException.java \
  java/nio/channels/WritePendingException.java \
  java/nio/channels/spi/AbstractSelectableChannel.java \
  java/nio/channels/spi/AbstractSelectionKey.java \
  java/nio/channels/spi/AbstractSelector.java \
  java/nio/channels/spi/AsynchronousChannelProvider.java \
  java/nio/channels/spi/SelectorProvider.java \
  java/util/InputMismatchException.java \
  java/util/Scanner.java

JAVA_PRIVATE_SOURCES_CHANNELS = \
  dalvik/system/SocketTagger.java \
  java/net/ProtocolFamily.java \
  java/net/StandardProtocolFamily.java \
  jdk/net/ExtendedSocketOptions.java \
  jdk/net/NetworkPermission.java \
  jdk/net/SocketFlow.java \
  sun/misc/LRUCache.java \
  sun/net/ExtendedOptionsImpl.java \
  sun/net/spi/nameservice/NameService.java \
  sun/nio/ch/AbstractPollArrayWrapper.java \
  sun/nio/ch/AbstractPollSelectorImpl.java \
  sun/nio/ch/AllocatedNativeObject.java \
  sun/nio/ch/AsynchronousChannelGroupImpl.java \
  sun/nio/ch/AsynchronousFileChannelImpl.java \
  sun/nio/ch/AsynchronousServerSocketChannelImpl.java \
  sun/nio/ch/AsynchronousSocketChannelImpl.java \
  sun/nio/ch/BsdAsynchronousChannelProvider.java \
  sun/nio/ch/Cancellable.java \
  sun/nio/ch/ChannelInputStream.java \
  sun/nio/ch/CompletedFuture.java \
  sun/nio/ch/DatagramChannelImpl.java \
  sun/nio/ch/DatagramDispatcher.java \
  sun/nio/ch/DatagramSocketAdaptor.java \
  sun/nio/ch/DefaultAsynchronousChannelProvider.java \
  sun/nio/ch/DefaultSelectorProvider.java \
  sun/nio/ch/ExtendedSocketOption.java \
  sun/nio/ch/FileChannelImpl.java \
  sun/nio/ch/FileKey.java \
  sun/nio/ch/FileLockImpl.java \
  sun/nio/ch/FileLockTable.java \
  sun/nio/ch/FileDescriptorHolderSocketImpl.java \
  sun/nio/ch/FileDispatcherImpl.java \
  sun/nio/ch/FileDispatcher.java \
  sun/nio/ch/Groupable.java \
  sun/nio/ch/InheritedChannel.java \
  sun/nio/ch/Invoker.java \
  sun/nio/ch/IOStatus.java \
  sun/nio/ch/IOUtil.java \
  sun/nio/ch/IOVecWrapper.java \
  sun/nio/ch/KQueue.java \
  sun/nio/ch/KQueueArrayWrapper.java \
  sun/nio/ch/KQueuePort.java \
  sun/nio/ch/KQueueSelectorImpl.java \
  sun/nio/ch/KQueueSelectorProvider.java \
  sun/nio/ch/MembershipKeyImpl.java \
  sun/nio/ch/MembershipRegistry.java \
  sun/nio/ch/NativeDispatcher.java \
  sun/nio/ch/NativeObject.java \
  sun/nio/ch/NativeThread.java \
  sun/nio/ch/NativeThreadSet.java \
  sun/nio/ch/Net.java \
  sun/nio/ch/OptionKey.java \
  sun/nio/ch/PendingFuture.java \
  sun/nio/ch/PipeImpl.java \
  sun/nio/ch/PollArrayWrapper.java \
  sun/nio/ch/PollSelectorImpl.java \
  sun/nio/ch/PollSelectorProvider.java \
  sun/nio/ch/Port.java \
  sun/nio/ch/Reflect.java \
  sun/nio/ch/SelChImpl.java \
  sun/nio/ch/SelectionKeyImpl.java \
  sun/nio/ch/SelectorImpl.java \
  sun/nio/ch/SelectorProviderImpl.java \
  sun/nio/ch/ServerSocketAdaptor.java \
  sun/nio/ch/ServerSocketChannelImpl.java \
  sun/nio/ch/SimpleAsynchronousFileChannelImpl.java \
  sun/nio/ch/SinkChannelImpl.java \
  sun/nio/ch/SocketAdaptor.java \
  sun/nio/ch/SocketChannelImpl.java \
  sun/nio/ch/SocketDispatcher.java \
  sun/nio/ch/SocketOptionRegistry.java \
  sun/nio/ch/SourceChannelImpl.java \
  sun/nio/ch/ThreadPool.java \
  sun/nio/ch/UnixAsynchronousServerSocketChannelImpl.java \
  sun/nio/ch/UnixAsynchronousSocketChannelImpl.java \
  sun/nio/ch/Util.java

NATIVE_JRE_SOURCES_CHANNELS = \
  DatagramChannelImpl.m \
  DatagramDispatcher.m \
  FileChannelImpl.m \
  FileDispatcherImpl.m \
  FileKey.m \
  InheritedChannel.m \
  IOUtil.m \
  KQueue.m \
  KQueuePort.m \
  NativeThread.m \
  Net.m \
  PollArrayWrapper.m \
  ServerSocketChannelImpl.m \
  SocketChannelImpl.m \
  UnixAsynchronousServerSocketChannelImpl.m \
  UnixAsynchronousSocketChannelImpl.m \

JAVA_PUBLIC_SOURCES_FILE = \
  java/nio/file/AccessDeniedException.java \
  java/nio/file/AccessMode.java \
  java/nio/file/AtomicMoveNotSupportedException.java \
  java/nio/file/ClosedDirectoryStreamException.java \
  java/nio/file/ClosedFileSystemException.java \
  java/nio/file/ClosedWatchServiceException.java \
  java/nio/file/CopyOption.java \
  java/nio/file/DirectoryIteratorException.java \
  java/nio/file/DirectoryNotEmptyException.java \
  java/nio/file/DirectoryStream.java \
  java/nio/file/FileAlreadyExistsException.java \
  java/nio/file/FileStore.java \
  java/nio/file/FileSystem.java \
  java/nio/file/FileSystemAlreadyExistsException.java \
  java/nio/file/FileSystemException.java \
  java/nio/file/FileSystemLoopException.java \
  java/nio/file/FileSystemNotFoundException.java \
  java/nio/file/FileSystems.java \
  java/nio/file/FileVisitOption.java \
  java/nio/file/FileVisitResult.java \
  java/nio/file/FileVisitor.java \
  java/nio/file/Files.java \
  java/nio/file/InvalidPathException.java \
  java/nio/file/LinkOption.java \
  java/nio/file/LinkPermission.java \
  java/nio/file/NoSuchFileException.java \
  java/nio/file/NotDirectoryException.java \
  java/nio/file/NotLinkException.java \
  java/nio/file/OpenOption.java \
  java/nio/file/PathMatcher.java \
  java/nio/file/Paths.java \
  java/nio/file/ProviderMismatchException.java \
  java/nio/file/ProviderNotFoundException.java \
  java/nio/file/ReadOnlyFileSystemException.java \
  java/nio/file/SecureDirectoryStream.java \
  java/nio/file/SimpleFileVisitor.java \
  java/nio/file/StandardCopyOption.java \
  java/nio/file/StandardOpenOption.java \
  java/nio/file/StandardWatchEventKinds.java \
  java/nio/file/WatchEvent.java \
  java/nio/file/WatchKey.java \
  java/nio/file/WatchService.java \
  java/nio/file/Watchable.java \
  java/nio/file/attribute/AclEntry.java \
  java/nio/file/attribute/AclEntryFlag.java \
  java/nio/file/attribute/AclEntryPermission.java \
  java/nio/file/attribute/AclEntryType.java \
  java/nio/file/attribute/AclFileAttributeView.java \
  java/nio/file/attribute/AttributeView.java \
  java/nio/file/attribute/BasicFileAttributeView.java \
  java/nio/file/attribute/BasicFileAttributes.java \
  java/nio/file/attribute/DosFileAttributeView.java \
  java/nio/file/attribute/DosFileAttributes.java \
  java/nio/file/attribute/FileAttributeView.java \
  java/nio/file/attribute/FileOwnerAttributeView.java \
  java/nio/file/attribute/FileStoreAttributeView.java \
  java/nio/file/attribute/GroupPrincipal.java \
  java/nio/file/attribute/PosixFileAttributeView.java \
  java/nio/file/attribute/PosixFileAttributes.java \
  java/nio/file/attribute/PosixFilePermission.java \
  java/nio/file/attribute/PosixFilePermissions.java \
  java/nio/file/attribute/UserDefinedFileAttributeView.java \
  java/nio/file/attribute/UserPrincipal.java \
  java/nio/file/attribute/UserPrincipalLookupService.java \
  java/nio/file/attribute/UserPrincipalNotFoundException.java \
  java/nio/file/spi/FileSystemProvider.java \
  java/nio/file/spi/FileTypeDetector.java

JAVA_PRIVATE_SOURCES_FILE = \
  com/sun/nio/file/ExtendedCopyOption.java \
  com/sun/nio/file/ExtendedWatchEventModifier.java \
  com/sun/nio/file/SensitivityWatchEventModifier.java \
  java/nio/file/CopyMoveHelper.java \
  java/nio/file/TempFileHelper.java \
  java/nio/file/FileTreeIterator.java \
  java/nio/file/FileTreeWalker.java \
  sun/misc/JavaIOFileDescriptorAccess.java \
  sun/misc/SharedSecrets.java \
  sun/nio/fs/AbstractBasicFileAttributeView.java \
  sun/nio/fs/AbstractFileSystemProvider.java \
  sun/nio/fs/AbstractFileTypeDetector.java \
  sun/nio/fs/AbstractPath.java \
  sun/nio/fs/AbstractWatchKey.java \
  sun/nio/fs/AbstractWatchService.java \
  sun/nio/fs/BasicFileAttributesHolder.java \
  sun/nio/fs/BsdFileStore.java \
  sun/nio/fs/BsdFileSystem.java \
  sun/nio/fs/BsdFileSystemProvider.java \
  sun/nio/fs/BsdNativeDispatcher.java \
  sun/nio/fs/Cancellable.java \
  sun/nio/fs/DefaultFileSystemProvider.java \
  sun/nio/fs/DefaultFileTypeDetector.java \
  sun/nio/fs/DynamicFileAttributeView.java \
  sun/nio/fs/FileOwnerAttributeViewImpl.java \
  sun/nio/fs/Globs.java \
  sun/nio/fs/MacOSXFileSystem.java \
  sun/nio/fs/MacOSXFileSystemProvider.java \
  sun/nio/fs/MacOSXNativeDispatcher.java \
  sun/nio/fs/MimeTypesFileTypeDetector.java \
  sun/nio/fs/NativeBuffer.java \
  sun/nio/fs/NativeBuffers.java \
  sun/nio/fs/PollingWatchService.java \
  sun/nio/fs/UnixChannelFactory.java \
  sun/nio/fs/UnixConstants.java \
  sun/nio/fs/UnixCopyFile.java \
  sun/nio/fs/UnixDirectoryStream.java \
  sun/nio/fs/UnixException.java \
  sun/nio/fs/UnixFileAttributeViews.java \
  sun/nio/fs/UnixFileAttributes.java \
  sun/nio/fs/UnixFileKey.java \
  sun/nio/fs/UnixFileModeAttribute.java \
  sun/nio/fs/UnixFileStore.java \
  sun/nio/fs/UnixFileStoreAttributes.java \
  sun/nio/fs/UnixFileSystem.java \
  sun/nio/fs/UnixFileSystemProvider.java \
  sun/nio/fs/UnixMountEntry.java \
  sun/nio/fs/UnixNativeDispatcher.java \
  sun/nio/fs/UnixPath.java \
  sun/nio/fs/UnixSecureDirectoryStream.java \
  sun/nio/fs/UnixUriUtils.java \
  sun/nio/fs/UnixUserPrincipals.java \
  sun/nio/fs/Util.java \
  sun/security/util/SecurityConstants.java

NATIVE_JRE_SOURCES_FILE = \
  BsdNativeDispatcher.m \
  MacOSXNativeDispatcher.m \
  UnixCopyFile.m \
  UnixNativeDispatcher.m

JAVA_PUBLIC_SOURCES_SECURITY = \
  java/io/SerialVersionUIDDigest.java \
  java/net/URLClassLoader.java \
  java/security/AccessControlException.java \
  java/security/AlgorithmConstraints.java \
  java/security/AlgorithmParameterGenerator.java \
  java/security/AlgorithmParameterGeneratorSpi.java \
  java/security/AlgorithmParameters.java \
  java/security/AlgorithmParametersSpi.java \
  java/security/CodeSigner.java \
  java/security/CodeSource.java \
  java/security/CryptoPrimitive.java \
  java/security/DigestException.java \
  java/security/DigestInputStream.java \
  java/security/DigestOutputStream.java \
  java/security/GeneralSecurityException.java \
  java/security/GuardedObject.java \
  java/security/InvalidAlgorithmParameterException.java \
  java/security/InvalidKeyException.java \
  java/security/InvalidParameterException.java \
  java/security/Key.java \
  java/security/KeyException.java \
  java/security/KeyFactory.java \
  java/security/KeyFactorySpi.java \
  java/security/KeyManagementException.java \
  java/security/KeyPair.java \
  java/security/KeyPairGenerator.java \
  java/security/KeyPairGeneratorSpi.java \
  java/security/KeyRep.java \
  java/security/KeyStore.java \
  java/security/KeyStoreException.java \
  java/security/KeyStoreSpi.java \
  java/security/MessageDigest.java \
  java/security/MessageDigestSpi.java \
  java/security/NoSuchAlgorithmException.java \
  java/security/NoSuchProviderException.java \
  java/security/Policy.java \
  java/security/Principal.java \
  java/security/PrivateKey.java \
  java/security/PrivilegedAction.java \
  java/security/PrivilegedExceptionAction.java \
  java/security/ProtectionDomain.java \
  java/security/Provider.java \
  java/security/ProviderException.java \
  java/security/PublicKey.java \
  java/security/SecureClassLoader.java \
  java/security/SecureRandom.java \
  java/security/SecureRandomSpi.java \
  java/security/Security.java \
  java/security/SecurityPermission.java \
  java/security/Signature.java \
  java/security/SignatureException.java \
  java/security/SignatureSpi.java \
  java/security/Timestamp.java \
  java/security/UnrecoverableEntryException.java \
  java/security/UnrecoverableKeyException.java \
  java/security/cert/CRL.java \
  java/security/cert/CRLException.java \
  java/security/cert/CertPath.java \
  java/security/cert/CertPathBuilder.java \
  java/security/cert/CertPathBuilderException.java \
  java/security/cert/CertPathBuilderResult.java \
  java/security/cert/CertPathBuilderSpi.java \
  java/security/cert/CertPathChecker.java \
  java/security/cert/CertPathParameters.java \
  java/security/cert/CertPathValidator.java \
  java/security/cert/CertPathValidatorException.java \
  java/security/cert/CertPathValidatorResult.java \
  java/security/cert/CertPathValidatorSpi.java \
  java/security/cert/CertSelector.java \
  java/security/cert/Certificate.java \
  java/security/cert/CertificateEncodingException.java \
  java/security/cert/CertificateException.java \
  java/security/cert/CertificateExpiredException.java \
  java/security/cert/CertificateFactory.java \
  java/security/cert/CertificateFactorySpi.java \
  java/security/cert/CertificateNotYetValidException.java \
  java/security/cert/CertificateParsingException.java \
  java/security/cert/CertificateRevokedException.java \
  java/security/cert/CertStore.java \
  java/security/cert/CertStoreException.java \
  java/security/cert/CertStoreParameters.java \
  java/security/cert/CertStoreSpi.java \
  java/security/cert/CollectionCertStoreParameters.java \
  java/security/cert/CRLReason.java \
  java/security/cert/CRLSelector.java \
  java/security/cert/Extension.java \
  java/security/cert/LDAPCertStoreParameters.java \
  java/security/cert/PKIXBuilderParameters.java \
  java/security/cert/PKIXCertPathBuilderResult.java \
  java/security/cert/PKIXCertPathChecker.java \
  java/security/cert/PKIXCertPathValidatorResult.java \
  java/security/cert/PKIXParameters.java \
  java/security/cert/PKIXReason.java \
  java/security/cert/PKIXRevocationChecker.java \
  java/security/cert/PolicyNode.java \
  java/security/cert/PolicyQualifierInfo.java \
  java/security/cert/TrustAnchor.java \
  java/security/cert/X509Certificate.java \
  java/security/cert/X509CertSelector.java \
  java/security/cert/X509CRL.java \
  java/security/cert/X509CRLEntry.java \
  java/security/cert/X509CRLSelector.java \
  java/security/cert/X509Extension.java \
  java/security/interfaces/DSAKey.java \
  java/security/interfaces/DSAParams.java \
  java/security/interfaces/DSAPrivateKey.java \
  java/security/interfaces/DSAPublicKey.java \
  java/security/interfaces/ECKey.java \
  java/security/interfaces/ECPrivateKey.java \
  java/security/interfaces/ECPublicKey.java \
  java/security/interfaces/RSAKey.java \
  java/security/interfaces/RSAMultiPrimePrivateCrtKey.java \
  java/security/interfaces/RSAPrivateCrtKey.java \
  java/security/interfaces/RSAPrivateKey.java \
  java/security/interfaces/RSAPublicKey.java \
  java/security/spec/AlgorithmParameterSpec.java \
  java/security/spec/DSAParameterSpec.java \
  java/security/spec/DSAPrivateKeySpec.java \
  java/security/spec/DSAPublicKeySpec.java \
  java/security/spec/ECField.java \
  java/security/spec/ECFieldF2m.java \
  java/security/spec/ECFieldFp.java \
  java/security/spec/ECGenParameterSpec.java \
  java/security/spec/ECParameterSpec.java \
  java/security/spec/ECPoint.java \
  java/security/spec/ECPrivateKeySpec.java \
  java/security/spec/ECPublicKeySpec.java \
  java/security/spec/EllipticCurve.java \
  java/security/spec/EncodedKeySpec.java \
  java/security/spec/InvalidKeySpecException.java \
  java/security/spec/InvalidParameterSpecException.java \
  java/security/spec/KeySpec.java \
  java/security/spec/MGF1ParameterSpec.java \
  java/security/spec/PKCS8EncodedKeySpec.java \
  java/security/spec/PSSParameterSpec.java \
  java/security/spec/RSAKeyGenParameterSpec.java \
  java/security/spec/RSAMultiPrimePrivateCrtKeySpec.java \
  java/security/spec/RSAOtherPrimeInfo.java \
  java/security/spec/RSAPrivateCrtKeySpec.java \
  java/security/spec/RSAPrivateKeySpec.java \
  java/security/spec/RSAPublicKeySpec.java \
  java/security/spec/X509EncodedKeySpec.java \
  java/util/UUID.java \
  javax/crypto/AEADBadTagException.java \
  javax/crypto/BadPaddingException.java \
  javax/crypto/Cipher.java \
  javax/crypto/CipherInputStream.java \
  javax/crypto/CipherOutputStream.java \
  javax/crypto/CipherSpi.java \
  javax/crypto/ExemptionMechanism.java \
  javax/crypto/ExemptionMechanismException.java \
  javax/crypto/ExemptionMechanismSpi.java \
  javax/crypto/IllegalBlockSizeException.java \
  javax/crypto/KeyAgreement.java \
  javax/crypto/KeyAgreementSpi.java \
  javax/crypto/KeyGenerator.java \
  javax/crypto/KeyGeneratorSpi.java \
  javax/crypto/Mac.java \
  javax/crypto/MacSpi.java \
  javax/crypto/NoSuchPaddingException.java \
  javax/crypto/NullCipher.java \
  javax/crypto/SealedObject.java \
  javax/crypto/SecretKey.java \
  javax/crypto/SecretKeyFactory.java \
  javax/crypto/SecretKeyFactorySpi.java \
  javax/crypto/ShortBufferException.java \
  javax/crypto/interfaces/DHKey.java \
  javax/crypto/interfaces/DHPrivateKey.java \
  javax/crypto/interfaces/DHPublicKey.java \
  javax/crypto/interfaces/PBEKey.java \
  javax/crypto/spec/DESKeySpec.java \
  javax/crypto/spec/DESedeKeySpec.java \
  javax/crypto/spec/DHGenParameterSpec.java \
  javax/crypto/spec/DHParameterSpec.java \
  javax/crypto/spec/DHPrivateKeySpec.java \
  javax/crypto/spec/DHPublicKeySpec.java \
  javax/crypto/spec/GCMParameterSpec.java \
  javax/crypto/spec/IvParameterSpec.java \
  javax/crypto/spec/OAEPParameterSpec.java \
  javax/crypto/spec/PBEKeySpec.java \
  javax/crypto/spec/PBEParameterSpec.java \
  javax/crypto/spec/PSource.java \
  javax/crypto/spec/RC2ParameterSpec.java \
  javax/crypto/spec/RC5ParameterSpec.java \
  javax/crypto/spec/SecretKeySpec.java \
  javax/security/auth/DestroyFailedException.java \
  javax/security/auth/Destroyable.java \
  javax/security/auth/PrivateCredentialPermission.java \
  javax/security/auth/Subject.java \
  javax/security/auth/SubjectDomainCombiner.java \
  javax/security/auth/callback/Callback.java \
  javax/security/auth/callback/CallbackHandler.java \
  javax/security/auth/callback/PasswordCallback.java \
  javax/security/auth/callback/UnsupportedCallbackException.java \
  javax/security/auth/x500/X500Principal.java \
  javax/security/cert/Certificate.java \
  javax/security/cert/CertificateEncodingException.java \
  javax/security/cert/CertificateException.java \
  javax/security/cert/CertificateExpiredException.java \
  javax/security/cert/CertificateNotYetValidException.java \
  javax/security/cert/CertificateParsingException.java \
  javax/security/cert/X509Certificate.java

JAVA_PRIVATE_SOURCES_SECURITY = \
  com/google/j2objc/security/IosMD5MessageDigest.java \
  com/google/j2objc/security/IosRSAKey.java \
  com/google/j2objc/security/IosRSAKeyFactory.java \
  com/google/j2objc/security/IosRSAKeyPairGenerator.java \
  com/google/j2objc/security/IosRSASignature.java \
  com/google/j2objc/security/IosSHAMessageDigest.java \
  com/google/j2objc/security/IosSecureRandomImpl.java \
  com/google/j2objc/security/IosSecurityProvider.java \
  com/google/j2objc/security/cert/IosCertificateFactory.java \
  com/google/j2objc/security/cert/IosX509Certificate.java \
  java/security/cert/CertPathHelperImpl.java \
  javax/crypto/JceSecurity.java \
  javax/crypto/NullCipherSpi.java \
  sun/misc/BASE64Decoder.java \
  sun/misc/CEFormatException.java \
  sun/misc/CEStreamExhausted.java \
  sun/misc/CharacterDecoder.java \
  sun/misc/CharacterEncoder.java \
  sun/misc/HexDumpEncoder.java \
  sun/misc/IOUtils.java \
  sun/security/jca/GetInstance.java \
  sun/security/jca/JCAUtil.java \
  sun/security/jca/ProviderConfig.java \
  sun/security/jca/ProviderList.java \
  sun/security/jca/Providers.java \
  sun/security/jca/ServiceId.java \
  sun/security/pkcs/ContentInfo.java \
  sun/security/pkcs/ParsingException.java \
  sun/security/pkcs/PKCS7.java \
  sun/security/pkcs/PKCS9Attribute.java \
  sun/security/pkcs/PKCS9Attributes.java \
  sun/security/pkcs/SignerInfo.java \
  sun/security/pkcs/SigningCertificateInfo.java \
  sun/security/provider/CertPathProvider.java \
  sun/security/provider/X509Factory.java \
  sun/security/provider/certpath/AdaptableX509CertSelector.java \
  sun/security/provider/certpath/AdjacencyList.java \
  sun/security/provider/certpath/AlgorithmChecker.java \
  sun/security/provider/certpath/BasicChecker.java \
  sun/security/provider/certpath/Builder.java \
  sun/security/provider/certpath/BuildStep.java \
  sun/security/provider/certpath/CertId.java \
  sun/security/provider/certpath/CertPathHelper.java \
  sun/security/provider/certpath/CertStoreHelper.java \
  sun/security/provider/certpath/CollectionCertStore.java \
  sun/security/provider/certpath/ConstraintsChecker.java \
  sun/security/provider/certpath/DistributionPointFetcher.java \
  sun/security/provider/certpath/ForwardBuilder.java \
  sun/security/provider/certpath/ForwardState.java \
  sun/security/provider/certpath/IndexedCollectionCertStore.java \
  sun/security/provider/certpath/KeyChecker.java \
  sun/security/provider/certpath/OCSP.java \
  sun/security/provider/certpath/OCSPRequest.java \
  sun/security/provider/certpath/OCSPResponse.java \
  sun/security/provider/certpath/PKIX.java \
  sun/security/provider/certpath/PKIXCertPathValidator.java \
  sun/security/provider/certpath/PKIXMasterCertPathValidator.java \
  sun/security/provider/certpath/PolicyChecker.java \
  sun/security/provider/certpath/PolicyNodeImpl.java \
  sun/security/provider/certpath/ReverseBuilder.java \
  sun/security/provider/certpath/ReverseState.java \
  sun/security/provider/certpath/RevocationChecker.java \
  sun/security/provider/certpath/State.java \
  sun/security/provider/certpath/SunCertPathBuilder.java \
  sun/security/provider/certpath/SunCertPathBuilderException.java \
  sun/security/provider/certpath/SunCertPathBuilderParameters.java \
  sun/security/provider/certpath/SunCertPathBuilderResult.java \
  sun/security/provider/certpath/UntrustedChecker.java \
  sun/security/provider/certpath/URICertStore.java \
  sun/security/provider/certpath/Vertex.java \
  sun/security/provider/certpath/X509CertificatePair.java \
  sun/security/provider/certpath/X509CertPath.java \
  sun/security/util/BitArray.java \
  sun/security/util/ByteArrayLexOrder.java \
  sun/security/util/ByteArrayTagOrder.java \
  sun/security/util/Cache.java \
  sun/security/util/Debug.java \
  sun/security/util/DerEncoder.java \
  sun/security/util/DerIndefLenConverter.java \
  sun/security/util/DerInputBuffer.java \
  sun/security/util/DerInputStream.java \
  sun/security/util/DerOutputStream.java \
  sun/security/util/DerValue.java \
  sun/security/util/DisabledAlgorithmConstraints.java \
  sun/security/util/KeyUtil.java \
  sun/security/util/Length.java \
  sun/security/util/ObjectIdentifier.java \
  sun/security/util/PropertyExpander.java \
  sun/security/util/Resources.java \
  sun/security/util/ResourcesMgr.java \
  sun/security/util/UntrustedCertificates.java \
  sun/security/x509/AccessDescription.java \
  sun/security/x509/AlgorithmId.java \
  sun/security/x509/AttributeNameEnumeration.java \
  sun/security/x509/AuthorityInfoAccessExtension.java \
  sun/security/x509/AuthorityKeyIdentifierExtension.java \
  sun/security/x509/AVA.java \
  sun/security/x509/BasicConstraintsExtension.java \
  sun/security/x509/CertAttrSet.java \
  sun/security/x509/CertificateAlgorithmId.java \
  sun/security/x509/CertificateExtensions.java \
  sun/security/x509/CertificateIssuerExtension.java \
  sun/security/x509/CertificateIssuerName.java \
  sun/security/x509/CertificatePoliciesExtension.java \
  sun/security/x509/CertificatePolicyId.java \
  sun/security/x509/CertificatePolicyMap.java \
  sun/security/x509/CertificatePolicySet.java \
  sun/security/x509/CertificateSerialNumber.java \
  sun/security/x509/CertificateValidity.java \
  sun/security/x509/CertificateVersion.java \
  sun/security/x509/CertificateX509Key.java \
  sun/security/x509/CRLDistributionPointsExtension.java \
  sun/security/x509/CRLExtensions.java \
  sun/security/x509/CRLNumberExtension.java \
  sun/security/x509/CRLReasonCodeExtension.java \
  sun/security/x509/DeltaCRLIndicatorExtension.java \
  sun/security/x509/DistributionPoint.java \
  sun/security/x509/DistributionPointName.java \
  sun/security/x509/DNSName.java \
  sun/security/x509/EDIPartyName.java \
  sun/security/x509/ExtendedKeyUsageExtension.java \
  sun/security/x509/Extension.java \
  sun/security/x509/FreshestCRLExtension.java \
  sun/security/x509/GeneralNameInterface.java \
  sun/security/x509/GeneralName.java \
  sun/security/x509/GeneralNames.java \
  sun/security/x509/GeneralSubtree.java \
  sun/security/x509/GeneralSubtrees.java \
  sun/security/x509/InhibitAnyPolicyExtension.java \
  sun/security/x509/IPAddressName.java \
  sun/security/x509/IssuerAlternativeNameExtension.java \
  sun/security/x509/IssuingDistributionPointExtension.java \
  sun/security/x509/InvalidityDateExtension.java \
  sun/security/x509/KeyIdentifier.java \
  sun/security/x509/KeyUsageExtension.java \
  sun/security/x509/NameConstraintsExtension.java \
  sun/security/x509/NetscapeCertTypeExtension.java \
  sun/security/x509/OCSPNoCheckExtension.java \
  sun/security/x509/OIDMap.java \
  sun/security/x509/OIDName.java \
  sun/security/x509/OtherName.java \
  sun/security/x509/PKIXExtensions.java \
  sun/security/x509/PolicyConstraintsExtension.java \
  sun/security/x509/PolicyInformation.java \
  sun/security/x509/PolicyMappingsExtension.java \
  sun/security/x509/PrivateKeyUsageExtension.java \
  sun/security/x509/RDN.java \
  sun/security/x509/ReasonFlags.java \
  sun/security/x509/RFC822Name.java \
  sun/security/x509/SerialNumber.java \
  sun/security/x509/SubjectAlternativeNameExtension.java \
  sun/security/x509/SubjectInfoAccessExtension.java \
  sun/security/x509/SubjectKeyIdentifierExtension.java \
  sun/security/x509/UniqueIdentity.java \
  sun/security/x509/URIName.java \
  sun/security/x509/X400Address.java \
  sun/security/x509/X500Name.java \
  sun/security/x509/X509AttributeName.java \
  sun/security/x509/X509CertImpl.java \
  sun/security/x509/X509CertInfo.java \
  sun/security/x509/X509CRLEntryImpl.java \
  sun/security/x509/X509CRLImpl.java \
  sun/security/x509/X509Key.java

NATIVE_JRE_SOURCES_SSL = \
  com/google/j2objc/net/ssl/IosSslSocket.m

JAVA_PUBLIC_SOURCES_SSL = \
  javax/net/ServerSocketFactory.java \
  javax/net/SocketFactory.java \
  javax/net/ssl/ExtendedSSLSession.java \
  javax/net/ssl/HandshakeCompletedEvent.java \
  javax/net/ssl/HandshakeCompletedListener.java \
  javax/net/ssl/HostnameVerifier.java \
  javax/net/ssl/HttpsURLConnection.java \
  javax/net/ssl/KeyManager.java \
  javax/net/ssl/KeyManagerFactory.java \
  javax/net/ssl/KeyManagerFactorySpi.java \
  javax/net/ssl/ManagerFactoryParameters.java \
  javax/net/ssl/SNIHostName.java \
  javax/net/ssl/SNIMatcher.java \
  javax/net/ssl/SNIServerName.java \
  javax/net/ssl/SSLContext.java \
  javax/net/ssl/SSLContextSpi.java \
  javax/net/ssl/SSLEngine.java \
  javax/net/ssl/SSLEngineResult.java \
  javax/net/ssl/SSLException.java \
  javax/net/ssl/SSLHandshakeException.java \
  javax/net/ssl/SSLKeyException.java \
  javax/net/ssl/SSLParameters.java \
  javax/net/ssl/SSLPeerUnverifiedException.java \
  javax/net/ssl/SSLProtocolException.java \
  javax/net/ssl/SSLServerSocket.java \
  javax/net/ssl/SSLServerSocketFactory.java \
  javax/net/ssl/SSLSession.java \
  javax/net/ssl/SSLSessionBindingEvent.java \
  javax/net/ssl/SSLSessionBindingListener.java \
  javax/net/ssl/SSLSessionContext.java \
  javax/net/ssl/SSLSocket.java \
  javax/net/ssl/SSLSocketFactory.java \
  javax/net/ssl/StandardConstants.java \
  javax/net/ssl/TrustManager.java \
  javax/net/ssl/TrustManagerFactory.java \
  javax/net/ssl/TrustManagerFactorySpi.java \
  javax/net/ssl/X509ExtendedTrustManager.java \
  javax/net/ssl/X509KeyManager.java \
  javax/net/ssl/X509TrustManager.java

JAVA_PRIVATE_SOURCES_SSL = \
  com/google/j2objc/net/IosHttpsHandler.java \
  com/google/j2objc/net/IosHttpsURLConnection.java \
  com/google/j2objc/net/ssl/IosSslSocketFactory.java \
  com/google/j2objc/net/ssl/IosSslContextSpi.java

JAVA_PUBLIC_SOURCES_XML = \
  com/google/j2objc/util/PropertiesXmlLoader.java \
  javax/xml/XMLConstants.java \
  javax/xml/datatype/DatatypeConfigurationException.java \
  javax/xml/datatype/DatatypeConstants.java \
  javax/xml/datatype/DatatypeFactory.java \
  javax/xml/datatype/Duration.java \
  javax/xml/datatype/FactoryFinder.java \
  javax/xml/datatype/XMLGregorianCalendar.java \
  javax/xml/namespace/NamespaceContext.java \
  javax/xml/namespace/QName.java \
  javax/xml/parsers/DocumentBuilder.java \
  javax/xml/parsers/DocumentBuilderFactory.java \
  javax/xml/parsers/FactoryConfigurationError.java \
  javax/xml/parsers/FilePathToURI.java \
  javax/xml/parsers/ParserConfigurationException.java \
  javax/xml/parsers/SAXParser.java \
  javax/xml/parsers/SAXParserFactory.java \
  javax/xml/transform/ErrorListener.java \
  javax/xml/transform/OutputKeys.java \
  javax/xml/transform/Result.java \
  javax/xml/transform/Source.java \
  javax/xml/transform/SourceLocator.java \
  javax/xml/transform/Templates.java \
  javax/xml/transform/Transformer.java \
  javax/xml/transform/TransformerConfigurationException.java \
  javax/xml/transform/TransformerException.java \
  javax/xml/transform/TransformerFactory.java \
  javax/xml/transform/TransformerFactoryConfigurationError.java \
  javax/xml/transform/URIResolver.java \
  javax/xml/transform/dom/DOMLocator.java \
  javax/xml/transform/dom/DOMResult.java \
  javax/xml/transform/dom/DOMSource.java \
  javax/xml/transform/sax/SAXResult.java \
  javax/xml/transform/sax/SAXSource.java \
  javax/xml/transform/sax/SAXTransformerFactory.java \
  javax/xml/transform/sax/TemplatesHandler.java \
  javax/xml/transform/sax/TransformerHandler.java \
  javax/xml/transform/stream/FilePathToURI.java \
  javax/xml/transform/stream/StreamResult.java \
  javax/xml/transform/stream/StreamSource.java \
  javax/xml/validation/Schema.java \
  javax/xml/validation/SchemaFactory.java \
  javax/xml/validation/SchemaFactoryFinder.java \
  javax/xml/validation/SchemaFactoryLoader.java \
  javax/xml/validation/TypeInfoProvider.java \
  javax/xml/validation/Validator.java \
  javax/xml/validation/ValidatorHandler.java \
  javax/xml/xpath/XPath.java \
  javax/xml/xpath/XPathConstants.java \
  javax/xml/xpath/XPathException.java \
  javax/xml/xpath/XPathExpression.java \
  javax/xml/xpath/XPathExpressionException.java \
  javax/xml/xpath/XPathFactory.java \
  javax/xml/xpath/XPathFactoryConfigurationException.java \
  javax/xml/xpath/XPathFactoryFinder.java \
  javax/xml/xpath/XPathFunction.java \
  javax/xml/xpath/XPathFunctionException.java \
  javax/xml/xpath/XPathFunctionResolver.java \
  javax/xml/xpath/XPathVariableResolver.java \
  org/w3c/dom/Attr.java \
  org/w3c/dom/CDATASection.java \
  org/w3c/dom/CharacterData.java \
  org/w3c/dom/Comment.java \
  org/w3c/dom/DOMConfiguration.java \
  org/w3c/dom/DOMError.java \
  org/w3c/dom/DOMErrorHandler.java \
  org/w3c/dom/DOMException.java \
  org/w3c/dom/DOMImplementation.java \
  org/w3c/dom/DOMImplementationList.java \
  org/w3c/dom/DOMImplementationSource.java \
  org/w3c/dom/DOMLocator.java \
  org/w3c/dom/DOMStringList.java \
  org/w3c/dom/Document.java \
  org/w3c/dom/DocumentFragment.java \
  org/w3c/dom/DocumentType.java \
  org/w3c/dom/Element.java \
  org/w3c/dom/Entity.java \
  org/w3c/dom/EntityReference.java \
  org/w3c/dom/NameList.java \
  org/w3c/dom/NamedNodeMap.java \
  org/w3c/dom/Node.java \
  org/w3c/dom/NodeList.java \
  org/w3c/dom/Notation.java \
  org/w3c/dom/ProcessingInstruction.java \
  org/w3c/dom/Text.java \
  org/w3c/dom/TypeInfo.java \
  org/w3c/dom/UserDataHandler.java \
  org/w3c/dom/ls/DOMImplementationLS.java \
  org/w3c/dom/ls/LSException.java \
  org/w3c/dom/ls/LSInput.java \
  org/w3c/dom/ls/LSOutput.java \
  org/w3c/dom/ls/LSParser.java \
  org/w3c/dom/ls/LSParserFilter.java \
  org/w3c/dom/ls/LSResourceResolver.java \
  org/w3c/dom/ls/LSSerializer.java \
  org/w3c/dom/ls/LSSerializerFilter.java \
  org/w3c/dom/traversal/NodeFilter.java \
  org/w3c/dom/traversal/NodeIterator.java \
  org/xml/sax/AttributeList.java \
  org/xml/sax/Attributes.java \
  org/xml/sax/ContentHandler.java \
  org/xml/sax/DTDHandler.java \
  org/xml/sax/DocumentHandler.java \
  org/xml/sax/EntityResolver.java \
  org/xml/sax/ErrorHandler.java \
  org/xml/sax/HandlerBase.java \
  org/xml/sax/InputSource.java \
  org/xml/sax/Locator.java \
  org/xml/sax/Parser.java \
  org/xml/sax/SAXException.java \
  org/xml/sax/SAXNotRecognizedException.java \
  org/xml/sax/SAXNotSupportedException.java \
  org/xml/sax/SAXParseException.java \
  org/xml/sax/XMLFilter.java \
  org/xml/sax/XMLReader.java \
  org/xml/sax/ext/Attributes2.java \
  org/xml/sax/ext/Attributes2Impl.java \
  org/xml/sax/ext/DeclHandler.java \
  org/xml/sax/ext/DefaultHandler2.java \
  org/xml/sax/ext/EntityResolver2.java \
  org/xml/sax/ext/LexicalHandler.java \
  org/xml/sax/ext/Locator2.java \
  org/xml/sax/ext/Locator2Impl.java \
  org/xml/sax/helpers/AttributeListImpl.java \
  org/xml/sax/helpers/AttributesImpl.java \
  org/xml/sax/helpers/DefaultHandler.java \
  org/xml/sax/helpers/LocatorImpl.java \
  org/xml/sax/helpers/NamespaceSupport.java \
  org/xml/sax/helpers/NewInstance.java \
  org/xml/sax/helpers/ParserAdapter.java \
  org/xml/sax/helpers/ParserFactory.java \
  org/xml/sax/helpers/XMLFilterImpl.java \
  org/xml/sax/helpers/XMLReaderAdapter.java \
  org/xml/sax/helpers/XMLReaderFactory.java

JAVA_PUBLIC_SOURCES_XMLPULL = \
  org/xmlpull/v1/XmlPullParser.java \
  org/xmlpull/v1/XmlPullParserException.java \
  org/xmlpull/v1/XmlPullParserFactory.java \
  org/xmlpull/v1/XmlSerializer.java \
  org/xmlpull/v1/sax2/Driver.java

JAVA_PRIVATE_SOURCES_XML = \
  libcore/internal/StringPool.java \
  org/apache/harmony/xml/dom/AttrImpl.java \
  org/apache/harmony/xml/dom/CDATASectionImpl.java \
  org/apache/harmony/xml/dom/CharacterDataImpl.java \
  org/apache/harmony/xml/dom/CommentImpl.java \
  org/apache/harmony/xml/dom/DOMConfigurationImpl.java \
  org/apache/harmony/xml/dom/DOMErrorImpl.java \
  org/apache/harmony/xml/dom/DOMImplementationImpl.java \
  org/apache/harmony/xml/dom/DocumentFragmentImpl.java \
  org/apache/harmony/xml/dom/DocumentImpl.java \
  org/apache/harmony/xml/dom/DocumentTypeImpl.java \
  org/apache/harmony/xml/dom/ElementImpl.java \
  org/apache/harmony/xml/dom/EntityImpl.java \
  org/apache/harmony/xml/dom/EntityReferenceImpl.java \
  org/apache/harmony/xml/dom/InnerNodeImpl.java \
  org/apache/harmony/xml/dom/LeafNodeImpl.java \
  org/apache/harmony/xml/dom/NodeImpl.java \
  org/apache/harmony/xml/dom/NodeListImpl.java \
  org/apache/harmony/xml/dom/NotationImpl.java \
  org/apache/harmony/xml/dom/ProcessingInstructionImpl.java \
  org/apache/harmony/xml/dom/TextImpl.java \
  org/apache/harmony/xml/parsers/DocumentBuilderFactoryImpl.java \
  org/apache/harmony/xml/parsers/DocumentBuilderImpl.java \
  org/apache/harmony/xml/parsers/SAXParserFactoryImpl.java \
  org/apache/harmony/xml/parsers/SAXParserImpl.java \
  org/kxml2/io/KXmlParser.java \
  org/kxml2/io/KXmlSerializer.java

NATIVE_JRE_SOURCES_ZIP = \
  java_util_zip_Deflater.m \
  java_util_zip_Inflater.m \
  java_util_zip_ZipFile.m \
  zip_util.m

JAVA_PUBLIC_SOURCES_ZIP = \
  java/net/JarURLConnection.java \
  java/util/jar/Attributes.java \
  java/util/jar/JarEntry.java \
  java/util/jar/JarException.java \
  java/util/jar/JarFile.java \
  java/util/jar/JarInputStream.java \
  java/util/jar/JarOutputStream.java \
  java/util/jar/Manifest.java \
  java/util/jar/Pack200.java \
  java/util/zip/Adler32.java \
  java/util/zip/CRC32.java \
  java/util/zip/CheckedInputStream.java \
  java/util/zip/CheckedOutputStream.java \
  java/util/zip/Checksum.java \
  java/util/zip/DataFormatException.java \
  java/util/zip/Deflater.java \
  java/util/zip/DeflaterInputStream.java \
  java/util/zip/DeflaterOutputStream.java \
  java/util/zip/GZIPInputStream.java \
  java/util/zip/GZIPOutputStream.java \
  java/util/zip/Inflater.java \
  java/util/zip/InflaterInputStream.java \
  java/util/zip/InflaterOutputStream.java \
  java/util/zip/ZipConstants.java \
  java/util/zip/ZipEntry.java \
  java/util/zip/ZipError.java \
  java/util/zip/ZipException.java \
  java/util/zip/ZipFile.java \
  java/util/zip/ZipInputStream.java \
  java/util/zip/ZipOutputStream.java

JAVA_PRIVATE_SOURCES_ZIP = \
  java/util/jar/JarVerifier.java \
  java/util/zip/ZStreamRef.java \
  java/util/zip/ZipCoder.java \
  java/util/zip/ZipConstants64.java \
  java/util/zip/ZipUtils.java \
  libcore/io/Base64.java \
  libcore/io/BufferIterator.java \
  libcore/net/url/JarHandler.java \
  libcore/net/url/JarURLConnectionImpl.java \
  sun/misc/ASCIICaseInsensitiveComparator.java \
  sun/security/timestamp/TimestampToken.java \
  sun/security/util/SignatureFileVerifier.java \
  sun/security/util/ManifestDigester.java \
  sun/security/util/ManifestEntryVerifier.java

JAVA_PUBLIC_SOURCES_SQL = \
  java/sql/Array.java \
  java/sql/BatchUpdateException.java \
  java/sql/Blob.java \
  java/sql/CallableStatement.java \
  java/sql/ClientInfoStatus.java \
  java/sql/Clob.java \
  java/sql/Connection.java \
  java/sql/DataTruncation.java \
  java/sql/DatabaseMetaData.java \
  java/sql/Date.java \
  java/sql/Driver.java \
  java/sql/DriverManager.java \
  java/sql/DriverPropertyInfo.java \
  java/sql/NClob.java \
  java/sql/ParameterMetaData.java \
  java/sql/PreparedStatement.java \
  java/sql/Ref.java \
  java/sql/ResultSet.java \
  java/sql/ResultSetMetaData.java \
  java/sql/RowId.java \
  java/sql/RowIdLifetime.java \
  java/sql/SQLClientInfoException.java \
  java/sql/SQLData.java \
  java/sql/SQLDataException.java \
  java/sql/SQLException.java \
  java/sql/SQLFeatureNotSupportedException.java \
  java/sql/SQLInput.java \
  java/sql/SQLIntegrityConstraintViolationException.java \
  java/sql/SQLInvalidAuthorizationSpecException.java \
  java/sql/SQLNonTransientConnectionException.java \
  java/sql/SQLNonTransientException.java \
  java/sql/SQLOutput.java \
  java/sql/SQLPermission.java \
  java/sql/SQLRecoverableException.java \
  java/sql/SQLSyntaxErrorException.java \
  java/sql/SQLTimeoutException.java \
  java/sql/SQLTransactionRollbackException.java \
  java/sql/SQLTransientConnectionException.java \
  java/sql/SQLTransientException.java \
  java/sql/SQLWarning.java \
  java/sql/SQLXML.java \
  java/sql/Savepoint.java \
  java/sql/Statement.java \
  java/sql/Struct.java \
  java/sql/Time.java \
  java/sql/Timestamp.java \
  java/sql/Types.java \
  java/sql/Wrapper.java \
  javax/sql/CommonDataSource.java \
  javax/sql/ConnectionEvent.java \
  javax/sql/ConnectionEventListener.java \
  javax/sql/ConnectionPoolDataSource.java \
  javax/sql/DataSource.java \
  javax/sql/PooledConnection.java \
  javax/sql/RowSet.java \
  javax/sql/RowSetEvent.java \
  javax/sql/RowSetInternal.java \
  javax/sql/RowSetListener.java \
  javax/sql/RowSetMetaData.java \
  javax/sql/RowSetReader.java \
  javax/sql/RowSetWriter.java \
  javax/sql/StatementEvent.java \
  javax/sql/StatementEventListener.java

JAVA_PRIVATE_SOURCES_SQL =

JAVA_PUBLIC_SOURCES_BEANS = \
  java/awt/font/NumericShaper.java \
  java/awt/font/TextAttribute.java \
  java/beans/BeanDescriptor.java \
  java/beans/BeanInfo.java \
  java/beans/EventSetDescriptor.java \
  java/beans/FeatureDescriptor.java \
  java/beans/IndexedPropertyChangeEvent.java \
  java/beans/IndexedPropertyDescriptor.java \
  java/beans/IntrospectionException.java \
  java/beans/Introspector.java \
  java/beans/MethodDescriptor.java \
  java/beans/ParameterDescriptor.java \
  java/beans/PropertyChangeEvent.java \
  java/beans/PropertyChangeListener.java \
  java/beans/PropertyChangeListenerProxy.java \
  java/beans/PropertyChangeSupport.java \
  java/beans/PropertyDescriptor.java \
  java/beans/PropertyVetoException.java \
  java/beans/SimpleBeanInfo.java \
  java/util/TooManyListenersException.java

JAVA_PRIVATE_SOURCES_BEANS = \
  java/beans/ChangeListenerMap.java \
  java/beans/StandardBeanInfo.java \
  org/apache/harmony/beans/BeansUtils.java

JAVA_PUBLIC_SOURCES_TIME = \
  java/time/Clock.java \
  java/time/DateTimeException.java \
  java/time/DayOfWeek.java \
  java/time/Duration.java \
  java/time/Instant.java \
  java/time/LocalDate.java \
  java/time/LocalDateTime.java \
  java/time/LocalTime.java \
  java/time/Month.java \
  java/time/MonthDay.java \
  java/time/OffsetDateTime.java \
  java/time/OffsetTime.java \
  java/time/Period.java \
  java/time/Year.java \
  java/time/YearMonth.java \
  java/time/ZoneId.java \
  java/time/ZoneOffset.java \
  java/time/ZonedDateTime.java \
  java/time/chrono/AbstractChronology.java \
  java/time/chrono/ChronoLocalDate.java \
  java/time/chrono/ChronoLocalDateTime.java \
  java/time/chrono/ChronoPeriod.java \
  java/time/chrono/ChronoZonedDateTime.java \
  java/time/chrono/Chronology.java \
  java/time/chrono/Era.java \
  java/time/chrono/IsoChronology.java \
  java/time/chrono/IsoEra.java \
  java/time/format/DateTimeFormatter.java \
  java/time/format/DateTimeFormatterBuilder.java \
  java/time/format/DateTimeParseException.java \
  java/time/format/DecimalStyle.java \
  java/time/format/FormatStyle.java \
  java/time/format/ResolverStyle.java \
  java/time/format/SignStyle.java \
  java/time/format/TextStyle.java \
  java/time/temporal/ChronoField.java \
  java/time/temporal/ChronoUnit.java \
  java/time/temporal/IsoFields.java \
  java/time/temporal/JulianFields.java \
  java/time/temporal/Temporal.java \
  java/time/temporal/TemporalAccessor.java \
  java/time/temporal/TemporalAdjuster.java \
  java/time/temporal/TemporalAdjusters.java \
  java/time/temporal/TemporalAmount.java \
  java/time/temporal/TemporalField.java \
  java/time/temporal/TemporalQueries.java \
  java/time/temporal/TemporalQuery.java \
  java/time/temporal/TemporalUnit.java \
  java/time/temporal/UnsupportedTemporalTypeException.java \
  java/time/temporal/ValueRange.java \
  java/time/temporal/WeekFields.java \
  java/time/zone/ZoneOffsetTransition.java \
  java/time/zone/ZoneOffsetTransitionRule.java \
  java/time/zone/ZoneRules.java \
  java/time/zone/ZoneRulesException.java

JAVA_PRIVATE_SOURCES_TIME = \
  java/time/Ser.java \
  java/time/ZoneRegion.java \
  java/time/chrono/ChronoLocalDateImpl.java \
  java/time/chrono/ChronoLocalDateTimeImpl.java \
  java/time/chrono/ChronoPeriodImpl.java \
  java/time/chrono/ChronoZonedDateTimeImpl.java \
  java/time/chrono/Ser.java \
  java/time/format/DateTimeParseContext.java \
  java/time/format/DateTimePrintContext.java \
  java/time/format/DateTimeTextProvider.java \
  java/time/format/Parsed.java \
  java/time/format/ZoneName.java \
  java/time/zone/IcuZoneRulesProvider.java \
  java/time/zone/Ser.java \
  java/time/zone/ZoneRulesProvider.java \
  sun/util/locale/provider/CalendarDataUtility.java

JAVA_PUBLIC_SOURCES_ICU = \
  android/icu/lang/UCharacter.java \
  android/icu/lang/UCharacterCategory.java \
  android/icu/lang/UCharacterEnums.java \
  android/icu/lang/UProperty.java \
  android/icu/lang/UScript.java \
  android/icu/math/BigDecimal.java \
  android/icu/math/MathContext.java \
  android/icu/text/BreakIterator.java \
  android/icu/text/CurrencyPluralInfo.java \
  android/icu/text/DateFormat.java \
  android/icu/text/DateFormatSymbols.java \
  android/icu/text/DateTimePatternGenerator.java \
  android/icu/text/DecimalFormat.java \
  android/icu/text/DecimalFormatSymbols.java \
  android/icu/text/DisplayContext.java \
  android/icu/text/LocaleDisplayNames.java \
  android/icu/text/MessageFormat.java \
  android/icu/text/MessagePattern.java \
  android/icu/text/Normalizer.java \
  android/icu/text/Normalizer2.java \
  android/icu/text/NumberFormat.java \
  android/icu/text/NumberingSystem.java \
  android/icu/text/PluralFormat.java \
  android/icu/text/PluralRules.java \
  android/icu/text/Replaceable.java \
  android/icu/text/SelectFormat.java \
  android/icu/text/SimpleDateFormat.java \
  android/icu/text/SymbolTable.java \
  android/icu/text/TimeZoneFormat.java \
  android/icu/text/TimeZoneNames.java \
  android/icu/text/UCharacterIterator.java \
  android/icu/text/UFormat.java \
  android/icu/text/UForwardCharacterIterator.java \
  android/icu/text/UnicodeFilter.java \
  android/icu/text/UnicodeMatcher.java \
  android/icu/text/UnicodeSet.java \
  android/icu/text/UnicodeSetIterator.java \
  android/icu/util/Calendar.java \
  android/icu/util/Currency.java \
  android/icu/util/CurrencyAmount.java \
  android/icu/util/Freezable.java \
  android/icu/util/GregorianCalendar.java \
  android/icu/util/HebrewCalendar.java \
  android/icu/util/ICUUncheckedIOException.java \
  android/icu/util/IllformedLocaleException.java \
  android/icu/util/LocaleData.java \
  android/icu/util/Measure.java \
  android/icu/util/MeasureUnit.java \
  android/icu/util/Output.java \
  android/icu/util/RangeValueIterator.java \
  android/icu/util/TimeUnit.java \
  android/icu/util/TimeZone.java \
  android/icu/util/ULocale.java \
  android/icu/util/ValueIterator.java \
  android/icu/util/VersionInfo.java \
  java/text/BreakIterator.java \

JAVA_PRIVATE_SOURCES_ICU = \
  android/icu/impl/Assert.java \
  android/icu/impl/BMPSet.java \
  android/icu/impl/CSCharacterIterator.java \
  android/icu/impl/CacheBase.java \
  android/icu/impl/CacheValue.java \
  android/icu/impl/CalendarCache.java \
  android/icu/impl/CalendarUtil.java \
  android/icu/impl/CaseMapImpl.java \
  android/icu/impl/CharTrie.java \
  android/icu/impl/CharacterIteration.java \
  android/icu/impl/CharacterIteratorWrapper.java \
  android/icu/impl/ClassLoaderUtil.java \
  android/icu/impl/CurrencyData.java \
  android/icu/impl/DateNumberFormat.java \
  android/icu/impl/DayPeriodRules.java \
  android/icu/impl/Grego.java \
  android/icu/impl/ICUBinary.java \
  android/icu/impl/ICUCache.java \
  android/icu/impl/ICUConfig.java \
  android/icu/impl/ICUData.java \
  android/icu/impl/ICUDebug.java \
  android/icu/impl/ICULocaleService.java \
  android/icu/impl/ICUNotifier.java \
  android/icu/impl/ICURWLock.java \
  android/icu/impl/ICUResourceBundle.java \
  android/icu/impl/ICUResourceBundleImpl.java \
  android/icu/impl/ICUResourceBundleReader.java \
  android/icu/impl/ICUResourceTableAccess.java \
  android/icu/impl/ICUService.java \
  android/icu/impl/IllegalIcuArgumentException.java \
  android/icu/impl/IntTrie.java \
  android/icu/impl/IntTrieBuilder.java \
  android/icu/impl/JavaTimeZone.java \
  android/icu/impl/LocaleIDParser.java \
  android/icu/impl/LocaleIDs.java \
  android/icu/impl/LocaleUtility.java \
  android/icu/impl/Norm2AllModes.java \
  android/icu/impl/Normalizer2Impl.java \
  android/icu/impl/OlsonTimeZone.java \
  android/icu/impl/Pair.java \
  android/icu/impl/PatternProps.java \
  android/icu/impl/PatternTokenizer.java \
  android/icu/impl/PluralRulesLoader.java \
  android/icu/impl/Relation.java \
  android/icu/impl/RelativeDateFormat.java \
  android/icu/impl/ReplaceableUCharacterIterator.java \
  android/icu/impl/ResourceBundleWrapper.java \
  android/icu/impl/RuleCharacterIterator.java \
  android/icu/impl/SimpleCache.java \
  android/icu/impl/SimpleFilteredSentenceBreakIterator.java \
  android/icu/impl/SimpleFormatterImpl.java \
  android/icu/impl/SoftCache.java \
  android/icu/impl/SortedSetRelation.java \
  android/icu/impl/StandardPlural.java \
  android/icu/impl/StringRange.java \
  android/icu/impl/TZDBTimeZoneNames.java \
  android/icu/impl/TextTrieMap.java \
  android/icu/impl/TimeZoneAdapter.java \
  android/icu/impl/TimeZoneNamesFactoryImpl.java \
  android/icu/impl/TimeZoneGenericNames.java \
  android/icu/impl/TimeZoneNamesImpl.java \
  android/icu/impl/Trie.java \
  android/icu/impl/Trie2.java \
  android/icu/impl/Trie2Writable.java \
  android/icu/impl/Trie2_16.java \
  android/icu/impl/Trie2_32.java \
  android/icu/impl/TrieBuilder.java \
  android/icu/impl/UBiDiProps.java \
  android/icu/impl/UCaseProps.java \
  android/icu/impl/UCharArrayIterator.java \
  android/icu/impl/UCharacterIteratorWrapper.java \
  android/icu/impl/UCharacterName.java \
  android/icu/impl/UCharacterNameChoice.java \
  android/icu/impl/UCharacterNameReader.java \
  android/icu/impl/UCharacterProperty.java \
  android/icu/impl/UCharacterUtility.java \
  android/icu/impl/UPropertyAliases.java \
  android/icu/impl/URLHandler.java \
  android/icu/impl/UResource.java \
  android/icu/impl/UnicodeSetStringSpan.java \
  android/icu/impl/Utility.java \
  android/icu/impl/ZoneMeta.java \
  android/icu/impl/locale/AsciiUtil.java \
  android/icu/impl/locale/BaseLocale.java \
  android/icu/impl/locale/Extension.java \
  android/icu/impl/locale/InternalLocaleBuilder.java \
  android/icu/impl/locale/KeyTypeData.java \
  android/icu/impl/locale/LanguageTag.java \
  android/icu/impl/locale/LocaleExtensions.java \
  android/icu/impl/locale/LocaleObjectCache.java \
  android/icu/impl/locale/LocaleSyntaxException.java \
  android/icu/impl/locale/ParseStatus.java \
  android/icu/impl/locale/StringTokenIterator.java \
  android/icu/impl/locale/UnicodeLocaleExtension.java \
  android/icu/lang/CharSequences.java \
  android/icu/lang/UCharacterNameIterator.java \
  android/icu/text/BreakIteratorFactory.java \
  android/icu/text/CurrencyDisplayNames.java \
  android/icu/text/CurrencyMetaInfo.java \
  android/icu/text/DictionaryBreakEngine.java \
  android/icu/text/DictionaryMatcher.java \
  android/icu/text/DigitList.java \
  android/icu/text/Edits.java \
  android/icu/text/FilteredBreakIteratorBuilder.java \
  android/icu/text/FilteredNormalizer2.java \
  android/icu/text/LanguageBreakEngine.java \
  android/icu/text/NFRule.java \
  android/icu/text/NFRuleSet.java \
  android/icu/text/NFSubstitution.java \
  android/icu/text/NumberFormatServiceShim.java \
  android/icu/text/PluralRanges.java \
  android/icu/text/PluralRulesSerialProxy.java \
  android/icu/text/RBBIDataWrapper.java \
  android/icu/text/RBBINode.java \
  android/icu/text/RBBIRuleBuilder.java \
  android/icu/text/RBBIRuleParseTable.java \
  android/icu/text/RBBIRuleScanner.java \
  android/icu/text/RBBISetBuilder.java \
  android/icu/text/RBBISymbolTable.java \
  android/icu/text/RBBITableBuilder.java \
  android/icu/text/RBNFPostProcessor.java \
  android/icu/text/RbnfLenientScanner.java \
  android/icu/text/RbnfLenientScannerProvider.java \
  android/icu/text/ReplaceableString.java \
  android/icu/text/RuleBasedBreakIterator.java \
  android/icu/text/RuleBasedNumberFormat.java \
  android/icu/text/UFieldPosition.java \
  android/icu/text/UTF16.java \
  android/icu/text/UnhandledBreakEngine.java \
  android/icu/util/AnnualTimeZoneRule.java \
  android/icu/util/BasicTimeZone.java \
  android/icu/util/BytesTrie.java \
  android/icu/util/CharsTrie.java \
  android/icu/util/CharsTrieBuilder.java \
  android/icu/util/DateTimeRule.java \
  android/icu/util/ICUCloneNotSupportedException.java \
  android/icu/util/ICUException.java \
  android/icu/util/InitialTimeZoneRule.java \
  android/icu/util/OutputInt.java \
  android/icu/util/RuleBasedTimeZone.java \
  android/icu/util/STZInfo.java \
  android/icu/util/SimpleTimeZone.java \
  android/icu/util/StringTrieBuilder.java \
  android/icu/util/TimeArrayTimeZoneRule.java \
  android/icu/util/TimeZoneRule.java \
  android/icu/util/TimeZoneTransition.java \
  android/icu/util/UResourceBundle.java \
  android/icu/util/UResourceBundleIterator.java \
  android/icu/util/UResourceTypeMismatchException.java \
  android/icu/util/VTimeZone.java \
  java/text/IcuIteratorWrapper.java \

NATIVE_JRE_ICU_EMBEDDED_DATA = ICUData.m

# These sources are not included in any sub-library, only the full jre_emul.
# javax.lang.model.element.Modifier is required by mockito, and the
# java.lang.management classes by JUnit 4.13, so they are only needed
# in a testing environment. The other classes are errors only thrown by a JVM.
JAVA_PUBLIC_SOURCES_OTHER = \
  java/lang/ClassCircularityError.java \
  java/lang/UnsupportedClassVersionError.java \
  java/lang/management/ManagementFactory.java \
  java/lang/management/RuntimeMXBean.java \
  java/lang/management/ThreadMXBean.java \
  javax/lang/model/element/Modifier.java

JAVA_PRIVATE_SOURCES_OTHER = \
  java/lang/management/ThreadInfo.java

ANDROID_PUBLIC_SOURCES = \
  android/os/AsyncTask.java \
  android/os/SystemClock.java \
  android/test/suitebuilder/annotation/LargeTest.java \
  android/test/suitebuilder/annotation/MediumTest.java \
  android/test/suitebuilder/annotation/SmallTest.java \
  android/test/suitebuilder/annotation/Smoke.java \
  android/test/suitebuilder/annotation/Suppress.java \
  android/text/Editable.java \
  android/text/GetChars.java \
  android/text/InputFilter.java \
  android/text/InputType.java \
  android/text/NoCopySpan.java \
  android/text/Selection.java \
  android/text/SpanSet.java \
  android/text/SpanWatcher.java \
  android/text/Spannable.java \
  android/text/SpannableString.java \
  android/text/SpannableStringBuilder.java \
  android/text/SpannableStringInternal.java \
  android/text/Spanned.java \
  android/text/SpannedString.java \
  android/text/TextUtils.java \
  android/text/TextWatcher.java \
  android/text/util/Rfc822Token.java \
  android/text/util/Rfc822Tokenizer.java \
  android/util/ArrayMap.java \
  android/util/ArraySet.java \
  android/util/Base64.java \
  android/util/Base64DataException.java \
  android/util/Base64InputStream.java \
  android/util/Base64OutputStream.java \
  android/util/Log.java \
  android/util/LruCache.java \
  android/util/MapCollections.java \
  android/util/Pair.java \
  android/util/Printer.java \
  android/util/SparseArray.java \
  android/util/SparseBooleanArray.java \
  android/util/SparseIntArray.java \
  android/util/SparseLongArray.java

ANDROID_PRIVATE_SOURCES = \
  android/util/ContainerHelpers.java \
  com/android/internal/util/ArrayUtils.java \
  com/google/android/collect/Lists.java \
  com/google/android/collect/Maps.java \
  com/google/android/collect/Sets.java

JSON_PUBLIC_SOURCES = \
  org/json/JSONArray.java \
  org/json/JSONException.java \
  org/json/JSONObject.java \
  org/json/JSONStringer.java \
  org/json/JSONTokener.java

JSON_PRIVATE_SOURCES = \
  org/json/JSON.java

ANDROID_ANNOTATIONS = android/platform/libcore/annotations/ojluni.jaif
J2OBJC_ANNOTATIONS = j2objc.jaif

JAVA_SOURCES_CORE = $(JAVA_PUBLIC_SOURCES_CORE) $(JAVA_PRIVATE_SOURCES_CORE)
JAVA_SOURCES_OTHER = $(JAVA_PUBLIC_SOURCES_OTHER) $(JAVA_PRIVATE_SOURCES_OTHER)
JAVA_SOURCES_IO = $(JAVA_PUBLIC_SOURCES_IO) $(JAVA_PRIVATE_SOURCES_IO)
JAVA_SOURCES_NET = $(JAVA_PUBLIC_SOURCES_NET) $(JAVA_PRIVATE_SOURCES_NET)
JAVA_SOURCES_UTIL = $(JAVA_PUBLIC_SOURCES_UTIL) $(JAVA_PRIVATE_SOURCES_UTIL)
JAVA_SOURCES_CONCURRENT = $(JAVA_PUBLIC_SOURCES_CONCURRENT) $(JAVA_PRIVATE_SOURCES_CONCURRENT)
JAVA_SOURCES_CHANNELS = $(JAVA_PUBLIC_SOURCES_CHANNELS) $(JAVA_PRIVATE_SOURCES_CHANNELS)
JAVA_SOURCES_FILE = $(JAVA_PUBLIC_SOURCES_FILE) $(JAVA_PRIVATE_SOURCES_FILE)
JAVA_SOURCES_SECURITY = $(JAVA_PUBLIC_SOURCES_SECURITY) $(JAVA_PRIVATE_SOURCES_SECURITY)
JAVA_SOURCES_SSL = $(JAVA_PUBLIC_SOURCES_SSL) $(JAVA_PRIVATE_SOURCES_SSL)
JAVA_SOURCES_XML = $(JAVA_PUBLIC_SOURCES_XML) $(JAVA_PUBLIC_SOURCES_XMLPULL) \
  $(JAVA_PRIVATE_SOURCES_XML)
JAVA_SOURCES_ZIP = $(JAVA_PUBLIC_SOURCES_ZIP) $(JAVA_PRIVATE_SOURCES_ZIP)
JAVA_SOURCES_SQL = $(JAVA_PUBLIC_SOURCES_SQL) $(JAVA_PRIVATE_SOURCES_SQL)
JAVA_SOURCES_BEANS = $(JAVA_PUBLIC_SOURCES_BEANS) $(JAVA_PRIVATE_SOURCES_BEANS)
JAVA_SOURCES_TIME = $(JAVA_PUBLIC_SOURCES_TIME) $(JAVA_PRIVATE_SOURCES_TIME)
JAVA_SOURCES_ICU = $(JAVA_PUBLIC_SOURCES_ICU) $(JAVA_PRIVATE_SOURCES_ICU)
JAVA_SOURCES_ANDROID = $(ANDROID_PUBLIC_SOURCES) $(ANDROID_PRIVATE_SOURCES)
JAVA_SOURCES_JSON = $(JSON_PUBLIC_SOURCES) $(JSON_PRIVATE_SOURCES)

# These annotations have a SOURCE retention, and so should not be part of the runtime.
# They need to be included in the jre_emul.jar, however.
SOURCE_RETENTION_ANNOTATIONS = \
  java/lang/Override.java \
  java/lang/SuppressWarnings.java \
  java/lang/annotation/Native.java \
  javax/annotation/processing/Generated.java

JSON_SOURCE_RETENTION_ANNOTATIONS = \
  org/json/NonNull.java \
  org/json/Nullable.java \
  org/json/UnsupportedAppUsage.java

# Java classes with hand written obj-c implementations. Shouldn't be translated,
# but need to include the .java file in jre_emul.jar.
EMULATED_JAVA_SOURCES = \
  com/google/j2objc/NSException.java \
  com/google/j2objc/NSFastEnumeration.java \
  com/google/j2objc/net/ssl/IosSslSocket.java \
  java/lang/AbstractStringBuilder.java \
  java/lang/Class.java \
  java/lang/Cloneable.java \
  java/lang/Number.java \
  java/lang/Object.java \
  java/lang/String.java \
  java/lang/reflect/AccessibleObject.java \
  java/lang/reflect/Constructor.java \
  java/lang/reflect/Executable.java \
  java/lang/reflect/Field.java \
  java/lang/reflect/Method.java

# All non-generated headers that should be made public.
PUBLIC_NATIVE_HEADERS = \
  IOSArray.h \
  IOSClass.h \
  IOSMetadata.h \
  IOSObjectArray.h \
  IOSPrimitiveArray.h \
  J2ObjC_common.h \
  J2ObjC_header.h \
  J2ObjC_source.h \
  J2ObjC_types.h \
  JavaObject.h \
  JreEmulation.h \
  JreRetainedWith.h \
  NSCopying+JavaCloneable.h \
  NSDataInputStream.h \
  NSDataOutputStream.h \
  NSDictionaryMap.h \
  NSNumber+JavaNumber.h \
  NSObject+JavaObject.h \
  NSString+JavaString.h \
  java/lang/AbstractStringBuilder.h \
  java/lang/reflect/AccessibleObject.h \
  java/lang/reflect/Constructor.h \
  java/lang/reflect/Executable.h \
  java/lang/reflect/Field.h \
  java/lang/reflect/Method.h \
  jni.h

JRE_PUBLIC_PACKAGES = \
  java.awt.font \
  java.beans \
  java.io \
  java.lang \
  java.lang.annotation \
  java.lang.ref \
  java.lang.reflect \
  java.math \
  java.net \
  java.nio \
  java.nio.channels \
  java.nio.channels.spi \
  java.nio.charset \
  java.nio.charset.spi \
  java.nio.file \
  java.nio.file.attribute \
  java.nio.file.spi \
  java.security \
  java.security.cert \
  java.security.interfaces \
  java.security.spec \
  java.sql \
  java.text \
  java.time \
  java.time.chrono \
  java.time.format \
  java.time.temporal \
  java.time.zone \
  java.util \
  java.util.concurrent \
  java.util.concurrent.atomic \
  java.util.concurrent.locks \
  java.util.function \
  java.util.jar \
  java.util.logging \
  java.util.regex \
  java.util.zip \
  javax.crypto \
  javax.crypto.interfaces \
  javax.crypto.spec \
  javax.lang.model.element \
  javax.lang.model.type \
  javax.net \
  javax.net.ssl \
  javax.security.auth \
  javax.security.auth.callback \
  javax.security.auth.x500 \
  javax.security.cert \
  javax.sql \
  javax.xml \
  javax.xml.datatype \
  javax.xml.namespace \
  javax.xml.parsers \
  javax.xml.transform \
  javax.xml.transform.dom \
  javax.xml.transform.sax \
  javax.xml.transform.stream \
  javax.xml.validation \
  javax.xml.xpath \
  org.w3c.dom \
  org.w3c.dom.ls \
  org.w3c.dom.traversal \
  org.xml.sax \
  org.xml.sax.ext \
  org.xml.sax.helpers

ANDROID_PUBLIC_PACKAGES = \
  android.os \
  android.text \
  android.text.util \
  android.util \
  org.json \
  org.xmlpull.v1 \
  org.xmlpull.v1.sax2

# They are only needed while translating files in the corresponding packages,
# but they do not need to be translated.
ANNOTATED_PACKAGE_INFO = \
  java/util/concurrent/package-info.java \
  sun/security/x509/package-info.java

NO_TRANSLATE_JAVA_SOURCES = \
  $(SOURCE_RETENTION_ANNOTATIONS) \
  $(EMULATED_JAVA_SOURCES) \
  $(ANNOTATED_PACKAGE_INFO)

JAVA_PUBLIC_SOURCES_JRE = \
  $(JAVA_PUBLIC_SOURCES_CORE) \
  $(JAVA_PUBLIC_SOURCES_IO) \
  $(JAVA_PUBLIC_SOURCES_NET) \
  $(JAVA_PUBLIC_SOURCES_UTIL) \
  $(JAVA_PUBLIC_SOURCES_CONCURRENT) \
  $(JAVA_PUBLIC_SOURCES_CHANNELS) \
  $(JAVA_PUBLIC_SOURCES_FILE) \
  $(JAVA_PUBLIC_SOURCES_SECURITY) \
  $(JAVA_PUBLIC_SOURCES_SSL) \
  $(JAVA_PUBLIC_SOURCES_XML) \
  $(JAVA_PUBLIC_SOURCES_ZIP) \
  $(JAVA_PUBLIC_SOURCES_SQL) \
  $(JAVA_PUBLIC_SOURCES_BEANS) \
  $(JAVA_PUBLIC_SOURCES_TIME) \
  $(JAVA_PUBLIC_SOURCES_ICU) \
  $(JAVA_PUBLIC_SOURCES_OTHER)
JAVA_PRIVATE_SOURCES = \
  $(JAVA_PRIVATE_SOURCES_CORE) \
  $(JAVA_PRIVATE_SOURCES_IO) \
  $(JAVA_PRIVATE_SOURCES_NET) \
  $(JAVA_PRIVATE_SOURCES_UTIL) \
  $(JAVA_PRIVATE_SOURCES_CONCURRENT) \
  $(JAVA_PRIVATE_SOURCES_CHANNELS) \
  $(JAVA_PRIVATE_SOURCES_FILE) \
  $(JAVA_PRIVATE_SOURCES_SECURITY) \
  $(JAVA_PRIVATE_SOURCES_SSL) \
  $(JAVA_PRIVATE_SOURCES_XML) \
  $(JAVA_PRIVATE_SOURCES_ZIP) \
  $(JAVA_PRIVATE_SOURCES_SQL) \
  $(JAVA_PRIVATE_SOURCES_BEANS) \
  $(JAVA_PRIVATE_SOURCES_TIME) \
  $(JAVA_PRIVATE_SOURCES_ICU) \
  $(JAVA_PRIVATE_SOURCES_OTHER) \
  $(ANDROID_PRIVATE_SOURCES)

JAVA_PUBLIC_SOURCES = $(JAVA_PUBLIC_SOURCES_JRE) $(ANDROID_PUBLIC_SOURCES) \
  $(JAVA_PUBLIC_SOURCES_XMLPULL)
JAVA_SOURCES = $(JAVA_PUBLIC_SOURCES) $(JAVA_PRIVATE_SOURCES)

NATIVE_JRE_SOURCES = $(NATIVE_JRE_SOURCES_CORE) $(NATIVE_JRE_SOURCES_ZIP) \
  $(NATIVE_JRE_SOURCES_CHANNELS) $(NATIVE_JRE_SOURCES_FILE) $(NATIVE_JRE_SOURCES_NET) \
  $(NATIVE_JRE_SOURCES_SSL) $(NATIVE_JRE_ICU_EMBEDDED_DATA)
