# Author: Jason Mobarak <jmob@unm.edu>
# $Header: /var/cvsroot/gentoo-src/java-config/python/java_config/jc_iface.py,v 1.6 2004/07/03 06:33:44 aether Exp $

__version__ = "$Revision: 1.6 $"[11:-2]


class OptInterface:
	'''
	Base Interface for java-config functionality, all classes that 
	implement new options must subclass this.

	Class fields that must be defined:

	usage - A tuple containing a two strings with (short, long) help.  Long
	help will be printed when the user requets the --help option followed 
	by the name of an option. Short help will be printed when the user 
	requests help with no options or calls the java-config program with 
	no arguments. 

	names -	The (short, long) names for the option. (i.e. what the user can 
	specify on the command line to access a specific option.
	'''

	usage = (None, None)
	names = (None, None)

	# -Begin- These are not required to be defined in subclasses class
	# whether the option requires root access
	require_root = False 
	# whether the option only requires one arg (thus arg1,arg2 will fail)
	single_arg = False 
	# -End-

	def __call__(self, args): 

		''' 
		The main java-config program calls this method in order to
		run the option, all option classes must define this method with 
		the specific signature.  
		'''

		raise NotImplementedError

# vim: noet:ts=4:
