# $Header: /var/cvsroot/gentoo-src/java-config/python/java_config/jc_util.py,v 1.14 2004/07/04 23:31:43 aether Exp $

__version__ = "$Revision: 1.14 $"

import os
import re
import glob
import sys

sys.path.insert(0, '/usr/lib/portage/pym')
from jc_output import *

from jc_exceptions import OptionRuntimeError

env = os.environ
ENV_DIR = '/etc/env.d'
USER_ENV_DIR = os.path.join(env['HOME'], '.gentoo')
VM_DIR = os.path.join(ENV_DIR, 'java')


def warn (msg):

	sys.stderr.write(red(msg) + '\n')	


def get_line_from_env_file (query, fn):

	fp = open(fn)
	rStr = _get_line_from_env_file(query, fp)
	fp.close()

	return rStr


def _get_line_from_env_file (query, fp):

	while True:

		try: line = fp.readline()
		except (OSError, IOError,), e:
			raise OptionRuntimeError('Error reading file ' + str(e))

		if line == '': # EOF reached query not found
			return None

		if line.strip().startswith(query):
			S = line.split('=', 1)
			return S[-1].strip()


def get_jvm_env_var (name):

	jh = None

	if env.has_key(name): 
		jh = env[name]
	else:
		try:
			jh = get_line_from_env_file(name, os.path.join(USER_ENV_DIR, 'java'))
		except (IOError, OSError):
			try:
				jh = get_line_from_env_file(name, os.path.join(ENV_DIR, '20java'))
			except (IOError, OSError):
				pass

	return jh


def get_java_home():

	return get_jvm_env_var ('JAVA_HOME')


JAVA_HOME = get_java_home()


def die_no_jh (): 
	"""
	Send an error up to java-config if there is no JAVA_HOME set 
	in the enviroment
	"""

	if JAVA_HOME is None: 
		raise OptionRuntimeError, \
			'No JAVA_HOME available! Please set your Java '\
			'Virtual Machine'


def find_exec(exe, java_home=None):
	"""
	Find executable 'exe' and return it, search the /bin and /jre/bin dirs 
	of current JVM. Raises an error if the command isn't executable or if it
	can't be found
	"""

	JAVA_HOME = get_java_home()

	if java_home is not None:
		JAVA_HOME = java_home

	exec_0 = JAVA_HOME+'/bin/'+exe
	exec_1 = JAVA_HOME+'/jre/bin/'+exe
	die_no_jh()
	if os.path.isfile(exec_0):
		if not os.access(exec_0, os.X_OK):
			raise OptionRuntimeError, \
				'%s command is not executable' % exec_0
		return exec_0 
	elif os.path.isfile(exec_1):
		if not os.access(exec_1, os.X_OK): 
			raise OptionRuntimeError, \
				'%s command is not executable' % exec_1
		return exec_1
	else:
		raise OptionRuntimeError, '%s not found' % exe


may_want_to_source_txt = \
'''You may want to update your enviroment by running:
\t"/usr/sbin/env-update && source /etc/profile"'''


def may_want_to_source():
	print may_want_to_source_txt


def norm_cp (classpath):
	"""
	Normalize a classpath string

	@type classpath: C{str}
	"""

	new_cp = re.sub(':+', ':', classpath.strip(':'))
	
	return new_cp


def collect_packages (args):

	args = args.strip().split(',')
	classpath_list = []

	for pkg in args:

		cp_env = collect_packages.cp_env(pkg)
		pkg_env = collect_packages.pkg_env(pkg) 
		classpath = None

		if os.path.isfile(pkg_env):
			classpath = get_line_from_env_file('CLASSPATH', pkg_env) + ':'

		elif os.path.isfile(cp_env):
			classpath = open(cp_env).read().strip()

		if classpath is None:
			raise OptionRuntimeError, 'Could not find package %s' % pkg

		else:
			classpath_list.append(classpath)

		adl_pkgs = collect_packages.adl_pkgs(pkg)

		for pkg in adl_pkgs:
			classpath_list.append(get_line_from_env_file('CLASSPATH', pkg))

	ret_classpath_list = []
	for I in classpath_list:
		if I not in ret_classpath_list:
			ret_classpath_list.append(I)

	# return CLASSPATH string without ending :
	return norm_cp(':'.join(ret_classpath_list))

collect_packages.cp_env = lambda pkg: os.path.join(
  '/', 'usr', 'share', pkg, 'classpath.env'
)

collect_packages.pkg_env = lambda pkg: os.path.join(
  '/', 'usr', 'share', pkg, 'package.env'
)

collect_packages.adl_pkgs = lambda pkg: glob.glob(
  os.path.join(
    '/', 'usr', 'share', pkg, 'packages', '*'
  )
)


def collect_vms():

	from cfg_parse import getconfig

	vm_list = {}

	if os.path.isdir(VM_DIR):
		for fn in os.listdir(VM_DIR):
			cfg = getconfig(os.path.join(VM_DIR, fn), env)
			# Try block should fix bug #32347
			try:
				if os.path.isdir(cfg['JAVA_HOME']):
					vm_list[fn] = cfg
			except KeyError:
				warn(
					'Cannot find JAVA_HOME in config file ' +
					os.path.join(VM_DIR, fn)
				)
	return vm_list

# vim: noet:ts=4:
