# $Header: /var/cvsroot/gentoo-src/java-config/python/java_config/cfg_parse.py,v 1.3 2004/07/03 06:33:44 aether Exp $

__version__ = '$Revision: 1.3 $' [11:-2]

class NotTolerantException (Exception):
	"Raise me when someone screws up a config file."

def cfgverify (cfg_dict):
	""" XXX - verify a config dict has everything we're looking for! """
	# Currently the only key java-config expects to be there is JAVA_HOME...

def getconfig (cfg_file, env):

	var_dict = {}
	bracketed = False
	l_count = 0

	cfg = filter(
		lambda S: \
			not S.isspace() and S != '', open(cfg_file, 'r').read().split('\n')
	)

	for line in cfg:

		line.replace
		twice = line.split('=')
		#print twice

		if not line.startswith('#') and len(twice) == 2:

			var_name, var_value = twice 

			if var_value == '': 
				raise NotTolerantException, 'Error at line ' + str(l_count)

			vars = line.split('$')

			if len(vars) == 1: 
				vars = []
			else: 
				vars = vars[1:]

			#print twice

			for item in iter(vars):
				item = item.strip("\'\"").strip('\\')
				item = item.split('}')[0]
				#print item
				if item.startswith('{'):
					bracketed = True
					item = item[1:]

				# This should fix bug #31924
				# expand stuff
				if var_dict.has_key(item):
					value = var_dict[item]
				elif env.has_key(item):
					value = env[item]
				else:
					value = ''

				if bracketed:
					rep = '${%s}' % var_name
					var_value = var_value.replace('${%s}' % item, value)	
					bracketed = False

				else:
					var_value = var_value.replace('$%s' % item, value)

			var_dict[var_name] = var_value
			# tweedle dee...
			env[var_name] = var_value

		l_count += 1

	return var_dict


#if err_msg != '':
#	raise SystemExit, 'Config file produced errors!\n\n' + err_msg

#print bash_out.read()
if __name__ == '__main__':

	import sys

	if len(sys.argv) != 2:
		raise SystemExit, 'Usage: %s <config-file>' % __file__

	try:
		var_dict = varexpand(sys.argv[1])
		var_dict2 = get_cfg(sys.argv[1])
	except NotTolerantException, reason:
		raise SystemExit, 'Not tolerant! ' + str(reason)

	#cfg = cfg.split('\n')
				
	print 'varexpand :::'
	for var, value in var_dict.iteritems():
		print '%s --> %s' % (var, value)

	print 'get_cfg :::'
	for var, value in var_dict2.iteritems():
		print '%s --> %s' % (var, value)

# vim: noet:ts=4:
