# $Header: /var/cvsroot/gentoo-src/java-config/python/java_config/jc_util.py,v 1.32 2006/09/06 23:35:52 nichoj Exp $

__version__ = "$Revision: 1.32 $"

import os
import re
import glob
import sys

sys.path.insert(0, '/usr/lib/portage/pym')
from jc_output import *
from jc_exceptions import OptionRuntimeError

env = os.environ
ENV_DIR = '/etc/env.d'

def warn (msg):

	sys.stderr.write(red(msg) + '\n')	


def get_line_from_env_file (query, fn):

	fp = open(fn)
	rStr = _get_line_from_env_file(query, fp)
	fp.close()
	if rStr != None:
		rStr = re.sub("\"", "", rStr)

	return rStr


def _get_line_from_env_file (query, fp):

	while True:

		try: line = fp.readline()
		except (OSError, IOError,), e:
			raise OptionRuntimeError('Error reading file ' + str(e))

		if line == '': # EOF reached query not found
			return None

		if line.strip().startswith(query):
			S = line.split('=', 1)
			return S[-1].strip()


def get_jvm_env_var (name):

	value = ''
	user_env_dir = get_jvm_env_var.user_env_dir
	# Read VMHANDLE from /etc/env.d/20java
	p = re.compile('^' + name + '=\"?(.*?)\"?$')
	try:
		fh = open('/etc/env.d/20java')
		for line in fh.readlines():
			line = line.strip()
			m = p.match(line)
			if m:
				value = m.group(1)
				break
		fh.close()
	# we don't need no stinking exceptions
	except IOError:
		pass

	return value

def get_vmhandle(filename):
	vmhandle = ''
	fh = open(filename, 'r')
	for line in fh.readlines():
		line = line.strip()
		if line[0:8] == 'VMHANDLE':
			vmhandle = line[10:-1]
			break
	fh.close()
	return vmhandle


get_jvm_env_var.user_env_dir = os.path.join(env.get('HOME', 'THERE_IS_NO_HOME'), '.gentoo')

def get_java_home():
	jh = get_jvm_env_var('JAVA_HOME')
	return jh

def die_no_jh (): 
	"""
	Send an error up to java-config if there is no JAVA_HOME set 
	in the enviroment
	"""

	if JAVA_HOME is None: 
		raise OptionRuntimeError, \
			'No JAVA_HOME available! Please set your Java '\
			'Virtual Machine'


def find_exec(exe, java_home):
	"""
	Find executable 'exe' and return it, search the /bin and /jre/bin dirs 
	of current JVM. Raises an error if the command isn't executable or if it
	can't be found
	"""

	exec_0 = jh+'/bin/'+exe
	exec_1 = jh+'/jre/bin/'+exe
	if os.path.isfile(exec_0):
		if not os.access(exec_0, os.X_OK):
			raise OptionRuntimeError, \
				'%s command is not executable' % exec_0
		return exec_0 
	elif os.path.isfile(exec_1):
		if not os.access(exec_1, os.X_OK): 
			raise OptionRuntimeError, \
				'%s command is not executable' % exec_1
		return exec_1
	else:
		raise OptionRuntimeError, '%s not found at %s or %s' % (exe, exec_0, exec_1,)


may_want_to_source_txt = \
'''You may want to update your enviroment by running:
\t"/usr/sbin/env-update && source /etc/profile"'''


def may_want_to_source():
	print may_want_to_source_txt


def norm_cp (classpath):
	"""
	Normalize a classpath string

	@type classpath: C{str}
	"""

	stripped_classpath = re.sub(':+', ':', classpath.strip(':'))
	pkgs = stripped_classpath.split(":")
	
	classpath_dict = {}
	for x in pkgs:
		classpath_dict[x] = True
		
	return ':'.join(classpath_dict.keys())

def collect_library(args):

	args = args.strip().split(',')
	library_list= []

	for pkg in args:

		pkg_env = collect_packages.pkg_env(pkg) 
		library = None

		if os.path.isfile(pkg_env):
			library = get_line_from_env_file('LIBRARY_PATH', pkg_env)
		else:
			raise OptionRuntimeError, 'Could not find package %s' % pkg

		if library is None:
			raise OptionRuntimeError, 'Could not find library path for %s' % pkg

		else:
			library_list.append(library)

	return norm_cp(':'.join(library_list))


def collect_packages (args):

	args = args.strip().split(',')
	classpath_list = []

	for pkg in args:

		cp_env = collect_packages.cp_env(pkg)
		pkg_env = collect_packages.pkg_env(pkg) 
		classpath = None

		if os.path.isfile(pkg_env):
			classpath = get_line_from_env_file('CLASSPATH', pkg_env) + ':'

		elif os.path.isfile(cp_env):
			classpath = open(cp_env).read().strip()

		if classpath is None:
			raise OptionRuntimeError, 'Could not find package %s' % pkg

		else:
			classpath_list.append(classpath)

		adl_pkgs = collect_packages.adl_pkgs(pkg)

		for pkg in adl_pkgs:
			classpath_list.append(get_line_from_env_file('CLASSPATH', pkg))

	return norm_cp(':'.join(classpath_list))

collect_packages.cp_env = lambda pkg: os.path.join(
  '/', 'usr', 'share', pkg, 'classpath.env'
)

collect_packages.pkg_env = lambda pkg: os.path.join(
  '/', 'usr', 'share', pkg, 'package.env'
)

collect_packages.adl_pkgs = lambda pkg: glob.glob(
  os.path.join(
    '/', 'usr', 'share', pkg, 'packages', '*'
  )
)


def collect_vms():

	from cfg_parse import getconfig

	vm_list = {}
	vm_dir = collect_vms.vm_dir

	if os.path.isdir(vm_dir):
		for fn in os.listdir(vm_dir):
			conf_file = os.path.join(vm_dir, fn)
			if not (os.path.isfile(conf_file) and 
					os.access(conf_file, os.R_OK)):
				continue
			p = re.compile('^20')
			if not p.match(fn):
				continue
			cfg = getconfig(conf_file, env)


			generation = cfg.get('GENERATION')
			# FIXME the config parser should probably pull the surrounding "s
			if generation != '"2"':
				warn( conf_file + ' has not been updated to generation-2. You need to run \'java-check-environment\' to verify your Java environment is valid.')
				continue

			jh = cfg.get('JAVA_HOME')
			if jh != None:
				if os.path.isdir(jh):
					vm_list[fn] = cfg
				else:
					warn( 'Invalid JAVA_HOME, ' + jh + ', does not exist' )
			else:
				warn(
					'Config file does not define JAVA_HOME:' + 
					conf_file
				)
	return vm_list

collect_vms.vm_dir = os.path.join(ENV_DIR, 'java')

# vim: noet:ts=4:
