/*
 * Decompiled with CFR 0.152.
 */
package COM.sun.labs.javaccgui;

import COM.sun.labs.javaccgui.GlobalGlobals;
import COM.sun.labs.javaccgui.Globals;
import java.awt.AWTEvent;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.FileOutputStream;
import java.io.IOException;

class DialogBox
extends Dialog {
    String message;
    String button;
    boolean okdialog;
    int width;
    int locx;
    int locy;
    DialogButton one;
    DialogButton two;

    DialogBox(String string, boolean bl) {
        super(Globals.mainframe, " ", true);
        this.message = string;
        this.okdialog = bl;
        this.setResizable(false);
        ((Component)this).setBackground(Globals.DIALOGBACKGROUNDCOLOR);
        this.setForeground(Globals.DIALOGFOREGROUNDCOLOR);
        this.setFont(Globals.TEXTFONT);
        FontMetrics fontMetrics = Globals.toolkit.getFontMetrics(Globals.TEXTFONT);
        this.width = Math.max(fontMetrics.stringWidth(this.message), 150) + 60;
        ((Component)this).setSize(this.width, 130);
        if (this.okdialog) {
            this.one = new DialogButton("OK");
        } else {
            this.one = new DialogButton("No");
            this.two = new DialogButton("Yes");
            this.add(this.two);
        }
        this.add(this.one);
        this.locx = (Globals.screenx - this.width) / 2;
        this.locy = (Globals.screeny - 130) / 2;
        ((Component)this).setLocation(this.locx, this.locy);
    }

    static boolean booleanDialog(String string) {
        DialogBox dialogBox = new DialogBox(string, false);
        dialogBox.show();
        ((Component)dialogBox).setLocation(dialogBox.locx, dialogBox.locy);
        return dialogBox.getButton().equals("Yes");
    }

    public void doLayout() {
        this.setFont(Globals.TEXTFONT);
        Dimension dimension = this.one.getPreferredSize();
        if (this.okdialog) {
            int n = dimension.width;
            int n2 = dimension.height;
            this.one.setBounds(this.width / 2 - n / 2, 80, n, n2);
        } else {
            Dimension dimension2 = this.two.getPreferredSize();
            int n = Math.max(dimension.width, dimension2.width);
            int n3 = Math.max(dimension.height, dimension2.height);
            this.one.setBounds(this.width / 4 - n / 2 + 20, 80, n, n3);
            this.two.setBounds(3 * this.width / 4 - n / 2 - 20, 80, n, n3);
        }
    }

    synchronized String getButton() {
        return this.button;
    }

    static void okDialog(String string) {
        DialogBox dialogBox = new DialogBox(string, true);
        ((Component)dialogBox).setVisible(true);
        ((Component)dialogBox).setLocation(dialogBox.locx, dialogBox.locy);
    }

    public void paint(Graphics graphics) {
        ((Component)this).setLocation(this.locx, this.locy);
        Insets insets = this.getInsets();
        graphics.setColor(Globals.DIALOGOUTLINECOLOR);
        graphics.drawRoundRect(insets.left + 5, insets.top + 5, this.width - insets.left - insets.right - 11, 130 - insets.top - insets.bottom - 11, 15, 15);
        graphics.setFont(Globals.TEXTFONT);
        graphics.setColor(Globals.DIALOGFOREGROUNDCOLOR);
        graphics.drawString(this.message, 30, 60);
    }

    static void quit() {
        if (DialogBox.booleanDialog("Really quit?")) {
            DialogBox.reallyquit();
        }
    }

    static void reallyquit() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(Globals.optfile);
            GlobalGlobals.options.save(fileOutputStream, null);
            fileOutputStream.close();
        }
        catch (IOException iOException) {}
        System.exit(0);
    }

    synchronized void setButton(String string) {
        this.button = string;
    }

    class DialogButton
    extends Button {
        String label;

        DialogButton(String string) {
            super(string);
            this.label = string;
            this.setBackground(Globals.BUTTONBACKGROUNDCOLOR);
            this.setForeground(Globals.BUTTONFOREGROUNDCOLOR);
            this.enableEvents(128L);
        }

        public void processEvent(AWTEvent aWTEvent) {
            DialogBox.this.setButton(this.label);
            DialogBox.this.dispose();
        }
    }
}

