/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.java.CleanCompilerGroup;
import org.netbeans.modules.java.JavaCompilerType;
import org.netbeans.modules.java.JavaDataObject;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerGroup;
import org.openide.compiler.CompilerJob;
import org.openide.compiler.ErrorEvent;
import org.openide.compiler.ProgressEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.MultiDataObject;

final class CleanCompiler
extends Compiler {
    JavaDataObject jdo;
    CleanCompilerGroup group;
    FileSystem target;
    static /* synthetic */ Class class$org$netbeans$modules$java$CleanCompilerGroup;

    public CleanCompiler(CompilerJob job, JavaDataObject jdo, FileSystem target) {
        super(job);
        this.jdo = jdo;
        this.target = target;
    }

    private boolean isCrossCompiling() {
        return this.target != null;
    }

    public boolean isUpToDate() {
        return this.jdo.files().size() == 1;
    }

    public FileSystem getFileSystem() {
        if (this.target != null) {
            return this.target;
        }
        try {
            return this.jdo.getPrimaryFile().getFileSystem();
        }
        catch (FileStateInvalidException ex) {
            return null;
        }
    }

    protected Collection getCleanables() {
        ArrayList<FileObject> c = null;
        if (!this.isCrossCompiling() || this.target.isValid()) {
            Set files = this.jdo.secondaryEntries();
            Iterator it = files.iterator();
            c = new ArrayList<FileObject>(files.size());
            while (it.hasNext()) {
                MultiDataObject.Entry entry = (MultiDataObject.Entry)it.next();
                FileObject fo = entry.getFile();
                if (!fo.getExt().equals("class")) continue;
                c.add(fo);
            }
        }
        return c == null || c.size() == 0 ? Collections.EMPTY_LIST : c;
    }

    private void reportError(FileObject fo, IOException ex) {
        String message = MessageFormat.format(JavaCompilerType.getString("MSG_CannotClean"), fo, ex.getLocalizedMessage());
        ErrorEvent evt = new ErrorEvent((CompilerGroup)this.group, this.jdo.getPrimaryFile(), 0, 0, message, "");
        this.group.ireErrorEvent(evt);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean deleteClasses(JavaDataObject dobj) throws IOException {
        Collection c = this.getCleanables();
        Iterator it = c.iterator();
        FileSystem myFS = this.jdo.getPrimaryFile().getFileSystem();
        boolean ok = true;
        block8: while (it.hasNext()) {
            Object var10_11;
            FileLock lock;
            FileObject fo = (FileObject)it.next();
            try {
                lock = fo.lock();
            }
            catch (IOException e) {
                ok = false;
                this.reportError(fo, e);
                continue;
            }
            this.group.ireProgressEvent(new ProgressEvent((CompilerGroup)this.group, fo, 4));
            try {
                fo.delete(lock);
                var10_11 = null;
            }
            catch (Throwable throwable) {
                var10_11 = null;
                lock.releaseLock();
                throw throwable;
            }
            lock.releaseLock();
            FileObject dir = fo.getParent();
            if (this.target == myFS || dir.getFileSystem() != this.target) continue;
            while (true) {
                block12: {
                    Object var12_13;
                    if (dir.isRoot() || dir.getChildren().length != 0) continue block8;
                    lock = null;
                    try {
                        try {
                            lock = dir.lock();
                            dir.delete(lock);
                        }
                        catch (IOException ex) {
                            var12_13 = null;
                            if (lock == null) continue block8;
                            lock.releaseLock();
                            continue block8;
                        }
                        var12_13 = null;
                        if (lock == null) break block12;
                    }
                    catch (Throwable throwable) {
                        var12_13 = null;
                        if (lock != null) {
                            lock.releaseLock();
                        }
                        throw throwable;
                    }
                    lock.releaseLock();
                }
                dir = dir.getParent();
            }
            break;
        }
        return ok;
    }

    public boolean equals(Object other) {
        if (!(other instanceof CleanCompiler)) {
            return false;
        }
        return this.jdo == ((CleanCompiler)((Object)other)).jdo;
    }

    public int hashCode() {
        return this.jdo == null ? 0 : ((Object)((Object)this.jdo)).hashCode();
    }

    boolean compile() {
        try {
            return this.deleteClasses(this.jdo);
        }
        catch (IOException ioe) {
            this.group.printThrowable(ioe);
            return false;
        }
    }

    public final boolean getClearEnv() {
        return false;
    }

    public Class compilerGroupClass() {
        return class$org$netbeans$modules$java$CleanCompilerGroup == null ? (class$org$netbeans$modules$java$CleanCompilerGroup = CleanCompiler.class$("org.netbeans.modules.java.CleanCompilerGroup")) : class$org$netbeans$modules$java$CleanCompilerGroup;
    }

    public Object compilerGroupKey() {
        ArrayList<Object> l;
        block2: {
            l = new ArrayList<Object>(2);
            try {
                l.add(super.compilerGroupKey());
                l.add(this.jdo.getPrimaryFile().getFileSystem());
            }
            catch (FileStateInvalidException e) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block2;
                e.printStackTrace();
            }
        }
        return l;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

