/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.io.File;
import java.io.IOException;
import org.netbeans.modules.java.JavaCompilerType;
import org.netbeans.modules.java.JavaExternalCompilerType;
import org.netbeans.modules.java.Util;
import org.openide.execution.NbProcessDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;

public class FastJavacCompilerType
extends JavaExternalCompilerType {
    private static final long serialVersionUID = -3875747959787225041L;
    private static String wiredFullName;
    private static String wiredName;
    private transient int version = 0;
    private static final String NEW_PROCESS_NAME = "{fastjavacBinary}";
    private static final String REPLACE_PROCESS_NAME = "{ide.home}{/}bin{/}fastjavac{/}{fastjavac.wired}";
    static /* synthetic */ Class class$org$netbeans$modules$java$FastJavacCompilerType;

    NbProcessDescriptor createDescriptor() {
        return new NbProcessDescriptor(NEW_PROCESS_NAME, "{debuginfo} {deprecation} {optimize} {outputdir} {encoding} {source.opt} {bootclasspath.opt}{bootclasspath} -jdk {q}{jdk.home}{q} -classpath {filesystems}{:}{classpath} {files}", JavaExternalCompilerType.getAdditionalHint() + Util.getString("MSG_FastCompilerHint"));
    }

    public NbProcessDescriptor getExternalCompiler() {
        this.updateConfig();
        return super.getExternalCompiler();
    }

    private void updateConfig() {
        if (this.externalCompiler == null || this.version > 0) {
            return;
        }
        String procName = this.externalCompiler.getProcessName();
        if (REPLACE_PROCESS_NAME.equals(procName)) {
            this.externalCompiler = new NbProcessDescriptor(NEW_PROCESS_NAME, this.externalCompiler.getArguments());
        }
        this.version = 1;
    }

    public String displayName() {
        return JavaCompilerType.getString("CTL_FastCompilerType");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$java$FastJavacCompilerType == null ? (class$org$netbeans$modules$java$FastJavacCompilerType = FastJavacCompilerType.class$("org.netbeans.modules.java.FastJavacCompilerType")) : class$org$netbeans$modules$java$FastJavacCompilerType);
    }

    private static boolean isX86() {
        String arch = System.getProperty("os.arch");
        return arch.indexOf("i386") >= 0 || arch.indexOf("x86") >= 0;
    }

    private static boolean isX86Linux() {
        return FastJavacCompilerType.isX86() && (Utilities.getOperatingSystem() & 0x10) != 0;
    }

    public static boolean isFastJavacPlatform() {
        return FastJavacCompilerType.getWiredFullName() != null;
    }

    private static boolean isWin() {
        return (Utilities.getOperatingSystem() & 0x5007) != 0;
    }

    private static String findFastJavac(String rootName) {
        String name = FastJavacCompilerType.getWiredName();
        if (name == null) {
            return null;
        }
        File root = new File(rootName);
        File dir = new File(new File(root, "bin"), "fastjavac");
        File f1 = new File(dir, FastJavacCompilerType.getWiredName());
        if (f1.exists()) {
            try {
                return f1.getCanonicalPath();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if ((f1 = new File(dir, "fastjavac")).exists()) {
            try {
                return f1.getCanonicalPath();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return null;
    }

    static String getWiredFullName() {
        if (wiredFullName != null) {
            if (wiredFullName.length() == 0) {
                return null;
            }
            return wiredFullName;
        }
        String user = System.getProperty("netbeans.user");
        String nb = System.getProperty("netbeans.home");
        String fjpath = null;
        if (!user.equals(nb)) {
            fjpath = FastJavacCompilerType.findFastJavac(user);
        }
        if (fjpath == null) {
            fjpath = FastJavacCompilerType.findFastJavac(nb);
        }
        if (fjpath != null) {
            wiredFullName = fjpath;
            return fjpath;
        }
        wiredFullName = "";
        return null;
    }

    static String getWiredName() {
        if (wiredName != null) {
            return wiredName;
        }
        int OS = Utilities.getOperatingSystem();
        if ((OS & 8) != 0) {
            wiredName = System.getProperty("os.arch").indexOf("sparc") >= 0 ? "fastjavac.sun" : "fastjavac.sun.intel";
        } else if ((OS & 0x5007) != 0) {
            wiredName = "fastjavac.exe";
        } else if (FastJavacCompilerType.isX86Linux()) {
            wiredName = "fastjavac.linux";
        }
        return wiredName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

