/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.io.File;
import java.io.IOException;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import org.netbeans.modules.java.FastJavacCompilerType;
import org.netbeans.modules.java.JExternalCompiler;
import org.netbeans.modules.java.JavaCompilerType;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.JavaExternalCompilerType;
import org.netbeans.modules.java.Util;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerGroup;
import org.openide.compiler.ErrorEvent;
import org.openide.compiler.ExternalCompiler;
import org.openide.compiler.ExternalCompilerGroup;
import org.openide.execution.NbClassPath;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;

public class JExternalCompilerGroup
extends ExternalCompilerGroup {
    private final HashSet indirectCompilers = new HashSet(7);
    private final HashSet directCompilers = new HashSet(7);
    private JavaExternalCompilerType jext;
    private FileSystem targetFS;
    private String encoding;
    private static int DEFAULT_FILENAME_THRESHOLD = 256;
    private ExternalCompiler overflow;
    private Iterator compilerIterator;
    private int filenameThreshold;
    private boolean splitJob = false;
    static /* synthetic */ Class class$org$netbeans$modules$java$JavaDataObject;

    static boolean isSplitEnabled() {
        return Boolean.getBoolean("org.netbeans.modules.java.extCompileMultistep");
    }

    public void add(Compiler c) {
        if (c instanceof JavaCompilerType.IndirectCompiler) {
            this.indirectCompilers.add(c);
        } else {
            this.checkAndAdd((JExternalCompiler)c);
        }
    }

    private void checkAndAdd(JExternalCompiler c) {
        if (c.isUpToDate()) {
            return;
        }
        if (this.directCompilers.add(c)) {
            if (this.jext == null) {
                this.initializeOptions((Compiler)c);
            }
            super.add((Compiler)c);
        }
    }

    protected Collection filterCompilers(Collection in) {
        if (!this.splitJob) {
            return super.filterCompilers(in);
        }
        if (this.compilerIterator == null) {
            this.compilerIterator = super.filterCompilers(in).iterator();
        }
        LinkedList<ExternalCompiler> cs = new LinkedList<ExternalCompiler>();
        int namesLen = 0;
        if (this.overflow != null) {
            cs.add(this.overflow);
            namesLen += this.overflow.getFileName().length();
            this.overflow = null;
        }
        while (this.compilerIterator.hasNext() && cs.size() <= 10) {
            ExternalCompiler c = (ExternalCompiler)this.compilerIterator.next();
            String name = c.getFileName();
            if (!cs.isEmpty() && name.length() + namesLen > this.filenameThreshold) {
                this.overflow = c;
                break;
            }
            namesLen += name.length();
            cs.add(c);
        }
        return cs;
    }

    boolean needsMoreProcessing() {
        return this.compilerIterator != null && (this.compilerIterator.hasNext() || this.overflow != null);
    }

    public boolean start() {
        boolean success;
        int i;
        if (this.indirectCompilers.size() > 0) {
            JavaCompilerType.IndirectCompiler[] cs = new JavaCompilerType.IndirectCompiler[this.indirectCompilers.size()];
            cs = ((AbstractCollection)this.indirectCompilers).toArray(cs);
            i = 0;
            while (i < cs.length) {
                Compiler compiler = cs[i].getCompiler();
                if (compiler != null) {
                    this.checkAndAdd((JExternalCompiler)compiler);
                }
                ++i;
            }
        }
        try {
            if (this.jext == null) {
                return true;
            }
            this.jext.assureValidTargetFS();
        }
        catch (IOException ex) {
            String msg = MessageFormat.format(JavaCompilerType.getString("MSG_CompilerFatal"), ex.getLocalizedMessage());
            this.fireErrorEvent(new ErrorEvent((CompilerGroup)this, null, 0, 0, msg, ""));
            return false;
        }
        ExternalCompiler[] compilers = this.getAllCompilers();
        i = 0;
        while (i < compilers.length) {
            JExternalCompiler exC = (JExternalCompiler)compilers[i];
            try {
                DataObject dobj = DataObject.find((FileObject)exC.getFileObject0());
                JavaDataObject d = (JavaDataObject)dobj.getCookie(class$org$netbeans$modules$java$JavaDataObject == null ? JExternalCompilerGroup.class$("org.netbeans.modules.java.JavaDataObject") : class$org$netbeans$modules$java$JavaDataObject);
                if (d != null) {
                    d.clearProducts(this.targetFS);
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            ++i;
        }
        this.splitJob = JExternalCompilerGroup.isSplitEnabled();
        if (!this.splitJob) {
            success = super.start();
        } else {
            this.filenameThreshold = Integer.getInteger("org.openide.compilers.filelistThreshold", DEFAULT_FILENAME_THRESHOLD);
            success = true;
            while ((success &= super.start()) && this.needsMoreProcessing()) {
            }
        }
        if (this.targetFS != null) {
            this.jext.incrementGenCount();
        }
        return success;
    }

    void initializeOptions(Compiler c) {
        this.jext = ((JExternalCompiler)c).getMyType();
        this.encoding = ((JExternalCompiler)c).myEncoding;
        if (this.jext.isCrossCompile()) {
            this.targetFS = this.jext.getTargetFileSystem();
        }
    }

    protected Process createProcess(NbProcessDescriptor desc, String[] files) throws IOException {
        return desc.exec((Format)((Object)new JFormat(files, this.jext, desc, this.encoding)), this.jext.getEnvironmentVariables(), this.jext.getWorkingDirectory());
    }

    static String getMsgFile(String nbhome) {
        StringBuffer sb = new StringBuffer(nbhome);
        sb.append(File.separatorChar);
        sb.append("lib");
        sb.append(File.separatorChar);
        sb.append("fastjavac.messages");
        String ret = sb.toString();
        if (ret.indexOf(32) >= 0) {
            sb.insert(0, '\"');
            sb.append('\"');
            ret = sb.toString();
        }
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class JFormat
    extends ExternalCompilerGroup.Format {
        public static final String TAG_OPTIMIZE = "optimize";
        public static final String TAG_DEBUGINFO = "debuginfo";
        public static final String TAG_DEPRECATION = "deprecation";
        public static final String TAG_ENCODING = "encoding";
        public static final String TAG_OUTDIR = "outputdir";
        public static final String TAG_IDEHOME = "ide.home";
        public static final String TAG_NBHOME = "netbeans.home";
        public static final String TAG_FORTEHOME = "forte.home";
        public static final String TAG_MSGFILE = Util.getString("TAG_Msgfile");
        public static final String TAG_FASTJAVAC_BINARY_FULL = "fastjavacBinary";
        public static final String TAG_FASTJAVAC_BINARY = "fastjavac.wired";
        public static final String TAG_OPTION_BOOTCLASSPATH = "bootclasspath.opt";
        public static final String TAG_QUOTE = "q";
        public static final String TAG_SYSTEMBOOTCLASSPATH = "sun.boot.class.path";
        public static final String TAG_SOURCE = "source.opt";
        static final long serialVersionUID = -8630048324703405233L;
        private NbProcessDescriptor descriptor;

        public JFormat(String[] files, JavaExternalCompilerType jext, NbProcessDescriptor descriptor, String encoding) throws IOException {
            super(JExternalCompilerGroup.isSplitEnabled() ? new String[]{} : files, jext.getClassPath(), jext.getBootClassPath(), jext.getRepositoryPath(), jext.getLibraryPath());
            this.descriptor = descriptor;
            Map map = this.getMap();
            map.put(TAG_OPTIMIZE, jext.getOptimize() ? jext.getOptimizeReplace() : "");
            map.put(TAG_DEBUGINFO, jext.getDebug() ? jext.getDebuginfoReplace() : "");
            map.put(TAG_DEPRECATION, jext.getDeprecation() ? jext.getDeprecationReplace() : "");
            map.put(TAG_OUTDIR, JFormat.createOutputReplace(jext));
            map.put(TAG_ENCODING, this.createEncodingReplace(jext, encoding));
            map.put(TAG_QUOTE, "\"");
            String nb = System.getProperty(TAG_NBHOME);
            String wiredName = FastJavacCompilerType.getWiredName();
            String wiredFullName = FastJavacCompilerType.getWiredFullName();
            nb = new File(nb).getCanonicalPath();
            map.put(TAG_FORTEHOME, nb);
            map.put(TAG_NBHOME, nb);
            map.put(TAG_IDEHOME, nb);
            map.put(TAG_MSGFILE, JExternalCompilerGroup.getMsgFile(nb));
            map.put(TAG_FASTJAVAC_BINARY_FULL, wiredFullName);
            map.put(TAG_FASTJAVAC_BINARY, wiredName);
            map.put(TAG_OPTION_BOOTCLASSPATH, this.createBootClassPathReplace(jext));
            map.put(TAG_SYSTEMBOOTCLASSPATH, JFormat.createSystemBootClassPath());
            map.put(TAG_SOURCE, this.createSourceReplace(jext));
            if (JExternalCompilerGroup.isSplitEnabled()) {
                StringBuffer sb = new StringBuffer();
                String add = "";
                int i = 0;
                while (i < files.length) {
                    sb.append(add);
                    if (files[i].indexOf(32) >= 0) {
                        sb.append("\"");
                        sb.append(files[i]);
                        sb.append("\"");
                    } else {
                        sb.append(files[i]);
                    }
                    add = " ";
                    ++i;
                }
                map.put("files", sb.toString());
            }
        }

        public JFormat(String[] files, JavaExternalCompilerType jext, NbProcessDescriptor descriptor) throws IOException {
            this(files, jext, descriptor, jext.getCharEncoding());
        }

        public StringBuffer format(Object obj, StringBuffer toAppend, FieldPosition pos) {
            StringBuffer ret = super.format(obj, toAppend, pos);
            String arg = ret.toString();
            int idx = arg.indexOf("-classpath");
            if (idx < 0) {
                return ret;
            }
            if ((idx += 11) >= arg.length()) {
                return ret;
            }
            int space = JFormat.getClassPathEntriesEnd(idx, arg);
            if (space <= idx) {
                return ret;
            }
            String classpath = ret.substring(idx, space);
            HashMap<String, String> map = new HashMap<String, String>();
            StringBuffer newpath = new StringBuffer();
            StringTokenizer stoken = new StringTokenizer(classpath, File.pathSeparator);
            while (stoken.hasMoreTokens()) {
                String token = stoken.nextToken();
                if (map.put(token, token) != null) continue;
                newpath.append(token);
                newpath.append(File.pathSeparator);
            }
            map = null;
            newpath.insert(0, arg.substring(0, idx));
            newpath.append(arg.substring(space));
            return newpath;
        }

        private String createSourceReplace(JavaExternalCompilerType jext) {
            if (!jext.getSource14Enable()) {
                return "";
            }
            return "-source 1.4 ";
        }

        protected String createBootClassPathReplace(JavaExternalCompilerType t) {
            NbClassPath bcp = t.getBootClassPath();
            if (bcp == null) {
                return "";
            }
            String classPath = bcp.getClassPath();
            if (!"".equals(classPath)) {
                return t.getBootClassPathReplace();
            }
            return "";
        }

        private static int getClassPathEntriesEnd(int idx, String searched) {
            boolean slashed = false;
            boolean inToken = false;
            int slen = searched.length();
            int i = idx;
            while (i < slen) {
                switch (searched.charAt(i)) {
                    case ' ': {
                        if (inToken) break;
                        return i;
                    }
                    case '\\': {
                        slashed = !slashed;
                        break;
                    }
                    case '\"': {
                        if (!slashed) {
                            inToken = !inToken;
                        }
                    }
                    default: {
                        slashed = false;
                    }
                }
                ++i;
            }
            return -1;
        }

        String createEncodingReplace(JavaExternalCompilerType jext, String encoding) {
            if (encoding == null || "".equals(encoding)) {
                return "";
            }
            return jext.getEncodingReplace() + " " + encoding;
        }

        static String createOutputReplace(JavaExternalCompilerType jext) {
            boolean hasSpace;
            if (!jext.isCrossCompile()) {
                return "";
            }
            FileSystem fs = jext.getTargetFileSystem();
            if (fs == JavaCompilerType.TARGET_INVALID) {
                return "";
            }
            StringBuffer sb = new StringBuffer(fs.getSystemName().length() + 4);
            File localFile = NbClassPath.toFile((FileObject)fs.getRoot());
            sb.append(jext.getDReplace());
            String localName = localFile.toString();
            boolean bl = hasSpace = localName.indexOf(32) > -1;
            if (hasSpace) {
                sb.append(" \"");
            } else {
                sb.append(" ");
            }
            sb.append(localName);
            if (hasSpace) {
                sb.append('\"');
            }
            return sb.toString();
        }

        static String createSystemBootClassPath() {
            String bcp = System.getProperty(TAG_SYSTEMBOOTCLASSPATH);
            StringTokenizer tukac = new StringTokenizer(bcp, File.pathSeparator);
            boolean hasSpaces = false;
            StringBuffer sb = new StringBuffer(bcp.length());
            boolean first = true;
            while (tukac.hasMoreElements()) {
                String s = tukac.nextToken();
                File f = new File(s);
                if (!f.exists()) continue;
                if (s.indexOf(32) > -1) {
                    hasSpaces = true;
                }
                if (!first) {
                    sb.append(File.pathSeparatorChar);
                }
                sb.append(s);
                first = false;
            }
            if (sb.length() == 0) {
                return "\"\"";
            }
            if (hasSpaces) {
                sb.insert(0, '\"');
                sb.append('\"');
            }
            return sb.toString();
        }
    }
}

