/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.DateFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.netbeans.modules.java.IndentFileEntry;
import org.netbeans.modules.java.JMapFormat;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.ParserEngine;
import org.netbeans.modules.java.Util;
import org.netbeans.modules.java.settings.JavaSettings;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.util.actions.SystemAction;

public class JavaDataLoader
extends MultiFileLoader {
    public static final String JAVA_EXTENSION = "java";
    public static final String CLASS_EXTENSION = "class";
    public static final String PROP_PARSER_ENGINE = "parserEngine";
    public static final String PROP_EXTENSIONS = "extensions";
    public static final String PROP_PERFECT_RECOGNITION = "perfectRecognition";
    public static final String DEFAULT_PARSER_ENGINE = "org.netbeans.modules.java.gj.JavaParserEngine";
    private static final int EXTERNALIZED_VERSION = 2;
    static ArrayList parsingListeners = new ArrayList();
    static final long serialVersionUID = -6286836352608877232L;
    private transient ParserEngine parserEngine;
    static SystemAction[] standardActions;
    static /* synthetic */ Class class$org$openide$actions$OpenAction;
    static /* synthetic */ Class class$org$openide$actions$CustomizeBeanAction;
    static /* synthetic */ Class class$org$openide$actions$FileSystemAction;
    static /* synthetic */ Class class$org$openide$actions$CompileAction;
    static /* synthetic */ Class class$org$openide$actions$BuildAction;
    static /* synthetic */ Class class$org$openide$actions$ExecuteAction;
    static /* synthetic */ Class class$org$openide$actions$CutAction;
    static /* synthetic */ Class class$org$openide$actions$CopyAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$org$openide$actions$NewAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$openide$actions$RenameAction;
    static /* synthetic */ Class class$org$openide$actions$SaveAsTemplateAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
    static /* synthetic */ Class class$org$netbeans$modules$java$JavaDataLoader;

    public JavaDataLoader() {
        this("org.netbeans.modules.java.JavaDataObject");
    }

    public JavaDataLoader(String recognizedObject) {
        super(recognizedObject);
    }

    public JavaDataLoader(Class recognizedObject) {
        super(recognizedObject);
    }

    private SystemAction[] createDefaultActions() {
        return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$OpenAction == null ? (class$org$openide$actions$OpenAction = JavaDataLoader.class$("org.openide.actions.OpenAction")) : class$org$openide$actions$OpenAction)), SystemAction.get((Class)(class$org$openide$actions$CustomizeBeanAction == null ? (class$org$openide$actions$CustomizeBeanAction = JavaDataLoader.class$("org.openide.actions.CustomizeBeanAction")) : class$org$openide$actions$CustomizeBeanAction)), SystemAction.get((Class)(class$org$openide$actions$FileSystemAction == null ? (class$org$openide$actions$FileSystemAction = JavaDataLoader.class$("org.openide.actions.FileSystemAction")) : class$org$openide$actions$FileSystemAction)), null, SystemAction.get((Class)(class$org$openide$actions$CompileAction == null ? (class$org$openide$actions$CompileAction = JavaDataLoader.class$("org.openide.actions.CompileAction")) : class$org$openide$actions$CompileAction)), null, SystemAction.get((Class)(class$org$openide$actions$BuildAction == null ? (class$org$openide$actions$BuildAction = JavaDataLoader.class$("org.openide.actions.BuildAction")) : class$org$openide$actions$BuildAction)), null, SystemAction.get((Class)(class$org$openide$actions$ExecuteAction == null ? (class$org$openide$actions$ExecuteAction = JavaDataLoader.class$("org.openide.actions.ExecuteAction")) : class$org$openide$actions$ExecuteAction)), null, SystemAction.get((Class)(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = JavaDataLoader.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction)), SystemAction.get((Class)(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = JavaDataLoader.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction)), SystemAction.get((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = JavaDataLoader.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction)), null, SystemAction.get((Class)(class$org$openide$actions$NewAction == null ? (class$org$openide$actions$NewAction = JavaDataLoader.class$("org.openide.actions.NewAction")) : class$org$openide$actions$NewAction)), SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = JavaDataLoader.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)), SystemAction.get((Class)(class$org$openide$actions$RenameAction == null ? (class$org$openide$actions$RenameAction = JavaDataLoader.class$("org.openide.actions.RenameAction")) : class$org$openide$actions$RenameAction)), null, SystemAction.get((Class)(class$org$openide$actions$SaveAsTemplateAction == null ? (class$org$openide$actions$SaveAsTemplateAction = JavaDataLoader.class$("org.openide.actions.SaveAsTemplateAction")) : class$org$openide$actions$SaveAsTemplateAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = JavaDataLoader.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = JavaDataLoader.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
    }

    protected String defaultDisplayName() {
        return Util.getString("PROP_JavaLoader_Name");
    }

    protected SystemAction[] defaultActions() {
        if (standardActions != null) {
            return standardActions;
        }
        Class clazz = class$org$netbeans$modules$java$JavaDataLoader == null ? (class$org$netbeans$modules$java$JavaDataLoader = JavaDataLoader.class$("org.netbeans.modules.java.JavaDataLoader")) : class$org$netbeans$modules$java$JavaDataLoader;
        synchronized (clazz) {
            if (standardActions == null) {
                standardActions = this.createDefaultActions();
            }
        }
        return standardActions;
    }

    protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException, IOException {
        return new JavaDataObject(primaryFile, this);
    }

    protected FileObject findPrimaryFile(FileObject fo) {
        if (fo.isFolder()) {
            return null;
        }
        String ext = fo.getExt();
        if (ext.equals(CLASS_EXTENSION)) {
            return Util.findBrother(fo, this.getExtensions());
        }
        if (this.getExtensions().isRegistered(fo)) {
            return fo;
        }
        return null;
    }

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject obj, FileObject primaryFile) {
        primaryFile.setImportant(true);
        return new JavaFileEntry(obj, primaryFile);
    }

    protected MultiDataObject.Entry createSecondaryEntry(MultiDataObject obj, FileObject secondaryFile) {
        secondaryFile.setImportant(false);
        return new FileEntry.Numb(obj, secondaryFile);
    }

    protected Map createStringsMap() {
        Properties map = JavaSettings.getDefault().getReplaceableStringsProps();
        map.put("DATE", DateFormat.getDateInstance(1).format(new Date()));
        map.put("TIME", DateFormat.getTimeInstance(3).format(new Date()));
        return map;
    }

    public void setParserEngine(ParserEngine eng) {
        ParserEngine old;
        if (eng == this.parserEngine) {
            return;
        }
        JavaDataLoader javaDataLoader = this;
        synchronized (javaDataLoader) {
            old = this.parserEngine;
            this.parserEngine = eng;
        }
        old.unregisterAll();
        this.firePropertyChange(PROP_PARSER_ENGINE, old, eng);
    }

    public ParserEngine getParserEngine() {
        JavaDataLoader javaDataLoader = this;
        synchronized (javaDataLoader) {
            if (this.parserEngine != null) {
                ParserEngine parserEngine = this.parserEngine;
                return parserEngine;
            }
            boolean ok = false;
            ReflectiveOperationException ex = null;
            try {
                this.parserEngine = (ParserEngine)Class.forName(DEFAULT_PARSER_ENGINE).newInstance();
                ok = true;
            }
            catch (IllegalAccessException e) {
                ex = e;
            }
            catch (InstantiationException e) {
                ex = e;
            }
            catch (ClassNotFoundException e) {
                ex = e;
            }
            if (!ok && ex != null && Boolean.getBoolean("netbeans.debug.exceptions")) {
                ex.printStackTrace();
            }
            ParserEngine parserEngine = this.parserEngine;
            return parserEngine;
        }
    }

    public ExtensionList getExtensions() {
        ExtensionList extensions = (ExtensionList)this.getProperty(PROP_EXTENSIONS);
        if (extensions == null) {
            extensions = new ExtensionList();
            extensions.addExtension(JAVA_EXTENSION);
            this.putProperty(PROP_EXTENSIONS, extensions, false);
        }
        return extensions;
    }

    public void setExtensions(ExtensionList ext) {
        this.putProperty(PROP_EXTENSIONS, ext, true);
    }

    public void setPerfectRecognition(boolean b) {
        Boolean prev = (Boolean)this.getProperty(PROP_PERFECT_RECOGNITION);
        if (prev == null && !b || prev != null && prev == b) {
            return;
        }
        this.putProperty(PROP_PERFECT_RECOGNITION, b ? Boolean.TRUE : Boolean.FALSE, true);
    }

    public boolean isPerfectRecognition() {
        Boolean v = (Boolean)this.getProperty(PROP_PERFECT_RECOGNITION);
        if (v == null) {
            return false;
        }
        return v;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(2);
        out.writeObject(this.getProperty(PROP_EXTENSIONS));
        Boolean b = (Boolean)this.getProperty(PROP_PERFECT_RECOGNITION);
        if (b != null && b.booleanValue()) {
            out.writeBoolean(true);
        } else {
            out.writeBoolean(false);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        if (in.available() > 0) {
            int v = in.readInt();
            if (v >= 1) {
                this.putProperty(PROP_EXTENSIONS, in.readObject(), false);
            }
            if (v >= 2) {
                this.putProperty(PROP_PERFECT_RECOGNITION, in.readBoolean() ? Boolean.TRUE : Boolean.FALSE, false);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class JavaFileEntry
    extends IndentFileEntry {
        static final long serialVersionUID = 8244159045498569616L;
        boolean disableInputStream;
        private Collection activeReaders;

        public JavaFileEntry(MultiDataObject obj, FileObject file) {
            super(obj, file);
        }

        protected Format createFormat(FileObject target, String n, String e) {
            Map map = JavaDataLoader.this.createStringsMap();
            this.modifyMap(map, target, n, e);
            JMapFormat format = new JMapFormat(map);
            format.setLeftBrace("__");
            format.setRightBrace("__");
            format.setCondDelimiter("$");
            format.setExactMatch(false);
            return format;
        }

        protected void modifyMap(Map map, FileObject target, String n, String e) {
            map.put("NAME", n);
            map.put("PACKAGE", target.getPackageName('.'));
            map.put("PACKAGE_SLASHES", target.getPackageName('/'));
            if (target.isRoot()) {
                map.put("PACKAGE_AND_NAME", n);
                map.put("PACKAGE_AND_NAME_SLASHES", n);
            } else {
                map.put("PACKAGE_AND_NAME", target.getPackageName('.') + '.' + n);
                map.put("PACKAGE_AND_NAME_SLASHES", target.getPackageName('/') + '/' + n);
            }
            map.put("QUOTES", "\"");
        }

        public synchronized void addReader(InputStream r) {
            if (this.activeReaders == null) {
                this.activeReaders = new LinkedList();
            }
            this.activeReaders.add(r);
        }

        public synchronized void removeReader(InputStream r) {
            if (this.activeReaders == null) {
                return;
            }
            this.activeReaders.remove(r);
        }

        public void delete() throws IOException {
            JavaFileEntry javaFileEntry = this;
            synchronized (javaFileEntry) {
                if (this.activeReaders != null && this.activeReaders.size() > 0) {
                    Iterator it = this.activeReaders.iterator();
                    while (it.hasNext()) {
                        InputStream r = (InputStream)it.next();
                        r.close();
                    }
                }
                this.activeReaders = null;
                this.disableInputStream = true;
            }
            super.delete();
        }

        public InputStream getInputStream() throws FileNotFoundException {
            FileObject fob = this.getFile();
            JavaFileEntry javaFileEntry = this;
            synchronized (javaFileEntry) {
                if (this.disableInputStream) {
                    throw new FileNotFoundException("File is being deleted.");
                }
                NotifyInputStream s = new NotifyInputStream(fob.getInputStream());
                this.addReader(s);
                NotifyInputStream notifyInputStream = s;
                return notifyInputStream;
            }
        }

        private class NotifyInputStream
        extends FilterInputStream {
            public NotifyInputStream(InputStream is) {
                super(is);
            }

            public void close() throws IOException {
                super.close();
                JavaFileEntry.this.removeReader(this);
            }
        }
    }
}

