/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.codegen;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.java.codegen.CodeGenerator;
import org.netbeans.modules.java.codegen.ContainerImpl;
import org.netbeans.modules.java.codegen.ExceptionRunnable;
import org.netbeans.modules.java.codegen.SourceText;
import org.netbeans.modules.java.codegen.TextBinding;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.Element;
import org.openide.src.ElementPrinter;
import org.openide.src.ElementPrinterInterruptException;
import org.openide.src.ElementProperties;
import org.openide.src.FieldElement;
import org.openide.src.InitializerElement;
import org.openide.src.JavaDoc;
import org.openide.src.MethodElement;
import org.openide.src.SourceException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;

abstract class ElementBinding
implements TextBinding,
ElementProperties {
    private Element el;
    protected PositionBounds wholeBounds;
    protected PositionBounds docBounds;
    protected PositionBounds headerBounds;
    protected PositionBounds bodyBounds;
    protected SourceText source;
    protected ContainerImpl containerRef;
    static Map setterCache;
    private static final boolean DEBUG = false;
    private static final String lineSeparator;
    private static final int lineSeparatorLength;
    private static final String LINEFEED = "\n";
    static final int CLASS_IGNORE = 0;
    static final int CLASS_HEADER = 1;
    static final int CLASS_BODY = 2;
    static final int CLASS_JAVADOC = 3;

    public ElementBinding(Element el, SourceText s) {
        this.el = el;
        this.source = s;
        s.registerBinding(el, this);
    }

    public TextBinding.Container getContainer(String type) {
        return this.containerRef;
    }

    public void linkAfter(TextBinding b) {
    }

    public Element getElement() {
        return this.el;
    }

    public PositionBounds getElementRange(boolean defRange) {
        if (!defRange || this.headerBounds == null) {
            return this.wholeBounds;
        }
        return new PositionBounds(this.headerBounds.getBegin(), this.wholeBounds.getEnd());
    }

    protected abstract Element cloneElement();

    public void create(PositionBounds bounds) throws SourceException {
        this.wholeBounds = bounds;
        this.regenerateWhole(this.el, true);
    }

    public PositionRef prepareInsert(ElementBinding tbi, boolean after) throws SourceException {
        return after ? this.wholeBounds.getEnd() : this.wholeBounds.getBegin();
    }

    public void insertAfter(ElementBinding b) throws SourceException {
        b.createAt(this.wholeBounds.getEnd());
    }

    public void create(ContainerImpl container, ElementBinding previous, ElementBinding next, PositionBounds containerBounds, boolean emptyBefore, boolean emptyAfter) throws SourceException {
        PositionRef top;
        PositionRef beginPos = previous == null ? containerBounds.getBegin() : previous.prepareInsert(this, true);
        PositionBounds gap = new PositionBounds(beginPos, top = next == null ? containerBounds.getEnd() : next.prepareInsert(this, false));
        PositionRef pos = this.source.findFreePosition(gap);
        if (pos == null) {
            throw new SourceException("No room for element");
        }
        this.createAt(pos, emptyBefore, emptyAfter);
        this.containerRef = container;
    }

    private void createAt(PositionRef r, boolean sepBefore, boolean sepAfter) throws SourceException {
        PositionBounds newBounds = CodeGenerator.createNewLineBounds(r, 0, sepBefore, sepAfter);
        this.create(newBounds);
    }

    private void createAt(PositionRef r) throws SourceException {
        PositionBounds newBounds = CodeGenerator.createNewLineBounds(r, 0);
        this.create(newBounds);
    }

    public void applyPropertyChange(Object bean, String property, Object value) throws SourceException {
        Method setter;
        if (setterCache == null) {
            setterCache = new HashMap(29);
            setter = null;
        } else {
            setter = (Method)setterCache.get(property);
        }
        if (setter == null) {
            try {
                BeanInfo binfo = Introspector.getBeanInfo(bean.getClass());
                PropertyDescriptor[] desc = binfo.getPropertyDescriptors();
                int i = 0;
                while (i < desc.length) {
                    if (desc[i].getName().equals(property)) {
                        setter = desc[i].getWriteMethod();
                    }
                    ++i;
                }
            }
            catch (IntrospectionException ex) {
                // empty catch block
            }
            if (setter == null) {
                throw new SourceException("Cannot find setter for " + property);
            }
            setterCache.put(property, setter);
        }
        try {
            setter.invoke(bean, value);
            return;
        }
        catch (IllegalAccessException ex) {
        }
        catch (InvocationTargetException ex) {
            // empty catch block
        }
    }

    public void changeElementProperty(final PropertyChangeEvent evt) throws SourceException {
        if (!this.source.isGeneratorEnabled()) {
            return;
        }
        this.source.runAtomic(this.el, new ExceptionRunnable(){

            public void run() throws Exception {
                ElementBinding.this.doChangeProperty(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        });
    }

    protected void doChangeProperty(String property, Object old, Object now) throws Exception {
        int propClass = this.classifyProperty(property);
        if (propClass == 0) {
            return;
        }
        Element clonedBean = this.cloneElement();
        this.applyPropertyChange(clonedBean, property, now);
        switch (propClass) {
            case 1: {
                this.regenerateHeader(clonedBean);
                break;
            }
            case 2: {
                this.regenerateBody(clonedBean);
                break;
            }
            case 3: {
                this.regenerateJavaDoc(clonedBean, this.getJavaDoc());
            }
        }
    }

    protected JavaDoc getJavaDoc() {
        throw new UnsupportedOperationException("Generic javadoc not supported!");
    }

    protected int classifyProperty(String propName) {
        return 0;
    }

    public ElementBinding findBindingAt(int off) {
        if (this.wholeBounds.getBegin().getOffset() <= off && this.wholeBounds.getEnd().getOffset() > off) {
            return this;
        }
        return null;
    }

    protected void remove(boolean collapseBefore, boolean collapseAfter) throws SourceException, IllegalStateException {
        try {
            CodeGenerator.clearBounds(this.wholeBounds, collapseBefore);
        }
        catch (Exception ex) {
            SourceText.rethrowException(this.el, ex);
        }
    }

    protected void moveTo(ElementBinding before, ElementBinding after) throws SourceException {
        PositionBounds oldWholeBounds = this.wholeBounds;
        this.containerRef.insertChild(this, before, after);
        try {
            CodeGenerator.clearBounds(oldWholeBounds, false);
        }
        catch (BadLocationException ex) {
            SourceText.rethrowException(this.getElement(), ex);
        }
    }

    protected StyledDocument findDocument() throws SourceException {
        return this.source.getDocument();
    }

    protected void regenerateHeader(Element el) throws SourceException {
        StyledDocument doc = this.findDocument();
        this.source.runAtomic(this.el, new PartialGenerator(doc, el, this.headerBounds, 4, 5));
    }

    protected void regenerateWhole(Element el, boolean updatePositions) throws SourceException {
        StyledDocument doc = this.findDocument();
        this.source.runAtomic(this.el, new PartialGenerator(doc, el, updatePositions));
    }

    protected void regenerateBody(Element el) throws SourceException {
        StyledDocument doc = this.findDocument();
        this.source.runAtomic(this.el, new PartialGenerator(doc, el, this.bodyBounds, 6, 7));
    }

    protected void regenerateJavaDoc(Element el, JavaDoc javadoc) throws SourceException {
        StyledDocument doc = this.findDocument();
        if (this.docBounds != null) {
            this.source.runAtomic(this.el, new PartialGenerator(doc, el, this.docBounds, 2, 3));
        } else {
            this.source.runAtomic(this.el, new JavaDocGenerator((Document)doc, el, javadoc));
        }
    }

    public boolean canInsertAfter() {
        return true;
    }

    public void changeJavaDoc(JavaDoc content) throws SourceException {
        if (!this.source.isGeneratorEnabled()) {
            return;
        }
        this.regenerateJavaDoc(this.el, content);
    }

    public void updateBounds(int kind, PositionBounds bounds) {
        switch (kind) {
            case 0: {
                this.wholeBounds = bounds;
                break;
            }
            case 1: {
                this.docBounds = bounds;
                break;
            }
            case 3: {
                this.bodyBounds = bounds;
                break;
            }
            case 2: {
                this.headerBounds = bounds;
            }
        }
    }

    PositionRef getEndPosition() {
        StyledDocument doc = this.source.getEditorSupport().getDocument();
        return this.source.createPos(doc.getLength(), Position.Bias.Backward);
    }

    PositionBounds findContainerBounds(TextBinding.Container cont) {
        throw new UnsupportedOperationException(this.toString());
    }

    public String toString() {
        return "Binding for " + this.getElement();
    }

    static String convertNewlines(String input) {
        if (lineSeparator == null) {
            return input;
        }
        int firstIndex = input.indexOf(lineSeparator);
        if (firstIndex == -1) {
            return input;
        }
        StringBuffer result = new StringBuffer();
        char[] contents = input.toCharArray();
        if (firstIndex > 0) {
            result.append(contents, 0, firstIndex);
        }
        result.append(LINEFEED);
        int lastPos = firstIndex += lineSeparatorLength;
        while (firstIndex < contents.length) {
            if ((firstIndex = input.indexOf(lineSeparator, firstIndex)) == -1) {
                result.append(contents, lastPos, contents.length - lastPos);
                return result.toString();
            }
            result.append(contents, lastPos, firstIndex - lastPos);
            result.append(LINEFEED);
            lastPos = firstIndex += lineSeparatorLength;
        }
        result.append(contents, lastPos, firstIndex - lastPos);
        return result.toString();
    }

    static {
        String sep = System.getProperty("line.separator");
        if (sep == null || LINEFEED.equals(sep)) {
            lineSeparator = null;
            lineSeparatorLength = -1;
        } else {
            lineSeparator = sep;
            lineSeparatorLength = sep.length();
        }
    }

    static class ElementPrinterImpl
    implements ElementPrinter {
        PrintWriter writer;
        String lastText = null;
        Element printedElement;
        int beginMark;
        int endMark;
        int status;

        ElementPrinterImpl(Writer writer) {
            this(writer, null, 0, 0);
            this.status = 1;
        }

        ElementPrinterImpl(Writer writer, Element printedElement, int beginMark, int endMark) {
            this.writer = new PrintWriter(writer);
            this.printedElement = printedElement;
            this.beginMark = beginMark;
            this.endMark = endMark;
            this.status = 0;
        }

        public boolean isBegin(Element element, int what) {
            return this.printedElement == null || element == this.printedElement && what == this.beginMark;
        }

        public boolean isEnd(Element element, int what) {
            return this.printedElement == element && what == this.endMark;
        }

        public void markNotify(Element element, int what) {
        }

        public String getString() {
            return this.writer.toString();
        }

        public void print(String text) throws ElementPrinterInterruptException {
            switch (this.status) {
                case 0: {
                    this.lastText = null;
                    return;
                }
                case 1: {
                    this.lastText = text = ElementBinding.convertNewlines(text);
                    this.writer.print(text);
                    break;
                }
                case 2: {
                    throw new ElementPrinterInterruptException();
                }
            }
        }

        public void println(String text) throws ElementPrinterInterruptException {
            this.print(text);
            this.print(ElementBinding.LINEFEED);
        }

        private void mark(Element element, int what) throws ElementPrinterInterruptException {
            switch (this.status) {
                case 0: {
                    if (!this.isBegin(element, what)) break;
                    this.markNotify(element, what);
                    this.status = 1;
                    break;
                }
                case 1: {
                    this.writer.flush();
                    this.markNotify(element, what);
                    if (!this.isEnd(element, what)) break;
                    this.status = 2;
                    this.writer.close();
                    throw new ElementPrinterInterruptException();
                }
                case 2: {
                    throw new ElementPrinterInterruptException();
                }
            }
        }

        public void markClass(ClassElement element, int what) throws ElementPrinterInterruptException {
            this.mark((Element)element, what);
        }

        public void markInitializer(InitializerElement element, int what) throws ElementPrinterInterruptException {
            this.mark((Element)element, what);
        }

        public void markField(FieldElement element, int what) throws ElementPrinterInterruptException {
            this.mark((Element)element, what);
        }

        public void markConstructor(ConstructorElement element, int what) throws ElementPrinterInterruptException {
            this.mark((Element)element, what);
        }

        public void markMethod(MethodElement element, int what) throws ElementPrinterInterruptException {
            this.mark((Element)element, what);
        }
    }

    class WholeElementPrinter
    extends ElementPrinterImpl {
        StringWriter stringWriter;
        CloneableEditorSupport editor;
        int[] positions;

        WholeElementPrinter(Writer writer, StringWriter stringWriter) {
            super(writer);
            this.stringWriter = stringWriter;
            this.editor = ElementBinding.this.source.getEditorSupport();
            this.positions = new int[8];
            Arrays.fill(this.positions, -1);
        }

        public void markNotify(Element el, int what) {
            if (this.lastText != null && this.lastText.endsWith(" ")) {
                String writerText = this.stringWriter.getBuffer().toString();
                int len = this.lastText.length();
                if (len > 0 && !writerText.endsWith(" ")) {
                    int ch = 0;
                    int i = len - 1;
                    while (i >= 0) {
                        ch = this.lastText.charAt(i);
                        if (ch != 32) break;
                        --i;
                    }
                    if (ch != 10) {
                        this.stringWriter.write(this.lastText, ++i, len - i);
                    }
                }
            }
            this.positions[what] = this.stringWriter.getBuffer().length();
            if (what == 1 && this.positions[7] != -1 && (el instanceof ConstructorElement || el instanceof InitializerElement)) {
                this.positions[7] = this.positions[1] - 1;
            }
        }

        void finish() {
            int offset = ElementBinding.this.wholeBounds.getBegin().getOffset();
            if (this.positions[0] != -1 && this.positions[1] != -1) {
                ElementBinding.this.wholeBounds = this.createStableBounds(this.positions[0] + offset, this.positions[1] + offset);
            }
            if (this.positions[2] != -1 && this.positions[3] != -1) {
                ElementBinding.this.docBounds = this.createStableBounds(this.positions[2] + offset, this.positions[3] + offset);
            }
            if (this.positions[4] != -1 && this.positions[5] != -1) {
                ElementBinding.this.headerBounds = this.createStableBounds(this.positions[4] + offset, this.positions[5] + offset);
            }
            if (this.positions[6] != -1 && this.positions[7] != -1) {
                ElementBinding.this.bodyBounds = this.createBounds(this.positions[6] + offset, this.positions[7] + offset);
            }
        }

        private PositionBounds createStableBounds(int begin, int end) {
            if (begin == -1 || end == -1) {
                return null;
            }
            PositionRef posBegin = this.editor.createPositionRef(begin, Position.Bias.Backward);
            PositionRef posEnd = this.editor.createPositionRef(end, Position.Bias.Forward);
            return new PositionBounds(posBegin, posEnd);
        }

        private PositionBounds createBounds(int begin, int end) {
            if (begin == -1 || end == -1) {
                return null;
            }
            PositionRef posBegin = this.editor.createPositionRef(begin, Position.Bias.Backward);
            PositionRef posEnd = this.editor.createPositionRef(end, Position.Bias.Forward);
            return new PositionBounds(posBegin, posEnd);
        }
    }

    protected class PartialGenerator
    implements ExceptionRunnable {
        PositionBounds posBounds;
        int begin;
        int end;
        Document doc;
        Element el;
        boolean update;

        PartialGenerator(Document doc, Element el, boolean updateBounds) {
            this.update = updateBounds;
            this.el = el;
            this.doc = doc;
            this.begin = 0;
            this.end = 1;
            this.posBounds = ElementBinding.this.wholeBounds;
        }

        PartialGenerator(Document doc, Element el, PositionBounds pos, int begin, int end) {
            this.posBounds = pos;
            this.begin = begin;
            this.end = end;
            this.doc = doc;
            this.el = el;
        }

        public void run() throws Exception {
            PositionRef headerBegin = this.posBounds.getBegin();
            StyledDocument doc = ElementBinding.this.findDocument();
            StringWriter wr = new StringWriter();
            Writer indentWriter = CodeGenerator.findIndentWriter(doc, headerBegin.getOffset(), wr);
            ElementPrinterImpl printer = this.update ? new WholeElementPrinter(indentWriter, wr) : new ElementPrinterImpl(indentWriter, this.el, this.begin, this.end);
            try {
                this.el.print((ElementPrinter)printer);
            }
            catch (ElementPrinterInterruptException e) {
                // empty catch block
            }
            try {
                indentWriter.close();
            }
            catch (IOException ex) {
                throw new InternalError(ex.getMessage());
            }
            CodeGenerator.fillTextBounds(this.posBounds, wr.toString());
            if (this.update) {
                ((WholeElementPrinter)printer).finish();
            }
        }
    }

    protected class JavaDocGenerator
    extends PartialGenerator {
        JavaDoc content;

        JavaDocGenerator(Document doc, Element el, JavaDoc javadoc) {
            super(doc, el, null, 2, 3);
            this.content = javadoc;
        }

        public void run() throws Exception {
            String raw = this.content.getRawText();
            if (raw == null) {
                if (ElementBinding.this.docBounds != null) {
                    CodeGenerator.clearBounds(ElementBinding.this.docBounds, false);
                    ElementBinding.this.docBounds = null;
                }
            } else {
                this.posBounds = CodeGenerator.createNewLineBounds(ElementBinding.this.wholeBounds.getBegin(), 1);
                super.run();
                ElementBinding.this.docBounds = this.posBounds;
                ElementBinding.this.wholeBounds = new PositionBounds(this.posBounds.getBegin(), ElementBinding.this.wholeBounds.getEnd());
            }
        }
    }

    protected class RemovingRunnable
    implements ExceptionRunnable {
        protected RemovingRunnable() {
        }

        public void run() throws Exception {
            CodeGenerator.clearBounds(ElementBinding.this.wholeBounds, true);
        }
    }
}

