/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.codesync;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.java.JavaConnections;
import org.netbeans.modules.java.codesync.ChangeCache;
import org.netbeans.modules.java.model.CommitListener;
import org.netbeans.modules.java.model.LangModel;
import org.openide.cookies.ConnectionCookie;
import org.openide.loaders.ConnectionSupport;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.Element;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.InitializerElement;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.Type;

public class ModelEventAdapter
extends ConnectionSupport
implements CommitListener {
    public static final int FIELD = 0;
    public static final int METHOD = 1;
    public static final int CLASS = 2;
    public static final int CONSTRUCTOR = 3;
    public static final int INITIALIZER = 4;
    protected static final int TYPE_COUNT = 5;
    private static final Element[] EMPTY_ELEMENT_ARRAY = new Element[0];
    private static final JavaConnections.Change[] EMPTY_CHANGE_ARRAY = new JavaConnections.Change[0];
    private static final int[] EVENT_TYPES = new int[5];
    private static final String[] EVENT_TYPE_NAMES;
    private static final String[] EVENT_OPERATION_NAMES;
    LangModel model;
    private ChangeCache[] cachedChanges;
    private Node fakeNodeSource;
    private MultiDataObject.Entry sourceEntry;
    private static final boolean DEBUG = false;
    ChangeCache[] eventCaches = new ChangeCache[5];
    static /* synthetic */ Class class$org$openide$src$Element$Impl;

    public ModelEventAdapter(MultiDataObject.Entry entry) {
        super(entry, new ConnectionCookie.Type[]{new JavaConnections.Type(1048575)});
        this.model = this.model;
        this.sourceEntry = entry;
    }

    public boolean isAttached() {
        return this.model != null;
    }

    protected synchronized Node getSourceNode() {
        if (this.fakeNodeSource == null) {
            this.fakeNodeSource = this.createSourceNode();
        }
        return this.fakeNodeSource;
    }

    protected Node createSourceNode() {
        return this.sourceEntry.getDataObject().getNodeDelegate();
    }

    public synchronized void attachToModel(LangModel model) {
        if (this.model != null) {
            if (model != this.model) {
                throw new IllegalStateException("Already attached");
            }
            return;
        }
        model.addPostCommitListener(this);
        this.model = model;
    }

    public synchronized void detachFromModel() {
        LangModel m = this.model;
        this.model = null;
        if (m == null) {
            return;
        }
        m.removePostCommitListener(this);
    }

    private void splitCollection(Collection original, Collection[] out) {
        if (original == null || original.isEmpty()) {
            return;
        }
        Iterator it = original.iterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            int kind = this.classifyElement(el);
            if (kind < 0) continue;
            if (out[kind] == null) {
                out[kind] = new LinkedList();
            }
            out[kind].add(el);
        }
    }

    private void splitMap(Map original, Map[] out) {
        if (original == null || original.isEmpty()) {
            return;
        }
        Iterator it = original.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry en = it.next();
            Element el = (Element)en.getKey();
            int kind = this.classifyElement(el);
            if (kind < 0) continue;
            if (out[kind] == null) {
                out[kind] = new HashMap(19);
            }
            out[kind].put(el, en.getValue());
        }
    }

    public void changesCommited(Set created, Set removed, Map changed) {
        Collection[] creations = new Collection[5];
        Collection[] removals = new Collection[5];
        Map[] changes = new Map[5];
        LinkedList allChanges = new LinkedList();
        this.splitCollection(created, creations);
        this.splitCollection(removed, removals);
        this.splitMap(changed, changes);
        int mask = this.getListenerMask();
        int i = 0;
        while (i < EVENT_TYPES.length) {
            Collection c = this.createChange(mask, i, creations[i], removals[i], changes[i]);
            if (c != null) {
                allChanges.addAll(c);
            }
            ++i;
        }
        if (allChanges.isEmpty()) {
            return;
        }
        int resultType = 0;
        Iterator it = allChanges.iterator();
        while (it.hasNext()) {
            resultType |= ((JavaConnections.Change)it.next()).getChangeType();
        }
        JavaConnections.Type wholeType = new JavaConnections.Type(resultType);
        JavaConnections.Change[] arr = allChanges.toArray(new JavaConnections.Change[allChanges.size()]);
        JavaConnections.Event evt = new JavaConnections.Event(this.getSourceNode(), arr, wholeType);
        this.fireEvent(evt);
    }

    private Collection createChange(int listenmask, int kind, Collection created, Collection removed, Map changed) {
        Change ch;
        if (created == null && removed == null && changed == null) {
            return null;
        }
        ChangeCache cache = this.getEventCache(kind);
        if (created != null) {
            created = cache.elementsCreated(created);
        }
        if (removed != null) {
            removed = cache.elementsRemoved(removed);
        }
        Collection changePairs = changed != null ? cache.elementsChanged(changed) : null;
        int baseType = EVENT_TYPES[kind];
        int mask = listenmask & baseType;
        if (created == null && removed == null && changePairs == null) {
            return null;
        }
        if (mask == 0) {
            return null;
        }
        LinkedList<Change> out = new LinkedList<Change>();
        if (changePairs != null) {
            boolean accept = (mask & 0x44444) > 0;
            Iterator it = changePairs.iterator();
            while (it.hasNext()) {
                Element eNew = (Element)it.next();
                Element eOld = (Element)it.next();
                if (eOld == null) {
                    if (created == null) {
                        created = new LinkedList<Element>();
                    }
                    created.add(eNew);
                    continue;
                }
                if (!accept) continue;
                ch = new Change(baseType & 0x44444, eOld, eNew);
                out.add(ch);
            }
        }
        if (created != null && (mask & 0x11111) > 0) {
            ch = new Change(baseType & 0x11111, created);
            out.add(ch);
        }
        if (removed != null && (mask & 0x22222) > 0) {
            ch = new Change(baseType & 0x22222, removed);
            out.add(ch);
        }
        return out;
    }

    protected ChangeCache getEventCache(int kind) {
        if (this.eventCaches[kind] != null) {
            return this.eventCaches[kind];
        }
        this.eventCaches[kind] = new Cache(kind);
        return this.eventCaches[kind];
    }

    protected int classifyElement(Element el) {
        if (el instanceof ClassElement) {
            return 2;
        }
        if (el instanceof ConstructorElement) {
            if (el instanceof MethodElement) {
                return 1;
            }
            return 3;
        }
        if (el instanceof FieldElement) {
            return 0;
        }
        if (el instanceof InitializerElement) {
            return 4;
        }
        return -1;
    }

    protected int getListenerMask() {
        List regTypes = this.getRegisteredTypes();
        int mask = 0;
        Iterator it = regTypes.iterator();
        while (it.hasNext()) {
            ConnectionCookie.Type t = (ConnectionCookie.Type)it.next();
            if (t instanceof JavaConnections.Type) {
                mask |= ((JavaConnections.Type)t).getFilter();
                continue;
            }
            System.err.println("WARNING: Unknown listener type: " + t);
        }
        return mask;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean checkType(Type t) {
        if (!t.isPrimitive()) ** GOTO lbl4
        return true;
lbl-1000:
        // 1 sources

        {
            t = t.getElementType();
lbl4:
            // 2 sources

            ** while (t.isArray())
        }
lbl5:
        // 1 sources

        if (t.isPrimitive()) {
            return true;
        }
        return this.checkIdentifier(t.getTypeIdentifier());
    }

    protected boolean checkIdentifier(Identifier id) {
        if (id == null) {
            return true;
        }
        return id.getResolutionStatus() != 0;
    }

    protected boolean isMature(int type, Element test, Element hint) {
        return this.checkIsMature(type, test, hint);
    }

    private void reportChange(JavaConnections.Change ch) {
        int type;
        int op = type = ch.getChangeType();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < 5) {
            if ((type & EVENT_TYPES[i]) == 0) {
                op >>= 4;
            } else {
                sb.append(EVENT_TYPE_NAMES[i]);
                sb.append('-');
                sb.append(EVENT_OPERATION_NAMES[op & 7]);
                sb.append('(');
                sb.append(new Integer(op).toString());
                sb.append(')');
            }
            ++i;
        }
        sb.append(':');
        if ((type & 0x11111) > 0) {
            ModelEventAdapter.reportElementIDs(sb, Arrays.asList(ch.getElements()));
        }
        if ((type & 0x22222) > 0) {
            ModelEventAdapter.reportElementIDs(sb, Arrays.asList(ch.getElements()));
        }
        if ((type & 0x44444) > 0) {
            ModelEventAdapter.reportElementIDs(sb, Collections.singleton(ch.getNewElement()));
        }
        System.err.println(sb.toString());
    }

    private void reportFiredChanges(Collection changes) {
        Iterator it = changes.iterator();
        while (it.hasNext()) {
            JavaConnections.Change ch = (JavaConnections.Change)it.next();
            this.reportChange(ch);
        }
    }

    static String reportElementID(Element e) {
        StringBuffer sb = new StringBuffer();
        ModelEventAdapter.reportElementIDs(sb, Collections.singletonList(e));
        return sb.toString();
    }

    static void reportElementIDs(StringBuffer sb, Collection c) {
        boolean first = true;
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Element el;
            if (!first) {
                sb.append(", ");
            }
            if ((el = (Element)it.next()) instanceof FieldElement) {
                sb.append(((FieldElement)el).getName().toString());
            } else if (el instanceof InitializerElement) {
                sb.append("<initializer>");
            } else if (el instanceof ConstructorElement) {
                sb.append(((ConstructorElement)el).getName().toString());
                sb.append(ModelEventAdapter.reportParameters((ConstructorElement)el));
            } else if (el instanceof ClassElement) {
                sb.append(((ClassElement)el).getName().getFullName());
            } else {
                sb.append("<" + el + ">");
                continue;
            }
            first = false;
        }
    }

    private static String reportParameters(ConstructorElement e) {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        MethodParameter[] pars = e.getParameters();
        int i = 0;
        while (i < pars.length) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(pars[i].toString());
            ++i;
        }
        sb.append(')');
        return sb.toString();
    }

    private boolean checkIsMature(int type, Element test, Element hint) {
        switch (type) {
            case 0: {
                return this.checkType(((FieldElement)test).getType());
            }
            case 1: {
                if (!this.checkType(((MethodElement)test).getReturn())) {
                    return false;
                }
            }
            case 3: {
                ConstructorElement cons = (ConstructorElement)test;
                MethodParameter[] pars = cons.getParameters();
                int i = 0;
                while (i < pars.length) {
                    if (!this.checkType(pars[i].getType())) {
                        return false;
                    }
                    ++i;
                }
                Identifier[] exs = cons.getExceptions();
                int i2 = 0;
                while (i2 < exs.length) {
                    if (!this.checkIdentifier(exs[i2])) {
                        return false;
                    }
                    ++i2;
                }
                break;
            }
            case 2: {
                ClassElement c = (ClassElement)test;
                if (!this.checkIdentifier(c.getSuperclass())) {
                    return false;
                }
                Identifier[] its = c.getInterfaces();
                int i = 0;
                while (i < its.length) {
                    if (!this.checkIdentifier(its[i])) {
                        return false;
                    }
                    ++i;
                }
                break;
            }
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ModelEventAdapter.EVENT_TYPES[0] = 7;
        ModelEventAdapter.EVENT_TYPES[1] = 112;
        ModelEventAdapter.EVENT_TYPES[2] = 1792;
        ModelEventAdapter.EVENT_TYPES[3] = 28672;
        ModelEventAdapter.EVENT_TYPES[4] = 458752;
        EVENT_TYPE_NAMES = new String[]{"Fields", "Methods", "Classes", "Constructors", "Initializers"};
        EVENT_OPERATION_NAMES = new String[]{"0", "add", "remove", "undefined", "change", "5", "6", "7"};
    }

    protected class Cache
    extends ChangeCache {
        int elementType;

        Cache(int type) {
            this.elementType = type;
        }

        protected boolean isMature(Element one, Element two) {
            return ModelEventAdapter.this.isMature(this.elementType, one, two);
        }
    }

    private static class Change
    extends JavaConnections.Change {
        Change(int type, Collection items) {
            super(type, null, null, items.toArray(EMPTY_ELEMENT_ARRAY));
        }

        Change(int type, Element old, Element n) {
            super(type, old, n, null);
        }
    }
}

