/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.environment;

import java.awt.Image;
import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.netbeans.modules.java.environment.LibraryArchive;
import org.netbeans.modules.java.environment.Utilities;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.XMLDataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.xml.sax.AttributeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class LibraryProcessor
extends FilterNode
implements XMLDataObject.Processor,
InstanceCookie {
    static final String TAG_LIBRARY_OLD = "Library";
    static final String TAG_LIBRARY = "library";
    static final String TAG_ARCHIVE_OLD = "Archive";
    static final String TAG_ARCHIVE = "archive";
    static final String ATTR_NAME = "name";
    static final String ATTR_COMPILE = "compile";
    static final String ATTR_EXECUTE = "execute";
    static final String ATTR_DEBUG = "debug";
    static final String ATTR_DOCUMENT = "document";
    static final String VALUE_YES = "yes";
    private static final char FILE_SEPARATOR = File.separatorChar;
    protected XMLDataObject xmlDataObject;
    FileSystem libraryFileSystem;
    static /* synthetic */ Class class$org$netbeans$modules$java$environment$LibraryProcessor;
    static /* synthetic */ Class class$org$netbeans$modules$java$environment$LibraryArchive;

    public LibraryProcessor() {
        super((Node)new AbstractNode(Children.LEAF), Children.LEAF);
        this.disableDelegation(48);
    }

    public String getShortDescription() {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$java$environment$LibraryProcessor == null ? (class$org$netbeans$modules$java$environment$LibraryProcessor = LibraryProcessor.class$("org.netbeans.modules.java.environment.LibraryProcessor")) : class$org$netbeans$modules$java$environment$LibraryProcessor)).getString("HINT_javaClassLibrary");
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public Image getIcon(int type) {
        return org.openide.util.Utilities.loadImage((String)"org/netbeans/modules/java/resources/library.gif");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.java.Filesystem.libraryFS");
    }

    public void attachTo(XMLDataObject xmlDO) {
        this.xmlDataObject = xmlDO;
        this.changeOriginal((Node)new DataNode((DataObject)xmlDO, Children.LEAF), false);
    }

    public Object instanceCreate() throws IOException, ClassNotFoundException {
        if (this.libraryFileSystem != null) {
            return this.libraryFileSystem;
        }
        this.loadLibrary(this.xmlDataObject);
        return this.libraryFileSystem;
    }

    public Class instanceClass() {
        return class$org$netbeans$modules$java$environment$LibraryArchive == null ? (class$org$netbeans$modules$java$environment$LibraryArchive = LibraryProcessor.class$("org.netbeans.modules.java.environment.LibraryArchive")) : class$org$netbeans$modules$java$environment$LibraryArchive;
    }

    public String instanceName() {
        return this.instanceClass().getName();
    }

    static void throwNotFoundException(DataObject mountPoint, String mountedResource) throws SAXException {
        ErrorManager man = ErrorManager.getDefault();
        String message = MessageFormat.format(Utilities.getString("FMT_ResourceNotFound"), mountedResource, mountPoint.getPrimaryFile().toString());
        throw (SAXException)man.annotate((Throwable)new SAXException("Mount resource not found"), 256, null, message, null, null);
    }

    private void loadLibrary(XMLDataObject xml) throws IOException {
        HandlerBase handler = new HandlerBase(){
            private boolean inLibrary = false;
            private boolean inArchive = false;
            private FileSystemCapability.Bean capBean = new FileSystemCapability.Bean();
            private File archiveRoot;
            private boolean capSpecified = false;

            public void startElement(String name, AttributeList attrlist) throws SAXException {
                if (LibraryProcessor.TAG_LIBRARY.equals(name) || LibraryProcessor.TAG_LIBRARY_OLD.equals(name)) {
                    this.inLibrary = true;
                } else if (this.inLibrary && (LibraryProcessor.TAG_ARCHIVE.equals(name) || LibraryProcessor.TAG_ARCHIVE_OLD.equals(name))) {
                    String nameString = attrlist.getValue(LibraryProcessor.ATTR_NAME);
                    if (nameString == null) {
                        return;
                    }
                    if (FILE_SEPARATOR != '/') {
                        nameString.replace('/', FILE_SEPARATOR);
                    }
                    this.archiveRoot = Utilities.findInstalledFile(nameString);
                    if (this.archiveRoot == null) {
                        LibraryProcessor.throwNotFoundException((DataObject)LibraryProcessor.this.xmlDataObject, nameString);
                    }
                    String v = attrlist.getValue(LibraryProcessor.ATTR_COMPILE);
                    this.capBean.setCompile(LibraryProcessor.VALUE_YES.equals(v));
                    this.capSpecified |= v != null;
                    v = attrlist.getValue(LibraryProcessor.ATTR_DEBUG);
                    this.capBean.setDebug(LibraryProcessor.VALUE_YES.equals(v));
                    this.capSpecified |= v != null;
                    v = attrlist.getValue(LibraryProcessor.ATTR_EXECUTE);
                    this.capBean.setExecute(LibraryProcessor.VALUE_YES.equals(v));
                    this.capSpecified |= v != null;
                    v = attrlist.getValue(LibraryProcessor.ATTR_DOCUMENT);
                    this.capBean.setDoc(LibraryProcessor.VALUE_YES.equals(v));
                    this.capSpecified |= v != null;
                }
            }

            public void endElement(String name) throws SAXException {
                if (LibraryProcessor.TAG_LIBRARY.equals(name) || LibraryProcessor.TAG_LIBRARY_OLD.equals(name)) {
                    this.inLibrary = false;
                } else if (LibraryProcessor.TAG_ARCHIVE.equals(name) || LibraryProcessor.TAG_ARCHIVE_OLD.equals(name)) {
                    String systemName = LibraryProcessor.this.xmlDataObject.getPrimaryFile().getPackageNameExt('/', '.');
                    LibraryArchive jfs = this.capSpecified ? new LibraryArchive(systemName, (FileSystemCapability)this.capBean) : new LibraryArchive(systemName);
                    try {
                        jfs.setJarFile(this.archiveRoot);
                        jfs.setHidden(true);
                        LibraryProcessor.this.libraryFileSystem = jfs;
                    }
                    catch (PropertyVetoException ex) {
                        ex.printStackTrace();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    this.inArchive = false;
                }
            }
        };
        Parser parser = XMLDataObject.createParser();
        parser.setDocumentHandler(handler);
        parser.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String pubid, String sysid) {
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
        });
        try {
            parser.parse(new InputSource(xml.getPrimaryFile().getInputStream()));
        }
        catch (SAXException e) {
            IOException ex = new IOException();
            ErrorManager.getDefault().annotate((Throwable)ex, (Throwable)e);
            throw ex;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

