/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.imptool;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.JavaEditor;
import org.netbeans.modules.java.imptool.BodyIdentifier;
import org.netbeans.modules.java.imptool.IdentifierNode;
import org.netbeans.modules.java.imptool.ImpDataSourceNode;
import org.netbeans.modules.java.imptool.ImpToolSettings;
import org.netbeans.modules.java.imptool.ImportLineNode;
import org.netbeans.modules.java.imptool.MethodParameterOwner;
import org.netbeans.modules.java.imptool.PackageNode;
import org.netbeans.modules.java.imptool.PackageResolver;
import org.netbeans.modules.java.imptool.SourceIdentifier;
import org.netbeans.modules.java.imptool.SourceIdentifiersList;
import org.netbeans.modules.java.imptool.SourceImport;
import org.openide.ErrorManager;
import org.openide.cookies.SourceCookie;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.Import;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.text.PositionBounds;
import org.openide.util.SharedClassObject;

public class ImpDataSource {
    private TreeMap sourceIDMap;
    private TreeMap packageMap;
    private TreeMap idNodes;
    private HashMap dupSimpleNames;
    private HashSet topCLassNames;
    private ImpToolSettings impSetting;
    private JavaDataObject dataObject;
    private PackageResolver packageResolver;
    private SourceCookie.Editor sourceEditor;
    private JavaEditor javaEditor;
    private SourceElement sourceElement;
    private String sourceFilePackageName;
    private int stage = 0;
    private static final int FQN_STAGE = 1;
    private static final int IMPORT_STAGE = 2;
    private static final int RESOLVE_STAGE = 3;
    private static final int COMMIT_STAGE = 4;
    static /* synthetic */ Class class$org$openide$cookies$SourceCookie$Editor;
    static /* synthetic */ Class class$org$netbeans$modules$java$JavaEditor;
    static /* synthetic */ Class class$org$netbeans$modules$java$imptool$ImpToolSettings;

    ImpDataSource(JavaDataObject jdo, Collection bodyIdentifiers) {
        Iterator bodyIdIt = bodyIdentifiers.iterator();
        this.dataObject = jdo;
        this.sourceEditor = (SourceCookie.Editor)jdo.getCookie(class$org$openide$cookies$SourceCookie$Editor == null ? (class$org$openide$cookies$SourceCookie$Editor = ImpDataSource.class$("org.openide.cookies.SourceCookie$Editor")) : class$org$openide$cookies$SourceCookie$Editor);
        this.javaEditor = (JavaEditor)jdo.getCookie(class$org$netbeans$modules$java$JavaEditor == null ? (class$org$netbeans$modules$java$JavaEditor = ImpDataSource.class$("org.netbeans.modules.java.JavaEditor")) : class$org$netbeans$modules$java$JavaEditor);
        this.sourceElement = jdo.getSource();
        this.sourceIDMap = new TreeMap();
        this.packageMap = new TreeMap();
        this.idNodes = new TreeMap();
        this.dupSimpleNames = new HashMap();
        this.topCLassNames = new HashSet();
        this.impSetting = (ImpToolSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$java$imptool$ImpToolSettings == null ? (class$org$netbeans$modules$java$imptool$ImpToolSettings = ImpDataSource.class$("org.netbeans.modules.java.imptool.ImpToolSettings")) : class$org$netbeans$modules$java$imptool$ImpToolSettings), (boolean)true);
        ClassElement[] classArray = this.sourceElement.getAllClasses();
        Identifier sourceFilePackage = this.sourceElement.getPackage();
        this.sourceFilePackageName = sourceFilePackage != null ? sourceFilePackage.getSourceName() : "";
        int i = 0;
        while (i < classArray.length) {
            ClassElement clsEl = classArray[i];
            FieldElement[] fields = clsEl.getFields();
            ConstructorElement[] constructors = clsEl.getConstructors();
            MethodElement[] methods = clsEl.getMethods();
            Identifier superClass = clsEl.getSuperclass();
            this.topCLassNames.add(clsEl.getName().getFullName());
            if (!this.isGuarded((org.openide.src.Element)clsEl)) {
                if (superClass != null) {
                    this.addIdentifier(superClass, 1, clsEl);
                }
                this.addIdentifierFromArray(clsEl.getInterfaces(), 2, (org.openide.src.Element)clsEl);
            }
            int j = 0;
            while (j < fields.length) {
                FieldElement fEl = fields[j];
                if (!this.isGuarded((org.openide.src.Element)fEl)) {
                    this.addIdentifierFromType(fEl.getType(), fEl);
                }
                ++j;
            }
            j = 0;
            while (j < constructors.length) {
                ConstructorElement constructor = constructors[j];
                if (!this.isGuarded((org.openide.src.Element)constructor)) {
                    this.addIdentifierFromMethodParams(constructor);
                    this.addIdentifierFromArray(constructor.getExceptions(), 3, (org.openide.src.Element)constructor);
                }
                ++j;
            }
            j = 0;
            while (j < methods.length) {
                MethodElement method = methods[j];
                if (!this.isGuarded((org.openide.src.Element)method)) {
                    this.addIdentifierFromMethodParams((ConstructorElement)method);
                    this.addIdentifierFromArray(method.getExceptions(), 3, (org.openide.src.Element)method);
                    this.addIdentifierFromType(method.getReturn(), method);
                }
                ++j;
            }
            ++i;
        }
        while (bodyIdIt.hasNext()) {
            BodyIdentifier bId = (BodyIdentifier)bodyIdIt.next();
            if (this.isGuardedIndetifier(bId)) continue;
            this.addIdentifier(bId.getIdentifier(), 4, bId);
        }
        Import[] imports = this.sourceElement.getImports();
        i = 0;
        while (i < imports.length) {
            SourceImport srcImp = new SourceImport(imports[i]);
            srcImp.setUsed(!this.impSetting.isRemoveImport());
            this.addImport(srcImp);
            ++i;
        }
        if (this.impSetting.getResolveStrategy() == 1) {
            this.tryResolveIdetifiers();
        }
    }

    private void addIdentifierFromType(Type type, Object owner) {
        if (type.isClass()) {
            this.addIdentifier(type.getTypeIdentifier(), 0, owner);
        } else if (type.isArray()) {
            this.addIdentifierFromType(type.getElementType(), owner);
        }
    }

    private void addIdentifierFromMethodParams(ConstructorElement el) {
        MethodParameter[] pars = el.getParameters();
        int i = 0;
        while (i < pars.length) {
            MethodParameterOwner owner = new MethodParameterOwner(el, i);
            this.addIdentifierFromType(pars[i].getType(), owner);
            ++i;
        }
    }

    private void addIdentifierFromArray(Identifier[] ids, int type, org.openide.src.Element owner) {
        int i = 0;
        while (i < ids.length) {
            this.addIdentifier(ids[i], type, owner);
            ++i;
        }
    }

    private void addIdentifier(Identifier id, int type, Object owner) {
        if (this.onlySimpleNameAllowed(id)) {
            return;
        }
        SourceIdentifier srcid = new SourceIdentifier(id, type, owner);
        this.addObjectToMap(this.sourceIDMap, srcid.getPackage(), srcid.getName(), srcid);
        if (id.getResolutionStatus() == 2) {
            String idKey = id.getSourceName();
            IdentifierNode idNode = (IdentifierNode)((Object)this.idNodes.get(idKey));
            if (idNode == null) {
                SourceIdentifiersList srcList = new SourceIdentifiersList(this);
                srcList.addSourceIdentifier(srcid);
                idNode = new IdentifierNode(srcList);
                this.idNodes.put(idKey, idNode);
            } else {
                idNode.add(srcid);
            }
        }
    }

    private void addImport(SourceImport imp) {
        String packageName = imp.getPackage();
        String className = imp.isPackage() ? "*" : imp.getName();
        TreeMap<String, SourceImport> simpleNameMap = (TreeMap<String, SourceImport>)this.packageMap.get(packageName);
        if (simpleNameMap == null) {
            simpleNameMap = new TreeMap<String, SourceImport>();
            this.packageMap.put(packageName, simpleNameMap);
        }
        simpleNameMap.put(className, imp);
    }

    private void addObjectToMap(TreeMap map, String packageName, String className, SourceIdentifier o) {
        SourceIdentifiersList objs;
        TreeMap<String, SourceIdentifiersList> nameMap = (TreeMap<String, SourceIdentifiersList>)map.get(packageName);
        if (nameMap == null) {
            nameMap = new TreeMap<String, SourceIdentifiersList>();
            map.put(packageName, nameMap);
        }
        if ((objs = (SourceIdentifiersList)nameMap.get(className)) == null) {
            objs = new SourceIdentifiersList(this);
            nameMap.put(className, objs);
        }
        objs.addSourceIdentifier(o);
    }

    private void checkDupNames(HashMap simpleNames, SourceIdentifiersList array) {
        if (array.count() == 0) {
            return;
        }
        String simpleName = array.getName();
        List dupNamesList = (List)this.dupSimpleNames.get(simpleName);
        if (dupNamesList != null) {
            dupNamesList.add(array);
        } else {
            SourceIdentifiersList dupName = (SourceIdentifiersList)simpleNames.get(simpleName);
            if (dupName != null) {
                ArrayList<SourceIdentifiersList> n = new ArrayList<SourceIdentifiersList>();
                n.add(dupName);
                n.add(array);
                this.dupSimpleNames.put(simpleName, n);
            } else {
                simpleNames.put(simpleName, array);
            }
        }
    }

    private boolean isImplicitlyImported(String packageName) {
        if (packageName == "") {
            return true;
        }
        if (packageName.equals("java.lang")) {
            return true;
        }
        return packageName.equals(this.sourceFilePackageName);
    }

    private boolean onlySimpleNameAllowed(Identifier id) {
        if (id.getResolutionStatus() != 1) {
            return false;
        }
        String fqn = id.getFullName();
        if (!fqn.startsWith(this.sourceFilePackageName)) {
            return false;
        }
        Iterator it = this.topCLassNames.iterator();
        while (it.hasNext()) {
            String topClassName = (String)it.next();
            if (!fqn.startsWith(topClassName)) continue;
            return true;
        }
        return false;
    }

    ImpDataSourceNode createRootFQNNode() {
        Node[] template = new Node[]{};
        Children.Array ch = new Children.Array();
        ch.add(this.idNodes.values().toArray(template));
        this.stage = 1;
        return new ImpDataSourceNode((Children)ch, 0);
    }

    ImpDataSourceNode createRootImportNode() {
        Node[] template = new Node[]{};
        Children.Array ch = new Children.Array();
        Iterator packageNameIt = this.sourceIDMap.keySet().iterator();
        ArrayList<PackageNode> packageArray = new ArrayList<PackageNode>();
        HashMap simpleNames = new HashMap();
        while (packageNameIt.hasNext()) {
            String packageName = (String)packageNameIt.next();
            if (packageName == "") continue;
            boolean isSpecialPackage = this.isImplicitlyImported(packageName);
            TreeMap nameMap = (TreeMap)this.sourceIDMap.get(packageName);
            Iterator nameIt = nameMap.values().iterator();
            while (nameIt.hasNext()) {
                SourceIdentifiersList array = (SourceIdentifiersList)nameIt.next();
                this.checkDupNames(simpleNames, array);
                packageArray.add(new PackageNode(array));
                if (isSpecialPackage) continue;
                this.setFQNDefaultFlagFor(array);
            }
        }
        ch.add(packageArray.toArray(template));
        this.stage = 2;
        return new ImpDataSourceNode((Children)ch, 1);
    }

    ImpDataSourceNode createRootResolveNode() {
        Children.Array ch = new Children.Array();
        int i = 0;
        this.mergeSourceIDToPackages();
        Collection packageArray = this.packageMap.values();
        Iterator pckIt = packageArray.iterator();
        Node[] packageNodes = new Node[packageArray.size()];
        while (pckIt.hasNext()) {
            TreeMap nameMap = (TreeMap)pckIt.next();
            packageNodes[i++] = ImportLineNode.createPackageNode(nameMap.values());
        }
        ch.add(packageNodes);
        this.stage = 3;
        return new ImpDataSourceNode((Children)ch, 2);
    }

    void setPackage(String packageName, SourceIdentifier srcId) {
        TreeMap nameMap = (TreeMap)this.sourceIDMap.get(srcId.getPackage());
        String className = srcId.getName();
        if (nameMap == null) {
            throw new IllegalArgumentException("Package TreeMap mismatch");
        }
        SourceIdentifiersList array = (SourceIdentifiersList)nameMap.get(className);
        if (array == null) {
            throw new IllegalArgumentException("Name TreeMap mismatch");
        }
        if (!array.removeSourceIdentifier(srcId)) {
            throw new IllegalArgumentException("Array mismatch");
        }
        if (array.count() == 0) {
            nameMap.remove(className);
        }
        srcId.setPackage(packageName);
        this.addObjectToMap(this.sourceIDMap, packageName, className, srcId);
    }

    void setFQNDefaultFlagFor(SourceIdentifiersList srcArray) {
        int size = srcArray.count();
        int fqnFlag = size > this.impSetting.getMaxFqn() ? 2 : 1;
        srcArray.setFQNFlag(fqnFlag);
    }

    void mergeSourceIDToPackages() {
        SourceImport srcImp;
        Iterator packageNameIt = this.sourceIDMap.keySet().iterator();
        while (packageNameIt.hasNext()) {
            String packageName = (String)packageNameIt.next();
            if (this.isImplicitlyImported(packageName)) continue;
            TreeMap nameImportMap = (TreeMap)this.packageMap.get(packageName);
            TreeMap nameMap = (TreeMap)this.sourceIDMap.get(packageName);
            Iterator nameIt = nameMap.keySet().iterator();
            while (nameIt.hasNext()) {
                String className = (String)nameIt.next();
                SourceIdentifiersList srcList = (SourceIdentifiersList)nameMap.get(className);
                if (srcList.reallyUseFQN()) continue;
                srcImp = null;
                if (nameImportMap != null) {
                    srcImp = (SourceImport)nameImportMap.get(className);
                }
                if (srcImp == null) {
                    srcImp = new SourceImport(packageName, className);
                    this.addImport(srcImp);
                }
                srcImp.setUsed(true);
            }
        }
        Iterator importMapIt = this.packageMap.keySet().iterator();
        while (importMapIt.hasNext()) {
            String packageName = (String)importMapIt.next();
            TreeMap nameImportMap = (TreeMap)this.packageMap.get(packageName);
            if (nameImportMap.get("*") == null) {
                srcImp = new SourceImport(packageName, "*");
                srcImp.setUsed(false);
                this.addImport(srcImp);
            }
            this.setUseDefaultFlagFor(nameImportMap);
        }
    }

    void setUseDefaultFlagFor(TreeMap nameImportMap) {
        Iterator impIt = nameImportMap.values().iterator();
        int usedImports = 0;
        SourceImport packageImport = null;
        while (impIt.hasNext()) {
            SourceImport srcImp = (SourceImport)impIt.next();
            if (srcImp.isPackage()) {
                packageImport = srcImp;
                continue;
            }
            if (!srcImp.isUse()) continue;
            ++usedImports;
        }
        if (packageImport != null) {
            if (usedImports > this.impSetting.getSingleImports()) {
                packageImport.setUse(true);
            } else {
                packageImport.setUse(false);
            }
        }
    }

    void commitIdentifiers() throws SourceException, IOException, BadLocationException {
        Iterator classMapIt = this.sourceIDMap.values().iterator();
        while (classMapIt.hasNext()) {
            Iterator classArrayIt = ((TreeMap)classMapIt.next()).values().iterator();
            while (classArrayIt.hasNext()) {
                SourceIdentifiersList srcIdList = (SourceIdentifiersList)classArrayIt.next();
                srcIdList.commit();
            }
        }
    }

    void commitImports() throws SourceException {
        Iterator classMapIt = this.packageMap.values().iterator();
        ArrayList allImports = new ArrayList();
        Import[] impArray = new Import[]{};
        while (classMapIt.hasNext()) {
            TreeMap nameImportMap = (TreeMap)classMapIt.next();
            SourceImport srcImp = (SourceImport)nameImportMap.get("*");
            if (this.addImportToList(allImports, srcImp)) continue;
            Iterator impArrayIt = nameImportMap.values().iterator();
            while (impArrayIt.hasNext()) {
                this.addImportToList(allImports, (SourceImport)impArrayIt.next());
            }
        }
        impArray = allImports.toArray(impArray);
        this.dataObject.getSource().setImports(impArray);
    }

    private void commitAllChanges() {
        final Exception[] ex = new Exception[]{null};
        this.dataObject.suspendSupports();
        try {
            this.sourceElement.runAtomicAsUser(new Runnable(){

                public void run() {
                    try {
                        ImpDataSource.this.commitIdentifiers();
                        ImpDataSource.this.commitImports();
                    }
                    catch (Exception e) {
                        ex[0] = e;
                    }
                }
            });
        }
        catch (SourceException e) {
            ex[0] = e;
        }
        this.dataObject.resumeSupports();
        if (ex[0] != null) {
            ErrorManager.getDefault().notify((Throwable)ex[0]);
        }
    }

    private boolean addImportToList(List allImports, SourceImport srcImp) {
        if (srcImp.isUse()) {
            allImports.add(srcImp.getImport());
            return true;
        }
        return false;
    }

    private Collection getAllPackages() {
        String[] defaultPackages = this.impSetting.getResolvePlaces();
        HashSet allPackages = new HashSet(this.sourceIDMap.keySet());
        Set impPackages = this.packageMap.keySet();
        allPackages.remove("");
        impPackages.remove("");
        allPackages.addAll(impPackages);
        int i = 0;
        while (i < defaultPackages.length) {
            String defaultPackage = defaultPackages[i];
            if (defaultPackage.length() > 0) {
                allPackages.add(defaultPackage);
            }
            ++i;
        }
        return allPackages;
    }

    PackageResolver getPackageResolver() {
        if (this.packageResolver == null) {
            this.packageResolver = new PackageResolver(this.getAllPackages());
        }
        return this.packageResolver;
    }

    Collection getDupSimpleName(String simpleName) {
        return (Collection)this.dupSimpleNames.get(simpleName);
    }

    private void tryResolveIdetifiers() {
        TreeMap classMap = (TreeMap)this.sourceIDMap.get("");
        if (classMap != null) {
            classMap = (TreeMap)classMap.clone();
            Iterator arrIt = classMap.values().iterator();
            PackageResolver res = this.getPackageResolver();
            while (arrIt.hasNext()) {
                SourceIdentifiersList arr = (SourceIdentifiersList)arrIt.next();
                String packageName = res.getPackageForClass(arr.getName());
                if (packageName == null) continue;
                arr.setPackage(packageName);
            }
        }
    }

    void runSilentFromNextStage() {
        switch (this.stage + 1) {
            case 1: {
                this.createRootFQNNode();
            }
            case 2: {
                this.createRootImportNode();
            }
            case 3: {
                this.createRootResolveNode();
            }
            case 4: {
                this.commitAllChanges();
            }
        }
    }

    private boolean isGuarded(org.openide.src.Element el) {
        if (this.sourceEditor != null && this.javaEditor != null) {
            PositionBounds bounds;
            Element textEl = this.sourceEditor.sourceToText(el);
            int start = textEl.getStartOffset();
            int end = textEl.getEndOffset() - 1;
            if (!textEl.isLeaf()) {
                Element firstTextEl = textEl.getElement(0);
                end = firstTextEl.getStartOffset() - 1;
            }
            return !this.javaEditor.testOverlap(bounds = this.javaEditor.createBounds(start, end, true));
        }
        return false;
    }

    private boolean isGuardedIndetifier(BodyIdentifier bId) {
        if (this.javaEditor != null) {
            return !this.javaEditor.testOverlap(bId.getBounds());
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

