/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.imptool;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.accessibility.AccessibleContext;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.java.imptool.ImpDataSource;
import org.netbeans.modules.java.imptool.Util;
import org.openide.WizardDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerPanel;
import org.openide.explorer.view.TreeTableView;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;

abstract class RootPanel
extends JPanel
implements WizardDescriptor.Panel,
WizardDescriptor.FinishPanel {
    ImpDataSource dataSource;
    boolean initialized = false;
    private static final String PROP_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";
    private TreeTableView ttv;

    void initialize() {
        if (!this.initialized) {
            this.initAllComponents();
            this.setPreferredSize(new Dimension(560, 350));
            this.initialized = true;
        }
    }

    public Component getComponent() {
        this.initialize();
        return this;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("java.import");
    }

    public void readSettings(Object settings) {
        this.dataSource = (ImpDataSource)settings;
    }

    public void storeSettings(Object settings) {
    }

    public boolean isValid() {
        return true;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    public void setHighlight(int number) {
        this.putClientProperty(PROP_CONTENT_SELECTED_INDEX, new Integer(number));
    }

    void addTableView(Node masterNode, JScrollPane tv) {
        ExplorerManager em = new ExplorerManager();
        em.setRootContext(masterNode);
        ExplorerPanel ep = new ExplorerPanel(em);
        ep.setLayout(new BorderLayout());
        ep.add("Center", tv);
        this.add((Component)ep, "Center");
    }

    void initListTableView(Node masterNode, int width) {
        if (masterNode.getChildren().getNodesCount() != 0) {
            TreeTableView ltv = new TreeTableView();
            AccessibleContext ac = ltv.getAccessibleContext();
            ac.setAccessibleName(Util.getString("ACS_ListTableViewA11yName"));
            ac.setAccessibleDescription(Util.getString("ACS_ListTableViewA11yDesc"));
            ltv.setPopupAllowed(false);
            ltv.setTableAutoResizeMode(4);
            ltv.setRootVisible(false);
            Node.Property[] props = this.getPropertiesFrom(masterNode);
            if (props != null) {
                ltv.setProperties(props);
            }
            this.addTableView(masterNode, (JScrollPane)ltv);
            ltv.setTreePreferredWidth(width);
        } else {
            this.addNoRowsLabel();
        }
    }

    void initTreeTableView(Node masterNode) {
        if (masterNode.getChildren().getNodesCount() != 0) {
            this.ttv = new TreeTableView();
            AccessibleContext ac = this.ttv.getAccessibleContext();
            ac.setAccessibleName(Util.getString("ACS_TreeTableViewA11yName"));
            ac.setAccessibleDescription(Util.getString("ACS_TreeTableViewA11yDesc"));
            this.ttv.setPopupAllowed(false);
            this.ttv.setTableAutoResizeMode(4);
            Node.Property[] props = this.getPropertiesFrom(masterNode);
            if (props != null) {
                this.ttv.setProperties(props);
            }
            this.addTableView(masterNode, (JScrollPane)this.ttv);
            this.ttv.setTreePreferredWidth(320);
        } else {
            this.addNoRowsLabel();
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.ttv != null) {
            this.ttv.expandAll();
            this.ttv = null;
        }
    }

    Node.Property[] getPropertiesFrom(Node masterNode) {
        Node.PropertySet[] sets;
        Node[] nodes = masterNode.getChildren().getNodes();
        if (nodes.length > 0 && (sets = nodes[0].getPropertySets()).length > 0) {
            return sets[0].getProperties();
        }
        return null;
    }

    private void addNoRowsLabel() {
        JLabel noRowText = new JLabel();
        noRowText.setText(Util.getString(this.noRowsText()));
        this.add((Component)noRowText, "North");
    }

    abstract void initAllComponents();

    public abstract String getName();

    abstract String noRowsText();
}

