/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.imptool;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.java.imptool.ImpDataSource;
import org.netbeans.modules.java.imptool.SourceIdentifier;
import org.openide.src.SourceException;

class SourceIdentifiersList {
    private List sourceIdentifiers = new ArrayList();
    private ImpDataSource datasource;
    private PropertyChangeSupport propSupport;
    static final String PROP_FQN_FLAG = "FQN_FLAG";

    SourceIdentifiersList(ImpDataSource source) {
        this.datasource = source;
    }

    boolean addSourceIdentifier(SourceIdentifier srcId) {
        return this.sourceIdentifiers.add(srcId);
    }

    boolean removeSourceIdentifier(SourceIdentifier srcId) {
        return this.sourceIdentifiers.remove(srcId);
    }

    int getFQNFlag() {
        Iterator it = this.sourceIdentifiers.iterator();
        if (it.hasNext()) {
            SourceIdentifier srcId = (SourceIdentifier)it.next();
            return srcId.getUseFQN();
        }
        return 0;
    }

    void setFQNFlag(int fqnFlag) {
        Iterator it = this.sourceIdentifiers.iterator();
        if (!it.hasNext()) {
            return;
        }
        String simpleName = this.getName();
        Collection dupNamesList = this.datasource.getDupSimpleName(simpleName);
        if (dupNamesList != null && fqnFlag != 1) {
            Iterator dupIt = dupNamesList.iterator();
            while (dupIt.hasNext()) {
                SourceIdentifiersList array = (SourceIdentifiersList)dupIt.next();
                if (array == this) continue;
                array.setFQNFlag(1);
            }
        }
        do {
            SourceIdentifier srcId = (SourceIdentifier)it.next();
            srcId.setUseFQN(fqnFlag);
        } while (it.hasNext());
        if (this.propSupport != null) {
            this.propSupport.firePropertyChange(PROP_FQN_FLAG, null, null);
        }
    }

    void setPackage(String packageName) {
        Iterator idIt = ((AbstractList)new ArrayList(this.sourceIdentifiers)).iterator();
        while (idIt.hasNext()) {
            SourceIdentifier srcId = (SourceIdentifier)idIt.next();
            this.datasource.setPackage(packageName, srcId);
        }
    }

    void commit() throws SourceException, IOException, BadLocationException {
        Iterator idIt = this.sourceIdentifiers.iterator();
        while (idIt.hasNext()) {
            SourceIdentifier srcId = (SourceIdentifier)idIt.next();
            srcId.commit();
        }
    }

    int count() {
        return this.sourceIdentifiers.size();
    }

    int fqnCount() {
        Iterator it = this.sourceIdentifiers.iterator();
        int count = 0;
        while (it.hasNext()) {
            SourceIdentifier srcId = (SourceIdentifier)it.next();
            if (!srcId.reallyUseFQN()) continue;
            ++count;
        }
        return count;
    }

    String getName() {
        if (this.sourceIdentifiers.isEmpty()) {
            return "";
        }
        return ((SourceIdentifier)this.sourceIdentifiers.get(0)).getName();
    }

    String getFQN() {
        SourceIdentifier id = this.getSourceIdentifier();
        if (id == null) {
            return "";
        }
        return id.getFQN();
    }

    String getPackage() {
        SourceIdentifier id = this.getSourceIdentifier();
        if (id == null) {
            return "";
        }
        return id.getPackage();
    }

    String getSourceText() {
        SourceIdentifier id = this.getSourceIdentifier();
        if (id == null) {
            return "";
        }
        return id.getSourceText();
    }

    boolean reallyUseFQN() {
        return this.fqnCount() == this.count();
    }

    private SourceIdentifier getSourceIdentifier() {
        if (this.sourceIdentifiers.isEmpty()) {
            return null;
        }
        return (SourceIdentifier)this.sourceIdentifiers.get(0);
    }

    void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.propSupport == null) {
            SourceIdentifiersList sourceIdentifiersList = this;
            synchronized (sourceIdentifiersList) {
                if (this.propSupport == null) {
                    this.propSupport = new PropertyChangeSupport(this);
                }
            }
        }
        this.propSupport.addPropertyChangeListener(l);
    }

    void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.propSupport == null) {
            return;
        }
        this.propSupport.removePropertyChangeListener(l);
    }
}

