/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.model;

import java.beans.PropertyChangeEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.netbeans.modules.java.ElementFactory;
import org.netbeans.modules.java.model.Binding;
import org.netbeans.modules.java.model.BindingFactory;
import org.netbeans.modules.java.model.CallableImpl;
import org.netbeans.modules.java.model.ClassElementImpl;
import org.netbeans.modules.java.model.CommitListener;
import org.netbeans.modules.java.model.ConstructorElementImpl;
import org.netbeans.modules.java.model.DefaultInsertStrategy;
import org.netbeans.modules.java.model.ElementImpl;
import org.netbeans.modules.java.model.EventQueue;
import org.netbeans.modules.java.model.ExceptionRunnable;
import org.netbeans.modules.java.model.FieldElementImpl;
import org.netbeans.modules.java.model.ImportImpl;
import org.netbeans.modules.java.model.InitializerElementImpl;
import org.netbeans.modules.java.model.LangModel;
import org.netbeans.modules.java.model.MethodElementImpl;
import org.netbeans.modules.java.model.Positioner;
import org.netbeans.modules.java.model.SourceElementImpl;
import org.netbeans.modules.java.model.WrapperFactory;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.Element;
import org.openide.src.Identifier;
import org.openide.src.Import;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.util.RequestProcessor;

public class DefaultLangModel
implements LangModel,
LangModel.Updater,
Runnable {
    private static boolean initialized;
    private static Class CLASS_MEMBER_IMPL;
    private static Class CLASS_INITIALIZER_IMPL;
    static final Positioner DEFAULT_POSITIONER;
    private Object locked;
    private LangModel.Env env;
    private Object writerNotify;
    private Thread writingThread;
    private int readerCount;
    private Thread reader;
    private BindingFactory bindingFactory;
    private WrapperFactory wrapperFactory;
    private EventQueue eventQueue;
    private int writeLocks;
    private int masterLocks;
    private boolean transactionCommited;
    private boolean transactionConstrained;
    private boolean eventDispatch;
    Collection preCommitListeners;
    Collection postCommitListeners;
    LinkedList outputQueue;
    boolean firingEvents;
    static /* synthetic */ Class class$org$netbeans$modules$java$model$ElementImpl;

    public DefaultLangModel(LangModel.Env env) {
        this.env = env;
        this.writerNotify = new Object();
        this.eventQueue = new EventQueue(null);
    }

    private static void initializeClasses() {
        if (initialized) {
            return;
        }
        try {
            CLASS_MEMBER_IMPL = Class.forName("org.netbeans.modules.java.model.MemberElementImpl");
            CLASS_INITIALIZER_IMPL = Class.forName("org.netbeans.modules.java.model.InitializerElementImpl");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        initialized = true;
    }

    public Object clone() {
        return null;
    }

    public ClassElementImpl createTopClass(SourceElement src) {
        ClassElementImpl c = new ClassElementImpl(this);
        this.getWrapper().wrapClass(c, (Element)src);
        c.setParent((Element)src);
        return c;
    }

    public ClassElementImpl createInnerClass(ClassElement parent) {
        ClassElementImpl c = new ClassElementImpl(this);
        this.getWrapper().wrapClass(c, (Element)parent);
        c.setParent((Element)parent);
        return c;
    }

    public FieldElementImpl createField(ClassElement parent) {
        FieldElementImpl impl = new FieldElementImpl(this);
        this.getWrapper().wrapField(impl, (Element)parent);
        impl.setParent((Element)parent);
        return impl;
    }

    public ConstructorElementImpl createConstructor(ClassElement parent) {
        ConstructorElementImpl impl = new ConstructorElementImpl(this);
        this.getWrapper().wrapConstructor(impl, (Element)parent);
        impl.setParent((Element)parent);
        return impl;
    }

    public MethodElementImpl createMethod(ClassElement parent) {
        MethodElementImpl impl = new MethodElementImpl(this);
        this.getWrapper().wrapMethod(impl, (Element)parent);
        impl.setParent((Element)parent);
        return impl;
    }

    public ImportImpl createImport(SourceElement parent) {
        ImportImpl impl = new ImportImpl(this);
        this.getWrapper().wrapImport(impl, (Element)parent);
        impl.setParent((Element)parent);
        return impl;
    }

    public InitializerElementImpl createInitializer(ClassElement parent) {
        InitializerElementImpl impl = new InitializerElementImpl(this);
        this.getWrapper().wrapInitializer(impl, (Element)parent);
        impl.setParent((Element)parent);
        return impl;
    }

    public SourceElementImpl createSource() {
        return new SourceElementImpl(this);
    }

    final Identifier resolveIdent(Element context, Identifier original) {
        return this.env.resolveTypeIdent(context, original);
    }

    final Type resolveType(Element context, Type t) {
        return this.env.resolveType(context, t);
    }

    public void addPreCommitListener(CommitListener l) {
        DefaultLangModel defaultLangModel = this;
        synchronized (defaultLangModel) {
            if (this.preCommitListeners == null) {
                this.preCommitListeners = new LinkedList();
            }
        }
        Collection collection = this.preCommitListeners;
        synchronized (collection) {
            this.preCommitListeners.add(l);
        }
    }

    public void addPostCommitListener(CommitListener l) {
        DefaultLangModel defaultLangModel = this;
        synchronized (defaultLangModel) {
            if (this.postCommitListeners == null) {
                this.postCommitListeners = new LinkedList();
            }
        }
        Collection collection = this.postCommitListeners;
        synchronized (collection) {
            this.postCommitListeners.add(l);
        }
    }

    public void removePreCommitListener(CommitListener l) {
        if (this.preCommitListeners == null) {
            return;
        }
        Collection collection = this.preCommitListeners;
        synchronized (collection) {
            this.preCommitListeners.remove(l);
        }
    }

    public void removePostCommitListener(CommitListener l) {
        if (this.postCommitListeners == null) {
            return;
        }
        Collection collection = this.postCommitListeners;
        synchronized (collection) {
            this.postCommitListeners.remove(l);
        }
    }

    final void notifyEventsDispatched(boolean dispatchOn) {
        this.eventDispatch = dispatchOn;
    }

    public final Object writeLock() {
        Object l = this.doWriteLock();
        if (this.masterLocks == -1) {
            this.createEventQueue();
        }
        return l;
    }

    private void createEventQueue() {
        this.eventQueue = new EventQueue(this.eventQueue);
    }

    final Object masterWriteLock() {
        Object l = this.doWriteLock();
        if (this.masterLocks > 0) {
            try {
                this.releaseWriteLock(l);
            }
            catch (SourceException sourceException) {
                // empty catch block
            }
            throw new IllegalStateException("Nested master locks!!");
        }
        this.masterLocks = this.writeLocks;
        this.eventQueue = new EventQueue(this.eventQueue);
        return l;
    }

    public Object tryWriteLock() {
        return this.tryWriteLock(false);
    }

    private Object tryWriteLock(boolean master) {
        Object object = this.writerNotify;
        synchronized (object) {
            if (this.locked == null || this.writingThread == Thread.currentThread()) {
                Object object2 = master ? this.masterWriteLock() : this.writeLock();
                return object2;
            }
        }
        return null;
    }

    public final Object doWriteLock() {
        Object object = this.writerNotify;
        synchronized (object) {
            if (this.writingThread == Thread.currentThread()) {
                if (this.eventDispatch) {
                    throw new IllegalStateException("Modification from inside the event handler are banned");
                }
                ++this.writeLocks;
                Object object2 = this.locked;
                return object2;
            }
            if (this.locked != null) {
                try {
                    this.writerNotify.wait();
                }
                catch (InterruptedException ex) {
                    throw new IllegalStateException("Interrupted");
                }
            }
            this.transactionConstrained = true;
            ++this.writeLocks;
            this.locked = this.writerNotify;
            this.writingThread = Thread.currentThread();
            Object object3 = this.locked;
            return object3;
        }
    }

    public final void releaseWriteLock(Object handle) throws SourceException {
        this.releaseWriteLock(handle, false);
    }

    final void releaseWriteLock(Object handle, boolean forkThread) throws SourceException {
        if (handle == null) {
            throw new IllegalArgumentException("Invalid lock: " + handle);
        }
        if (this.locked == null) {
            throw new IllegalStateException("Model not locked.");
        }
        Object object = this.writerNotify;
        synchronized (object) {
            if (handle != this.locked) {
                throw new IllegalArgumentException("Invalid unlock attempt.");
            }
        }
        EventQueue result = null;
        if (this.masterLocks == -1) {
            result = this.mergeEventQueues();
        } else if (this.masterLocks >= this.writeLocks) {
            result = this.mergeEventQueues();
            this.masterLocks = -1;
        }
        if (--this.writeLocks > 0) {
            return;
        }
        this.eventQueue = null;
        result.fixupChanges();
        this.firePreCommitEvents(result);
        this.enqueue(result);
        Object object2 = this.writerNotify;
        synchronized (object2) {
            this.writingThread = null;
            this.locked = null;
            this.writerNotify.notifyAll();
        }
        if (forkThread) {
            RequestProcessor.getDefault().post((Runnable)this);
        } else {
            this.processOutputQueue();
        }
    }

    private void enqueue(EventQueue q) {
        if (this.outputQueue == null) {
            this.outputQueue = new LinkedList();
        }
        LinkedList linkedList = this.outputQueue;
        synchronized (linkedList) {
            this.outputQueue.addLast(q);
        }
    }

    public void run() {
        this.processOutputQueue();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processOutputQueue() {
        LinkedList linkedList;
        if (this.outputQueue == null) {
            return;
        }
        LinkedList linkedList2 = this.outputQueue;
        synchronized (linkedList2) {
            if (this.firingEvents) {
                return;
            }
            this.firingEvents = true;
        }
        try {
            while (true) {
                EventQueue bit;
                LinkedList linkedList3 = this.outputQueue;
                synchronized (linkedList3) {
                    if (this.outputQueue.isEmpty()) {
                        // MONITOREXIT @DISABLED, blocks:[1, 5, 9, 12] lbl15 : MonitorExitStatement: MONITOREXIT : var3_3
                        Object var6_4 = null;
                        linkedList = this.outputQueue;
                        break;
                    }
                    bit = (EventQueue)this.outputQueue.removeFirst();
                }
                bit.fireEvents();
                this.firePostCommitEvents(bit);
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            LinkedList linkedList4 = this.outputQueue;
            synchronized (linkedList4) {
                this.firingEvents = false;
                throw throwable;
            }
        }
        synchronized (linkedList) {
            this.firingEvents = false;
            return;
        }
    }

    private void firePreCommitEvents(EventQueue q) {
        this.fireCommitEvents(this.preCommitListeners, q);
    }

    private void firePostCommitEvents(EventQueue what) {
        this.fireCommitEvents(this.postCommitListeners, what);
    }

    private void fireCommitEvents(Collection origListeners, EventQueue data) {
        Vector listeners;
        if (origListeners == null || data == null || data.isEmpty()) {
            return;
        }
        Collection collection = origListeners;
        synchronized (collection) {
            listeners = new Vector(origListeners);
        }
        Set removed = data.getRemovedElements();
        Set created = data.getCreatedElements();
        Map changed = data.getChangedElements();
        Iterator it = listeners.iterator();
        while (it.hasNext()) {
            CommitListener l = (CommitListener)it.next();
            l.changesCommited(created, removed, changed);
        }
    }

    private EventQueue mergeEventQueues() {
        EventQueue parent = this.eventQueue.getParent();
        if (parent != null) {
            if (this.transactionCommited) {
                this.eventQueue.mergeToParent();
            }
            this.eventQueue = parent;
        }
        this.transactionCommited = false;
        return this.eventQueue;
    }

    public void commitChanges() {
        if (this.locked == null || this.writingThread != Thread.currentThread()) {
            throw new IllegalStateException("Sanity check: commit outside lock");
        }
        if (this.masterLocks > 0 && this.masterLocks < this.writeLocks) {
            return;
        }
        this.transactionCommited = true;
    }

    public void runAtomic(Runnable r) throws SourceException {
        Object token = this.writeLock();
        try {
            r.run();
            this.commitChanges();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseWriteLock(token);
            throw throwable;
        }
        this.releaseWriteLock(token);
    }

    protected boolean isConstrained() {
        return this.transactionConstrained;
    }

    protected final Node.Cookie findElementCookie(Element el, Class clazz) {
        return this.env.findCookie(el, clazz);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean runUpdate(Runnable r, boolean disableConstraints) throws SourceException {
        Object token = this.tryWriteLock(true);
        if (token == null) {
            return false;
        }
        boolean saveConstraint = this.transactionConstrained;
        try {
            try {
                this.transactionConstrained = !disableConstraints;
                r.run();
                this.commitChanges();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SourceException("Unexpected implementation error");
            }
            Object var7_5 = null;
            this.transactionConstrained = saveConstraint;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.transactionConstrained = saveConstraint;
            this.releaseWriteLock(token, true);
            return true;
        }
        this.releaseWriteLock(token, true);
        return true;
    }

    private void doRunAtomic(ExceptionRunnable r) throws SourceException {
        try {
            r.run();
        }
        catch (SourceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SourceException("Unexpected implementation error.");
        }
    }

    public void runAtomic(ExceptionRunnable r) throws SourceException {
        boolean fire = false;
        boolean ok = false;
        Object token = null;
        token = this.writeLock();
        try {
            this.doRunAtomic(r);
            this.commitChanges();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.releaseWriteLock(token);
            throw throwable;
        }
        this.releaseWriteLock(token);
    }

    public Object getManagementLock() {
        return this.writerNotify;
    }

    public final void readLock() {
        Object object = this.writerNotify;
        synchronized (object) {
            if (this.writingThread != null && this.writingThread == Thread.currentThread()) {
                ++this.readerCount;
                return;
            }
            try {
                this.writerNotify.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.locked == null) {
                this.locked = Thread.currentThread();
            }
            ++this.readerCount;
        }
    }

    public final void releaseReadLock() {
        Object object = this.writerNotify;
        synchronized (object) {
            if (--this.readerCount == 0 && this.writingThread == null) {
                this.locked = null;
                this.writerNotify.notifyAll();
            }
        }
    }

    protected EventQueue getEventQueue() {
        return this.eventQueue;
    }

    public boolean isWriteLocked() {
        return this.writingThread != null;
    }

    public ElementFactory.Item createImport(Import im, int from, int to) {
        return null;
    }

    public void notifyElementChanged(Element ref, Element old) {
        this.eventQueue.elementChanged(ref, old);
    }

    public void notifyElementCreated(Element ref) {
        this.eventQueue.elementCreated(ref);
    }

    public void notifyElementRemoved(Element ref) {
        this.eventQueue.elementRemoved(ref);
    }

    public void fireModelElementChange(ElementImpl bean, PropertyChangeEvent evt) {
        this.queuePropertyChange(bean, evt.getPropertyName(), evt);
    }

    public void fireModelElementChange(Element.Impl bean, PropertyChangeEvent evt) {
        this.queuePropertyChange((ElementImpl)bean, evt.getPropertyName(), evt);
    }

    protected BindingFactory getBindingFactory() {
        if (this.bindingFactory != null) {
            return this.bindingFactory;
        }
        this.bindingFactory = this.env.getBindingFactory();
        return this.bindingFactory;
    }

    public WrapperFactory getWrapper() {
        if (this.wrapperFactory != null) {
            return this.wrapperFactory;
        }
        DefaultLangModel defaultLangModel = this;
        synchronized (defaultLangModel) {
            if (this.wrapperFactory == null) {
                this.wrapperFactory = this.env.getWrapperFactory();
            }
            WrapperFactory wrapperFactory = this.wrapperFactory;
            return wrapperFactory;
        }
    }

    private void queuePropertyChange(ElementImpl bean, String name, PropertyChangeEvent evt) {
        this.eventQueue.addPropertyChange(bean, evt);
    }

    private ElementImpl getElementImpl(Element el) {
        return (ElementImpl)el.getCookie(class$org$netbeans$modules$java$model$ElementImpl == null ? (class$org$netbeans$modules$java$model$ElementImpl = DefaultLangModel.class$("org.netbeans.modules.java.model.ElementImpl")) : class$org$netbeans$modules$java$model$ElementImpl);
    }

    public void updateMembers(Element target, String propertyName, Element[] els, int[] orderIndices, int[] optMap) {
        if (target instanceof ClassElement) {
            ClassElementImpl impl = (ClassElementImpl)this.getElementImpl(target);
            impl.updateMembers(propertyName, els, orderIndices, optMap);
        } else {
            SourceElementImpl impl = (SourceElementImpl)this.getElementImpl(target);
            impl.updateMembers(propertyName, els, optMap);
        }
    }

    public void updateMemberOrder(Element target, String id, Element[] orderedMembers) {
        ClassElementImpl impl = (ClassElementImpl)this.getElementImpl(target);
        impl.updateMemberOrder(orderedMembers);
    }

    public void activate(Element target) {
        ElementImpl impl = this.getElementImpl(target);
        impl.notifyCreate();
    }

    public Binding getElementBinding(Element target) {
        ElementImpl impl = this.getElementImpl(target);
        return impl.getRawBinding();
    }

    public boolean isSameContext(Element context, Identifier id) {
        ElementImpl impl = this.getElementImpl(context);
        if (impl == null) {
            return false;
        }
        return impl.checkIdentifierContext(id);
    }

    public Identifier createLocalIdentifier(Element context, Identifier id, int status) {
        ElementImpl impl = this.getElementImpl(context);
        if (impl == null) {
            throw new IllegalArgumentException("Unknown context class: " + context.getClass());
        }
        return impl.createLocalIdentifier(id, status);
    }

    public Identifier createLocalIdentifier(Element context, String full, String source, int status) {
        Identifier id = Identifier.create((String)full, (String)source);
        return this.createLocalIdentifier(context, id, status);
    }

    public Element findElement(Element.Impl impl) {
        if (!(impl instanceof ElementImpl)) {
            return null;
        }
        return ((ElementImpl)impl).getElement();
    }

    public void firePropertyChange(Element el, PropertyChangeEvent evt) {
        ElementImpl impl = this.getElementImpl(el);
        if (impl == null) {
            return;
        }
        impl.firePropertyChangeEvent(evt);
    }

    public void updateBody(Element el, String bodyContent) throws UnsupportedOperationException {
        ElementImpl impl = this.getElementImpl(el);
        if (impl instanceof CallableImpl) {
            ((CallableImpl)impl).updateBody(bodyContent);
        } else if (impl instanceof InitializerElementImpl) {
            ((InitializerElementImpl)impl).updateBody(bodyContent);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * Loose catch block
     */
    public void invalidateModel(SourceElement el) {
        block7: {
            SourceElementImpl impl = (SourceElementImpl)this.getElementImpl((Element)el);
            Object token = this.writeLock();
            if (impl != null) break block6;
            Object var5_4 = null;
            try {
                this.releaseWriteLock(token);
            }
            catch (SourceException x) {
                // empty catch block
            }
            {
                block6: {
                    return;
                }
                impl.notifyRemove();
                this.commitChanges();
            }
            Object var5_5 = null;
            try {
                this.releaseWriteLock(token);
            }
            catch (SourceException x) {}
            break block7;
            catch (Throwable throwable) {
                Object var5_6 = null;
                try {
                    this.releaseWriteLock(token);
                }
                catch (SourceException x) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        DEFAULT_POSITIONER = new DefaultInsertStrategy();
    }
}

