/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.model;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.openide.src.Identifier;

class IdentContextSupport {
    Map identifierSet;

    public IdentContextSupport(int capacity) {
        this.identifierSet = new HashMap(capacity * 4 / 3);
    }

    public Identifier create(Identifier id, int status) {
        Identifier oldID;
        Reference refV = (Reference)this.identifierSet.get(id.getSourceName());
        if (refV != null && (oldID = (Identifier)refV.get()) != null && oldID.getResolutionStatus() == status && oldID.getFullName() == id.getFullName()) {
            return oldID;
        }
        if (id.getResolutionStatus() != status) {
            id = Identifier.create((String)id.getFullName(), (String)id.getSourceName(), (int)status);
        }
        this.identifierSet.put(id.getSourceName(), new WeakReference<Identifier>(id));
        return id;
    }

    public boolean checkContext(Identifier id) {
        Reference refV = (Reference)this.identifierSet.get(id);
        if (refV == null) {
            return false;
        }
        Identifier x = (Identifier)refV.get();
        return x == id;
    }
}

