/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.model;

import java.beans.PropertyChangeEvent;
import java.util.zip.CRC32;
import org.netbeans.modules.java.model.Binding;
import org.netbeans.modules.java.model.DefaultLangModel;
import org.netbeans.modules.java.model.MemberElementImpl;
import org.netbeans.modules.java.model.SourceElementImpl;
import org.openide.src.Element;
import org.openide.src.InitializerElement;
import org.openide.src.JavaDoc;
import org.openide.src.SourceException;

class InitializerElementImpl
extends MemberElementImpl
implements InitializerElement.Impl,
Element.Impl2 {
    private transient String copiedBody;
    private transient long bodyHash = -1L;
    private static final long serialVersionUID = 3490993892523739282L;

    InitializerElementImpl(DefaultLangModel model) {
        super(model);
    }

    protected void createFromModel(Element el) throws SourceException {
        InitializerElement i = (InitializerElement)el;
        this.copyBody(i.getBody());
        this.setStatic(i.isStatic());
    }

    protected void notifyCreate() {
        super.notifyCreate();
        if (this.copiedBody != null) {
            this.bodyHash = this.computeHash(this.getBody());
        }
        this.copiedBody = null;
    }

    private long computeHash(String bodyContent) {
        CRC32 crc = new CRC32();
        crc.update(bodyContent.getBytes());
        return crc.getValue();
    }

    protected final Binding createBinding(Element el) {
        return this.getModelImpl().getBindingFactory().bindInitializer((InitializerElement)el);
    }

    public void attachedToElement(Element el) {
        super.attachedToElement(el);
    }

    public boolean isStatic() {
        return (this.getModifiers() & 8) > 0;
    }

    void copyBody(String s) {
        if (s == null) {
            s = "";
        }
        this.copiedBody = s;
    }

    public String getBody() {
        if (this.isCreated()) {
            return this.copiedBody;
        }
        try {
            return this.getInitializerBinding().getBodyContent();
        }
        catch (SourceException ex) {
            return null;
        }
    }

    public JavaDoc getJavaDoc() {
        return null;
    }

    public boolean isValid() {
        return super.isValid() && (this.getDeclaringImpl() == null || this.getDeclaringImpl().isValid());
    }

    void updateBody(String content) {
        if (content == null) {
            this.bodyHash = -1L;
            return;
        }
        long newHash = this.computeHash(content);
        if (newHash == this.bodyHash) {
            return;
        }
        this.bodyHash = newHash;
        this.addPropertyChange(new PropertyChangeEvent(this.getElement(), "body", null, null));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setStatic(boolean enable) throws SourceException {
        Object token;
        block5: {
            block4: {
                token = this.takeLock();
                try {
                    if (!this.isCreated()) {
                        if ((this.mod & 8) > 0 == enable) {
                            Object var5_3 = null;
                            break block4;
                        }
                        PropertyChangeEvent evt = new PropertyChangeEvent(this.getElement(), "static", enable ? Boolean.FALSE : Boolean.TRUE, enable ? Boolean.TRUE : Boolean.FALSE);
                        this.checkVetoablePropertyChange(evt);
                        this.getInitializerBinding().changeStatic(enable);
                        this.fireOwnPropertyChange(evt);
                    }
                    this.mod = enable ? 8 : 0;
                    this.commit();
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    this.releaseLock(token);
                    throw throwable;
                }
            }
            this.releaseLock(token);
            return;
        }
        Object var5_4 = null;
        this.releaseLock(token);
    }

    public void setBody(String body) throws SourceException {
        String oldBody;
        Object token = this.takeLock();
        try {
            block5: {
                if (this.isCreated()) break block4;
                oldBody = this.getInitializerBinding().getBodyContent();
                if (oldBody == body) break block5;
                if (oldBody == null || body == null || !oldBody.equals(body)) break block6;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.releaseLock(token);
            throw throwable;
        }
        this.releaseLock(token);
        {
            block4: {
                block6: {
                    return;
                }
                PropertyChangeEvent evt = new PropertyChangeEvent(this.getElement(), "body", oldBody, body);
                this.checkVetoablePropertyChange(evt);
                this.getInitializerBinding().changeBody(body);
                body = this.getBody();
                evt = new PropertyChangeEvent(this.getElement(), "body", oldBody, body);
                this.addPropertyChange(evt);
            }
            this.bodyHash = this.computeHash(body);
            this.commit();
        }
        Object var6_5 = null;
        this.releaseLock(token);
    }

    protected final Binding.Initializer getInitializerBinding() {
        return (Binding.Initializer)this.getBinding();
    }

    protected final SourceElementImpl findSource() {
        return this.getDeclaringImpl().findSource();
    }

    protected Element cloneSelf() {
        InitializerElement el = new InitializerElement();
        try {
            el.setStatic(this.isStatic());
        }
        catch (SourceException sourceException) {
            // empty catch block
        }
        return el;
    }

    public Object readResolve() {
        return null;
    }
}

