/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.model;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import org.netbeans.modules.java.model.ElementCreator;
import org.netbeans.modules.java.model.ElementEvents;
import org.netbeans.modules.java.model.ElementImpl;
import org.netbeans.modules.java.model.IndexedPropertyBase;
import org.netbeans.modules.java.model.MemberCollection;
import org.netbeans.modules.java.model.Positioner;
import org.openide.src.Element;
import org.openide.src.MultiPropertyChangeEvent;
import org.openide.src.SourceException;

abstract class PartialCollection
extends IndexedPropertyBase {
    public static final int SMALL_THRESHOLD = 500;
    ElementEvents events;
    private int[] positions;
    Element[] elements;
    MemberCollection allMembers;
    ElementCreator creator;
    boolean ignoreContentChange;
    private static final int[] EMPTY_POSITIONS = new int[0];
    protected static final boolean DEBUG = false;
    static /* synthetic */ Class class$org$netbeans$modules$java$model$ElementImpl;

    public PartialCollection(ElementEvents events, ElementCreator creator, MemberCollection allMembers, String propertyName) {
        super(propertyName);
        this.events = events;
        this.allMembers = allMembers;
        this.creator = creator;
        this.positions = EMPTY_POSITIONS;
        allMembers.addPartialCollection(this);
    }

    public abstract Class getElementImplClass();

    protected abstract ElementImpl createElement(Element var1);

    protected abstract Object[] createEmpty();

    protected abstract Element[] createEmpty(int var1);

    public int[] getPositions() {
        return this.positions;
    }

    public final Element[] getElements() {
        if (this.elements == null) {
            return (Element[])this.createEmpty();
        }
        return this.elements;
    }

    public boolean isEmpty() {
        return this.elements == null || this.elements.length == 0;
    }

    public void addMembers(Element[] els) throws SourceException {
        if (els.length == 0) {
            return;
        }
        Element[] insertingEls = new Element[els.length];
        Element[] elements = this.getElements();
        int i = 0;
        while (i < els.length) {
            insertingEls[i] = this.copyElement(els[i]);
            ++i;
        }
        Element[] allElems = this.allMembers.getElements();
        Element[] precedings = this.allMembers.findPositions(insertingEls);
        Element[] newElems = this.createEmpty(insertingEls.length + elements.length);
        int[] insertIndices = new int[els.length];
        int[] newPositions = new int[newElems.length];
        HashMap m = new HashMap(precedings.length * 4 / 3);
        int i2 = 0;
        while (i2 < precedings.length) {
            Object o = m.get(precedings[i2]);
            if (o != null) {
                LinkedList<Object> c;
                if (!(o instanceof Collection)) {
                    c = new LinkedList<Object>();
                    c.add(o);
                    m.put(precedings[i2], c);
                } else {
                    c = (LinkedList<Object>)o;
                }
                c.add(insertingEls[i2]);
            } else {
                m.put(precedings[i2], insertingEls[i2]);
            }
            ++i2;
        }
        Element prevElem = Positioner.FIRST;
        int newPos = 0;
        int oldPos = 0;
        int inserted = 0;
        int newGlobalPos = 0;
        int oldGlobalPos = 0;
        int[] newGlobalIndices = new int[els.length];
        oldGlobalPos = 0;
        while (oldGlobalPos <= allElems.length) {
            Object dependent = m.get(prevElem);
            if (dependent != null) {
                Element newEl;
                LinkedList toInsert = new LinkedList();
                do {
                    if (dependent instanceof Collection) {
                        toInsert.addAll((Collection)dependent);
                    } else {
                        toInsert.add(dependent);
                    }
                    newEl = (Element)toInsert.removeFirst();
                    newGlobalIndices[inserted] = newGlobalPos;
                    insertIndices[inserted] = newPos;
                    newElems[newPos] = newEl;
                    newPositions[newPos] = newGlobalPos++;
                    ++inserted;
                    ++newPos;
                } while ((dependent = m.get(newEl)) != null);
            }
            if (oldGlobalPos >= allElems.length) break;
            prevElem = allElems[oldGlobalPos];
            if (oldPos < elements.length && prevElem == elements[oldPos]) {
                newPositions[newPos] = newGlobalPos;
                newElems[newPos++] = elements[oldPos++];
            }
            ++newGlobalPos;
            ++oldGlobalPos;
        }
        if (inserted < insertingEls.length) {
            throw new IllegalArgumentException("Inconsistent insertion strategy");
        }
        IndexedPropertyBase.Change chng = new IndexedPropertyBase.Change();
        chng.insertIndices = insertIndices;
        chng.inserted = Arrays.asList(insertingEls);
        chng.phaseCount = 1;
        chng.sizeDiff = insertingEls.length;
        MultiPropertyChangeEvent evt = this.createInsertionEvent(this.events.getEventSource(), elements, newElems, chng.inserted, insertIndices);
        chng.insertIndices = newGlobalIndices;
        this.events.fireVetoableChange((PropertyChangeEvent)evt);
        try {
            this.ignoreContentChange = true;
            this.allMembers.changeMembers(chng);
            Object var23_23 = null;
            this.ignoreContentChange = false;
        }
        catch (Throwable throwable) {
            Object var23_24 = null;
            this.ignoreContentChange = false;
            throw throwable;
        }
        this.events.addPropertyChange((PropertyChangeEvent)evt);
        this.elements = newElems;
        this.positions = newPositions;
        this.sanityCheck();
    }

    public void removeMembers(Element[] els) throws SourceException {
        Element[] elements = this.getElements();
        int[] removeIndices = this.createIdentityMap(els);
        int i = 0;
        while (i < removeIndices.length) {
            if (removeIndices[i] == -1) {
                throw new SourceException("Element does not exist");
            }
            ++i;
        }
        Element[] newElems = this.createEmpty(elements.length - els.length);
        int[] offsets = new int[elements.length];
        int newPos = 0;
        int removed = 0;
        int nextRemove = removeIndices[0];
        int i2 = 0;
        while (i2 < elements.length) {
            if (i2 == nextRemove) {
                offsets[i2] = -i2 - 1;
                nextRemove = ++removed < removeIndices.length ? removeIndices[removed] : -1;
            } else {
                offsets[i2] = newPos - i2;
                newElems[newPos] = elements[i2];
                ++newPos;
            }
            ++i2;
        }
        IndexedPropertyBase.Change ch = new IndexedPropertyBase.Change();
        ch.removed = Arrays.asList(els);
        ch.removeIndices = removeIndices;
        ch.offsets = offsets;
        ch.sizeDiff = -els.length;
        ch.phaseCount = 1;
        this.doSetMembers(newElems, ch);
    }

    public void updateMembers(Element[] members, int[] indices, int[] map) {
        if (this.elements != null) {
            Object[] els = this.getElements();
            Object[] newEls = this.createEmpty(members.length);
            if (map == null) {
                map = this.createIdentityMap(members);
            }
            IndexedPropertyBase.Change chng = IndexedPropertyBase.computeChanges2(els, newEls, map);
            if (chng.phaseCount > 0) {
                this.events.addPropertyChange((PropertyChangeEvent)this.createPropertyEvent(chng, this.events.getEventSource(), els, newEls));
            }
        } else if (!this.events.getElementImpl().isCreated()) {
            int[] indexes = new int[members.length];
            ArrayList<Element> insert = new ArrayList<Element>(members.length);
            int i = 0;
            while (i < members.length) {
                indexes[i] = i;
                insert.add(members[i]);
                ++i;
            }
            this.events.addPropertyChange((PropertyChangeEvent)this.createInsertionEvent(this.events.getEventSource(), this.createEmpty(), members, insert, indexes));
        }
        this.elements = members;
        this.positions = indices;
    }

    protected Element copyElement(Element el) {
        ElementImpl impl = this.createElement((Element)this.events.getEventSource());
        try {
            impl.createFromModel(el);
        }
        catch (SourceException sourceException) {
            // empty catch block
        }
        return impl.getElement();
    }

    public void setMembers(Element[] members) throws SourceException {
        Object[] els = this.getElements();
        Object[] newEls = this.createEmpty(members.length);
        int[] map = this.createIdentityMap(members);
        boolean memberPos = false;
        boolean copied = false;
        int i = 0;
        while (i < map.length) {
            if (map[i] == -1) {
                newEls[i] = this.copyElement(members[i]);
                copied = true;
            } else {
                newEls[i] = members[i];
            }
            ++i;
        }
        IndexedPropertyBase.Change chng = IndexedPropertyBase.computeChanges2(els, newEls, map);
        this.doSetMembers((Element[])newEls, chng);
    }

    /*
     * WARNING - void declaration
     */
    private void mapInsertIndices(IndexedPropertyBase.Change chng, int[] newPositions) throws SourceException {
        int[] iindices = chng.insertIndices;
        int[] offsets = chng.offsets;
        int nextInsert = iindices[0];
        int oldIndex = 0;
        int prevOldIndex = -1;
        Element[] all = this.allMembers.getElements();
        Element[] elements = this.getElements();
        int iPos = 0;
        int globalPrecedingPos = -1;
        block0: while (iPos < iindices.length) {
            int newIndex;
            if (oldIndex < offsets.length) {
                int myPos;
                int testPos;
                while ((newIndex = oldIndex + offsets[oldIndex]) < nextInsert) {
                    void var10_12;
                    if (var10_12 != -1) {
                        prevOldIndex = oldIndex;
                    }
                    if (++oldIndex < offsets.length) continue;
                    oldIndex = -1;
                    newIndex = newPositions.length;
                    break;
                }
                if (prevOldIndex == -1) {
                    testPos = -1;
                    globalPrecedingPos = -1;
                    myPos = 0;
                } else {
                    testPos = this.positions[prevOldIndex];
                    myPos = prevOldIndex + 1;
                    globalPrecedingPos = testPos + offsets[prevOldIndex];
                }
                int globalBarrier = oldIndex == -1 ? all.length : this.positions[oldIndex];
                while (true) {
                    Element ref;
                    if (testPos >= globalBarrier) {
                        throw new SourceException("cannot insert");
                    }
                    Element element = ref = testPos < 0 ? null : all[testPos];
                    if (!this.allMembers.canInsertAfter(ref)) {
                        if (myPos < elements.length && this.positions[myPos] != testPos) {
                            ++globalPrecedingPos;
                        } else {
                            ++myPos;
                        }
                        ++testPos;
                        continue;
                    }
                    break;
                }
            } else {
                newIndex = nextInsert + 1;
            }
            while (nextInsert < newIndex) {
                iindices[iPos] = ++globalPrecedingPos;
                newPositions[nextInsert] = globalPrecedingPos;
                if (++iPos >= iindices.length) continue block0;
                nextInsert = iindices[iPos];
            }
        }
    }

    private void doSetMembers(Element[] newElements, IndexedPropertyBase.Change chng) throws SourceException {
        int[] newPositions = new int[newElements.length];
        Element[] els = this.getElements();
        int[] offsets = chng.offsets;
        MultiPropertyChangeEvent multiEvt = this.createPropertyEvent(chng, this.events.getEventSource(), this.getElements(), newElements);
        if (multiEvt == null) {
            return;
        }
        this.events.fireVetoableChange((PropertyChangeEvent)multiEvt);
        if (offsets != null) {
            int i = 0;
            while (i < els.length) {
                int newPos = i + offsets[i];
                if (newPos >= 0) {
                    int newGlobPos;
                    newPositions[newPos] = newGlobPos = this.positions[i] + offsets[i];
                }
                ++i;
            }
        } else {
            System.arraycopy(this.positions, 0, newPositions, 0, els.length);
        }
        if (chng.inserted != null) {
            this.mapInsertIndices(chng, newPositions);
        }
        PartialCollection.mapIndices(chng.removeIndices, this.positions);
        PartialCollection.mapIndices(chng.replaceIndices, this.positions);
        this.mapReorderIndices(chng, newPositions);
        try {
            this.ignoreContentChange = true;
            this.allMembers.changeMembers(chng);
            Object var11_10 = null;
            this.ignoreContentChange = false;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.ignoreContentChange = false;
            throw throwable;
        }
        this.positions = newPositions;
        this.elements = newElements;
        this.sanityCheck();
        this.events.addPropertyChange((PropertyChangeEvent)multiEvt);
    }

    private void mapReorderIndices(IndexedPropertyBase.Change chng, int[] newPositions) {
        if (chng.reordered == null) {
            return;
        }
        int[] mainReorder = new int[this.allMembers.getElements().length];
        int[] myOrder = chng.reordered;
        Arrays.fill(mainReorder, -1);
        int i = 0;
        while (i < myOrder.length) {
            if (myOrder[i] != -1) {
                mainReorder[this.positions[i]] = newPositions[myOrder[i]];
            }
            ++i;
        }
        chng.reordered = mainReorder;
    }

    void contentSlotsChanged(int[] offsets) {
        if (this.ignoreContentChange) {
            return;
        }
        int l = this.getElements().length;
        int i = 0;
        while (i < l) {
            int n = i;
            this.positions[n] = this.positions[n] + offsets[this.positions[i]];
            ++i;
        }
        this.sanityCheck();
    }

    private static void mapIndices(int[] indices, int[] positions) {
        if (indices == null) {
            return;
        }
        int i = 0;
        while (i < indices.length) {
            if (indices[i] != -1) {
                indices[i] = positions[indices[i]];
            }
            ++i;
        }
    }

    protected int[] createIdentityMap(Element[] els) {
        Object[] olds = this.getElements();
        return super.createIdentityMap(els, olds);
    }

    protected final Object getSource(ElementImpl impl) {
        return impl.getElement();
    }

    public void changeMembers(Element[] items, int operation) throws SourceException {
        switch (operation) {
            case 1: {
                this.addMembers(items);
                break;
            }
            case -1: {
                this.removeMembers(items);
                break;
            }
            case 0: {
                this.setMembers(items);
                break;
            }
            default: {
                throw new InternalError("Unknown/unsupported operation: " + operation);
            }
        }
    }

    protected void sanityCheck() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

