/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.modules.java.ElementFactory;
import org.netbeans.modules.java.codegen.DocumentBinding;
import org.netbeans.modules.java.codegen.TextBinding;
import org.netbeans.modules.java.model.LangModel;
import org.netbeans.modules.java.parser.ElementMatch;
import org.openide.nodes.Node;
import org.openide.src.Element;
import org.openide.src.Identifier;
import org.openide.src.JavaDoc;
import org.openide.src.MemberElement;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.text.PositionBounds;

public abstract class BaseElementInfo
implements ElementFactory.Item {
    ElementFactory.Item parent;
    String name;
    int modifiers;
    String docText;
    Element el;
    TextBinding binding;
    String bodyContent;
    PositionBounds wholeBounds;
    PositionBounds bodyBounds;
    PositionBounds headerBounds;
    PositionBounds docBounds;
    static /* synthetic */ Class class$org$openide$src$MemberElement$Impl;

    BaseElementInfo(String name, int modifiers) {
        this.name = name;
        this.modifiers = modifiers;
    }

    public Element createModelElement(Element parent, LangModel.Updater model) throws SourceException {
        Element el = this.createModelImpl(model, parent);
        this.updateElement(model, el);
        this.el = el;
        return this.el;
    }

    public int comparePositionTo(TextBinding b) {
        if (b == null) {
            return -1;
        }
        PositionBounds bounds = b.getElementRange(true);
        int begin = (this.headerBounds == null ? this.wholeBounds : this.headerBounds).getBegin().getOffset();
        int otherBegin = bounds.getBegin().getOffset();
        int end = this.wholeBounds.getEnd().getOffset();
        int otherEnd = bounds.getEnd().getOffset();
        if (otherBegin == otherEnd) {
            return -1;
        }
        if (begin < otherEnd && end > otherBegin) {
            return 0;
        }
        if (end == otherBegin) {
            return -1;
        }
        return end - otherBegin;
    }

    protected Identifier createName() {
        return Identifier.create((String)this.name);
    }

    public Node.Cookie getCookie(Class desiredClass) {
        return null;
    }

    protected abstract Element createModelImpl(LangModel.Updater var1, Element var2);

    protected Identifier[] mapIdentifiers(LangModel.Updater model, Identifier[] arr, Element t) {
        if (arr.length == 0) {
            return arr;
        }
        Identifier[] ids = new Identifier[arr.length];
        int i = 0;
        while (i < ids.length) {
            ids[i] = this.createContextID(model, t, arr[i]);
            ++i;
        }
        return ids;
    }

    protected Identifier createContextID(LangModel.Updater model, Element context, Identifier orig) {
        return model.createLocalIdentifier(context, orig, orig.getResolutionStatus());
    }

    protected Type createContextType(LangModel.Updater model, Element context, Type orig) {
        if (orig.isPrimitive()) {
            return orig;
        }
        Type t2 = orig;
        int depth = 0;
        while (t2.isArray()) {
            t2 = t2.getElementType();
            ++depth;
        }
        if (t2.isPrimitive()) {
            return orig;
        }
        Identifier typeid = t2.getTypeIdentifier();
        Identifier newId = model.createLocalIdentifier(context, typeid, typeid.getResolutionStatus());
        t2 = Type.createClass((Identifier)newId);
        while (depth-- > 0) {
            t2 = Type.createArray((Type)t2);
        }
        return t2;
    }

    public void updateElement(LangModel.Updater model, Element el) throws SourceException {
        this.el = el;
        this.binding = (TextBinding)model.getElementBinding(el);
    }

    public void updateBindings(DocumentBinding updater) {
        this.updateBinding(updater, this.binding);
    }

    public void updateBinding(DocumentBinding updater, TextBinding b) {
        b.updateBounds(0, this.wholeBounds);
        b.updateBounds(2, this.headerBounds);
        b.updateBounds(3, this.bodyBounds);
        b.updateBounds(1, this.docBounds);
    }

    protected static void updateChildren(DocumentBinding updater, Collection infos, TextBinding.Container container) {
        ArrayList<TextBinding> blist = new ArrayList<TextBinding>(infos.size());
        Iterator it = infos.iterator();
        while (it.hasNext()) {
            BaseElementInfo i = (BaseElementInfo)it.next();
            i.updateBindings(updater);
            blist.add(i.binding);
        }
        container.updateChildren(blist);
    }

    protected void updateBase(Element el) throws SourceException {
        this.el = el;
        MemberElement.Impl m = (MemberElement.Impl)el.getCookie(class$org$openide$src$MemberElement$Impl == null ? (class$org$openide$src$MemberElement$Impl = BaseElementInfo.class$("org.openide.src.MemberElement$Impl")) : class$org$openide$src$MemberElement$Impl);
        m.setModifiers(this.modifiers);
        m.setName(this.createName());
    }

    protected void updateJavaDoc(JavaDoc doc) throws SourceException {
        doc.setRawText(this.docText);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class NameFinder
    extends ElementMatch.AbstractFinder {
        protected boolean matches(BaseElementInfo info, Element old) {
            MemberElement oldMember = (MemberElement)old;
            return info.name.equals(oldMember.getName().getSourceName());
        }
    }
}

