/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.parser;

import org.netbeans.modules.java.model.LangModel;
import org.netbeans.modules.java.parser.BaseElementInfo;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.Element;
import org.openide.src.Identifier;
import org.openide.src.JavaDoc;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceException;
import org.openide.src.Type;

public class MethodInfo
extends BaseElementInfo {
    Type retType;
    MethodParameter[] params;
    Identifier[] exceptions;
    boolean constructor;

    public MethodInfo(String name, int mods) {
        super(name, mods);
    }

    public Element createModelImpl(LangModel.Updater model, Element parent) {
        if (this.constructor) {
            return model.createConstructor((ClassElement)parent).getElement();
        }
        return model.createMethod((ClassElement)parent).getElement();
    }

    public void updateElement(LangModel.Updater model, Element target) throws SourceException {
        super.updateElement(model, target);
        super.updateBase(target);
        ConstructorElement c = (ConstructorElement)target;
        ClassElement decl = c.getDeclaringClass();
        c.setParameters(this.mapParameters(model, c));
        c.setExceptions(this.mapIdentifiers(model, this.exceptions, (Element)decl));
        this.updateJavaDoc((JavaDoc)c.getJavaDoc());
        model.updateBody((Element)c, this.bodyContent);
        if (!this.constructor) {
            ((MethodElement)c).setReturn(this.createContextType(model, (Element)decl, this.retType));
        }
    }

    private MethodParameter[] mapParameters(LangModel.Updater model, ConstructorElement t) {
        if (this.params.length == 0) {
            return this.params;
        }
        MethodParameter[] pars = new MethodParameter[this.params.length];
        ClassElement clazz = t.getDeclaringClass();
        int i = 0;
        while (i < this.params.length) {
            pars[i] = new MethodParameter(this.params[i].getName(), this.createContextType(model, (Element)clazz, this.params[i].getType()), this.params[i].isFinal());
            ++i;
        }
        return pars;
    }

    public static class Finder
    extends BaseElementInfo.NameFinder {
        private final boolean compareName;
        private final boolean compareTypes;

        public Finder(boolean names, boolean types) {
            this.compareName = names;
            this.compareTypes = types;
        }

        protected boolean matches(BaseElementInfo baseInfo, Element old) {
            MethodInfo info = (MethodInfo)baseInfo;
            ConstructorElement oldElem = (ConstructorElement)old;
            if (this.compareName && !super.matches(baseInfo, old)) {
                return false;
            }
            return !this.compareTypes || this.compareTypes(info, oldElem);
        }

        private boolean compareTypes(MethodInfo info, ConstructorElement old) {
            MethodParameter[] params1 = info.params;
            MethodParameter[] params2 = old.getParameters();
            if (params1.length != params2.length) {
                return false;
            }
            int i = 0;
            while (i < params1.length) {
                if (!this.compareTypes(params1[i].getType(), params2[i].getType())) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private boolean compareTypes(Type t1, Type t2) {
            return t1.getSourceString().equals(t2.getSourceString());
        }
    }
}

