/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TooManyListenersException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.java.ElementFactory;
import org.netbeans.modules.java.ErrConsumer;
import org.netbeans.modules.java.parser.DocumentModelBuilder;
import org.netbeans.modules.java.parser.DocumentModelUpdater;
import org.netbeans.modules.java.parser.JavaParser;
import org.netbeans.modules.java.parser.ParsableObjectRequest;
import org.netbeans.modules.java.parser.ParserAnnotation;
import org.netbeans.modules.java.settings.JavaSettings;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystemCapability;
import org.openide.text.CloneableEditorSupport;

public class ParseSourceRequest
implements ParsableObjectRequest,
ErrConsumer {
    public static final int STATE_WAITING = 0;
    public static final int STATE_READING = 1;
    public static final int STATE_CANCELLED = 2;
    public static final int STATE_ANALYSIS = 3;
    public static final int STATE_UPDATING = 4;
    public static final int STATE_COMPLETED = 10;
    private static final int READ_THRESHOLD = 2048;
    JavaParser.Env environment;
    ChangeListener listener;
    int state;
    boolean valid;
    int syntaxErrors;
    ElementFactory builder;
    CloneableEditorSupport editSupp;
    private int annotatedErrors = 0;
    private Map annotations = null;
    private String sourceName = null;
    private Collection sources;
    private Collection classes;
    private Collection bootclasses;

    public ParseSourceRequest() {
        JavaSettings settings = JavaSettings.getDefault();
        this.state = 0;
        this.valid = true;
        this.classes = new ArrayList(settings.getParserClassPathFS());
        this.bootclasses = new ArrayList(settings.getParserBootPathFS());
        this.sources = new LinkedList();
        Enumeration en = FileSystemCapability.COMPILE.fileSystems();
        while (en.hasMoreElements()) {
            this.sources.add(en.nextElement());
        }
        this.classes.addAll(this.sources);
    }

    public ParseSourceRequest(int errors, String name) {
        this();
        this.annotatedErrors = errors;
        this.sourceName = name;
    }

    ParseSourceRequest(JavaParser.Env env, CloneableEditorSupport editSupp) {
        this();
        this.editSupp = editSupp;
        this.environment = env;
    }

    public synchronized void addChangeListener(ChangeListener l) throws TooManyListenersException {
        if (this.listener != null) {
            throw new TooManyListenersException();
        }
        this.listener = l;
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        if (this.listener == l) {
            this.listener = null;
        }
    }

    public void setEnvironment(JavaParser.Env env) {
        this.environment = env;
    }

    public void setEditorSupport(CloneableEditorSupport editor) {
        this.editSupp = editor;
    }

    public void sourceChanged() {
        if (this.state == 1) {
            this.valid = false;
        }
    }

    public void modelChanged() {
        if (this.state != 0 && this.state != 10) {
            this.valid = false;
        }
    }

    public void setSyntaxErrors(int errors) {
        this.syntaxErrors = errors;
    }

    public int getSyntaxErrors() {
        return this.syntaxErrors;
    }

    public void setSemanticErrors(int errors) {
    }

    public ElementFactory getFactory() {
        if (this.builder == null) {
            this.builder = this.createBuilder(this.editSupp);
        }
        return this.builder;
    }

    public DocumentModelUpdater getUpdater() {
        DocumentModelUpdater result = null;
        ElementFactory builder = this.getFactory();
        if (builder instanceof DocumentModelUpdater) {
            result = (DocumentModelUpdater)((Object)builder);
        }
        return result;
    }

    protected ElementFactory createBuilder(CloneableEditorSupport supp) {
        return new DocumentModelBuilder(supp);
    }

    public void notifyReschedule() {
        this.builder = null;
        this.enterState(0);
    }

    protected void enterState(int state) {
        this.state = state;
        if (this.listener != null) {
            this.listener.stateChanged(new ChangeEvent(this));
        }
    }

    public char[] getSource() throws IOException {
        char[] buf;
        int read;
        this.valid = true;
        this.enterState(1);
        Reader r = this.environment.getSourceText();
        LinkedList<char[]> buffers = new LinkedList<char[]>();
        int total = 0;
        do {
            int offset = 0;
            buf = new char[2048];
            while ((read = r.read(buf)) != -1 && (offset += read) < buf.length) {
            }
            if (offset > 0) {
                buffers.add(buf);
            }
            total += offset;
        } while (read > 0);
        r.close();
        buf = new char[total];
        read = 0;
        Iterator it = buffers.iterator();
        while (it.hasNext()) {
            char[] b = (char[])it.next();
            int size = it.hasNext() ? b.length : total - read;
            System.arraycopy(b, 0, buf, read, size);
            read += size;
        }
        ElementFactory builder = this.getFactory();
        if (builder instanceof DocumentModelBuilder) {
            ((DocumentModelBuilder)builder).setContent(buf, this.editSupp.isDocumentLoaded());
        }
        return buf;
    }

    public InputStream findCompiledClass(String className) {
        return this.environment.findCompiledClass(className);
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean needsProcessing() {
        return this.valid;
    }

    public void notifyStart() {
    }

    public void notifyComplete() {
        this.enterState(10);
        if (this.annotations == null) {
            this.annotations = new HashMap();
        }
    }

    public Object getParserType() {
        if (this.annotatedErrors != 0) {
            return "deep";
        }
        return "shallow";
    }

    public ErrConsumer getErrConsumer() {
        if (this.annotatedErrors != 0) {
            return this;
        }
        return null;
    }

    public void pushError(FileObject errorFile, int line, int column, String message, String referenceText) {
        if (errorFile != null && !errorFile.getNameExt().equals(this.sourceName)) {
            return;
        }
        if (this.annotations == null) {
            this.annotations = new HashMap();
        }
        Integer lineInt = new Integer(line);
        ParserAnnotation newAnn = new ParserAnnotation(line, column, message);
        ParserAnnotation oldAnn = (ParserAnnotation)this.annotations.get(lineInt);
        if (oldAnn != null) {
            oldAnn.chain(newAnn);
        } else if (this.annotations.size() < this.annotatedErrors) {
            this.annotations.put(lineInt, newAnn);
        }
    }

    public Collection getAnnotations() {
        if (this.annotations != null) {
            return this.annotations.values();
        }
        return null;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public Collection getSourcePath() {
        return this.sources;
    }

    public Collection getLibraryPath() {
        return this.classes;
    }

    public Collection getBootClassPath() {
        return this.bootclasses;
    }
}

