/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.parser;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;

public class ParserAnnotation
extends Annotation
implements PropertyChangeListener {
    private final String error;
    private final int line;
    private final int column;
    private int state;
    private Line docline;
    private ParserAnnotation chained;
    private static final int STATE_NEW = 1;
    private static final int STATE_ATTACHED = 2;
    private static final int STATE_DETACHED = 3;

    ParserAnnotation(int l, int c, String err) {
        this.line = l;
        this.column = c;
        this.error = err;
        this.state = 1;
    }

    public String getAnnotationType() {
        return "org-netbeans-modules-java-parser_annotation";
    }

    public String getShortDescription() {
        if (this.chained != null) {
            return this.error + "\n\n" + this.chained.getShortDescription();
        }
        return this.error;
    }

    int getLine() {
        return this.line;
    }

    int getColumn() {
        return this.column;
    }

    String getError() {
        return this.error;
    }

    void chain(ParserAnnotation anno) {
        if (this.chained != null) {
            this.chained.chain(anno);
        } else {
            this.chained = anno;
        }
    }

    private int getState() {
        return this.state;
    }

    protected void notifyAttached(Annotatable toAnno) {
        super.notifyAttached(toAnno);
        this.docline.addPropertyChangeListener((PropertyChangeListener)this);
        this.state = 2;
    }

    protected void notifyDetached(Annotatable fromAnno) {
        super.notifyDetached(fromAnno);
        this.docline.removePropertyChangeListener((PropertyChangeListener)this);
        this.state = 3;
    }

    public boolean equals(Object obj) {
        boolean eq = this.shallowEquals(obj);
        if (!eq) {
            return false;
        }
        if (this.chained != null) {
            return this.chained.equals(((ParserAnnotation)obj).chained);
        }
        return true;
    }

    private boolean shallowEquals(Object obj) {
        if (obj instanceof ParserAnnotation) {
            ParserAnnotation ann = (ParserAnnotation)obj;
            if (this == obj) {
                return true;
            }
            if (this.line != ann.getLine()) {
                return false;
            }
            if (this.column != ann.getColumn()) {
                return false;
            }
            if (!this.error.equals(ann.getError())) {
                return false;
            }
            return this.getState() != 3 && ann.getState() != 3;
        }
        return false;
    }

    public void attachToLineSet(Line.Set lines) {
        this.docline = lines.getCurrent(this.line - 1);
        char[] string = this.docline.getText().toCharArray();
        int start = 0;
        int end = string.length - 1;
        while (start <= end && string[start] <= ' ') {
            ++start;
        }
        while (start <= end && string[end] <= ' ') {
            --end;
        }
        Line.Part part = start <= end ? this.docline.createPart(start, end - start + 1) : this.docline.createPart(0, string.length);
        this.attach((Annotatable)part);
    }

    public void propertyChange(PropertyChangeEvent ev) {
        String type = ev.getPropertyName();
        if (type == null || type == "text") {
            this.detach();
        }
    }
}

