/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.parser;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.java.ElementFactory;
import org.netbeans.modules.java.ErrConsumer;
import org.netbeans.modules.java.ParserEngine;
import org.netbeans.modules.java.codegen.DocumentBinding;
import org.netbeans.modules.java.model.CommitListener;
import org.netbeans.modules.java.model.ElementImpl;
import org.netbeans.modules.java.model.LangModel;
import org.netbeans.modules.java.parser.DocumentModelUpdater;
import org.netbeans.modules.java.parser.JavaParser;
import org.netbeans.modules.java.parser.ParsableObjectRequest;
import org.netbeans.modules.java.parser.ParseObjectRequest;
import org.netbeans.modules.java.parser.ParseSourceRequest;
import org.netbeans.modules.java.parser.SourceImplProxy;
import org.netbeans.modules.java.parser.Util;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.src.Element;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;

public class ParsingSupport
implements JavaParser {
    private static final int READ_THRESHOLD = 2048;
    private PropertyChangeSupport propSupport;
    public static final String PROP_STATUS = "status";
    private static final boolean DEBUG = false;
    private boolean valid;
    private boolean updating;
    private boolean clean;
    private JavaParser.Env parsingEnv;
    private ParserEngine engine;
    private SourceException savedException;
    private SourceElement src;
    private Processor currentRequest;
    private Processor runningRequest;
    LangModel model;
    LangModel.Updater updater;
    private SourceImplProxy proxy;
    private Reference refImplementation;
    private int status;
    Collection changeList;
    private static ReferenceQueue refQueue;
    private static Map referenceSupportMap;
    DocumentBinding docBinding;
    static final Runnable EMPTY_RUNNABLE;
    static RequestProcessor PARSING_RP;
    protected static DataFinalizer finalizer;
    private static final int FINALIZE_TIMEOUT = 30000;
    static /* synthetic */ Class class$org$netbeans$modules$java$parser$ParsingSupport;

    public ParsingSupport(JavaParser.Env parsingEnv, DocumentBinding docBinding, LangModel.Updater updater, LangModel model) {
        this.initialize(parsingEnv, docBinding, updater, model);
    }

    private void initialize(JavaParser.Env parsingEnv, DocumentBinding docBinding, LangModel.Updater updater, LangModel model) {
        this.docBinding = docBinding;
        this.parsingEnv = parsingEnv;
        this.updater = updater;
        this.model = model;
        this.valid = true;
        Class clazz = class$org$netbeans$modules$java$parser$ParsingSupport == null ? (class$org$netbeans$modules$java$parser$ParsingSupport = ParsingSupport.class$("org.netbeans.modules.java.parser.ParsingSupport")) : class$org$netbeans$modules$java$parser$ParsingSupport;
        synchronized (clazz) {
            if (referenceSupportMap == null) {
                referenceSupportMap = new HashMap(17);
                refQueue = new ReferenceQueue();
            }
        }
    }

    public void addChangeListener(ChangeListener l) {
        Object object;
        if (this.changeList == null) {
            object = this;
            synchronized (object) {
                if (this.changeList == null) {
                    this.changeList = new LinkedList();
                }
            }
        }
        object = this.changeList;
        synchronized (object) {
            this.changeList.add(l);
        }
    }

    public void removeChangeListener(ChangeListener l) {
        if (this.changeList == null) {
            return;
        }
        Collection collection = this.changeList;
        synchronized (collection) {
            this.changeList.remove(l);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.propSupport == null) {
            ParsingSupport parsingSupport = this;
            synchronized (parsingSupport) {
                if (this.propSupport == null) {
                    this.propSupport = new PropertyChangeSupport(this);
                }
            }
        }
        this.propSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.propSupport == null) {
            return;
        }
        this.propSupport.removePropertyChangeListener(l);
    }

    public Task parse(int priority, boolean ignoreClean, boolean acceptErrors) {
        ParseSourceRequest req = new ParseSourceRequest();
        return this.parse(priority, ignoreClean, acceptErrors, req);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Task parse(int priority, boolean ignoreClean, boolean acceptErrors, ParsableObjectRequest req) {
        Processor immediate;
        SourceElement.Impl i = null;
        CloneableEditorSupport editSupport = this.docBinding.getEditorSupport();
        ParsingSupport parsingSupport = this;
        synchronized (parsingSupport) {
            if (this.currentRequest != null) {
                if (!PARSING_RP.isRequestProcessorThread()) {
                    this.currentRequest.enableErrors(acceptErrors);
                    this.currentRequest.setPriority(priority);
                    return this.currentRequest.getClientTask();
                }
                immediate = this.currentRequest;
            } else {
                i = this.getSourceImpl();
                if (i != null && this.clean && !ignoreClean) {
                    return new FinishedTask(i);
                }
                Processor proc = new Processor(priority, this.parsingEnv, editSupport, req);
                proc.enableErrors(acceptErrors);
                if (PARSING_RP != null && PARSING_RP.isRequestProcessorThread()) {
                    immediate = proc;
                } else {
                    this.addRequest(proc, priority);
                    return proc.getClientTask();
                }
            }
        }
        immediate.run();
        i = this.getSourceImpl();
        return new FinishedTask(i);
    }

    public void fireElementPropertyChange(Element source, PropertyChangeEvent evt) {
        if (source == this.getSource()) {
            this.proxy.propertyChange(evt);
        } else {
            this.updater.firePropertyChange(source, evt);
        }
    }

    public ParserEngine getParserEngine() {
        return this.engine;
    }

    public void setParserEngine(ParserEngine eng) {
        this.engine = eng;
    }

    public Task prepare() {
        return this.parse(1, false, false);
    }

    public SourceElement getSource() {
        if (this.src != null) {
            return this.src;
        }
        ParsingSupport parsingSupport = this;
        synchronized (parsingSupport) {
            if (this.src != null) {
                SourceElement sourceElement = this.src;
                return sourceElement;
            }
            SourceElement sourceElement = this.src = this.createSourceProxy();
            return sourceElement;
        }
    }

    public void invalidate() {
        ParsingSupport parsingSupport = this;
        synchronized (parsingSupport) {
            if (!this.valid) {
                return;
            }
            SourceElement.Impl impl = this.getSourceImpl();
            if (impl == null) {
                return;
            }
            this.valid = false;
        }
        this.updater.invalidateModel(this.getSource());
        ParsingSupport parsingSupport2 = this;
        synchronized (parsingSupport2) {
            if (!this.updating) {
                this.refImplementation = null;
            }
        }
        this.changeStatus(0);
    }

    protected void changeStatus(int newStatus) {
        int oldStatus = this.status;
        this.status = newStatus;
        if (this.propSupport != null && this.propSupport.hasListeners(null)) {
            this.propSupport.firePropertyChange(PROP_STATUS, oldStatus, newStatus);
        }
        this.fireStateChange();
    }

    protected void fireStateChange() {
        ArrayList copy;
        if (this.changeList == null) {
            return;
        }
        Collection collection = this.changeList;
        synchronized (collection) {
            if (this.changeList.isEmpty()) {
                return;
            }
            copy = new ArrayList(this.changeList);
        }
        ChangeEvent e = new ChangeEvent(this);
        Iterator it = copy.iterator();
        while (it.hasNext()) {
            try {
                ((ChangeListener)it.next()).stateChanged(e);
            }
            catch (RuntimeException x) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) continue;
                x.printStackTrace();
            }
        }
    }

    public SourceElement.Impl getSourceImpl() {
        Object impl = this.refImplementation == null ? null : this.refImplementation.get();
        return impl;
    }

    public LangModel getModel() {
        return this.model;
    }

    public SourceElement.Impl findSourceImpl() throws SourceException {
        ParsingSupport parsingSupport = this;
        synchronized (parsingSupport) {
            SourceElement.Impl impl = this.getSourceImpl();
            if (impl != null) {
                SourceElement.Impl impl2 = impl;
                return impl2;
            }
            Util.log("impl = null");
            if (this.savedException != null) {
                throw this.savedException;
            }
        }
        throw new SourceException("Cannot acquire source");
    }

    public void sourceChanged(int from, int to) {
        Processor req = this.currentRequest;
        this.clean = false;
        if (req != null) {
            req.sourceChanged();
        }
    }

    public SourceException getErrorCause() {
        return this.savedException;
    }

    private SourceElement createSourceProxy() {
        this.proxy = new SourceImplProxy(this);
        return new SourceElement((SourceElement.Impl)this.proxy);
    }

    Node.Cookie findCookieForSource(Class type) {
        if (this.src == null) {
            return null;
        }
        return this.parsingEnv.findCookie(this.getSource(), type);
    }

    public int getStatus() {
        int s = this.status;
        if (s != 3) {
            return s;
        }
        SourceElement.Impl impl = this.getSourceImpl();
        if (impl == null) {
            this.changeStatus(0);
        }
        return this.status;
    }

    private SourceElement.Impl updateSourceModel(DocumentModelUpdater builder) throws SourceException {
        boolean created;
        SourceElement.Impl currentImpl;
        SourceElement.Impl finalImpl = currentImpl = this.getSourceImpl();
        ParsingSupport parsingSupport = this;
        synchronized (parsingSupport) {
            if (!this.valid) {
                throw new SourceException.IO("Source was deleted");
            }
            this.updating = true;
            Util.log("updating");
            created = currentImpl == null;
            if (created) {
                currentImpl = this.updater.createSource();
            }
        }
        try {
            SourceElement s = this.getSource();
            this.docBinding.enableGenerator(false);
            this.proxy.notifyInProgress(Thread.currentThread(), currentImpl);
            if (created) {
                currentImpl.attachedToElement((Element)s);
                ((ElementImpl)currentImpl).setBinding(this.docBinding.bindSource(s));
            }
            Util.log("Trying to update the model");
            builder.updateModel(this.updater, s, currentImpl);
            if (finalImpl == null) {
                this.updater.activate((Element)s);
            }
            Util.log("Update bindings");
            builder.updateBindings(this.docBinding);
            finalImpl = currentImpl;
            ParsingSupport parsingSupport2 = this;
            synchronized (parsingSupport2) {
                this.updating = false;
                if (!this.valid) {
                    throw new SourceException.IO("Source was deleted");
                }
            }
            Util.log("register data = " + finalImpl);
            this.registerData(finalImpl);
            Object var10_10 = null;
            this.docBinding.enableGenerator(true);
            this.proxy.setModelDelegate(finalImpl, created);
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.docBinding.enableGenerator(true);
            this.proxy.setModelDelegate(finalImpl, created);
            throw throwable;
        }
        return finalImpl;
    }

    public Task addParsingRunnable(Runnable r, int priority) {
        return PARSING_RP.post(r, priority);
    }

    private void addRequest(Processor proc, int priority) {
        ParsingSupport parsingSupport;
        if (PARSING_RP == null) {
            parsingSupport = this;
            synchronized (parsingSupport) {
                if (PARSING_RP == null) {
                    PARSING_RP = new RequestProcessor("Java source parsing");
                }
            }
        }
        parsingSupport = this;
        synchronized (parsingSupport) {
            if (this.currentRequest != proc) {
                if (this.currentRequest != null) {
                    proc.chainRequest(this.currentRequest);
                }
                this.currentRequest = proc;
            }
            proc.setProcessorTask(PARSING_RP.post((Runnable)proc, priority));
        }
    }

    protected void registerData(SourceElement.Impl data) {
        Class clazz = class$org$netbeans$modules$java$parser$ParsingSupport == null ? (class$org$netbeans$modules$java$parser$ParsingSupport = ParsingSupport.class$("org.netbeans.modules.java.parser.ParsingSupport")) : class$org$netbeans$modules$java$parser$ParsingSupport;
        synchronized (clazz) {
            if (finalizer == null) {
                finalizer = new DataFinalizer();
                RequestProcessor.getDefault().post((Runnable)finalizer, 30000, 1);
            }
        }
        Reference r = finalizer.registerParsingInfo(this, data, this.refImplementation);
        ParsingSupport parsingSupport = this;
        synchronized (parsingSupport) {
            this.refImplementation = r;
        }
    }

    protected void notifyFinalized(Reference refImpl) {
        ParsingSupport parsingSupport = this;
        synchronized (parsingSupport) {
            if (this.refImplementation != refImpl) {
                return;
            }
            this.refImplementation = null;
        }
        this.changeStatus(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        EMPTY_RUNNABLE = new Runnable(){

            public void run() {
            }
        };
    }

    private static class DataFinalizer
    implements Runnable {
        private Map mapSupportData = new HashMap(37);
        private ReferenceQueue finalizedQueue = new ReferenceQueue();

        DataFinalizer() {
        }

        public synchronized Reference registerParsingInfo(ParsingSupport supp, SourceElement.Impl data, Object oldRef) {
            if (oldRef != null) {
                this.mapSupportData.remove(oldRef);
            }
            WeakReference<SourceElement.Impl> newRef = new WeakReference<SourceElement.Impl>(data, this.finalizedQueue);
            this.mapSupportData.put(newRef, new WeakReference<ParsingSupport>(supp));
            return newRef;
        }

        /*
         * WARNING - void declaration
         */
        public void run() {
            Reference f;
            while ((f = this.finalizedQueue.poll()) != null) {
                ParsingSupport supp;
                Reference refSupp;
                void var1_1;
                DataFinalizer dataFinalizer = this;
                synchronized (dataFinalizer) {
                    refSupp = (Reference)this.mapSupportData.get(var1_1);
                }
                if (refSupp == null || (supp = (ParsingSupport)refSupp.get()) == null) continue;
                supp.notifyFinalized((Reference)var1_1);
            }
            RequestProcessor.getDefault().post((Runnable)this, 30000, 1);
        }
    }

    private class Processor
    implements Runnable,
    CommitListener,
    ParseObjectRequest {
        Processor chained;
        int priority;
        RequestProcessor.Task ownTask;
        boolean errorsOK;
        int stage;
        int resultStatus;
        ParsableObjectRequest request;
        T task;

        Processor(int priority, JavaParser.Env env, CloneableEditorSupport supp, ParsableObjectRequest req) {
            this.request = req;
            this.task = new T();
            this.request.setEnvironment(env);
            this.request.setEditorSupport(supp);
        }

        protected void directRun() {
            do {
                this.run();
            } while (this.stage >= 0);
        }

        public void setPriority(int prior) {
            if (this.priority > prior) {
                return;
            }
            this.priority = prior;
            if (this.ownTask.cancel()) {
                ParsingSupport.this.addRequest(this, prior);
            }
        }

        public void enableErrors(boolean enable) {
            this.errorsOK |= enable;
        }

        public void chainRequest(Processor other) {
            this.chained = other;
        }

        public void setProcessorTask(RequestProcessor.Task t) {
            this.ownTask = t;
        }

        public void run() {
            block12: {
                Util.log("processing request " + this + " stage " + this.stage);
                try {
                    try {
                        switch (this.stage++) {
                            case 0: {
                                this.parseLockModel();
                                break;
                            }
                            case 1: {
                                this.updateModel();
                            }
                        }
                    }
                    catch (SourceException.IO e) {
                        this.resultStatus = 1;
                        Object var4_2 = null;
                        --this.stage;
                        break block12;
                    }
                    catch (Throwable e) {
                        ParsingSupport.this.savedException = new SourceException(e.getLocalizedMessage());
                        ParsingSupport.this.parsingEnv.annotateThrowable(ParsingSupport.this.savedException, e);
                        ParsingSupport.this.parsingEnv.annotateThrowable(ParsingSupport.this.savedException, "Parser error", false);
                        ErrorManager.getDefault().notify(e);
                        this.resultStatus = 1;
                        Object var4_3 = null;
                        --this.stage;
                    }
                    Object var4_1 = null;
                    --this.stage;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    --this.stage;
                    throw throwable;
                }
            }
            Util.log("request " + this + " stage " + (this.stage + 1) + " end");
            if (this.stage > 0) {
                return;
            }
            if (this.resultStatus != -1) {
                this.complete();
            } else {
                this.request.notifyReschedule();
                Util.log("Rescheduling request");
                this.stage = 0;
                ParsingSupport.this.addRequest(this, this.priority);
            }
        }

        private void updateModel() throws SourceException {
            ParsingSupport.this.model.removePreCommitListener(this);
            if (this.getSyntaxErrors() > 0 && !this.errorsOK && ParsingSupport.this.getSourceImpl() != null) {
                this.resultStatus = 2;
                return;
            }
            if (this.isValid()) {
                SourceElement.Impl i = null;
                DocumentModelUpdater updater = this.request.getUpdater();
                if (updater != null) {
                    i = ParsingSupport.this.updateSourceModel(updater);
                }
                this.resultStatus = i == null ? 0 : (this.getSyntaxErrors() > 0 ? 2 : 3);
                return;
            }
        }

        private void parseLockModel() throws SourceException {
            block9: {
                ParsingSupport.this.model.addPreCommitListener(this);
                this.resultStatus = -1;
                ParsingSupport parsingSupport = ParsingSupport.this;
                synchronized (parsingSupport) {
                    ParsingSupport.this.runningRequest = this;
                    Util.log("Running request = " + this);
                }
                ParsingSupport.this.savedException = null;
                try {
                    block8: {
                        try {
                            ParsingSupport.this.runningRequest = this;
                            this.process(ParsingSupport.this.getParserEngine());
                            if (!this.isValid()) break block8;
                            Util.log("Request " + this + " processed. Still valid");
                            this.stage = 1;
                            Util.log("trying to run update");
                            ParsingSupport.this.updater.runUpdate(this, true);
                        }
                        catch (IOException ex) {
                            ParsingSupport.this.savedException = (SourceException)((Object)new SourceException.IO(ex));
                            ParsingSupport.this.parsingEnv.annotateThrowable(ParsingSupport.this.savedException, ex);
                            this.resultStatus = 1;
                            Object var5_5 = null;
                            ParsingSupport.this.model.removePreCommitListener(this);
                            break block9;
                        }
                        catch (InternalError er) {
                            ParsingSupport.this.savedException = new SourceException(er.getMessage());
                            ParsingSupport.this.parsingEnv.annotateThrowable(ParsingSupport.this.savedException, er);
                            this.resultStatus = 1;
                            Object var5_6 = null;
                            ParsingSupport.this.model.removePreCommitListener(this);
                        }
                    }
                    Object var5_4 = null;
                    ParsingSupport.this.model.removePreCommitListener(this);
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    ParsingSupport.this.model.removePreCommitListener(this);
                    throw throwable;
                }
            }
            ParsingSupport.this.runningRequest = null;
        }

        public void complete() {
            ParsingSupport parsingSupport = ParsingSupport.this;
            synchronized (parsingSupport) {
                if (ParsingSupport.this.currentRequest == this) {
                    ParsingSupport.this.currentRequest = null;
                }
            }
            ParsingSupport.this.changeStatus(this.resultStatus);
            this.task.complete();
            if (this.chained != null) {
                this.chained.complete();
            }
            this.stage = -1;
        }

        public void changesCommited(Set created, Set removed, Map changed) {
            this.request.modelChanged();
        }

        public void process(ParserEngine eng) throws IOException {
            eng.process(this);
        }

        public Task getClientTask() {
            return this.task;
        }

        public void sourceChanged() {
            this.request.sourceChanged();
        }

        public void setSyntaxErrors(int errors) {
            this.request.setSyntaxErrors(errors);
        }

        public void setSemanticErrors(int errors) {
            this.request.setSemanticErrors(errors);
        }

        public void notifyStart() {
            this.request.notifyStart();
        }

        public void notifyComplete() {
            this.request.notifyComplete();
        }

        public boolean isValid() {
            return this.request.isValid();
        }

        public boolean needsProcessing() {
            return this.request.needsProcessing();
        }

        public int getSyntaxErrors() {
            return this.request.getSyntaxErrors();
        }

        public ElementFactory getFactory() {
            return this.request.getFactory();
        }

        public char[] getSource() throws IOException {
            ParsingSupport.this.clean = true;
            return this.request.getSource();
        }

        public InputStream findCompiledClass(String className) {
            return this.request.findCompiledClass(className);
        }

        public Object getParserType() {
            return this.request.getParserType();
        }

        public ErrConsumer getErrConsumer() {
            return this.request.getErrConsumer();
        }

        public String getSourceName() {
            return this.request.getSourceName();
        }

        public Collection getSourcePath() {
            return this.request.getSourcePath();
        }

        public Collection getLibraryPath() {
            return this.request.getLibraryPath();
        }

        public Collection getBootClassPath() {
            return this.request.getBootClassPath();
        }

        private class T
        extends Task {
            T() {
                super(EMPTY_RUNNABLE);
            }

            public void run() {
                Processor.this.directRun();
            }

            protected void complete() {
                super.notifyFinished();
            }
        }
    }

    private static class FinishedTask
    extends Task {
        private Object hook;

        public FinishedTask(Object o) {
            super(null);
            this.hook = o;
        }
    }
}

