/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.tools;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import org.netbeans.modules.java.tools.InheritanceSupport;
import org.netbeans.modules.java.tools.OverrideAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.util.Task;
import org.openide.util.TaskListener;

class InheritanceChildren
extends Children.Keys
implements InheritanceSupport.HierarchyListener {
    private static final Object WAIT = new Object();
    private static final String WAIT_STRING = OverrideAction.getString("MSG_InheritanceWait");
    private InheritanceSupport data;
    private Comparator comparator;
    private InheritanceSupport.HierarchyListener listener;

    public InheritanceChildren(InheritanceSupport data, Comparator comp) {
        this.data = data;
        this.comparator = comp;
        this.setWaitNode();
        this.listener = this;
    }

    public void addNotify() {
        this.data.addHierarchyListener(this.listener);
        this.data.prepareHierarchy().addTaskListener(new TaskListener(){

            public void taskFinished(Task t) {
                t.removeTaskListener((TaskListener)this);
                InheritanceChildren.this.refreshData();
                InheritanceChildren.this.data.addHierarchyListener(InheritanceChildren.this.listener);
            }
        });
    }

    public void removeNotify() {
        this.data.removeHierarchyListener(this.listener);
    }

    public void setComparator(Comparator c) {
        this.comparator = c;
        this.refreshData();
    }

    private void refreshData() {
        TreeSet result;
        TreeSet original = this.data.getInheritedClasses();
        if (this.comparator == null) {
            result = original;
        } else {
            result = new TreeSet(this.comparator);
            result.addAll(original);
        }
        this.setKeys(result);
    }

    protected Node[] createNodes(Object key) {
        if (key instanceof ClassElement) {
            return new Node[]{this.data.createClassElementNode((ClassElement)key, Children.LEAF, false)};
        }
        if (key == WAIT) {
            return new Node[]{new AbstractNode(Children.LEAF){

                public String getDisplayName() {
                    return WAIT_STRING;
                }
            }};
        }
        throw new IllegalArgumentException(key.getClass().toString());
    }

    private final void setWaitNode() {
        this.setKeys(new Object[]{WAIT});
    }

    public void inheritanceChanged() {
        this.setWaitNode();
    }

    public void inheritedClassesComputed(Map classes) {
        this.refreshData();
    }

    public void inheritedMethodsComputed(Collection methods) {
    }
}

