/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.tools;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.java.tools.InheritanceSupport;
import org.netbeans.modules.java.tools.OverrideAction;
import org.netbeans.modules.java.tools.OverridePanelBase;
import org.openide.src.ClassElement;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceException;
import org.openide.src.Type;

public class OverrideActionPanel
extends OverridePanelBase {
    private Map removeMethods;
    private Map addMethods;

    public OverrideActionPanel(InheritanceSupport support) {
        super(support);
        this.initializeGUI();
    }

    private boolean isInSource(MethodElement method) {
        ClassElement target = this.getSupport().getSourceClass();
        MethodParameter[] mp = method.getParameters();
        Type[] paramTypes = new Type[mp.length];
        int i = 0;
        while (i < mp.length) {
            paramTypes[i] = mp[i].getType();
            ++i;
        }
        return target.getMethod(method.getName(), paramTypes) != null;
    }

    protected void overrideMethod(MethodElement source) throws SourceException {
        MethodElement.Key k = new MethodElement.Key(source);
        if (this.removeMethods != null && this.removeMethods.containsKey(k)) {
            this.removeMethods.remove(k);
        } else {
            if (this.isInSource(source)) {
                this.throwAddException(source);
            }
            if (this.addMethods == null) {
                this.addMethods = new HashMap(17);
            } else if (this.addMethods.containsKey(k)) {
                this.throwAddException(source);
            }
            this.addMethods.put(k, source);
        }
        super.overrideMethod(source);
    }

    private void throwAddException(MethodElement m) throws SourceException {
        String msg = MessageFormat.format(OverrideAction.getString("FMT_METHOD_PRESENT"), m.getName().getName());
        throw new SourceException(msg);
    }

    public Collection getMethodsToAdd() {
        if (this.addMethods == null) {
            return null;
        }
        return this.addMethods.values();
    }

    public Collection getMethodsToRemove() {
        if (this.removeMethods == null) {
            return null;
        }
        return this.removeMethods.values();
    }

    protected void removeMethod(MethodElement m) throws SourceException {
        MethodElement.Key k = new MethodElement.Key(m);
        if (this.addMethods == null || !this.addMethods.containsKey(k)) {
            if (this.removeMethods == null) {
                this.removeMethods = new HashMap(17);
            }
            this.removeMethods.put(k, m);
        } else {
            this.addMethods.remove(k);
        }
        super.removeMethod(m);
    }
}

