/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.openide.explorer.propertysheet.DefaultPropertyModel;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.nodes.Index;

public abstract class IndexedPropertyChildren
extends Index.KeysChildren {
    private PropertyModel model;
    private PropertyChangeListener beanListener;
    boolean ignoreBeanChanges;

    public IndexedPropertyChildren(Object bean, String propertyName) {
        this((PropertyModel)new DefaultPropertyModel(bean, propertyName));
    }

    public IndexedPropertyChildren(PropertyModel m) {
        super(new LinkedList());
        this.model = m;
        if (!m.getPropertyType().isArray()) {
            throw new IllegalArgumentException("Property of array type expected.");
        }
    }

    protected void addNotify() {
        this.model.addPropertyChangeListener(this.getBeanListener());
        this.refreshData();
    }

    protected void removeNotify() {
        this.model.removePropertyChangeListener(this.getBeanListener());
    }

    protected final PropertyChangeListener getBeanListener() {
        if (this.beanListener != null) {
            return this.beanListener;
        }
        this.beanListener = this.createBeanListener();
        return this.beanListener;
    }

    protected PropertyChangeListener createBeanListener() {
        return new SourceListener();
    }

    protected final void refreshData() {
        List<Object> c;
        try {
            c = Arrays.asList((Object[])this.model.getValue());
        }
        catch (InvocationTargetException e) {
            return;
        }
        this.list.clear();
        this.list.addAll(c);
        this.update();
    }

    protected Object[] createValue(Collection value) {
        Class<?> compType = this.model.getPropertyType().getComponentType();
        Object[] val = (Object[])Array.newInstance(compType, value.size());
        return value.toArray(val);
    }

    protected void reorder(int[] permutation) {
        super.reorder(permutation);
        try {
            try {
                this.ignoreBeanChanges = true;
                Object[] value = this.createValue(this.list);
                this.model.setValue((Object)value);
                Object var4_4 = null;
                this.ignoreBeanChanges = false;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.ignoreBeanChanges = false;
                throw throwable;
            }
        }
        catch (InvocationTargetException e) {
            this.handleReorderException(e);
        }
    }

    protected void handleReorderException(InvocationTargetException e) {
        this.refreshData();
    }

    private class SourceListener
    implements PropertyChangeListener {
        private SourceListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("value".equals(evt.getPropertyName())) {
                IndexedPropertyChildren.this.refreshData();
            }
        }
    }
}

